/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.blocks.machines.metal_processing.casting_spout;

import com.drmangotea.tfmg.blocks.machines.TFMGMachineBlockEntity;
import com.drmangotea.tfmg.blocks.machines.metal_processing.casting_basin.CastingBasinBlockEntity;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.LangBuilder;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class CastingSpoutBlockEntity
extends TFMGMachineBlockEntity {
    CastingBasinBlockEntity basin;
    public boolean isRunning = false;
    public LerpedFloat movement = LerpedFloat.linear();

    public CastingSpoutBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.tank2.forbidInsertion();
        this.tank2.forbidExtraction();
        this.tank1.forbidExtraction();
    }

    public void tick() {
        super.tick();
        if (this.isRunning) {
            this.movement.chase(0.03, (double)0.1f, LerpedFloat.Chaser.EXP);
        } else {
            this.movement.chase(0.0, (double)0.1f, LerpedFloat.Chaser.EXP);
        }
        this.movement.tickChaser();
        if (this.tank1.isEmpty()) {
            this.isRunning = false;
            return;
        }
        if (!(this.f_58857_.m_7702_(this.m_58899_().m_6625_(2)) instanceof CastingBasinBlockEntity)) {
            this.isRunning = false;
            return;
        }
        this.basin = (CastingBasinBlockEntity)this.f_58857_.m_7702_(this.m_58899_().m_6625_(2));
        if (this.basin.moldInventory.m_7983_()) {
            this.isRunning = false;
            return;
        }
        if (this.basin.tank1.getPrimaryHandler().getFluidAmount() == this.basin.tank1.getPrimaryHandler().getCapacity()) {
            this.isRunning = false;
            return;
        }
        if (this.basin.outputInventory.getStackInSlot(0).m_41613_() != 0) {
            this.isRunning = false;
            return;
        }
        if (this.basin.tank1.getPrimaryHandler().getCapacity() == 4000) {
            this.isRunning = false;
            return;
        }
        this.basin.tank1.getPrimaryHandler().setFluid(new FluidStack(this.tank1.getPrimaryHandler().getFluid().getFluid(), this.basin.tank1.getPrimaryHandler().getFluidAmount() + 1));
        this.tank1.getPrimaryHandler().drain(1, IFluidHandler.FluidAction.EXECUTE);
        this.isRunning = true;
    }

    @Override
    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        LazyOptional handler = this.getCapability(ForgeCapabilities.FLUID_HANDLER);
        Optional resolve = handler.resolve();
        if (!resolve.isPresent()) {
            return false;
        }
        IFluidHandler tank = (IFluidHandler)resolve.get();
        if (tank.getTanks() == 0) {
            return false;
        }
        LangBuilder mb = Lang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]);
        boolean isEmpty = true;
        for (int i = 0; i < tank.getTanks(); ++i) {
            FluidStack fluidStack = tank.getFluidInTank(i);
            if (fluidStack.isEmpty()) continue;
            Lang.fluidName((FluidStack)fluidStack).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
            Lang.builder().add(Lang.number((double)fluidStack.getAmount()).add(mb).style(ChatFormatting.DARK_GREEN)).text(ChatFormatting.GRAY, " / ").add(Lang.number((double)tank.getTankCapacity(i)).add(mb).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
            isEmpty = false;
        }
        if (tank.getTanks() > 1) {
            if (isEmpty) {
                tooltip.remove(tooltip.size() - 1);
            }
            return true;
        }
        if (!isEmpty) {
            return true;
        }
        Lang.translate((String)"gui.goggles.fluid_container.capacity", (Object[])new Object[0]).add(Lang.number((double)tank.getTankCapacity(0)).add(mb).style(ChatFormatting.DARK_GREEN)).style(ChatFormatting.DARK_GRAY).forGoggles(tooltip, 1);
        return true;
    }

    protected AABB createRenderBoundingBox() {
        return new AABB(this.m_58899_()).m_82400_(1.0);
    }
}

