/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.blocks.machines.oil_processing.distillation;

import com.drmangotea.tfmg.blocks.machines.oil_processing.distillation.distillery.DistilleryControllerBlockEntity;
import com.drmangotea.tfmg.recipes.distillation.AbstractDistillationRecipe;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.advancement.CreateAdvancement;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.simple.DeferralBehaviour;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class FluidProcessingBlockEntity
extends KineticBlockEntity {
    public DeferralBehaviour basinChecker;
    public boolean basinRemoved;
    protected AbstractDistillationRecipe recipe;

    public FluidProcessingBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.basinChecker = new DeferralBehaviour((SmartBlockEntity)this, this::updateController);
        behaviours.add((BlockEntityBehaviour)this.basinChecker);
    }

    public void tick() {
        if (this.basinRemoved) {
            this.basinRemoved = false;
            this.onControllerRemoved();
            this.sendData();
            return;
        }
        super.tick();
    }

    protected boolean updateController() {
        return false;
    }

    protected abstract boolean isRunning();

    public void startProcessing() {
    }

    public boolean continueWithPreviousRecipe() {
        return true;
    }

    protected <C extends Container> boolean matchItemlessRecipe(Recipe<C> recipe) {
        if (recipe == null) {
            return false;
        }
        Optional<DistilleryControllerBlockEntity> controller = this.getController();
        if (!controller.isPresent()) {
            return false;
        }
        return AbstractDistillationRecipe.match(controller.get(), recipe);
    }

    protected abstract void onControllerRemoved();

    public Optional<DistilleryControllerBlockEntity> getController() {
        if (this.f_58857_ == null) {
            return Optional.empty();
        }
        BlockEntity basinTE = this.f_58857_.m_7702_(this.f_58858_.m_6625_(1));
        if (!(basinTE instanceof DistilleryControllerBlockEntity)) {
            return Optional.empty();
        }
        return Optional.of((DistilleryControllerBlockEntity)basinTE);
    }

    protected Optional<CreateAdvancement> getProcessedRecipeTrigger() {
        return Optional.empty();
    }

    protected abstract <C extends Container> boolean matchStaticFilters(Recipe<C> var1);

    protected abstract Object getRecipeCacheKey();
}

