/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore;

import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import org.apache.commons.lang3.ArrayUtils;
import team.creative.creativecore.ICreativeLoader;
import team.creative.creativecore.Side;
import team.creative.creativecore.client.ClientLoader;
import team.creative.creativecore.common.CommonLoader;

public class CreativeForgeLoader
implements ICreativeLoader {
    @Override
    public Side getOverallSide() {
        return FMLEnvironment.dist.isClient() ? Side.CLIENT : Side.SERVER;
    }

    @Override
    public void registerDisplayTest(Supplier<String> suppliedVersion, BiPredicate<String, Boolean> remoteVersionTest) {
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(suppliedVersion, remoteVersionTest));
    }

    @Override
    public String ignoreServerNetworkConstant() {
        return "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31";
    }

    @Override
    public void register(CommonLoader loader) {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(x -> loader.onInitialize());
    }

    @Override
    public void registerClient(ClientLoader loader) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(x -> loader.onInitializeClient());
            MinecraftForge.EVENT_BUS.addListener(x -> loader.registerClientCommands(x.getDispatcher()));
        });
    }

    @Override
    public void registerClientTick(Runnable run) {
        MinecraftForge.EVENT_BUS.addListener(x -> {
            if (x.phase == TickEvent.Phase.START) {
                run.run();
            }
        });
    }

    @Override
    public void registerClientRenderGui(Consumer run) {
        MinecraftForge.EVENT_BUS.addListener(x -> run.accept(x.getGuiGraphics()));
    }

    @Override
    public void registerClientRenderStart(Runnable run) {
        MinecraftForge.EVENT_BUS.addListener(x -> {
            if (x.phase == TickEvent.Phase.START) {
                run.run();
            }
        });
    }

    @Override
    public void registerLevelTick(Consumer<ServerLevel> consumer) {
        MinecraftForge.EVENT_BUS.addListener(x -> {
            Level patt3833$temp;
            if (x.phase == TickEvent.Phase.END && (patt3833$temp = x.level) instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)patt3833$temp;
                consumer.accept(level);
            }
        });
    }

    @Override
    public void registerLevelTickStart(Consumer<ServerLevel> consumer) {
        MinecraftForge.EVENT_BUS.addListener(x -> {
            Level patt4140$temp;
            if (x.phase == TickEvent.Phase.START && (patt4140$temp = x.level) instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)patt4140$temp;
                consumer.accept(level);
            }
        });
    }

    @Override
    public void registerUnloadLevel(Consumer<LevelAccessor> consumer) {
        MinecraftForge.EVENT_BUS.addListener(x -> consumer.accept(x.getLevel()));
    }

    @Override
    public void registerLoadLevel(Consumer<LevelAccessor> consumer) {
        MinecraftForge.EVENT_BUS.addListener(x -> consumer.accept(x.getLevel()));
    }

    public void registerListener(Consumer consumer) {
        MinecraftForge.EVENT_BUS.addListener(consumer);
    }

    @Override
    public void registerClientStarted(Runnable run) {
        run.run();
    }

    @Override
    public void postForge(Event event) {
        MinecraftForge.EVENT_BUS.post(event);
    }

    @Override
    public boolean isModLoaded(String modid) {
        return ModList.get().isLoaded(modid);
    }

    @Override
    public float getFluidViscosityMultiplier(Fluid fluid, Level level) {
        return fluid.getFluidType().getViscosity() / 1000;
    }

    @Override
    public void registerKeybind(Supplier<KeyMapping> supplier) {
        Minecraft.m_91087_().f_91066_.f_92059_ = (KeyMapping[])ArrayUtils.add((Object[])Minecraft.m_91087_().f_91066_.f_92059_, (Object)supplier.get());
    }

    @Override
    public Side getEffectiveSide() {
        return EffectiveSide.get().isClient() ? Side.CLIENT : Side.SERVER;
    }
}

