/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.recipe;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.mehvahdjukaar.amendments.common.item.DyeBottleItem;
import net.mehvahdjukaar.amendments.common.recipe.DummyContainer;
import net.mehvahdjukaar.moonlight.api.fluids.FluidContainerList;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class RecipeUtils {
    public static Pair<ItemStack, Float> craftWithFluidAndDye(Level level, SoftFluidStack fluid, ItemStack toRecolor) {
        CompoundTag tag = fluid.getTag();
        if (tag == null) {
            return null;
        }
        Pair<ItemStack, Float> c = RecipeUtils.craftWithFluid(level, fluid, toRecolor, true);
        if (c != null) {
            return c;
        }
        DyeItem dyeItem = DyeItem.m_41082_((DyeColor)DyeBottleItem.getClosestDye(fluid));
        ItemStack recolored = RecipeUtils.simulateCrafting(level, toRecolor, dyeItem.m_7968_(), false);
        if (recolored != null) {
            return Pair.of((Object)recolored, (Object)Float.valueOf(1.0f));
        }
        return null;
    }

    public static Pair<ItemStack, Float> craftWithFluid(Level level, SoftFluidStack fluidStack, ItemStack playerItem, boolean try9x9) {
        SoftFluid sf = (SoftFluid)fluidStack.getFluid().m_203334_();
        for (FluidContainerList.Category category : sf.getContainerList().getCategories()) {
            ItemStack crafted9;
            Pair p;
            int capacity = category.getCapacity();
            if (capacity > fluidStack.getCount() || (p = fluidStack.toItem(category.getEmptyContainer().m_7968_(), true)) == null) continue;
            ItemStack crafted = RecipeUtils.simulateCrafting(level, (ItemStack)p.getFirst(), playerItem, false);
            if (crafted != null) {
                return Pair.of((Object)crafted, (Object)Float.valueOf(capacity));
            }
            if (!try9x9 || (crafted9 = RecipeUtils.simulateCrafting(level, (ItemStack)p.getFirst(), playerItem, true)) == null) continue;
            return Pair.of((Object)crafted9, (Object)Float.valueOf(capacity));
        }
        return null;
    }

    public static ItemStack simulateCrafting(Level level, ItemStack dye, ItemStack playerItem, boolean surround) {
        DummyContainer container = surround ? DummyContainer.surround(dye.m_41777_(), playerItem.m_41777_()) : DummyContainer.of(dye.m_41777_(), playerItem.m_41777_());
        List recipes = level.m_7465_().m_44056_(RecipeType.f_44107_, (Container)container, level);
        for (CraftingRecipe r : recipes) {
            ItemStack recolored = r.m_5874_((Container)container, level.m_9598_());
            if (recolored.m_41619_() || playerItem.equals(recolored)) continue;
            NonNullList remainingItems = r.m_7457_((Container)container);
            remainingItems.remove((Object)Items.f_42590_.m_7968_());
            if (!remainingItems.stream().noneMatch(i -> !i.m_41619_() && !i.m_150930_(Items.f_42590_))) continue;
            return recolored;
        }
        return null;
    }
}

