/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.item.neptunium;

import com.teammetallurgy.aquaculture.init.AquaItems;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="aquaculture")
public class NeptuniumArmor
extends ArmorItem {
    private static final AttributeModifier INCREASED_SWIM_SPEED = new AttributeModifier(UUID.fromString("d820cadc-2d19-421c-b19f-4c1f5b84a418"), "Neptunium Boots swim speed boost", 0.5, AttributeModifier.Operation.ADDITION);
    private String texture;

    public NeptuniumArmor(ArmorMaterial armorMaterial, ArmorItem.Type type) {
        super(armorMaterial, type, new Item.Properties());
    }

    public void onArmorTick(@Nonnull ItemStack stack, Level world, Player player) {
        if (player.isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get())) {
            if (this.f_265916_ == ArmorItem.Type.HELMET) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 20, 0, false, false, false));
            } else if (this.f_265916_ == ArmorItem.Type.CHESTPLATE) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19608_, 20, 0, false, false, false));
            } else if (!(this.f_265916_ != ArmorItem.Type.LEGGINGS || player.m_6047_() || player.f_20899_ || player.m_6069_())) {
                player.m_20256_(Vec3.f_82478_);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            AttributeInstance swimSpeed;
            Player player = event.player;
            if (!player.m_9236_().f_46443_ && (swimSpeed = player.m_21051_((Attribute)ForgeMod.SWIM_SPEED.get())) != null) {
                if (player.m_20069_() && player.m_6844_(EquipmentSlot.FEET).m_41720_() == AquaItems.NEPTUNIUM_BOOTS.get()) {
                    if (!swimSpeed.m_22109_(INCREASED_SWIM_SPEED)) {
                        swimSpeed.m_22125_(INCREASED_SWIM_SPEED);
                    }
                } else if (swimSpeed.m_22109_(INCREASED_SWIM_SPEED)) {
                    swimSpeed.m_22130_(INCREASED_SWIM_SPEED);
                }
            }
        }
    }

    public Item setArmorTexture(String string) {
        this.texture = string;
        return this;
    }

    public String getArmorTexture(@Nonnull ItemStack stack, Entity entity, EquipmentSlot slot, String layer) {
        return "aquaculture:textures/armor/" + this.texture + ".png";
    }
}

