/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Either;
import com.mojang.math.Transformation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import net.minecraftforge.common.util.ConcatenatedListView;
import org.jetbrains.annotations.NotNull;

public class SimpleCompositeModel
implements IUnbakedGeometry<SimpleCompositeModel> {
    private static final String PARTICLE_MATERIAL = "particle";
    private final ImmutableMap<String, BlockModel> children;

    private SimpleCompositeModel(ImmutableMap<String, BlockModel> children) {
        this.children = children;
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
        Material particleLocation = context.getMaterial(PARTICLE_MATERIAL);
        TextureAtlasSprite particle = spriteGetter.apply(particleLocation);
        Transformation rootTransform = context.getRootTransform();
        if (!rootTransform.isIdentity()) {
            modelState = new SimpleModelState(modelState.m_6189_().m_121096_(rootTransform), modelState.m_7538_());
        }
        ImmutableMap.Builder bakedPartsBuilder = ImmutableMap.builder();
        for (Map.Entry entry : this.children.entrySet()) {
            String name = (String)entry.getKey();
            if (!context.isComponentVisible(name, true)) continue;
            BlockModel model = (BlockModel)entry.getValue();
            bakedPartsBuilder.put((Object)name, (Object)model.m_111449_(baker, model, spriteGetter, modelState, modelLocation, true));
        }
        ImmutableMap bakedParts = bakedPartsBuilder.build();
        ImmutableList.Builder itemPassesBuilder = ImmutableList.builder();
        return new Baked(context.isGui3d(), context.useBlockLight(), context.useAmbientOcclusion(), particle, context.getTransforms(), overrides, (ImmutableMap<String, BakedModel>)bakedParts, (ImmutableList<BakedModel>)itemPassesBuilder.build());
    }

    public Map<String, Either<Material, String>> getTextures() {
        HashMap<String, Either<Material, String>> textures = new HashMap<String, Either<Material, String>>();
        this.children.values().forEach(childModel -> {
            IUnbakedGeometry patt4043$temp;
            childModel.f_111417_.forEach(textures::putIfAbsent);
            if (childModel.customData.hasCustomGeometry() && (patt4043$temp = childModel.customData.getCustomGeometry()) instanceof SimpleCompositeModel) {
                SimpleCompositeModel compositeModel = (SimpleCompositeModel)patt4043$temp;
                compositeModel.getTextures().forEach(textures::putIfAbsent);
            } else if (childModel.f_111418_ != null) {
                childModel.f_111418_.f_111417_.forEach(textures::putIfAbsent);
            }
        });
        return textures;
    }

    public void resolveParents(Function<ResourceLocation, UnbakedModel> modelGetter, IGeometryBakingContext context) {
        this.children.values().forEach(childModel -> childModel.m_5500_(modelGetter));
    }

    public List<BlockElement> getElements() {
        ArrayList<BlockElement> elements = new ArrayList<BlockElement>();
        this.children.forEach((name, model) -> {
            IUnbakedGeometry patt4916$temp;
            elements.addAll(model.m_111436_());
            if (model.customData.hasCustomGeometry() && (patt4916$temp = model.customData.getCustomGeometry()) instanceof SimpleCompositeModel) {
                SimpleCompositeModel compositeModel = (SimpleCompositeModel)patt4916$temp;
                elements.addAll(compositeModel.getElements());
            }
        });
        return elements;
    }

    public Set<String> getConfigurableComponentNames() {
        return this.children.keySet();
    }

    public static class Baked
    implements IDynamicBakedModel {
        private final boolean isAmbientOcclusion;
        private final boolean isGui3d;
        private final boolean isSideLit;
        private final TextureAtlasSprite particle;
        private final ItemOverrides overrides;
        private final ItemTransforms transforms;
        private final ImmutableMap<String, BakedModel> children;
        private final ImmutableList<BakedModel> itemPasses;

        public Baked(boolean isGui3d, boolean isSideLit, boolean isAmbientOcclusion, TextureAtlasSprite particle, ItemTransforms transforms, ItemOverrides overrides, ImmutableMap<String, BakedModel> children, ImmutableList<BakedModel> itemPasses) {
            this.children = children;
            this.isAmbientOcclusion = isAmbientOcclusion;
            this.isGui3d = isGui3d;
            this.isSideLit = isSideLit;
            this.particle = particle;
            this.overrides = overrides;
            this.transforms = transforms;
            this.itemPasses = itemPasses;
        }

        @NotNull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData data, @Nullable RenderType renderType) {
            ArrayList<List> quadLists = new ArrayList<List>();
            for (Map.Entry entry : this.children.entrySet()) {
                quadLists.add(((BakedModel)entry.getValue()).getQuads(state, side, rand, ModelData.EMPTY, renderType));
            }
            return ConcatenatedListView.of(quadLists);
        }

        public ModelData getModelData(BlockAndTintGetter level, BlockPos pos, BlockState state, ModelData modelData) {
            return ModelData.EMPTY;
        }

        public boolean m_7541_() {
            return this.isAmbientOcclusion;
        }

        public boolean m_7539_() {
            return this.isGui3d;
        }

        public boolean m_7547_() {
            return this.isSideLit;
        }

        public boolean m_7521_() {
            return false;
        }

        public TextureAtlasSprite m_6160_() {
            return this.particle;
        }

        public ItemOverrides m_7343_() {
            return this.overrides;
        }

        public ItemTransforms m_7442_() {
            return this.transforms;
        }

        public List<BakedModel> getRenderPasses(ItemStack itemStack, boolean fabulous) {
            return this.itemPasses;
        }

        public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
            ArrayList<ChunkRenderTypeSet> sets = new ArrayList<ChunkRenderTypeSet>();
            for (Map.Entry entry : this.children.entrySet()) {
                sets.add(((BakedModel)entry.getValue()).getRenderTypes(state, rand, ModelData.EMPTY));
            }
            return ChunkRenderTypeSet.union(sets);
        }
    }

    public static final class Loader
    implements IGeometryLoader<SimpleCompositeModel> {
        public static final Loader INSTANCE = new Loader();

        private Loader() {
        }

        public SimpleCompositeModel read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) {
            ImmutableMap.Builder childrenBuilder = ImmutableMap.builder();
            this.readChildren(jsonObject, deserializationContext, (ImmutableMap.Builder<String, BlockModel>)childrenBuilder);
            ImmutableMap children = childrenBuilder.build();
            if (children.isEmpty()) {
                throw new JsonParseException("Composite model requires a \"parts\" element with at least one element.");
            }
            return new SimpleCompositeModel((ImmutableMap<String, BlockModel>)children);
        }

        private void readChildren(JsonObject jsonObject, JsonDeserializationContext deserializationContext, ImmutableMap.Builder<String, BlockModel> children) {
            if (!jsonObject.has("parts")) {
                return;
            }
            JsonObject childrenJsonObject = jsonObject.getAsJsonObject("parts");
            for (Map.Entry entry : childrenJsonObject.entrySet()) {
                children.put((Object)((String)entry.getKey()), (Object)((BlockModel)deserializationContext.deserialize((JsonElement)entry.getValue(), BlockModel.class)));
            }
        }
    }
}

