/*
 * Decompiled with CFR 0.152.
 */
package com.mangomilk.design_decor.blocks.ceiling_fan;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mangomilk.design_decor.blocks.ceiling_fan.CeilingFanBlockEntity;
import com.mangomilk.design_decor.registry.CDDPartialModels;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityInstance;
import com.simibubi.create.content.kinetics.base.flwdata.RotatingData;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;

public class CeilingFanInstance
extends KineticBlockEntityInstance<CeilingFanBlockEntity>
implements DynamicInstance {
    protected final RotatingData shaft;
    protected final ModelData fan;
    protected float lastAngle = Float.NaN;

    public CeilingFanInstance(MaterialManager materialManager, CeilingFanBlockEntity blockEntity) {
        super(materialManager, (KineticBlockEntity)blockEntity);
        this.shaft = this.setup((RotatingData)this.getRotatingMaterial().getModel(this.shaft()).createInstance());
        this.fan = (ModelData)this.getTransformMaterial().getModel(CDDPartialModels.CEILING_FAN, this.blockState).createInstance();
        this.animate(blockEntity.angle);
    }

    public void beginFrame() {
        float partialTicks = AnimationTickHolder.getPartialTicks();
        float speed = ((CeilingFanBlockEntity)this.blockEntity).visualSpeed.getValue(partialTicks) * 3.0f / 10.0f;
        float angle = ((CeilingFanBlockEntity)this.blockEntity).angle + speed * partialTicks;
        if ((double)Math.abs(angle - this.lastAngle) < 0.001) {
            return;
        }
        this.animate(angle);
        this.lastAngle = angle;
    }

    private void animate(float angle) {
        PoseStack ms = new PoseStack();
        TransformStack msr = TransformStack.cast((PoseStack)ms);
        msr.translate((Vec3i)this.getInstancePosition());
        ((TransformStack)((TransformStack)msr.centre()).rotate(Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)this.axis), AngleHelper.rad((double)angle))).unCentre();
        this.fan.setTransform(ms);
    }

    public void update() {
        this.updateRotation(this.shaft);
    }

    public void updateLight() {
        this.relight(this.pos, new FlatLit[]{this.shaft, this.fan});
    }

    public void remove() {
        this.shaft.delete();
        this.fan.delete();
    }
}

