/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.automobile.attachment.rear;

import io.github.foundationgames.automobility.automobile.attachment.RearAttachmentType;
import io.github.foundationgames.automobility.automobile.attachment.rear.BlockRearAttachment;
import io.github.foundationgames.automobility.automobile.attachment.rear.ChestRearAttachment;
import io.github.foundationgames.automobility.automobile.attachment.rear.SaddledBarrelRearAttachment;
import io.github.foundationgames.automobility.entity.AutomobileEntity;
import io.github.foundationgames.automobility.util.duck.EnderChestContainerDuck;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.PlayerEnderChestContainer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.ChestLidController;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class BaseChestRearAttachment
extends BlockRearAttachment {
    public static final Component TITLE_CHEST = Component.m_237115_((String)"container.chest");
    public static final Component TITLE_ENDER_CHEST = Component.m_237115_((String)"container.enderchest");
    public static final Component TITLE_BARREL = Component.m_237115_((String)"container.barrel");
    private final ContainerOpenersCounter viewerManager = new ContainerOpenersCounter(){

        protected void m_142292_(Level world, BlockPos pos, BlockState state) {
            BaseChestRearAttachment.sound(world, pos, BaseChestRearAttachment.this.getOpenSound());
        }

        protected void m_142289_(Level world, BlockPos pos, BlockState state) {
            BaseChestRearAttachment.sound(world, pos, BaseChestRearAttachment.this.getCloseSound());
        }

        protected void m_142148_(Level world, BlockPos pos, BlockState state, int oldViewerCount, int newViewerCount) {
            if (!world.m_5776_()) {
                BaseChestRearAttachment.this.updateTrackedAnimation(newViewerCount);
            }
        }

        protected boolean m_142718_(Player player) {
            if (!(player.f_36096_ instanceof ChestMenu)) {
                return false;
            }
            Container inventory = ((ChestMenu)player.f_36096_).m_39261_();
            return inventory == BaseChestRearAttachment.this;
        }
    };
    public final ChestLidController lidAnimator = new ChestLidController();

    public BaseChestRearAttachment(RearAttachmentType<?> type, AutomobileEntity entity, BlockState block, @Nullable BiFunction<ContainerLevelAccess, BlockRearAttachment, MenuProvider> screenProvider) {
        super(type, entity, block, screenProvider);
    }

    public void open(Player player) {
        if (!player.m_5833_()) {
            this.viewerManager.m_155452_(player, this.world(), this.automobile.m_20183_(), Blocks.f_50016_.m_49966_());
        }
    }

    public void close(Player player) {
        if (!player.m_5833_()) {
            this.viewerManager.m_155468_(player, this.world(), this.automobile.m_20183_(), Blocks.f_50016_.m_49966_());
        }
    }

    @Override
    public void onTrackedAnimationUpdated(float animation) {
        super.onTrackedAnimationUpdated(animation);
        this.lidAnimator.m_155377_(animation > 0.0f);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.world().m_5776_()) {
            this.lidAnimator.m_155374_();
        }
    }

    protected SoundEvent getOpenSound() {
        return SoundEvents.f_11889_;
    }

    protected SoundEvent getCloseSound() {
        return SoundEvents.f_11888_;
    }

    private static void sound(Level world, BlockPos pos, SoundEvent soundEvent) {
        world.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, soundEvent, SoundSource.BLOCKS, 0.5f, world.f_46441_.m_188501_() * 0.1f + 0.9f);
    }

    public static BaseChestRearAttachment chest(RearAttachmentType<?> type, AutomobileEntity entity) {
        return new ChestRearAttachment(type, entity, Blocks.f_50265_.m_49966_(), (ctx, att) -> {
            ChestRearAttachment chest;
            return att instanceof ChestRearAttachment ? (chest = (ChestRearAttachment)att) : null;
        });
    }

    public static BaseChestRearAttachment enderChest(RearAttachmentType<?> type, AutomobileEntity entity) {
        return new BaseChestRearAttachment(type, entity, Blocks.f_50265_.m_49966_(), (ctx, att) -> new SimpleMenuProvider((syncId, inventory, player) -> {
            PlayerEnderChestContainer enderChest = player.m_36327_();
            if (att instanceof BaseChestRearAttachment) {
                BaseChestRearAttachment chest = (BaseChestRearAttachment)att;
                EnderChestContainerDuck.of(enderChest).automobility$setActiveAttachment(chest);
            }
            return ChestMenu.m_39237_((int)syncId, (Inventory)inventory, (Container)enderChest);
        }, TITLE_ENDER_CHEST));
    }

    public static BaseChestRearAttachment saddledBarrel(RearAttachmentType<?> type, AutomobileEntity entity) {
        return new SaddledBarrelRearAttachment(type, entity, Blocks.f_50618_.m_49966_(), (ctx, att) -> {
            SaddledBarrelRearAttachment barrel;
            return att instanceof SaddledBarrelRearAttachment ? (barrel = (SaddledBarrelRearAttachment)att) : null;
        });
    }
}

