/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.automobile.render.attachment.rear;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import io.github.foundationgames.automobility.Automobility;
import io.github.foundationgames.automobility.automobile.attachment.rear.BannerPostRearAttachment;
import io.github.foundationgames.automobility.automobile.attachment.rear.RearAttachment;
import io.github.foundationgames.automobility.automobile.render.attachment.rear.RearAttachmentRenderModel;
import java.util.List;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BannerRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.Holder;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BannerPattern;
import org.jetbrains.annotations.Nullable;

public class BannerPostRearAttachmentModel
extends RearAttachmentRenderModel {
    public static final ModelLayerLocation MODEL_LAYER = new ModelLayerLocation(Automobility.rl("automobile/rear_attachment/banner_post"), "main");
    private final ModelPart fakePole;
    private final ModelPart pole;
    private final ModelPart bar;
    private final ModelPart flagPole;
    private final ModelPart flagBar;
    private final ModelPart flag;
    private boolean renderPole;
    private boolean renderFlag;
    private List<Pair<Holder<BannerPattern>, DyeColor>> patterns;

    public BannerPostRearAttachmentModel(EntityRendererProvider.Context ctx) {
        super(RenderType::m_110458_, ctx, MODEL_LAYER);
        this.fakePole = this.root.m_171324_("fake_pole");
        this.pole = this.root.m_171324_("pole");
        this.bar = this.pole.m_171324_("bar");
        this.flagPole = this.root.m_171324_("flag_pole");
        this.flagBar = this.flagPole.m_171324_("flag_bar");
        this.flag = this.flagBar.m_171324_("flag");
        this.flagPole.f_104207_ = false;
        this.pole.f_104207_ = false;
    }

    @Override
    public void setRenderState(@Nullable RearAttachment attachment, float wheelAngle, float tickDelta) {
        super.setRenderState(attachment, wheelAngle, tickDelta);
        float push = attachment == null ? 0.0f : (float)Math.pow(Math.max(0.0f, attachment.automobile().getHSpeed() * 0.368f), 2.0);
        this.pole.f_104203_ = -push;
        this.bar.f_104203_ = push;
        this.flagPole.f_104203_ = -push;
        this.flagBar.f_104203_ = push;
        if (attachment instanceof BannerPostRearAttachment) {
            BannerPostRearAttachment bannerPost = (BannerPostRearAttachment)attachment;
            this.renderFlag = bannerPost.getBaseColor() != null;
            this.patterns = bannerPost.getPatterns();
            this.flag.m_171327_(push, this.flag.f_104204_, 0.05f * (float)Math.sin(((float)attachment.automobile().getTime() + tickDelta) / 20.0f));
        }
        this.renderPole = attachment != null;
        this.fakePole.f_104207_ = false;
    }

    @Override
    public void renderExtra(PoseStack matrices, VertexConsumer vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        if (this.renderPole) {
            this.pole.f_104207_ = true;
            matrices.m_85836_();
            matrices.m_252880_(0.0f, -1.0f, 0.0f);
            matrices.m_85841_(0.666f, 0.666f, 0.666f);
            matrices.m_252880_(0.0f, 1.0f, 0.0f);
            this.pole.m_104306_(matrices, vertices, light, overlay, red, green, blue, alpha);
            matrices.m_85849_();
            this.pole.f_104207_ = false;
            this.renderPole = false;
        }
        this.fakePole.f_104207_ = true;
    }

    @Override
    public void renderOtherLayer(PoseStack matrices, MultiBufferSource consumers, int light, int overlay) {
        if (this.renderFlag) {
            this.flagPole.f_104207_ = true;
            matrices.m_85836_();
            matrices.m_252880_(0.0f, -1.0f, 0.0f);
            matrices.m_85841_(0.666f, 0.666f, 0.666f);
            matrices.m_252880_(0.0f, 1.0f, 0.0f);
            BannerRenderer.m_112074_((PoseStack)matrices, (MultiBufferSource)consumers, (int)light, (int)overlay, (ModelPart)this.flagPole, (Material)ModelBakery.f_119224_, (boolean)true, this.patterns, (boolean)false);
            matrices.m_85849_();
            this.flagPole.f_104207_ = false;
            this.renderFlag = false;
        }
    }
}

