/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.mixins;

import net.mehvahdjukaar.moonlight.api.block.IBlockHolder;
import net.mehvahdjukaar.moonlight.api.block.IPistonMotionReact;
import net.mehvahdjukaar.moonlight.core.misc.IExtendedPistonTile;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.piston.PistonMovingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PistonMovingBlockEntity.class})
public abstract class PistonBlockEntityMixin
extends BlockEntity
implements IBlockHolder,
IExtendedPistonTile {
    @Shadow
    private Direction f_60335_;
    @Shadow
    private float f_60339_;
    @Shadow
    private float f_60340_;
    @Shadow
    private BlockState f_60334_;
    @Shadow
    private boolean f_60336_;

    protected PistonBlockEntityMixin(BlockEntityType<?> pType, BlockPos pWorldPosition, BlockState pBlockState) {
        super(pType, pWorldPosition, pBlockState);
    }

    @Override
    public BlockState getHeldBlock() {
        return this.f_60334_;
    }

    @Override
    public boolean setHeldBlock(BlockState state) {
        this.f_60334_ = state;
        return true;
    }

    @Shadow
    protected abstract float m_60390_(float var1);

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private static void whileMoving(Level pLevel, BlockPos pPos, BlockState pState, PistonMovingBlockEntity tile, CallbackInfo info) {
        if (tile instanceof IExtendedPistonTile) {
            IExtendedPistonTile t = (IExtendedPistonTile)tile;
            t.tickMovedBlock(pLevel, pPos);
        }
    }

    @Override
    public void tickMovedBlock(Level level, BlockPos pos) {
        IPistonMotionReact mr;
        Block b;
        if (this.f_60340_ < 1.0f && (b = this.f_60334_.m_60734_()) instanceof IPistonMotionReact && (mr = (IPistonMotionReact)b).ticksWhileMoved()) {
            AABB aabb = this.moveByPositionAndProgress(pos, Shapes.m_83144_().m_83215_());
            mr.moveTick(this.f_60334_, level, pos, aabb, (PistonMovingBlockEntity)this);
        }
    }

    private AABB moveByPositionAndProgress(BlockPos pos, AABB aabb) {
        double d0 = this.m_60390_(this.f_60339_);
        return aabb.m_82386_((double)pos.m_123341_() + d0 * (double)this.f_60335_.m_122429_(), (double)pos.m_123342_() + d0 * (double)this.f_60335_.m_122430_(), (double)pos.m_123343_() + d0 * (double)this.f_60335_.m_122431_());
    }

    @Inject(method={"finalTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;neighborChanged(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/Block;Lnet/minecraft/core/BlockPos;)V", shift=At.Shift.AFTER)})
    public void onFinishedShortPulse(CallbackInfo ci) {
        Block block = this.f_60334_.m_60734_();
        if (block instanceof IPistonMotionReact) {
            IPistonMotionReact pr = (IPistonMotionReact)block;
            pr.onMoved(this.f_60334_, this.f_58857_, this.f_58858_, this.f_60335_, this.f_60336_, (PistonMovingBlockEntity)this);
        }
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;setBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;I)Z", shift=At.Shift.AFTER)}, require=2)
    private static void onFinishedMoving(Level level, BlockPos pos, BlockState state, PistonMovingBlockEntity blockEntity, CallbackInfo ci) {
        Block block = blockEntity.m_60400_().m_60734_();
        if (block instanceof IPistonMotionReact) {
            IPistonMotionReact pr = (IPistonMotionReact)block;
            pr.onMoved(blockEntity.m_60400_(), level, blockEntity.m_58899_(), blockEntity.m_60392_(), blockEntity.m_60387_(), blockEntity);
        }
    }
}

