/*
 * Decompiled with CFR 0.152.
 */
package artifacts;

import artifacts.component.SwimData;
import artifacts.item.wearable.necklace.CharmOfSinkingItem;
import artifacts.platform.PlatformServices;
import artifacts.registry.ModGameRules;
import artifacts.registry.ModItems;
import artifacts.registry.ModKeyMappings;
import dev.architectury.event.events.client.ClientTickEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class HeliumFlamingoInputEventHandler {
    private static boolean wasSprintKeyDown;
    private static boolean wasSprintingOnGround;
    private static boolean hasTouchedGround;

    public static void register() {
        ClientTickEvent.CLIENT_POST.register(HeliumFlamingoInputEventHandler::onClientTick);
    }

    private static void onClientTick(Minecraft instance) {
        LocalPlayer player = instance.f_91074_;
        if (player != null && player.f_108618_ != null) {
            HeliumFlamingoInputEventHandler.handleHeliumFlamingoInput((Player)player);
        }
    }

    private static void handleHeliumFlamingoInput(Player player) {
        if (ModGameRules.HELIUM_FLAMINGO_FLIGHT_DURATION.get() <= 0) {
            return;
        }
        boolean isSprintKeyDown = ModKeyMappings.getHeliumFlamingoKey().m_90857_();
        SwimData swimData = PlatformServices.platformHelper.getSwimData((LivingEntity)player);
        if (swimData == null) {
            return;
        }
        if (!swimData.isSwimming()) {
            if (player.m_20096_()) {
                hasTouchedGround = true;
            } else if (HeliumFlamingoInputEventHandler.canActivateHeliumFlamingo(swimData, player, isSprintKeyDown)) {
                swimData.setSwimming(true);
                swimData.syncSwimming();
                hasTouchedGround = false;
            }
        } else if (player.m_150110_().f_35935_) {
            swimData.setSwimming(false);
            swimData.syncSwimming();
            hasTouchedGround = true;
        }
        wasSprintKeyDown = isSprintKeyDown;
        if (!isSprintKeyDown) {
            wasSprintingOnGround = false;
        } else if (player.m_20096_()) {
            wasSprintingOnGround = true;
        }
    }

    private static boolean canActivateHeliumFlamingo(SwimData swimData, Player player, boolean isSprintKeyDown) {
        if (swimData.isSwimming() || swimData.getSwimTime() < 0 || !ModItems.HELIUM_FLAMINGO.get().isEquippedBy((LivingEntity)player)) {
            return false;
        }
        if (player.m_6069_()) {
            return true;
        }
        return isSprintKeyDown && !wasSprintKeyDown && !wasSprintingOnGround && hasTouchedGround && !player.m_20096_() && (!player.m_20069_() || CharmOfSinkingItem.shouldSink((LivingEntity)player)) && !player.m_21255_() && !player.m_150110_().f_35935_ && !player.m_20159_();
    }
}

