/*
 * Decompiled with CFR 0.152.
 */
package artifacts.registry;

import artifacts.mixin.gamerule.BooleanValueInvoker;
import artifacts.mixin.gamerule.IntegerValueInvoker;
import artifacts.network.BooleanGameRuleChangedPacket;
import artifacts.network.IntegerGameRuleChangedPacket;
import artifacts.network.NetworkHandler;
import artifacts.registry.ModItems;
import artifacts.registry.RegistrySupplier;
import com.google.common.base.CaseFormat;
import dev.architectury.event.EventResult;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.GameRules;

public class ModGameRules {
    private static final Map<String, BooleanValue> BOOLEAN_VALUES = new HashMap<String, BooleanValue>();
    private static final Map<String, IntegerValue> INTEGER_VALUES = new HashMap<String, IntegerValue>();
    public static final BooleanValue ANTIDOTE_VESSEL_ENABLED = ModGameRules.booleanValue(ModGameRules.createName(ModItems.ANTIDOTE_VESSEL, "enabled"));
    public static final BooleanValue AQUA_DASHERS_ENABLED = ModGameRules.booleanValue(ModGameRules.createName(ModItems.AQUA_DASHERS, "enabled"));
    public static final BooleanValue BUNNY_HOPPERS_DO_CANCEL_FALL_DAMAGE = ModGameRules.booleanValue(ModGameRules.createName(ModItems.BUNNY_HOPPERS, "doCancelFallDamage"));
    public static final BooleanValue CHARM_OF_SINKING_ENABLED = ModGameRules.booleanValue(ModGameRules.createName(ModItems.CHARM_OF_SINKING, "enabled"));
    public static final BooleanValue CLOUD_IN_A_BOTTLE_ENABLED = ModGameRules.booleanValue(ModGameRules.createName(ModItems.CLOUD_IN_A_BOTTLE, "enabled"));
    public static final BooleanValue ETERNAL_STEAK_ENABLED = ModGameRules.booleanValue(ModGameRules.createName(ModItems.ETERNAL_STEAK, "enabled"));
    public static final BooleanValue EVERLASTING_BEEF_ENABLED = ModGameRules.booleanValue(ModGameRules.createName(ModItems.EVERLASTING_BEEF, "enabled"));
    public static final BooleanValue FLAME_PENDANT_DO_GRANT_FIRE_RESISTANCE = ModGameRules.booleanValue(ModGameRules.createName(ModItems.FLAME_PENDANT, "doGrantFireResistance"));
    public static final BooleanValue KITTY_SLIPPERS_ENABLED = ModGameRules.booleanValue(ModGameRules.createName(ModItems.KITTY_SLIPPERS, "enabled"));
    public static final BooleanValue NIGHT_VISION_GOGGLES_ENABLED = ModGameRules.booleanValue(ModGameRules.createName(ModItems.NIGHT_VISION_GOGGLES, "enabled"));
    public static final BooleanValue RUNNING_SHOES_DO_INCREASE_STEP_HEIGHT = ModGameRules.booleanValue(ModGameRules.createName(ModItems.RUNNING_SHOES, "doIncreaseStepHeight"));
    public static final BooleanValue SCARF_OF_INVISIBILITY_ENABLED = ModGameRules.booleanValue(ModGameRules.createName(ModItems.SCARF_OF_INVISIBILITY, "enabled"));
    public static final BooleanValue SHOCK_PENDANT_DO_CANCEL_LIGHTNING_DAMAGE = ModGameRules.booleanValue(ModGameRules.createName(ModItems.SHOCK_PENDANT, "doCancelLightningDamage"));
    public static final BooleanValue SNORKEL_ENABLED = ModGameRules.booleanValue(ModGameRules.createName(ModItems.SNORKEL, "enabled"));
    public static final BooleanValue STEADFAST_SPIKES_ENABLED = ModGameRules.booleanValue(ModGameRules.createName(ModItems.STEADFAST_SPIKES, "enabled"));
    public static final BooleanValue UMBRELLA_IS_SHIELD = ModGameRules.booleanValue(ModGameRules.createName(ModItems.UMBRELLA, "isShield"));
    public static final BooleanValue UMBRELLA_IS_GLIDER = ModGameRules.booleanValue(ModGameRules.createName(ModItems.UMBRELLA, "isGlider"));
    public static final BooleanValue UNIVERSAL_ATTRACTOR_ENABLED = ModGameRules.booleanValue(ModGameRules.createName(ModItems.UNIVERSAL_ATTRACTOR, "enabled"));
    public static final IntegerValue ANTIDOTE_VESSEL_MAX_EFFECT_DURATION = ModGameRules.integerValue(ModGameRules.createName(ModItems.ANTIDOTE_VESSEL, "maxEffectDuration"), 5);
    public static final IntegerValue BUNNY_HOPPERS_JUMP_BOOST_LEVEL = ModGameRules.integerValue(ModGameRules.createName(ModItems.BUNNY_HOPPERS, "jumpBoostLevel"), 2);
    public static final IntegerValue CLOUD_IN_A_BOTTLE_SPRINT_JUMP_VERTICAL_VELOCITY = ModGameRules.integerValue(ModGameRules.createName(ModItems.CLOUD_IN_A_BOTTLE, "sprintJumpVerticalVelocity"), 50);
    public static final IntegerValue CLOUD_IN_A_BOTTLE_SPRINT_JUMP_HORIZONTAL_VELOCITY = ModGameRules.integerValue(ModGameRules.createName(ModItems.CLOUD_IN_A_BOTTLE, "sprintJumpHorizontalVelocity"), 50);
    public static final IntegerValue CROSS_NECKLACE_BONUS_INVINCIBILITY_TICKS = ModGameRules.integerValue(ModGameRules.createName(ModItems.CROSS_NECKLACE, "bonusInvincibilityTicks"), 20);
    public static final IntegerValue CROSS_NECKLACE_COOLDOWN = ModGameRules.integerValue(ModGameRules.createName(ModItems.CROSS_NECKLACE, "cooldown"), 0);
    public static final IntegerValue CRYSTAL_HEART_HEALTH_BONUS = ModGameRules.integerValue(ModGameRules.createName(ModItems.CRYSTAL_HEART, "healthBonus"), 10);
    public static final IntegerValue DIGGING_CLAWS_DIG_SPEED_BONUS = ModGameRules.integerValue(ModGameRules.createName(ModItems.DIGGING_CLAWS, "digSpeedBonus"), 32);
    public static final IntegerValue DIGGING_CLAWS_TOOL_TIER = ModGameRules.integerValue(ModGameRules.createName(ModItems.DIGGING_CLAWS, "toolTier"), 2);
    public static final IntegerValue ETERNAL_STEAK_COOLDOWN = ModGameRules.integerValue(ModGameRules.createName(ModItems.ETERNAL_STEAK, "cooldown"), 15);
    public static final IntegerValue EVERLASTING_BEEF_COOLDOWN = ModGameRules.integerValue(ModGameRules.createName(ModItems.EVERLASTING_BEEF, "cooldown"), 15);
    public static final IntegerValue FERAL_CLAWS_ATTACK_SPEED_BONUS = ModGameRules.integerValue(ModGameRules.createName(ModItems.FERAL_CLAWS, "attackSpeedBonus"), 40);
    public static final IntegerValue FIRE_GAUNTLET_FIRE_DURATION = ModGameRules.integerValue(ModGameRules.createName(ModItems.FIRE_GAUNTLET, "fireDuration"), 8);
    public static final IntegerValue FLAME_PENDANT_COOLDOWN = ModGameRules.integerValue(ModGameRules.createName(ModItems.FLAME_PENDANT, "cooldown"), 0);
    public static final IntegerValue FLAME_PENDANT_FIRE_DURATION = ModGameRules.integerValue(ModGameRules.createName(ModItems.FLAME_PENDANT, "fireDuration"), 10);
    public static final IntegerValue FLAME_PENDANT_STRIKE_CHANCE = ModGameRules.integerValue(ModGameRules.createName(ModItems.FLAME_PENDANT, "strikeChance"), 40);
    public static final IntegerValue FLIPPERS_SWIM_SPEED_BONUS = ModGameRules.integerValue(ModGameRules.createName(ModItems.FLIPPERS, "swimSpeedBonus"), 100);
    public static final IntegerValue GOLDEN_HOOK_EXPERIENCE_BONUS = ModGameRules.integerValue(ModGameRules.createName(ModItems.GOLDEN_HOOK, "experienceBonus"), 75);
    public static final IntegerValue HELIUM_FLAMINGO_FLIGHT_DURATION = ModGameRules.integerValue(ModGameRules.createName(ModItems.HELIUM_FLAMINGO, "flightDuration"), 8);
    public static final IntegerValue HELIUM_FLAMINGO_RECHARGE_DURATION = ModGameRules.integerValue(ModGameRules.createName(ModItems.HELIUM_FLAMINGO, "rechargeDuration"), 15);
    public static final IntegerValue LUCKY_SCARF_FORTUNE_BONUS = ModGameRules.integerValue(ModGameRules.createName(ModItems.LUCKY_SCARF, "fortuneBonus"), 1);
    public static final IntegerValue NOVELTY_DRINKING_HAT_DRINKING_DURATION_MULTIPLIER = ModGameRules.integerValue(ModGameRules.createName(ModItems.NOVELTY_DRINKING_HAT, "drinkingDurationMultiplier"), 30);
    public static final IntegerValue NOVELTY_DRINKING_HAT_EATING_DURATION_MULTIPLIER = ModGameRules.integerValue(ModGameRules.createName(ModItems.NOVELTY_DRINKING_HAT, "eatingDurationMultiplier"), 60);
    public static final IntegerValue OBSIDIAN_SKULL_FIRE_RESISTANCE_COOLDOWN = ModGameRules.integerValue(ModGameRules.createName(ModItems.OBSIDIAN_SKULL, "fireResistanceCooldown"), 60);
    public static final IntegerValue OBSIDIAN_SKULL_FIRE_RESISTANCE_DURATION = ModGameRules.integerValue(ModGameRules.createName(ModItems.OBSIDIAN_SKULL, "fireResistanceDuration"), 30);
    public static final IntegerValue PANIC_NECKLACE_COOLDOWN = ModGameRules.integerValue(ModGameRules.createName(ModItems.PANIC_NECKLACE, "cooldown"), 0);
    public static final IntegerValue PANIC_NECKLACE_SPEED_DURATION = ModGameRules.integerValue(ModGameRules.createName(ModItems.PANIC_NECKLACE, "speedDuration"), 8);
    public static final IntegerValue PANIC_NECKLACE_SPEED_LEVEL = ModGameRules.integerValue(ModGameRules.createName(ModItems.PANIC_NECKLACE, "speedLevel"), 1);
    public static final IntegerValue PLASTIC_DRINKING_HAT_DRINKING_DURATION_MULTIPLIER = ModGameRules.integerValue(ModGameRules.createName(ModItems.PLASTIC_DRINKING_HAT, "drinkingDurationMultiplier"), 30);
    public static final IntegerValue PLASTIC_DRINKING_HAT_EATING_DURATION_MULTIPLIER = ModGameRules.integerValue(ModGameRules.createName(ModItems.PLASTIC_DRINKING_HAT, "eatingDurationMultiplier"), 60);
    public static final IntegerValue POCKET_PISTON_KNOCKBACK_STRENGTH = ModGameRules.integerValue(ModGameRules.createName(ModItems.POCKET_PISTON, "knockbackStrength"), 15);
    public static final IntegerValue POWER_GLOVE_ATTACK_DAMAGE_BONUS = ModGameRules.integerValue(ModGameRules.createName(ModItems.POWER_GLOVE, "attackDamageBonus"), 4);
    public static final IntegerValue RUNNING_SHOES_SPEED_BONUS = ModGameRules.integerValue(ModGameRules.createName(ModItems.RUNNING_SHOES, "speedBonus"), 40);
    public static final IntegerValue SHOCK_PENDANT_COOLDOWN = ModGameRules.integerValue(ModGameRules.createName(ModItems.SHOCK_PENDANT, "cooldown"), 0);
    public static final IntegerValue SHOCK_PENDANT_STRIKE_CHANCE = ModGameRules.integerValue(ModGameRules.createName(ModItems.SHOCK_PENDANT, "strikeChance"), 25);
    public static final IntegerValue SNORKEL_WATER_BREATHING_DURATION = ModGameRules.integerValue(ModGameRules.createName(ModItems.SNORKEL, "waterBreathingDuration"), 15);
    public static final IntegerValue SUPERSTITIOUS_HAT_LOOTING_LEVEL_BONUS = ModGameRules.integerValue(ModGameRules.createName(ModItems.SUPERSTITIOUS_HAT, "lootingLevelBonus"), 1);
    public static final IntegerValue THORN_PENDANT_COOLDOWN = ModGameRules.integerValue(ModGameRules.createName(ModItems.THORN_PENDANT, "cooldown"), 0);
    public static final IntegerValue THORN_PENDANT_MAX_DAMAGE = ModGameRules.integerValue(ModGameRules.createName(ModItems.THORN_PENDANT, "maxDamage"), 6);
    public static final IntegerValue THORN_PENDANT_MIN_DAMAGE = ModGameRules.integerValue(ModGameRules.createName(ModItems.THORN_PENDANT, "minDamage"), 2);
    public static final IntegerValue THORN_PENDANT_STRIKE_CHANCE = ModGameRules.integerValue(ModGameRules.createName(ModItems.THORN_PENDANT, "strikeChance"), 50);
    public static final IntegerValue VAMPIRIC_GLOVE_ABSORPTION_CHANCE = ModGameRules.integerValue(ModGameRules.createName(ModItems.VAMPIRIC_GLOVE, "absorptionChance"), 100);
    public static final IntegerValue VAMPIRIC_GLOVE_ABSORPTION_RATIO = ModGameRules.integerValue(ModGameRules.createName(ModItems.VAMPIRIC_GLOVE, "absorptionRatio"), 20);
    public static final IntegerValue VAMPIRIC_GLOVE_MAX_HEALING_PER_HIT = ModGameRules.integerValue(ModGameRules.createName(ModItems.VAMPIRIC_GLOVE, "maxHealingPerHit"), 6);
    public static final IntegerValue VILLAGER_HAT_REPUTATION_BONUS = ModGameRules.integerValue(ModGameRules.createName(ModItems.VILLAGER_HAT, "reputationBonus"), 100);
    public static final IntegerValue WHOOPEE_CUSHION_FART_CHANCE = ModGameRules.integerValue(ModGameRules.createName(ModItems.WHOOPEE_CUSHION, "fartChance"), 12);

    private static String createName(RegistrySupplier<? extends Item> item, String name) {
        return String.format("%s.%s.%s", "artifacts", CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, item.getId().m_135815_()), name);
    }

    private static BooleanValue booleanValue(String name) {
        BooleanValue result = new BooleanValue();
        GameRules.Type<GameRules.BooleanValue> type = BooleanValueInvoker.invokeCreate(true, (server, value) -> {
            result.update(value.m_46223_());
            NetworkHandler.CHANNEL.sendToPlayers((Iterable)server.m_6846_().m_11314_(), (Object)new BooleanGameRuleChangedPacket(name, value.m_46223_()));
        });
        result.key = GameRules.m_46189_((String)name, (GameRules.Category)GameRules.Category.PLAYER, type);
        BOOLEAN_VALUES.put(name, result);
        return result;
    }

    private static IntegerValue integerValue(String name, int defaultValue) {
        return ModGameRules.integerValue(name, defaultValue, (server, value) -> {});
    }

    private static IntegerValue integerValue(String name, int defaultValue, BiConsumer<MinecraftServer, GameRules.IntegerValue> onChanged) {
        IntegerValue result = new IntegerValue();
        result.update(defaultValue);
        GameRules.Type<GameRules.IntegerValue> type = IntegerValueInvoker.invokeCreate(defaultValue, (server, value) -> {
            result.update(value.m_46288_());
            NetworkHandler.CHANNEL.sendToPlayers((Iterable)server.m_6846_().m_11314_(), (Object)new IntegerGameRuleChangedPacket(name, value.m_46288_()));
            onChanged.accept((MinecraftServer)server, (GameRules.IntegerValue)value);
        });
        result.key = GameRules.m_46189_((String)name, (GameRules.Category)GameRules.Category.PLAYER, type);
        INTEGER_VALUES.put(name, result);
        return result;
    }

    public static void updateValue(String key, boolean value) {
        BOOLEAN_VALUES.get(key).update(value);
    }

    public static void updateValue(String key, int value) {
        INTEGER_VALUES.get(key).update(value);
    }

    public static EventResult onPlayerJoinLevel(Entity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            BOOLEAN_VALUES.forEach((key, value) -> NetworkHandler.CHANNEL.sendToPlayer(player, (Object)new BooleanGameRuleChangedPacket((String)key, value.get())));
            INTEGER_VALUES.forEach((key, value) -> NetworkHandler.CHANNEL.sendToPlayer(player, (Object)new IntegerGameRuleChangedPacket((String)key, value.get())));
        }
        return EventResult.pass();
    }

    public static void onServerStarted(MinecraftServer server) {
        BOOLEAN_VALUES.values().forEach(value -> value.update(server));
        INTEGER_VALUES.values().forEach(value -> value.update(server));
    }

    public static class BooleanValue
    implements Supplier<Boolean> {
        private Boolean value = true;
        private GameRules.Key<GameRules.BooleanValue> key;

        @Override
        public Boolean get() {
            return this.value;
        }

        private void update(MinecraftServer server) {
            this.update(server.m_129900_().m_46207_(this.key));
        }

        private void update(boolean value) {
            this.value = value;
        }
    }

    public static class IntegerValue
    implements Supplier<Integer> {
        private Integer value;
        private GameRules.Key<GameRules.IntegerValue> key;

        @Override
        public Integer get() {
            return this.value;
        }

        private void update(MinecraftServer server) {
            this.update(server.m_129900_().m_46215_(this.key));
        }

        private void update(int value) {
            this.value = value;
        }
    }
}

