/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.customizableelytra.mixin;

import com.hidoni.customizableelytra.ElytraUtils;
import com.hidoni.customizableelytra.customization.CustomizationUtils;
import com.hidoni.customizableelytra.customization.ElytraCustomization;
import com.hidoni.customizableelytra.item.CustomizableElytraItem;
import com.hidoni.customizableelytra.item.ElytraWingItem;
import java.util.Optional;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ArmorTrim.class})
public class ArmorTrimMixin {
    @Inject(method={"setTrim"}, at={@At(value="HEAD")}, cancellable=true)
    private static void setArmorTrimForElytra(RegistryAccess access, ItemStack stack, ArmorTrim trim, CallbackInfoReturnable<Boolean> cir) {
        Item item = stack.m_41720_();
        if (item instanceof CustomizableElytraItem) {
            CustomizableElytraItem item2 = (CustomizableElytraItem)item;
            item2.setArmorTrim(stack, access, trim);
            cir.setReturnValue((Object)true);
        } else if (ElytraUtils.isElytra(stack)) {
            ElytraCustomization customization = CustomizationUtils.getElytraCustomization(stack);
            ItemStack leftWing = customization.leftWing();
            ((ElytraWingItem)leftWing.m_41720_()).setArmorTrim(leftWing, access, trim);
            ItemStack rightWing = customization.rightWing();
            ((ElytraWingItem)rightWing.m_41720_()).setArmorTrim(rightWing, access, trim);
            customization.saveToElytra(stack);
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"getTrim"}, at={@At(value="HEAD")}, cancellable=true)
    private static void getArmorTrimForElytra(RegistryAccess access, ItemStack stack, CallbackInfoReturnable<Optional<ArmorTrim>> cir) {
        Item item = stack.m_41720_();
        if (item instanceof CustomizableElytraItem) {
            CustomizableElytraItem customizableElytraItem = (CustomizableElytraItem)item;
            cir.setReturnValue(customizableElytraItem.getArmorTrim(stack, access));
        }
        if (ElytraUtils.isElytra(stack)) {
            ElytraCustomization customization = CustomizationUtils.getElytraCustomization(stack);
            ItemStack leftWing = customization.leftWing();
            Optional<ArmorTrim> returnTrim = ((CustomizableElytraItem)leftWing.m_41720_()).getArmorTrim(leftWing, access);
            if (returnTrim.isEmpty()) {
                cir.setReturnValue(returnTrim);
            } else {
                ItemStack rightWing = customization.rightWing();
                if (returnTrim.equals(((CustomizableElytraItem)rightWing.m_41720_()).getArmorTrim(rightWing, access))) {
                    cir.setReturnValue(returnTrim);
                } else {
                    cir.setReturnValue(Optional.empty());
                }
            }
        }
    }
}

