/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.uniform;

import java.util.function.Supplier;
import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.gl.state.ValueUpdateNotifier;
import net.coderbot.iris.gl.uniform.Uniform;
import org.joml.Vector2i;

public class Vector2IntegerJomlUniform
extends Uniform {
    private Vector2i cachedValue = null;
    private final Supplier<Vector2i> value;

    Vector2IntegerJomlUniform(int n, Supplier<Vector2i> supplier) {
        this(n, supplier, null);
    }

    Vector2IntegerJomlUniform(int n, Supplier<Vector2i> supplier, ValueUpdateNotifier valueUpdateNotifier) {
        super(n, valueUpdateNotifier);
        this.value = supplier;
    }

    @Override
    public void update() {
        this.updateValue();
        if (this.notifier != null) {
            this.notifier.setListener(this::updateValue);
        }
    }

    private void updateValue() {
        Vector2i vector2i = this.value.get();
        if (this.cachedValue == null || !vector2i.equals((Object)this.cachedValue)) {
            this.cachedValue = vector2i;
            IrisRenderSystem.uniform2i(this.location, vector2i.x, vector2i.y);
        }
    }
}

