/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gui.element;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.coderbot.iris.gui.GuiUtil;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_5348;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import net.minecraft.class_8030;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IrisElementRow {
    private final Map<Element, Integer> elements = new HashMap<Element, Integer>();
    private final List<Element> orderedElements = new ArrayList<Element>();
    private final int spacing;
    private int x;
    private int y;
    private int width;
    private int height;

    public IrisElementRow(int n) {
        this.spacing = n;
    }

    public IrisElementRow() {
        this(1);
    }

    public IrisElementRow add(Element element, int n) {
        if (!this.orderedElements.contains(element)) {
            this.orderedElements.add(element);
        }
        this.elements.put(element, n);
        this.width += n + this.spacing;
        return this;
    }

    public void setWidth(Element element, int n) {
        if (!this.elements.containsKey(element)) {
            return;
        }
        this.width -= this.elements.get(element) + 2;
        this.add(element, n);
    }

    public void render(class_332 class_3322, int n, int n2, int n3, int n4, int n5, float f, boolean bl) {
        this.x = n;
        this.y = n2;
        this.height = n3;
        int n6 = n;
        for (Element element : this.orderedElements) {
            int n7 = this.elements.get(element);
            element.render(class_3322, n6, n2, n7, n3, n4, n5, f, bl && this.sectionHovered(n6, n7, n4, n5));
            n6 += n7 + this.spacing;
        }
    }

    public void renderRightAligned(class_332 class_3322, int n, int n2, int n3, int n4, int n5, float f, boolean bl) {
        this.render(class_3322, n - this.width, n2, n3, n4, n5, f, bl);
    }

    private boolean sectionHovered(int n, int n2, double d, double d2) {
        return d > (double)n && d < (double)(n + n2) && d2 > (double)this.y && d2 < (double)(this.y + this.height);
    }

    private Optional<Element> getHovered(double d, double d2) {
        int n = this.x;
        for (Element element : this.orderedElements) {
            int n2 = this.elements.get(element);
            if (this.sectionHovered(n, n2, d, d2)) {
                return Optional.of(element);
            }
            n += n2 + this.spacing;
        }
        return Optional.empty();
    }

    private Optional<Element> getFocused() {
        return this.orderedElements.stream().filter(Element::method_25370).findFirst();
    }

    public boolean mouseClicked(double d, double d2, int n) {
        return this.getHovered(d, d2).map(element -> element.method_25402(d, d2, n)).orElse(false);
    }

    public boolean mouseReleased(double d, double d2, int n) {
        return this.getHovered(d, d2).map(element -> element.method_25406(d, d2, n)).orElse(false);
    }

    public boolean keyPressed(int n, int n2, int n3) {
        return this.getFocused().map(element -> element.method_25404(n, n2, n3)).orElse(false);
    }

    public List<? extends class_364> children() {
        return ImmutableList.copyOf(this.orderedElements);
    }

    public static abstract class Element
    implements class_364 {
        public boolean disabled = false;
        private boolean hovered = false;
        private boolean focused;
        private class_8030 bounds = class_8030.method_48248();

        public void render(class_332 class_3322, int n, int n2, int n3, int n4, int n5, int n6, float f, boolean bl) {
            this.bounds = new class_8030(n, n2, n3, n4);
            GuiUtil.bindIrisWidgetsTexture();
            GuiUtil.drawButton(class_3322, n, n2, n3, n4, this.isHovered() || this.method_25370(), this.disabled);
            this.hovered = bl;
            this.renderLabel(class_3322, n, n2, n3, n4, n5, n6, f, bl);
        }

        public abstract void renderLabel(class_332 var1, int var2, int var3, int var4, int var5, int var6, int var7, float var8, boolean var9);

        public boolean isHovered() {
            return this.hovered;
        }

        public boolean method_25370() {
            return this.focused;
        }

        public void method_25365(boolean bl) {
            this.focused = bl;
        }

        @Nullable
        public class_8016 method_48205(class_8023 class_80232) {
            return !this.method_25370() ? class_8016.method_48193((class_364)this) : null;
        }

        @NotNull
        public class_8030 method_48202() {
            return this.bounds;
        }
    }

    public static class TextButtonElement
    extends ButtonElement<TextButtonElement> {
        protected final class_327 font;
        public class_2561 text;

        public TextButtonElement(class_2561 class_25612, Function<TextButtonElement, Boolean> function) {
            super(function);
            this.font = class_310.method_1551().field_1772;
            this.text = class_25612;
        }

        @Override
        public void renderLabel(class_332 class_3322, int n, int n2, int n3, int n4, int n5, int n6, float f, boolean bl) {
            int n7 = n + (int)((double)(n3 - this.font.method_27525((class_5348)this.text)) * 0.5);
            int n8 = n2 + (int)((double)(n4 - 8) * 0.5);
            class_3322.method_27535(this.font, this.text, n7, n8, 0xFFFFFF);
        }
    }

    public static class IconButtonElement
    extends ButtonElement<IconButtonElement> {
        public GuiUtil.Icon icon;
        public GuiUtil.Icon hoveredIcon;

        public IconButtonElement(GuiUtil.Icon icon, GuiUtil.Icon icon2, Function<IconButtonElement, Boolean> function) {
            super(function);
            this.icon = icon;
            this.hoveredIcon = icon2;
        }

        public IconButtonElement(GuiUtil.Icon icon, Function<IconButtonElement, Boolean> function) {
            this(icon, icon, function);
        }

        @Override
        public void renderLabel(class_332 class_3322, int n, int n2, int n3, int n4, int n5, int n6, float f, boolean bl) {
            int n7 = n + (int)((double)(n3 - this.icon.getWidth()) * 0.5);
            int n8 = n2 + (int)((double)(n4 - this.icon.getHeight()) * 0.5);
            GuiUtil.bindIrisWidgetsTexture();
            if (!this.disabled && (bl || this.method_25370())) {
                this.hoveredIcon.draw(class_3322, n7, n8);
            } else {
                this.icon.draw(class_3322, n7, n8);
            }
        }
    }

    public static abstract class ButtonElement<T extends ButtonElement<T>>
    extends Element {
        private final Function<T, Boolean> onClick;

        protected ButtonElement(Function<T, Boolean> function) {
            this.onClick = function;
        }

        public boolean method_25402(double d, double d2, int n) {
            if (this.disabled) {
                return false;
            }
            if (n == 0) {
                return this.onClick.apply(this);
            }
            return super.method_25402(d, d2, n);
        }

        public boolean method_25404(int n, int n2, int n3) {
            if (n == 257) {
                return this.onClick.apply(this);
            }
            return false;
        }
    }
}

