/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.items;

import com.jesz.createdieselgenerators.config.ConfigRegistry;
import com.jesz.createdieselgenerators.entity.ChemicalSprayerProjectileEntity;
import com.jesz.createdieselgenerators.items.ChemicalSprayerItemRenderer;
import com.jesz.createdieselgenerators.other.FuelTypeManager;
import com.simibubi.create.AllEnchantments;
import com.simibubi.create.content.equipment.armor.CapacityEnchantment;
import com.simibubi.create.foundation.item.CustomArmPoseItem;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModelRenderer;
import com.simibubi.create.foundation.item.render.SimpleCustomRenderer;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import net.minecraftforge.fml.ModList;

public class ChemicalSprayerItem
extends Item
implements CustomArmPoseItem,
CapacityEnchantment.ICapacityEnchantable {
    boolean lighter;

    public ChemicalSprayerItem(Item.Properties properties, boolean lighter) {
        super(properties.m_41487_(1));
        this.lighter = lighter;
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> components, TooltipFlag tooltipFlag) {
        super.m_7373_(stack, level, components, tooltipFlag);
        if (stack.m_41783_() != null) {
            CompoundTag tankCompound = stack.m_41783_().m_128469_("Fluid");
            FluidStack fStack = FluidStack.loadFluidStackFromNBT((CompoundTag)tankCompound);
            if (fStack.isEmpty()) {
                components.add((Component)Component.m_237115_((String)"createdieselgenerators.tooltip.empty").m_130940_(ChatFormatting.GRAY));
                return;
            }
            components.add((Component)Lang.fluidName((FluidStack)fStack).component().m_130940_(ChatFormatting.GRAY).m_130946_(" ").m_7220_((Component)Lang.number((double)fStack.getAmount()).style(ChatFormatting.GOLD).component()).m_7220_((Component)Component.m_237115_((String)"create.generic.unit.millibuckets").m_130940_(ChatFormatting.GOLD)).m_7220_((Component)Component.m_237113_((String)" / ")).m_7220_((Component)Lang.number((double)((Integer)ConfigRegistry.TOOL_CAPACITY.get() + stack.getEnchantmentLevel((Enchantment)AllEnchantments.CAPACITY.get()) * (Integer)ConfigRegistry.TOOL_CAPACITY_ENCHANTMENT.get())).style(ChatFormatting.GRAY).component()).m_7220_((Component)Component.m_237115_((String)"create.generic.unit.millibuckets").m_130940_(ChatFormatting.GRAY)));
            return;
        }
        components.add((Component)Component.m_237115_((String)"createdieselgenerators.tooltip.empty").m_130940_(ChatFormatting.GRAY));
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.NONE;
    }

    public HumanoidModel.ArmPose getArmPose(ItemStack stack, AbstractClientPlayer player, InteractionHand hand) {
        if (!player.f_20911_) {
            return HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
        return null;
    }

    public int m_142159_(ItemStack stack) {
        return 0xEFEFEF;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        FluidStack fluidStack;
        ItemStack stackInHand = player.m_21120_(hand);
        if (stackInHand.m_41783_() != null && (fluidStack = FluidStack.loadFluidStackFromNBT((CompoundTag)stackInHand.m_41783_().m_128469_("Fluid"))).getAmount() != 0) {
            player.m_6672_(hand);
        }
        return super.m_7203_(level, player, hand);
    }

    public boolean m_8120_(ItemStack stack) {
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == AllEnchantments.CAPACITY.get()) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public void m_5929_(Level level, LivingEntity player, ItemStack stack, int count) {
        FluidStack fluidStack;
        if (stack.m_41783_() != null && !(fluidStack = FluidStack.loadFluidStackFromNBT((CompoundTag)stack.m_41783_().m_128469_("Fluid"))).isEmpty() && !level.f_46443_) {
            Player p;
            if (count % 2 == 0) {
                ChemicalSprayerProjectileEntity projectile = ChemicalSprayerProjectileEntity.spray(level, fluidStack, FuelTypeManager.getGeneratedSpeed(fluidStack.getFluid()) != 0.0f && this.lighter || fluidStack.getFluid().m_6212_((Fluid)Fluids.f_76195_), fluidStack.getFluid().m_6212_((Fluid)Fluids.f_76193_));
                projectile.m_146884_(player.m_20182_().m_82520_(0.0, 1.5, 0.0));
                projectile.m_37251_((Entity)player, player.m_146909_() + new Random().nextFloat(-5.0f, 5.0f), player.m_146908_() + new Random().nextFloat(-5.0f, 5.0f), 0.0f, 1.0f, 1.0f);
                level.m_7967_((Entity)projectile);
                fluidStack.setAmount(fluidStack.getAmount() - 1);
            }
            if (!(player instanceof Player && (p = (Player)player).m_7500_() || count % 25 != 0)) {
                fluidStack.writeToNBT(stack.m_41783_().m_128469_("Fluid"));
            }
        }
        super.m_5929_(level, player, stack, count);
    }

    public int m_8105_(ItemStack stack) {
        return 1000;
    }

    public boolean m_142522_(ItemStack stack) {
        if (stack.m_41783_() != null) {
            CompoundTag tankCompound = stack.m_41783_().m_128469_("Fluid");
            FluidStack fStack = FluidStack.loadFluidStackFromNBT((CompoundTag)tankCompound);
            return !fStack.isEmpty();
        }
        return false;
    }

    public int m_142158_(ItemStack stack) {
        if (stack.m_41783_() == null) {
            return 0;
        }
        CompoundTag tankCompound = stack.m_41783_().m_128469_("Fluid");
        return Math.round(13.0f * Mth.m_14036_((float)((float)FluidStack.loadFluidStackFromNBT((CompoundTag)tankCompound).getAmount() / ((float)((Integer)ConfigRegistry.TOOL_CAPACITY.get()).intValue() + (float)(stack.getEnchantmentLevel((Enchantment)AllEnchantments.CAPACITY.get()) * (Integer)ConfigRegistry.TOOL_CAPACITY_ENCHANTMENT.get()))), (float)0.0f, (float)1.0f));
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        if (!ModList.get().isLoaded("dungeons_libraries")) {
            return new FluidHandlerItemStack(stack, (Integer)ConfigRegistry.TOOL_CAPACITY.get() + stack.getEnchantmentLevel((Enchantment)AllEnchantments.CAPACITY.get()) * (Integer)ConfigRegistry.TOOL_CAPACITY_ENCHANTMENT.get());
        }
        return new FluidHandlerItemStack(stack, ((Integer)ConfigRegistry.TOOL_CAPACITY.get()).intValue());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)SimpleCustomRenderer.create((Item)this, (CustomRenderedItemModelRenderer)new ChemicalSprayerItemRenderer()));
    }
}

