/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.blocks;

import com.endertech.minecraft.forge.world.GameWorld;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public interface IWaterLoggable
extends SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public static FluidState getFluidState(BlockState state, boolean falling) {
        return IWaterLoggable.isWaterlogged(state) ? Fluids.f_76193_.m_76068_(falling) : Fluids.f_76191_.m_76145_();
    }

    public static BlockState getStateForPlacementAt(LevelReader world, BlockPos pos, BlockState originalState) {
        if (originalState.m_61138_((Property)WATERLOGGED) && GameWorld.isWaterSource(world, pos)) {
            return (BlockState)originalState.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true));
        }
        return originalState;
    }

    public static BlockState getStateForPlacement(BlockPlaceContext context, BlockState originalState) {
        return IWaterLoggable.getStateForPlacementAt((LevelReader)context.m_43725_(), context.m_8083_(), originalState);
    }

    public static BlockState updateFluidPostPlacement(LevelAccessor worldIn, BlockPos currentPos, BlockState stateIn) {
        if (IWaterLoggable.isWaterlogged(stateIn)) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return stateIn;
    }

    public static boolean isWaterlogged(BlockState state) {
        return state.m_61138_((Property)WATERLOGGED) && (Boolean)state.m_61143_((Property)WATERLOGGED) != false;
    }
}

