/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import doggytalents.DoggyAccessories;
import doggytalents.DoggyAttributes;
import doggytalents.DoggyBlocks;
import doggytalents.DoggyEffects;
import doggytalents.DoggyEntityTypes;
import doggytalents.DoggyItems;
import doggytalents.DoggySerializers;
import doggytalents.DoggyTags;
import doggytalents.DoggyTalentsNext;
import doggytalents.api.enu.WetSource;
import doggytalents.api.feature.DataKey;
import doggytalents.api.feature.DogLevel;
import doggytalents.api.feature.DogSize;
import doggytalents.api.feature.EnumGender;
import doggytalents.api.feature.EnumMode;
import doggytalents.api.feature.FoodHandler;
import doggytalents.api.feature.InteractHandler;
import doggytalents.api.impl.DogAlterationProps;
import doggytalents.api.impl.DogArmorItemHandler;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.inferface.IDogAlteration;
import doggytalents.api.inferface.IDogFoodHandler;
import doggytalents.api.inferface.IThrowableItem;
import doggytalents.api.registry.Accessory;
import doggytalents.api.registry.AccessoryInstance;
import doggytalents.api.registry.AccessoryType;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.client.DogTextureManager;
import doggytalents.client.entity.model.dog.DogModel;
import doggytalents.client.entity.skin.DogSkin;
import doggytalents.client.event.ClientEventHandler;
import doggytalents.client.screen.DogNewInfoScreen.DogNewInfoScreen;
import doggytalents.client.screen.DogNewInfoScreen.screen.DogCannotInteractWithScreen;
import doggytalents.common.artifacts.DoggyArtifact;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.effects.NattoBiteEffect;
import doggytalents.common.entity.DogGroupsManager;
import doggytalents.common.entity.DogIncapacitatedMananger;
import doggytalents.common.entity.DogMiningCautiousManager;
import doggytalents.common.entity.DogOwnerDistanceManager;
import doggytalents.common.entity.ai.BerserkerModeGoal;
import doggytalents.common.entity.ai.DogAvoidPushWhenIdleGoal;
import doggytalents.common.entity.ai.DogBegGoal;
import doggytalents.common.entity.ai.DogBreedGoal;
import doggytalents.common.entity.ai.DogCommonSitIdleGoal;
import doggytalents.common.entity.ai.DogCommonStandIdleGoal;
import doggytalents.common.entity.ai.DogDrunkGoal;
import doggytalents.common.entity.ai.DogFeelingNakeyGoal;
import doggytalents.common.entity.ai.DogFindWaterGoal;
import doggytalents.common.entity.ai.DogFloatGoal;
import doggytalents.common.entity.ai.DogFollowOwnerGoal;
import doggytalents.common.entity.ai.DogFollowOwnerGoalDefeated;
import doggytalents.common.entity.ai.DogGoAwayFromFireGoal;
import doggytalents.common.entity.ai.DogGoRestOnBedGoalDefeated;
import doggytalents.common.entity.ai.DogHungryGoal;
import doggytalents.common.entity.ai.DogLookAtPlayerGoal;
import doggytalents.common.entity.ai.DogLowHealthGoal;
import doggytalents.common.entity.ai.DogMeleeAttackGoal;
import doggytalents.common.entity.ai.DogMoveBackToRestrictGoal;
import doggytalents.common.entity.ai.DogNearestToOwnerAttackableTargetGoal;
import doggytalents.common.entity.ai.DogOwnerHurtByTargetGoal;
import doggytalents.common.entity.ai.DogOwnerHurtTargetGoal;
import doggytalents.common.entity.ai.DogProtestSitOrderGoal;
import doggytalents.common.entity.ai.DogRandomSitIdleGoal;
import doggytalents.common.entity.ai.DogRandomSniffGoal;
import doggytalents.common.entity.ai.DogRandomStandIdleGoal;
import doggytalents.common.entity.ai.DogRandomStrollGoal;
import doggytalents.common.entity.ai.DogRestWhenSitGoal;
import doggytalents.common.entity.ai.DogSitWhenOrderedGoal;
import doggytalents.common.entity.ai.DogWrappedGoal;
import doggytalents.common.entity.ai.GuardModeGoal;
import doggytalents.common.entity.ai.PatrolAssistTargetGoal;
import doggytalents.common.entity.ai.nav.DogBodyRotationControl;
import doggytalents.common.entity.ai.nav.DogMoveControl;
import doggytalents.common.entity.ai.nav.DogPathNavigation;
import doggytalents.common.entity.ai.nav.IDogNavLock;
import doggytalents.common.entity.ai.triggerable.AnimationAction;
import doggytalents.common.entity.ai.triggerable.DogBackFlipAction;
import doggytalents.common.entity.ai.triggerable.DogDrownAction;
import doggytalents.common.entity.ai.triggerable.DogTriggerableGoal;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import doggytalents.common.entity.anim.DogAnimation;
import doggytalents.common.entity.anim.DogAnimationManager;
import doggytalents.common.entity.anim.DogPose;
import doggytalents.common.entity.datasync.DogDataSyncManager;
import doggytalents.common.entity.serializers.DimensionDependantArg;
import doggytalents.common.entity.stats.StatsTracker;
import doggytalents.common.entity.texture.DogSkinData;
import doggytalents.common.item.DoggyArtifactItem;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.ParticlePackets;
import doggytalents.common.network.packet.data.DogMountData;
import doggytalents.common.network.packet.data.DogShakingData;
import doggytalents.common.storage.DogLocationData;
import doggytalents.common.storage.DogLocationStorage;
import doggytalents.common.storage.DogRespawnData;
import doggytalents.common.storage.DogRespawnStorage;
import doggytalents.common.util.BackwardsComp;
import doggytalents.common.util.Cache;
import doggytalents.common.util.DogUtil;
import doggytalents.common.util.NBTUtil;
import doggytalents.common.util.WorldUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.network.PacketDistributor;
import org.apache.commons.lang3.ObjectUtils;

public class Dog
extends AbstractDog {
    private static final EntityDataAccessor<Optional<Component>> LAST_KNOWN_NAME = SynchedEntityData.m_135353_(Dog.class, (EntityDataSerializer)EntityDataSerializers.f_135032_);
    private static final EntityDataAccessor<Integer> DOG_FLAGS = SynchedEntityData.m_135353_(Dog.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> HUNGER_INT = SynchedEntityData.m_135353_(Dog.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<ItemStack> BONE_VARIANT = SynchedEntityData.m_135353_(Dog.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Integer> INCAP_VAL = SynchedEntityData.m_135353_(Dog.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANIMATION = SynchedEntityData.m_135353_(Dog.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANIM_SYNC_TIME = SynchedEntityData.m_135353_(Dog.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final Cache<EntityDataAccessor<DogLevel>> DOG_LEVEL = Cache.make(() -> SynchedEntityData.m_135353_(Dog.class, (EntityDataSerializer)((EntityDataSerializer)DoggySerializers.DOG_LEVEL_SERIALIZER.get())));
    private static final Cache<EntityDataAccessor<EnumGender>> GENDER = Cache.make(() -> SynchedEntityData.m_135353_(Dog.class, (EntityDataSerializer)((EntityDataSerializer)DoggySerializers.GENDER_SERIALIZER.get())));
    private static final Cache<EntityDataAccessor<EnumMode>> MODE = Cache.make(() -> SynchedEntityData.m_135353_(Dog.class, (EntityDataSerializer)((EntityDataSerializer)DoggySerializers.MODE_SERIALIZER.get())));
    private static final Cache<EntityDataAccessor<DimensionDependantArg<Optional<BlockPos>>>> DOG_BED_LOCATION = Cache.make(() -> SynchedEntityData.m_135353_(Dog.class, (EntityDataSerializer)((EntityDataSerializer)DoggySerializers.BED_LOC_SERIALIZER.get())));
    private static final Cache<EntityDataAccessor<DimensionDependantArg<Optional<BlockPos>>>> DOG_BOWL_LOCATION = Cache.make(() -> SynchedEntityData.m_135353_(Dog.class, (EntityDataSerializer)((EntityDataSerializer)DoggySerializers.BED_LOC_SERIALIZER.get())));
    private static final Cache<EntityDataAccessor<DogIncapacitatedMananger.IncapacitatedSyncState>> DOG_INCAP_SYNC_STATE = Cache.make(() -> SynchedEntityData.m_135353_(Dog.class, (EntityDataSerializer)((EntityDataSerializer)DoggySerializers.INCAP_SYNC_SERIALIZER.get())));
    private static final Cache<EntityDataAccessor<List<DoggyArtifactItem>>> ARTIFACTS = Cache.make(() -> SynchedEntityData.m_135353_(Dog.class, (EntityDataSerializer)((EntityDataSerializer)DoggySerializers.ARTIFACTS_SERIALIZER.get())));
    private static final Cache<EntityDataAccessor<DogSize>> DOG_SIZE = Cache.make(() -> SynchedEntityData.m_135353_(Dog.class, (EntityDataSerializer)((EntityDataSerializer)DoggySerializers.DOG_SIZE_SERIALIZER.get())));
    private static final Cache<EntityDataAccessor<DogSkinData>> CUSTOM_SKIN = Cache.make(() -> SynchedEntityData.m_135353_(Dog.class, (EntityDataSerializer)((EntityDataSerializer)DoggySerializers.DOG_SKIN_DATA_SERIALIZER.get())));
    private final Cache<Integer> spendablePoints = Cache.make(this::getSpendablePointsInternal);
    private final List<IDogAlteration> alterations = new ArrayList<IDogAlteration>(4);
    private final List<IDogFoodHandler> foodHandlers = new ArrayList<IDogFoodHandler>(4);
    public final DogAnimationManager animationManager = new DogAnimationManager(this);
    public final Map<Integer, Object> objects = new HashMap<Integer, Object>();
    private DogSkin clientSkin = DogSkin.CLASSICAL;
    private ArrayList<AccessoryInstance> clientAccessories = new ArrayList();
    public final StatsTracker statsTracker = new StatsTracker();
    public final DogDataSyncManager dogSyncedDataManager = new DogDataSyncManager(this);
    public final DogOwnerDistanceManager dogOwnerDistanceManager = new DogOwnerDistanceManager(this);
    public final DogMiningCautiousManager dogMiningCautiousManager = new DogMiningCautiousManager(this);
    public final DogGroupsManager dogGroupsManager = new DogGroupsManager();
    public final DogIncapacitatedMananger incapacitatedMananger = new DogIncapacitatedMananger(this);
    private DogAlterationProps alterationProps = new DogAlterationProps();
    private final DogArmorItemHandler dogArmors = new DogArmorItemHandler(this);
    private ItemStack mouthStack = ItemStack.f_41583_;
    protected final PathNavigation defaultNavigation;
    protected final MoveControl defaultMoveControl;
    @Nullable
    protected IDogNavLock navigationLock;
    protected PathNavigation currentNavigation;
    protected TriggerableAction stashedAction;
    protected TriggerableAction activeAction;
    protected int delayedActionStart = 0;
    protected int actionPendingTime = 0;
    protected List<WrappedGoal> trivialBlocking;
    protected List<WrappedGoal> nonTrivialBlocking;
    protected int switchNavCooldown = 0;
    private int hungerTick;
    private int prevHungerTick;
    private int hungerSaturation;
    private int hungerSaturationHealingTick;
    private int healingTick;
    private int prevHealingTick;
    private int wanderCooldown = 0;
    private int drunkTickLeft = 0;
    private float headRotationCourse;
    private float headRotationCourseOld;
    @Nonnull
    private WetSource wetSource = WetSource.NONE;
    private boolean isShaking;
    private float timeWolfIsShaking;
    private float prevTimeWolfIsShaking;
    private int tickUntilRest;
    private int onFireSmokeTick;
    private boolean shakeFire = false;
    private float radPerHealthDecrease;
    private float maxHealth0;
    protected boolean dogJumping;
    protected float jumpPower;
    protected boolean isDogSwimming;
    protected boolean isLowHunger;
    protected boolean isZeroHunger;
    protected int hungerDamageTick;
    public int lastOrderedToSitTick;
    private int tickChopinTail;
    private boolean dogAnimHurtImpules = false;
    private int idleAnimHurtCooldown = 0;
    private static final UUID HUNGER_MOVEMENT = UUID.fromString("50671f49-1dfd-4397-242b-78bb6b178115");
    private EntityDimensions visualDimension = null;
    private boolean isProtesting = false;
    private boolean ridingAuthorized = false;
    private boolean authorizedChangingOwner = false;
    private boolean authorizedChangingName = false;
    public static int MAX_NAME_LEN = 32;
    private boolean changeDimensionAuthorized = false;
    private Optional<DamageSource> dogDeathCause = Optional.empty();
    private boolean detectedDuplicateVertified = false;
    private boolean DTN_dogChangingDim = false;
    private UUID cachedSessionUUID = null;
    private DogAnimation sitAnim = DogAnimation.SIT_DOWN;
    private DogAnimation standAnim = DogAnimation.STAND_QUICK;
    private boolean isDogFollowingSomeone;
    private boolean isDogCurious;
    private AnimationAction animAction;
    private DogPose activePose = DogPose.STAND;

    public static final void initDataParameters() {
        DOG_LEVEL.get();
        GENDER.get();
        MODE.get();
        DOG_BED_LOCATION.get();
        DOG_BOWL_LOCATION.get();
        DOG_INCAP_SYNC_STATE.get();
        ARTIFACTS.get();
        DOG_SIZE.get();
        CUSTOM_SKIN.get();
    }

    public Dog(EntityType<? extends Dog> type, Level worldIn) {
        super(type, worldIn);
        this.m_7105_(false);
        this.setGender(EnumGender.random(this.m_217043_()));
        this.setLowHealthStrategy(LowHealthStrategy.STICK_TO_OWNER);
        this.authorizedChangingOwner = true;
        this.m_21816_(null);
        this.authorizedChangingOwner = false;
        this.resetTickTillRest();
        this.f_21342_ = new DogMoveControl(this);
        this.defaultNavigation = this.f_21344_;
        this.defaultMoveControl = this.f_21342_;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(LAST_KNOWN_NAME, Optional.empty());
        this.f_19804_.m_135372_(DOG_FLAGS, (Object)0);
        this.f_19804_.m_135372_(GENDER.get(), (Object)EnumGender.UNISEX);
        this.f_19804_.m_135372_(MODE.get(), (Object)EnumMode.DOCILE);
        this.f_19804_.m_135372_(HUNGER_INT, (Object)Float.valueOf(60.0f));
        this.f_19804_.m_135372_(CUSTOM_SKIN.get(), (Object)DogSkinData.NULL);
        this.f_19804_.m_135372_(DOG_LEVEL.get(), (Object)new DogLevel(0, 0));
        this.f_19804_.m_135372_(DOG_INCAP_SYNC_STATE.get(), (Object)DogIncapacitatedMananger.IncapacitatedSyncState.NONE);
        this.f_19804_.m_135372_(DOG_SIZE.get(), (Object)DogSize.MODERATO);
        this.f_19804_.m_135372_(BONE_VARIANT, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(ARTIFACTS.get(), new ArrayList(3));
        this.f_19804_.m_135372_(DOG_BED_LOCATION.get(), new DimensionDependantArg(() -> EntityDataSerializers.f_135039_));
        this.f_19804_.m_135372_(DOG_BOWL_LOCATION.get(), new DimensionDependantArg(() -> EntityDataSerializers.f_135039_));
        this.f_19804_.m_135372_(INCAP_VAL, (Object)0);
        this.f_19804_.m_135372_(ANIMATION, (Object)0);
        this.f_19804_.m_135372_(ANIM_SYNC_TIME, (Object)0);
    }

    protected void m_8099_() {
        int trivial_p = 0;
        int non_trivial_p = 0;
        ItemStack stack = new ItemStack((ItemLike)Items.f_42415_);
        DogSitWhenOrderedGoal sitGoal = null;
        int p = 1;
        this.registerDogGoal(p, (Goal)new DogFloatGoal(this));
        this.registerDogGoal(p, new DogDrunkGoal(this));
        this.registerDogGoal(p, new DogAvoidPushWhenIdleGoal(this));
        this.registerDogGoal(++p, new DogGoAwayFromFireGoal(this));
        sitGoal = new DogSitWhenOrderedGoal(this);
        this.registerDogGoal(++p, (Goal)sitGoal);
        this.registerDogGoal(p, new DogProtestSitOrderGoal(this));
        this.registerDogGoal(++p, new DogLowHealthGoal.StickToOwner(this));
        this.registerDogGoal(p, new DogLowHealthGoal.RunAway(this));
        non_trivial_p = ++p;
        this.registerDogGoal(p, new DogTriggerableGoal(this, false));
        this.registerDogGoal(++p, new DogHungryGoal(this, 1.0, 2.0f));
        this.registerDogGoal(++p, new GuardModeGoal.Minor(this));
        this.registerDogGoal(p, new GuardModeGoal.Major(this));
        this.registerDogGoal(++p, new DogMeleeAttackGoal(this, 1.0, true, 20, 40));
        this.registerDogGoal(p, new DogGoRestOnBedGoalDefeated(this));
        this.registerDogGoal(++p, new DogFindWaterGoal(this));
        trivial_p = ++p;
        this.registerDogGoal(p, new DogTriggerableGoal(this, true));
        this.registerDogGoal(p, new DogFollowOwnerGoalDefeated(this));
        this.registerDogGoal(p, new DogFollowOwnerGoal(this, 1.0, 10.0f, 2.0f));
        this.registerDogGoal(++p, (Goal)new DogMoveBackToRestrictGoal(this));
        this.registerDogGoal(p, new DogBreedGoal(this, 1.0));
        this.registerDogGoal(++p, (Goal)new DogRandomStrollGoal(this, 1.0));
        this.registerDogGoal(p, new DogRandomStandIdleGoal(this));
        this.registerDogGoal(p, new DogRandomSniffGoal(this));
        this.registerDogGoal(p, new DogCommonStandIdleGoal(this));
        this.registerDogGoal(++p, new DogBegGoal(this, 8.0f));
        this.registerDogGoal(++p, new DogFeelingNakeyGoal(this));
        this.registerDogGoal(p, (Goal)new DogLookAtPlayerGoal(this));
        this.registerDogGoal(p, (Goal)new RandomLookAroundGoal((Mob)this));
        this.registerDogGoal(p, new DogRandomSitIdleGoal(this));
        this.registerDogGoal(p, new DogCommonSitIdleGoal(this));
        this.registerDogGoal(p, new DogRestWhenSitGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new DogOwnerHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new DogOwnerHurtTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(5, new DogNearestToOwnerAttackableTargetGoal<AbstractSkeleton>(this, AbstractSkeleton.class, false));
        this.f_21346_.m_25352_(6, (Goal)new BerserkerModeGoal(this));
        this.f_21346_.m_25352_(6, (Goal)new GuardModeGoal(this));
        this.f_21346_.m_25352_(6, (Goal)new PatrolAssistTargetGoal(this));
        this.populateActionBlockingGoals(trivial_p, non_trivial_p, sitGoal);
    }

    private void registerDogGoal(int priority, Goal goal) {
        this.f_21345_.m_25352_(priority, (Goal)new DogWrappedGoal(goal));
    }

    private void populateActionBlockingGoals(int trivialP, int nonTrivialP, DogSitWhenOrderedGoal sitGoal) {
        this.nonTrivialBlocking = new ArrayList<WrappedGoal>();
        this.trivialBlocking = new ArrayList<WrappedGoal>();
        List trivial = this.f_21345_.m_148105_().stream().filter(x -> {
            DogWrappedGoal dogGoal;
            Goal patt22077$temp = x.m_26015_();
            return (!(patt22077$temp instanceof DogWrappedGoal) || (dogGoal = (DogWrappedGoal)patt22077$temp).getGoal() != sitGoal) && x.m_26012_() <= trivialP && x.m_7684_().contains(Goal.Flag.MOVE);
        }).collect(Collectors.toList());
        List nonTrivial = this.f_21345_.m_148105_().stream().filter(x -> {
            DogWrappedGoal dogGoal;
            Goal patt22446$temp = x.m_26015_();
            return !(patt22446$temp instanceof DogWrappedGoal && (dogGoal = (DogWrappedGoal)patt22446$temp).getGoal() == sitGoal || x.m_26012_() > nonTrivialP || !x.m_7684_().contains(Goal.Flag.MOVE) && !x.m_7684_().contains(Goal.Flag.LOOK));
        }).collect(Collectors.toList());
        this.nonTrivialBlocking.addAll(nonTrivial);
        this.trivialBlocking.addAll(trivial);
    }

    public void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12624_, 0.15f, 1.0f);
    }

    protected SoundEvent m_7515_() {
        if (this.isDefeated()) {
            return this.f_19796_.m_188503_(2) == 0 ? SoundEvents.f_12625_ : SoundEvents.f_12622_;
        }
        if (this.f_19796_.m_188503_(3) == 0) {
            return this.m_21824_() && this.m_21223_() < 10.0f ? SoundEvents.f_12625_ : SoundEvents.f_12622_;
        }
        return SoundEvents.f_12617_;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12621_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12618_;
    }

    protected SoundEvent getHowlSound() {
        return SoundEvents.f_12620_;
    }

    public void howl() {
        this.m_5496_(this.getHowlSound(), 1.0f, this.m_6100_());
    }

    @Override
    public float m_6121_() {
        return 0.4f;
    }

    public boolean isDogSoaked() {
        return this.wetSource.soaked();
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getShadingWhileWet(float partialTicks) {
        return Math.min(0.5f + Mth.m_14179_((float)partialTicks, (float)this.prevTimeWolfIsShaking, (float)this.timeWolfIsShaking) / 2.0f * 0.5f, 1.0f);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float getShakeAngle(float partialTicks, float offset) {
        float f = (Mth.m_14179_((float)partialTicks, (float)this.prevTimeWolfIsShaking, (float)this.timeWolfIsShaking) + offset) / 1.8f;
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        return Mth.m_14031_((float)(f * (float)Math.PI)) * Mth.m_14031_((float)(f * (float)Math.PI * 11.0f)) * 0.15f * (float)Math.PI;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float getInterestedAngle(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.headRotationCourseOld, (float)this.headRotationCourse) * 0.15f * (float)Math.PI;
    }

    public void m_7822_(byte id) {
        super.m_7822_(id);
    }

    public void handleDogShakingUpdate(DogShakingData.State state) {
        switch (state) {
            case SHAKE_WATER: {
                this.startShaking();
                break;
            }
            case SHAKE_LAVA: {
                this.startShakingLava();
                break;
            }
            case STOP: {
                this.finishShaking();
                break;
            }
            default: {
                this.finishShaking();
            }
        }
    }

    public float getTailRotation() {
        return this.m_21824_() ? 1.73f - this.radPerHealthDecrease * (this.m_21233_() - this.m_21223_()) : 0.62831855f;
    }

    @Override
    public float getWagAngle(float limbSwing, float limbSwingAmount, float partialTickTime) {
        return Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        if (this.m_20160_()) {
            return this.getDogVisualBbHeight() * 0.8f;
        }
        return sizeIn.f_20378_ * 0.8f;
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.6f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    public int m_8132_() {
        return this.m_21825_() ? 20 : super.m_8132_();
    }

    public double m_6049_() {
        return this.m_20202_() instanceof Player ? 0.5 : 0.2;
    }

    protected void m_20348_(Entity passanger) {
        super.m_20348_(passanger);
        this.m_6210_();
    }

    protected void m_20351_(Entity passanger) {
        super.m_20351_(passanger);
        this.m_6210_();
    }

    public EntityDimensions m_6972_(Pose p_19975_) {
        boolean collide_passeneger;
        EntityDimensions self_dim = super.m_6972_(p_19975_);
        this.visualDimension = null;
        if (self_dim.f_20377_ >= 1.0f) {
            self_dim = new EntityDimensions(1.0f, self_dim.f_20378_, self_dim.f_20379_);
        }
        if (!(collide_passeneger = ((Boolean)ConfigHandler.SERVER.WOLF_MOUNT_PASSENGER_COLLISION.get()).booleanValue())) {
            return self_dim;
        }
        if (this.m_20160_() && !this.m_20197_().isEmpty()) {
            this.visualDimension = self_dim;
            self_dim = this.computeRidingDimension(self_dim);
        }
        return self_dim;
    }

    public double m_6048_() {
        return (double)this.getRealDimensions().f_20378_ * 0.75;
    }

    public EntityDimensions getRealDimensions() {
        return super.m_6972_(this.m_20089_());
    }

    @Override
    public float getDogVisualBbHeight() {
        if (this.visualDimension != null) {
            return this.visualDimension.f_20378_;
        }
        return this.m_20206_();
    }

    @Override
    public float getDogVisualBbWidth() {
        if (this.visualDimension != null) {
            return this.visualDimension.f_20377_;
        }
        return this.m_20205_();
    }

    private EntityDimensions computeRidingDimension(EntityDimensions self_dim) {
        float total_width = self_dim.f_20377_;
        float total_height = (float)this.m_6048_();
        Entity passenger = (Entity)this.m_20197_().get(0);
        total_width = Math.max(total_width, passenger.m_20205_());
        total_height = (float)((double)total_height + ((double)passenger.m_20206_() + passenger.m_6049_()));
        if (total_width >= 1.0f) {
            total_width = 1.0f;
        }
        return new EntityDimensions(total_width, total_height, self_dim.f_20379_);
    }

    public void m_8119_() {
        LivingEntity owner;
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            this.dogSyncedDataManager.tick();
        }
        this.updateClassicalAnim();
        this.m_274367_(this.m_20160_() ? 1.0f : 0.6f);
        if (this.m_6084_()) {
            this.updateDogPose();
        }
        this.alterations.forEach(alter -> alter.tick(this));
        if (this.m_6084_() && this.m_21233_() != this.maxHealth0) {
            this.maxHealth0 = this.m_21233_();
            this.radPerHealthDecrease = 1.5707964f / this.maxHealth0;
        }
        if (this.m_6084_() && !this.m_9236_().f_46443_ && this.f_19797_ % 40 == 0 && (owner = this.m_269323_()) != null) {
            this.setOwnersName(owner.m_7755_());
        }
        if (this.m_6084_()) {
            this.animationManager.tick();
            if (!this.m_9236_().f_46443_) {
                this.tickAnimAction();
            }
        }
        if (this.m_9236_().f_46443_) {
            this.proccessCustomModelSkin();
        }
        if (this.m_9236_().f_46443_ && ((Boolean)ConfigHandler.CLIENT.DISPLAY_SMOKE_WHEN_ON_FIRE.get()).booleanValue()) {
            this.addAdditionalOnFireEffect();
        }
    }

    private void addAdditionalOnFireEffect() {
        if (this.m_6060_()) {
            if (this.m_217043_().m_188503_(3) == 0) {
                float f1 = (this.m_217043_().m_188501_() * 2.0f - 1.0f) * this.getDogVisualBbWidth() * 0.5f;
                float f2 = (this.m_217043_().m_188501_() * 2.0f - 1.0f) * this.getDogVisualBbWidth() * 0.5f;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123777_, this.m_20185_() + (double)f1, this.m_20186_() + (double)this.m_20192_(), this.m_20189_() + (double)f2, 0.0, 0.05, 0.0);
            }
            if (this.onFireSmokeTick <= 300) {
                ++this.onFireSmokeTick;
            } else if (this.onFireSmokeTick <= 600 && this.f_19797_ % 4 == 0) {
                ++this.onFireSmokeTick;
            }
            this.onFireSmokeTick = Mth.m_14045_((int)this.onFireSmokeTick, (int)20, (int)300);
        } else if (this.onFireSmokeTick > 0) {
            --this.onFireSmokeTick;
            if (this.m_217043_().m_188503_(3) == 0) {
                float f1 = (this.m_217043_().m_188501_() * 2.0f - 1.0f) * this.getDogVisualBbWidth() * 0.5f;
                float f2 = (this.m_217043_().m_188501_() * 2.0f - 1.0f) * this.getDogVisualBbWidth() * 0.5f;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_() + (double)f1, this.m_20186_() + (double)this.m_20192_(), this.m_20189_() + (double)f2, 0.0, 0.05, 0.0);
            }
        }
    }

    private void updateClassicalAnim() {
        if (!this.m_6084_()) {
            return;
        }
        this.updateClassicalBegAnim();
        boolean val = this.checkDogInWetSourceAndWetTheDog();
        this.updateClassicalShakeAnim(val);
    }

    private void updateClassicalBegAnim() {
        if (!this.canDogDoBegAnim()) {
            this.headRotationCourse = 0.0f;
            this.headRotationCourseOld = 0.0f;
            return;
        }
        this.headRotationCourseOld = this.headRotationCourse;
        this.headRotationCourse = this.isBegging() ? (this.headRotationCourse += (1.0f - this.headRotationCourse) * 0.4f) : (this.headRotationCourse += (0.0f - this.headRotationCourse) * 0.4f);
    }

    private boolean checkDogInWetSourceAndWetTheDog() {
        if (this.m_20077_()) {
            this.wetSource = WetSource.LAVA;
            return true;
        }
        if (this.m_20069_()) {
            this.wetSource = WetSource.WATER;
            return true;
        }
        if (this.m_20070_()) {
            this.wetSource = WetSource.RAIN;
            return true;
        }
        if (this.m_20072_()) {
            this.wetSource = WetSource.BUBBLE_COLUMN;
            return true;
        }
        return false;
    }

    private void updateClassicalShakeAnim(boolean currentlyInWater) {
        if (!this.m_9236_().f_46443_ && this.isShaking && (!this.canDogDoShakeAnim() || currentlyInWater)) {
            this.finishShaking();
            ParticlePackets.DogShakingPacket.sendDogShakingPacket(this, DogShakingData.State.STOP);
            return;
        }
        if (!this.isShaking) {
            return;
        }
        if (this.timeWolfIsShaking == 0.0f && !this.shakeFire) {
            this.m_5496_(SoundEvents.f_12623_, this.m_6121_(), (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
        }
        this.prevTimeWolfIsShaking = this.timeWolfIsShaking;
        this.timeWolfIsShaking += 0.05f;
        if (this.prevTimeWolfIsShaking >= 2.0f) {
            for (IDogAlteration alter : this.alterations) {
                alter.onShakingDry(this, this.wetSource);
            }
            this.wetSource = WetSource.NONE;
            this.finishShaking();
        }
        if (this.timeWolfIsShaking > 0.4f) {
            float f = (float)this.m_20186_();
            int i = (int)(Mth.m_14031_((float)((this.timeWolfIsShaking - 0.4f) * (float)Math.PI)) * 7.0f);
            Vec3 vec3d = this.m_20184_();
            for (int j = 0; j < i; ++j) {
                float f1 = (this.f_19796_.m_188501_() * 2.0f - 1.0f) * this.getDogVisualBbWidth() * 0.5f;
                float f2 = (this.f_19796_.m_188501_() * 2.0f - 1.0f) * this.getDogVisualBbWidth() * 0.5f;
                if (this.shakeFire) {
                    float r = this.m_217043_().m_188501_();
                    SimpleParticleType type = ParticleTypes.f_123762_;
                    if (r <= 0.15f) {
                        type = ParticleTypes.f_123802_;
                    } else if (r <= 0.6f) {
                        type = ParticleTypes.f_123756_;
                    }
                    this.m_9236_().m_7106_((ParticleOptions)type, this.m_20185_() + (double)f1, (double)(f + 0.8f), this.m_20189_() + (double)f2, vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_);
                    continue;
                }
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123769_, this.m_20185_() + (double)f1, (double)(f + 0.8f), this.m_20189_() + (double)f2, vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_);
            }
        }
        if ((double)this.timeWolfIsShaking > 0.5 && this.shakeFire && this.f_19796_.m_188503_(6) == 0) {
            this.m_5496_(SoundEvents.f_11937_, this.m_6121_(), (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
        }
    }

    public boolean canDoIdileAnim() {
        if (!this.m_6084_()) {
            return false;
        }
        if (this.m_20159_() || this.m_20160_()) {
            return false;
        }
        if (this.idleAnimHurtCooldown > 0) {
            return false;
        }
        return !this.isShaking && !this.animationManager.started();
    }

    public boolean canContinueDoIdileAnim() {
        if (this.dogAnimHurtImpules) {
            this.dogAnimHurtImpules = false;
            this.idleAnimHurtCooldown = 20;
            return false;
        }
        if (this.m_20159_() || this.m_20160_()) {
            return false;
        }
        return this.m_6084_() && !this.isShaking;
    }

    public void setAnimForIdle(DogAnimation anim) {
        this.setAnim(anim);
        this.dogAnimHurtImpules = false;
    }

    public boolean canDogDoBegAnim() {
        DogPose pose = this.getDogPose();
        if (!pose.canBeg) {
            return false;
        }
        return !this.animationManager.started() || this.getAnim().freeHead();
    }

    public boolean canDogDoShakeAnim() {
        DogPose pose = this.getDogPose();
        if (!pose.canShake) {
            return false;
        }
        return !this.animationManager.started();
    }

    private void proccessCustomModelSkin() {
        DogSkin skin = this.getClientSkin();
        if (!skin.useCustomModel()) {
            return;
        }
        DogModel model = skin.getCustomModel().getValue();
        if (model.tickClient()) {
            model.doTickClient(this);
        }
    }

    public void m_8107_() {
        if (this.f_21344_ != this.currentNavigation) {
            this.f_21344_ = this.currentNavigation;
        }
        if (this.navigationLock != null) {
            this.navigationLock.unlockDogNavigation();
        }
        this.validateGoalsAndTickNonRunningIfNeeded();
        super.m_8107_();
        if (!this.m_9236_().f_46443_ && this.delayedActionStart > 0) {
            --this.delayedActionStart;
        }
        if (!this.m_9236_().f_46443_) {
            this.updateAndInvalidatePendingAction();
        }
        this.updateDogBeginShake();
        if (!this.m_9236_().f_46443_ && !this.isDefeated()) {
            InteractionResultHolder<Integer> result;
            if (!((Boolean)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.DISABLE_HUNGER)).booleanValue()) {
                this.prevHungerTick = this.hungerTick++;
                if (this.m_20160_() || !this.m_21825_()) {
                    // empty if block
                }
                for (IDogAlteration alter2 : this.alterations) {
                    result = alter2.hungerTick(this, this.hungerTick - this.prevHungerTick);
                    if (!result.m_19089_().m_19080_()) continue;
                    this.hungerTick = (Integer)result.m_19095_() + this.prevHungerTick;
                }
                int tickPerDec = (Integer)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.TICK_PER_HUNGER_DEC);
                if (this.hungerTick > tickPerDec) {
                    if (this.hungerSaturation > 0) {
                        --this.hungerSaturation;
                    } else {
                        this.setDogHunger(this.getDogHunger() - 1.0f);
                    }
                    this.hungerTick -= tickPerDec;
                }
                if (this.isZeroHunger) {
                    this.handleZeroHunger();
                }
            }
            if (this.hungerSaturation > 0 && this.m_21223_() < this.m_21233_() && --this.hungerSaturationHealingTick <= 0) {
                this.hungerSaturationHealingTick = 10;
                this.m_5634_(1.0f);
                this.hungerSaturation -= 3;
            }
            this.prevHealingTick = this.healingTick;
            this.healingTick += 8;
            if (this.m_21825_()) {
                this.healingTick += 4;
            }
            for (IDogAlteration alter2 : this.alterations) {
                result = alter2.healingTick(this, this.healingTick - this.prevHealingTick);
                if (!result.m_19089_().m_19080_()) continue;
                this.healingTick = (Integer)result.m_19095_() + this.prevHealingTick;
            }
            if (this.healingTick >= 6000) {
                if (this.m_21223_() < this.m_21233_()) {
                    this.m_5634_(1.0f);
                }
                this.healingTick = 0;
            }
            this.dogOwnerDistanceManager.tick();
            this.dogMiningCautiousManager.tick();
        }
        if (this.m_9236_().f_46443_ && this.getDogLevel().isFullKami() && ((Boolean)ConfigHandler.ClientConfig.getConfig(ConfigHandler.CLIENT.KAMI_PARTICLES)).booleanValue()) {
            for (int i = 0; i < 2; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123760_, this.m_20208_(0.5), this.m_20187_() - 0.25, this.m_20262_(0.5), (this.f_19796_.m_188500_() - 0.5) * 2.0, -this.f_19796_.m_188500_(), (this.f_19796_.m_188500_() - 0.5) * 2.0);
            }
        }
        if (this.m_9236_().f_46443_ && this.isInDrunkPose() && this.f_19797_ % 16 == 0) {
            int color = 10101987;
            double d0 = (double)(color >> 16 & 0xFF) / 255.0;
            double d1 = (double)(color >> 8 & 0xFF) / 255.0;
            double d2 = (double)(color >> 0 & 0xFF) / 255.0;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), d0, d1, d2);
        }
        if (this.f_19797_ % 50 == 0) {
            ResourceKey dimKey = this.m_9236_().m_46472_();
            Optional<BlockPos> bowlPos = this.getBowlPos((ResourceKey<Level>)dimKey);
            if (bowlPos.isPresent() && this.m_20238_(Vec3.m_82539_((Vec3i)((Vec3i)bowlPos.get()))) >= 64.0) {
                this.setBowlPos((ResourceKey<Level>)dimKey, Optional.empty());
            }
            if (bowlPos.isPresent() && this.m_9236_().m_46805_(bowlPos.get()) && !this.m_9236_().m_8055_(bowlPos.get()).m_60713_((Block)DoggyBlocks.FOOD_BOWL.get())) {
                this.setBowlPos((ResourceKey<Level>)dimKey, Optional.empty());
            }
        }
        this.alterations.forEach(alter -> alter.livingTick(this));
        if (this.isDefeated()) {
            this.incapacitatedMananger.tick();
        }
        if (this.tickChopinTail > 0) {
            --this.tickChopinTail;
        }
        if (this.switchNavCooldown > 0) {
            --this.switchNavCooldown;
        }
        if (this.idleAnimHurtCooldown > 0) {
            --this.idleAnimHurtCooldown;
        }
        if (this.drunkTickLeft > 0) {
            --this.drunkTickLeft;
        }
        if (!this.m_9236_().f_46443_ && this.m_21825_() && !this.isDogResting() && this.tickUntilRest > 0) {
            --this.tickUntilRest;
        }
        if (this.navigationLock != null) {
            this.navigationLock.lockDogNavigation();
        }
    }

    private void updateDogBeginShake() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (this.isShaking) {
            return;
        }
        if (this.m_21691_()) {
            return;
        }
        if (!this.m_20096_()) {
            return;
        }
        if (!this.canDogDoShakeAnim()) {
            return;
        }
        if (this.wetSource.isNone()) {
            return;
        }
        if (this.checkDogInWetSourceAndWetTheDog()) {
            return;
        }
        if (this.wetSource.flame() && this.m_6060_()) {
            return;
        }
        this.startShakingAndBroadcast(this.wetSource.flame());
    }

    private void validateGoalsAndTickNonRunningIfNeeded() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        boolean needRemoved = false;
        Set availableGoals = this.f_21345_.m_148105_();
        for (WrappedGoal goal : availableGoals) {
            Goal goal2 = goal.m_26015_();
            if (goal2 instanceof DogWrappedGoal) {
                DogWrappedGoal dogGoal = (DogWrappedGoal)goal2;
                if (goal.m_7620_()) continue;
                dogGoal.tickDogWhenGoalNotRunning();
                continue;
            }
            needRemoved = true;
            break;
        }
        if (needRemoved) {
            availableGoals.removeIf(x -> !(x.m_26015_() instanceof DogWrappedGoal));
        }
    }

    public TriggerableAction getTriggerableAction() {
        return this.activeAction;
    }

    public boolean triggerAction(TriggerableAction action) {
        if (this.activeAction == action) {
            return false;
        }
        if (action == null) {
            if (this.activeAction != null) {
                this.activeAction.stop();
            }
            this.activeAction = null;
            if (this.stashedAction != null) {
                this.activeAction = this.stashedAction;
                this.stashedAction = null;
            }
            return false;
        }
        if (this.activeAction != null) {
            if (!this.activeAction.isTrivial()) {
                return false;
            }
            if (action.isTrivial()) {
                return false;
            }
        }
        if (this.m_21827_()) {
            if (this.forceSit()) {
                return false;
            }
            if (!action.canOverrideSit()) {
                return false;
            }
        }
        this.m_21839_(false);
        if (this.activeAction != null) {
            if (this.activeAction.canPause()) {
                if (this.stashedAction != null) {
                    this.stashedAction.stop();
                }
                this.activeAction.setState(TriggerableAction.ActionState.PAUSED);
                this.stashedAction = this.activeAction;
            } else {
                this.activeAction.stop();
            }
        }
        this.activeAction = action;
        return true;
    }

    public boolean isBusy() {
        if (!this.isDoingFine()) {
            return true;
        }
        if (this.m_21825_() && this.forceSit()) {
            return true;
        }
        if (this.activeAction != null) {
            return true;
        }
        for (WrappedGoal x : this.trivialBlocking) {
            if (!x.m_7620_()) continue;
            return true;
        }
        return this.m_217005_();
    }

    public boolean readyForNonTrivialAction() {
        if (!this.isDoingFine()) {
            return false;
        }
        if (this.m_21825_() && this.forceSit()) {
            return false;
        }
        if (this.activeAction != null && !this.activeAction.isTrivial()) {
            return false;
        }
        for (WrappedGoal x : this.nonTrivialBlocking) {
            if (!x.m_7620_()) continue;
            return false;
        }
        return !this.m_217005_();
    }

    public TriggerableAction getStashedTriggerableAction() {
        return this.stashedAction;
    }

    public void clearTriggerableAction() {
        if (this.stashedAction != null) {
            this.stashedAction.stop();
            this.stashedAction = null;
        }
        this.triggerAction(null);
    }

    public void setStashedTriggerableAction(TriggerableAction action) {
        if (action == this.stashedAction) {
            return;
        }
        if (this.stashedAction != null) {
            this.stashedAction.stop();
        }
        this.stashedAction = action;
    }

    public boolean hasDelayedActionStart() {
        return this.delayedActionStart > 0;
    }

    public boolean triggerActionDelayed(int delay, TriggerableAction action) {
        boolean triggered = this.triggerAction(action);
        if (triggered) {
            this.delayedActionStart = delay;
        }
        return triggered;
    }

    protected void updateAndInvalidatePendingAction() {
        if (this.activeAction == null) {
            this.actionPendingTime = 0;
            return;
        }
        if (this.activeAction.getState() != TriggerableAction.ActionState.PENDING) {
            this.actionPendingTime = 0;
            return;
        }
        if (++this.actionPendingTime >= 20) {
            this.actionPendingTime = 0;
            this.clearTriggerableAction();
        }
    }

    public boolean isOnSwitchNavCooldown() {
        return this.switchNavCooldown > 0;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (this.isDefeated()) {
            return this.incapacitatedMananger.interact(stack, player, hand);
        }
        if (this.handleOpenDogScreenDedicated(player, stack).m_19080_()) {
            return InteractionResult.SUCCESS;
        }
        if (this.handleTameDogIfNotTamed(player, stack, hand).m_19080_()) {
            return InteractionResult.SUCCESS;
        }
        if (this.dogCheckAndRidePlayer(player, stack).m_19080_()) {
            return InteractionResult.SUCCESS;
        }
        Optional<InteractionResult> otherHandlerResult = this.handleAlterationsAndOtherHandlers(player, stack, hand);
        if (otherHandlerResult.isPresent()) {
            return otherHandlerResult.get();
        }
        if (this.handleBreeding(player, hand, stack).m_19080_()) {
            return InteractionResult.SUCCESS;
        }
        if (this.handleOpenDogScreen(player).m_19080_()) {
            return InteractionResult.SUCCESS;
        }
        if (this.handleDogSitStand(player).m_19080_()) {
            return InteractionResult.SUCCESS;
        }
        if (this.m_9236_().f_46443_) {
            this.displayToastIfNoPermission(player);
        }
        return InteractionResult.PASS;
    }

    private InteractionResult handleDogSitStand(Player player) {
        if (!this.canInteract((LivingEntity)player)) {
            return InteractionResult.FAIL;
        }
        if (this.isProtesting()) {
            return InteractionResult.FAIL;
        }
        int sit_interval = this.f_19797_ - this.lastOrderedToSitTick;
        float r = this.m_217043_().m_188501_();
        if (!this.m_9236_().f_46443_ && this.m_21827_() && this.checkRandomBackflip(r, sit_interval) && this.m_9236_().m_8055_(this.m_20183_().m_7494_()).m_60795_()) {
            this.setStandAnim(DogAnimation.NONE);
            this.triggerAnimationAction(new DogBackFlipAction(this));
        }
        if (!this.m_9236_().f_46443_ && !this.m_21827_()) {
            this.lastOrderedToSitTick = this.f_19797_;
        }
        this.m_21839_(!this.m_21827_());
        this.f_20899_ = false;
        this.f_21344_.m_26573_();
        this.m_6710_(null);
        return InteractionResult.SUCCESS;
    }

    private InteractionResult handleOpenDogScreen(Player player) {
        if (!player.m_6144_()) {
            return InteractionResult.PASS;
        }
        if (!this.canInteract((LivingEntity)player)) {
            return InteractionResult.PASS;
        }
        if (this.m_9236_().f_46443_) {
            DogNewInfoScreen.open(this);
        }
        return InteractionResult.SUCCESS;
    }

    private InteractionResult handleOpenDogScreenDedicated(Player player, ItemStack stack) {
        if (stack.m_41720_() != Items.f_42398_) {
            return InteractionResult.FAIL;
        }
        if (!this.m_21824_()) {
            return InteractionResult.FAIL;
        }
        if (!this.m_9236_().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (this.canInteract((LivingEntity)player)) {
            DogNewInfoScreen.open(this);
        } else {
            DogCannotInteractWithScreen.open(this);
        }
        return InteractionResult.SUCCESS;
    }

    private InteractionResult dogCheckAndRidePlayer(Player player, ItemStack stack) {
        if (player.m_20363_((Entity)this)) {
            if (!this.m_9236_().f_46443_) {
                this.m_19877_();
            }
            return InteractionResult.SUCCESS;
        }
        if (stack.m_41720_() != Items.f_42500_) {
            return InteractionResult.PASS;
        }
        if (!player.m_6144_()) {
            return InteractionResult.PASS;
        }
        if (this.m_20160_()) {
            return InteractionResult.PASS;
        }
        if (!this.canInteract((LivingEntity)player)) {
            return InteractionResult.PASS;
        }
        if (!this.m_9236_().f_46443_ && this.m_20329_((Entity)player)) {
            player.m_5661_((Component)Component.m_237110_((String)"talent.doggytalents.bed_finder.dog_mount", (Object[])new Object[]{this.getGenderPronoun()}), true);
        }
        return InteractionResult.SUCCESS;
    }

    private Optional<InteractionResult> handleAlterationsAndOtherHandlers(Player player, ItemStack stack, InteractionHand hand) {
        Optional<IDogFoodHandler> foodHandler = FoodHandler.getMatch(this, stack, (Entity)player);
        if (foodHandler.isPresent()) {
            return Optional.of(foodHandler.get().consume(this, stack, (Entity)player));
        }
        InteractionResult interactResult = InteractHandler.getMatch(this, stack, player, hand);
        if (interactResult != InteractionResult.PASS) {
            return Optional.of(interactResult);
        }
        for (IDogAlteration alter : this.alterations) {
            InteractionResult result = alter.processInteract(this, this.m_9236_(), player, hand);
            if (result == InteractionResult.PASS) continue;
            return Optional.of(result);
        }
        return Optional.empty();
    }

    private InteractionResult handleBreeding(Player player, InteractionHand hand, ItemStack stack) {
        if (!stack.m_204117_(DoggyTags.BREEDING_ITEMS)) {
            return InteractionResult.PASS;
        }
        if (!this.canInteract((LivingEntity)player)) {
            return InteractionResult.PASS;
        }
        if (this.m_9236_().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        int age = this.m_146764_();
        if (age == 0 && this.m_5957_()) {
            this.m_142075_(player, hand, stack);
            this.m_27595_(player);
        } else if (this.m_6162_()) {
            this.m_142075_(player, hand, stack);
            this.m_146740_(Dog.m_216967_((int)(-age)), true);
        }
        return InteractionResult.SUCCESS;
    }

    private InteractionResult handleTameDogIfNotTamed(Player player, ItemStack stack, InteractionHand hand) {
        boolean alwaysTame;
        if (this.m_21824_()) {
            return InteractionResult.FAIL;
        }
        if (!this.isDogTameItem(stack)) {
            return InteractionResult.FAIL;
        }
        if (this.m_9236_().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        this.m_142075_(player, hand, stack);
        boolean bl = alwaysTame = stack.m_41720_() == DoggyItems.TRAINING_TREAT.get();
        if (alwaysTame || this.f_19796_.m_188503_(3) == 0) {
            this.m_21828_(player);
            this.f_21344_.m_26573_();
            this.m_6710_(null);
            this.m_21839_(true);
            this.m_21153_(20.0f);
            this.m_9236_().m_7605_((Entity)this, (byte)7);
        } else {
            this.m_9236_().m_7605_((Entity)this, (byte)6);
        }
        return InteractionResult.SUCCESS;
    }

    private boolean isDogTameItem(ItemStack stack) {
        return stack.m_150930_(Items.f_42500_) || stack.m_150930_((Item)DoggyItems.TRAINING_TREAT.get());
    }

    @Override
    public boolean canStillEat() {
        if (this.m_9236_().f_46443_) {
            return false;
        }
        if (((Boolean)ConfigHandler.SERVER.DISABLE_HUNGER.get()).booleanValue() && this.m_21223_() < this.m_21233_() && this.hungerSaturation <= 0) {
            return true;
        }
        return this.getDogHunger() < this.getMaxHunger();
    }

    private boolean checkRandomBackflip(float r, int sit_interval) {
        if (sit_interval <= 30) {
            return false;
        }
        if (sit_interval >= 1200) {
            return r <= 0.7f;
        }
        return r <= 0.3f;
    }

    public boolean isProtesting() {
        return this.isProtesting;
    }

    public void setProtesting(boolean p) {
        this.isProtesting = p;
    }

    private void displayToastIfNoPermission(Player player) {
        if (this.canInteract((LivingEntity)player)) {
            return;
        }
        player.m_5661_((Component)Component.m_237110_((String)"doggui.invalid_dog.no_permission.title", (Object[])new Object[]{this.getGenderPronoun()}).m_130940_(ChatFormatting.RED), true);
    }

    public boolean m_275843_() {
        for (IDogAlteration alter : this.alterations) {
            InteractionResult result = alter.canBeRiddenInWater(this);
            if (result.m_19080_()) {
                return false;
            }
            if (result != InteractionResult.FAIL) continue;
            return true;
        }
        return super.m_275843_();
    }

    public void m_8127_() {
        if (!this.m_9236_().f_46443_) {
            Entity e0 = this.m_20202_();
            super.m_8127_();
            Entity e1 = this.m_20202_();
            if (e0 != e1 && e0 instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)e0;
                PacketHandler.send(PacketDistributor.PLAYER.with(() -> player), new DogMountData(this.m_19879_(), false));
            }
        } else {
            super.m_8127_();
        }
    }

    public boolean m_20329_(Entity entity) {
        boolean not_authorized;
        boolean result = false;
        boolean bl = not_authorized = this.requireRidingAuthorization(entity) && !this.isRidingAuthorized();
        if (!not_authorized) {
            result = super.m_20329_(entity);
        }
        this.ridingAuthorized = false;
        if (!this.m_9236_().f_46443_ && result && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            PacketHandler.send(PacketDistributor.PLAYER.with(() -> player), new DogMountData(this.m_19879_(), true));
        }
        return result;
    }

    public boolean isRidingAuthorized() {
        return this.ridingAuthorized;
    }

    public void authorizeRiding() {
        this.ridingAuthorized = true;
    }

    public boolean requireRidingAuthorization(Entity entity) {
        Dog otherDog;
        if (this.dogAutoMount()) {
            return false;
        }
        UUID ownerUUID = this.m_21805_();
        if (ownerUUID == null) {
            return false;
        }
        if (!ObjectUtils.notEqual((Object)ownerUUID, (Object)entity.m_20148_())) {
            return false;
        }
        return !(entity instanceof Dog) || ObjectUtils.notEqual((Object)ownerUUID, (Object)(otherDog = (Dog)entity).m_21805_());
    }

    public boolean canTrample(BlockState state, BlockPos pos, float fallDistance) {
        return false;
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        if (this.dogFallImmune()) {
            return false;
        }
        for (IDogAlteration alter : this.alterations) {
            InteractionResult result = alter.onLivingFall(this, distance, damageMultiplier);
            if (result.m_19080_()) {
                return true;
            }
            if (result != InteractionResult.FAIL) continue;
            return false;
        }
        float[] ret = ForgeHooks.onLivingFall((LivingEntity)this, (float)distance, (float)damageMultiplier);
        if (ret == null) {
            return false;
        }
        distance = ret[0];
        damageMultiplier = ret[1];
        int i = this.m_5639_(distance, damageMultiplier);
        if (i > 0) {
            if (this.m_20160_()) {
                for (Entity e : this.m_20197_()) {
                    e.m_6469_(this.m_269291_().m_268989_(), (float)i);
                }
            }
            this.m_5496_(i > 4 ? this.m_196493_().f_196627_() : this.m_196493_().f_196626_(), 1.0f, 1.0f);
            this.m_21229_();
            this.m_6469_(this.m_269291_().m_268989_(), i);
            return true;
        }
        return false;
    }

    public boolean dogFallImmune() {
        return this.alterationProps.fallImmune();
    }

    public int m_6056_() {
        return 3;
    }

    protected int m_5639_(float distance, float damageMultiplier) {
        MobEffectInstance effectInst = this.m_21124_(MobEffects.f_19603_);
        float f = effectInst == null ? 0.0f : (float)(effectInst.m_19564_() + 1);
        distance -= f;
        for (IDogAlteration alter : this.alterations) {
            InteractionResultHolder<Float> result = alter.calculateFallDistance(this, distance);
            if (!result.m_19089_().m_19080_()) continue;
            distance = ((Float)result.m_19095_()).floatValue();
            break;
        }
        return Mth.m_14167_((float)((distance - 3.0f - f) * damageMultiplier));
    }

    public boolean m_6040_() {
        return this.alterationProps.canBreatheUnderwater();
    }

    protected int m_7302_(int air) {
        for (IDogAlteration alter : this.alterations) {
            InteractionResultHolder<Integer> result = alter.decreaseAirSupply(this, air);
            if (!result.m_19089_().m_19080_()) continue;
            return (Integer)result.m_19095_();
        }
        return super.m_7302_(air);
    }

    public boolean m_203441_(FluidState state) {
        if (this.m_5825_() && state.m_205070_(FluidTags.f_13132_)) {
            return true;
        }
        return super.m_203441_(state);
    }

    public boolean m_6128_() {
        for (IDogAlteration alter : this.alterations) {
            InteractionResult result = alter.negateExplosion(this);
            if (!result.m_19080_()) continue;
            return true;
        }
        return super.m_6128_();
    }

    protected int m_7305_(int currentAir) {
        currentAir += 4;
        for (IDogAlteration alter : this.alterations) {
            InteractionResultHolder<Integer> result = alter.determineNextAir(this, currentAir);
            if (!result.m_19089_().m_19080_()) continue;
            currentAir = (Integer)result.m_19095_();
            break;
        }
        return Math.min(currentAir, this.m_6062_());
    }

    public boolean m_6779_(LivingEntity target) {
        if (!this.getMode().shouldAttack()) {
            return false;
        }
        for (IDogAlteration alter : this.alterations) {
            InteractionResult result = alter.canAttack((AbstractDog)this, target);
            if (result.m_19080_()) {
                return true;
            }
            if (result != InteractionResult.FAIL) continue;
            return false;
        }
        if (target instanceof Creeper) {
            return false;
        }
        return super.m_6779_(target);
    }

    public boolean m_6549_(EntityType<?> entityType) {
        if (!this.getMode().shouldAttack()) {
            return false;
        }
        for (IDogAlteration alter : this.alterations) {
            InteractionResult result = alter.canAttack((AbstractDog)this, entityType);
            if (result.m_19080_()) {
                return true;
            }
            if (result != InteractionResult.FAIL) continue;
            return false;
        }
        if (entityType == EntityType.f_20558_) {
            return false;
        }
        return super.m_6549_(entityType);
    }

    public boolean m_7757_(LivingEntity target, LivingEntity owner) {
        if (!this.getMode().shouldAttack()) {
            return false;
        }
        for (IDogAlteration alter : this.alterations) {
            InteractionResult result = alter.shouldAttackEntity(this, target, owner);
            if (result.m_19080_()) {
                return true;
            }
            if (result != InteractionResult.FAIL) continue;
            return false;
        }
        if (target instanceof Creeper || target instanceof Ghast) {
            return false;
        }
        if (target instanceof Wolf) {
            Wolf wolfentity = (Wolf)target;
            return !wolfentity.m_21824_() || wolfentity.m_269323_() != owner;
        }
        if (target instanceof Dog) {
            Dog dogEntity = (Dog)target;
            return !dogEntity.m_21824_() || dogEntity.m_269323_() != owner;
        }
        if (target instanceof Player && owner instanceof Player && !((Player)owner).m_7099_((Player)target)) {
            return false;
        }
        if (target instanceof AbstractHorse && ((AbstractHorse)target).m_30614_()) {
            return false;
        }
        return !(target instanceof TamableAnimal) || !((TamableAnimal)target).m_21824_();
    }

    protected boolean stillIdleOrSitWhenHurt(DamageSource source, float amount) {
        if (this.isDogDrunk()) {
            return true;
        }
        for (IDogAlteration alt : this.alterations) {
            if (!alt.stillIdleOrSitWhenHurt(this, source, amount).m_19080_()) continue;
            return true;
        }
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        LivingEntity owner;
        boolean flag;
        Entity attacker = source.m_7639_();
        if (this.isDefeated() && !source.m_269533_(DamageTypeTags.f_268738_)) {
            Mob mob;
            LivingEntity target;
            int currentIncapVal;
            if (((Boolean)ConfigHandler.SERVER.INCAP_VAL_RESET_WHEN_HURT.get()).booleanValue() && (currentIncapVal = this.getDogIncapValue()) < this.getDefaultInitIncapVal()) {
                this.setDogIncapValue(this.getDefaultInitIncapVal());
            }
            this.incapacitatedMananger.onHurt();
            if (attacker instanceof Mob && (target = (mob = (Mob)attacker).m_5448_()) == this) {
                mob.m_6710_(null);
            }
            return false;
        }
        for (IDogAlteration alter : this.alterations) {
            InteractionResultHolder<Float> result = alter.gettingAttackedFrom(this, source, amount);
            if (result.m_19089_() == InteractionResult.FAIL) {
                return false;
            }
            amount = ((Float)result.m_19095_()).floatValue();
        }
        if (this.m_6673_(source)) {
            return false;
        }
        boolean allPlayerCannotAttackDog = (Boolean)ConfigHandler.ClientConfig.getConfig(ConfigHandler.SERVER.ALL_PLAYER_CANNOT_ATTACK_DOG);
        if (allPlayerCannotAttackDog && attacker instanceof Player) {
            return false;
        }
        if (!this.canOwnerAttack() && (flag = this.checkIfAttackedFromOwnerOrTeam(owner = this.m_269323_(), attacker))) {
            return false;
        }
        if (!this.m_9236_().f_46443_ && !this.stillIdleOrSitWhenHurt(source, amount)) {
            if (this.m_21825_() || amount > 6.0f) {
                this.setAnim(DogAnimation.HURT_1);
            } else if (source.m_7639_() != null) {
                this.setAnim(DogAnimation.HURT_2);
            }
            if (this.m_21825_()) {
                this.setStandAnim(DogAnimation.NONE);
                this.m_21837_(false);
            }
            this.m_21839_(false);
            this.dogAnimHurtImpules = true;
        }
        if (attacker != null && !(attacker instanceof Player) && !(attacker instanceof AbstractArrow)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        boolean ret = super.m_6469_(source, amount);
        if (this.m_21224_() && !this.m_9236_().f_46443_) {
            this.setAnim(DogAnimation.HURT_1);
        }
        if (this.m_9236_().f_46443_ && ((Boolean)ConfigHandler.CLIENT.BLOCK_RED_OVERLAY_WHEN_HURT.get()).booleanValue()) {
            this.f_20916_ = 0;
            this.f_20917_ = 0;
        }
        return ret;
    }

    public boolean checkIfAttackedFromOwnerOrTeam(LivingEntity owner, Entity attacker) {
        if (owner == null || attacker == null) {
            return false;
        }
        if (owner == attacker) {
            return true;
        }
        return attacker.m_7307_((Entity)owner);
    }

    public boolean m_7327_(Entity target) {
        for (IDogAlteration alter : this.alterations) {
            alter.doInitialAttackEffects(this, target);
        }
        AttributeInstance attackDamageInst = this.m_21051_(Attributes.f_22281_);
        AttributeInstance critDamageInst = this.m_21051_((Attribute)DoggyAttributes.CRIT_CHANCE.get());
        Set critModifiers = null;
        if (critDamageInst != null && critDamageInst.m_22135_() > this.m_217043_().m_188500_()) {
            AttributeInstance critBonusInst = this.m_21051_((Attribute)DoggyAttributes.CRIT_BONUS.get());
            Set set = critModifiers = critBonusInst == null ? null : critBonusInst.m_22122_();
            if (critModifiers != null && attackDamageInst != null) {
                critModifiers.forEach(arg_0 -> ((AttributeInstance)attackDamageInst).m_22118_(arg_0));
            }
        }
        int damage = (int)(attackDamageInst == null ? 0.0 : attackDamageInst.m_22135_());
        ItemStack stack = this.m_21205_();
        if (target instanceof LivingEntity && stack != null) {
            damage = (int)((float)damage + EnchantmentHelper.m_44833_((ItemStack)this.m_21205_(), (MobType)((LivingEntity)target).m_6336_()));
        }
        if (critModifiers != null && attackDamageInst != null) {
            critModifiers.forEach(arg_0 -> ((AttributeInstance)attackDamageInst).m_22130_(arg_0));
        }
        this.doInitialEnchantDamageEffects((LivingEntity)this, target);
        boolean flag = target.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)damage);
        if (!flag) {
            return false;
        }
        this.m_19970_((LivingEntity)this, target);
        this.statsTracker.increaseDamageDealt(damage);
        if (critModifiers != null) {
            ParticlePackets.CritEmitterPacket.sendCritEmitterPacketToNearClients(target);
            this.m_5496_(SoundEvents.f_12313_, 0.5f, 1.0f);
        }
        for (IDogAlteration alter : this.alterations) {
            alter.doAdditionalAttackEffects(this, target);
        }
        if (this.m_21023_((MobEffect)DoggyEffects.NATTO_BITE.get()) && target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            ((NattoBiteEffect)((Object)DoggyEffects.NATTO_BITE.get())).doAdditionalAttackEffects(this, living);
        }
        return true;
    }

    public boolean m_214076_(ServerLevel level, LivingEntity entity) {
        this.statsTracker.incrementKillCount((Entity)entity);
        return true;
    }

    protected void doInitialEnchantDamageEffects(LivingEntity dog, Entity target) {
        int i = EnchantmentHelper.m_44914_((LivingEntity)this);
        if (i > 0) {
            target.m_20254_(i * 4);
        }
        float knockback = (float)this.m_21133_(Attributes.f_22282_);
        if ((knockback += (float)EnchantmentHelper.m_44894_((LivingEntity)this)) > 0.0f && target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            living.m_147240_((double)(knockback * 0.5f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
            this.m_20256_(this.m_20184_().m_82542_(0.6, 1.0, 0.6));
        }
    }

    public boolean m_21275_(DamageSource source) {
        for (IDogAlteration alter : this.alterations) {
            InteractionResult result = alter.canBlockDamageSource(this, source);
            if (result.m_19080_()) {
                return true;
            }
            if (result != InteractionResult.FAIL) continue;
            return false;
        }
        return super.m_21275_(source);
    }

    public boolean m_142066_() {
        return !this.isDefeated() && super.m_142066_();
    }

    public void m_20254_(int second) {
        for (IDogAlteration alter : this.alterations) {
            InteractionResultHolder<Integer> result = alter.setFire(this, second);
            if (!result.m_19089_().m_19080_()) continue;
            second = (Integer)result.m_19095_();
        }
        super.m_20254_(second);
    }

    public boolean m_5825_() {
        return this.alterationProps.fireImmune();
    }

    public boolean shouldDogNotAfraidOfFire() {
        for (IDogAlteration alter : this.alterations) {
            InteractionResult result = alter.shouldNotAfraidOfFire(this);
            if (!result.m_19080_()) continue;
            return true;
        }
        return false;
    }

    public boolean m_6673_(DamageSource source) {
        for (IDogAlteration alter : this.alterations) {
            InteractionResult result = alter.isInvulnerableTo(this, source);
            if (result.m_19080_()) {
                return true;
            }
            if (result != InteractionResult.FAIL) continue;
            return false;
        }
        return super.m_6673_(source);
    }

    public boolean m_20147_() {
        for (IDogAlteration alter : this.alterations) {
            InteractionResult result = alter.isInvulnerable(this);
            if (result.m_19080_()) {
                return true;
            }
            if (result != InteractionResult.FAIL) continue;
            return false;
        }
        return super.m_20147_();
    }

    public boolean m_147207_(MobEffectInstance effectInst, @Nullable Entity adder) {
        if (this.isDefeated()) {
            return false;
        }
        return super.m_147207_(effectInst, adder);
    }

    public void m_147215_(MobEffectInstance p_147216_, @Nullable Entity adder) {
        if (this.isDefeated()) {
            return;
        }
        super.m_147215_(p_147216_, adder);
    }

    public boolean m_7301_(MobEffectInstance effectIn) {
        if (this.isDefeated()) {
            return false;
        }
        for (IDogAlteration alter : this.alterations) {
            InteractionResult result = alter.isPotionApplicable(this, effectIn);
            if (result.m_19080_()) {
                return true;
            }
            if (result != InteractionResult.FAIL) continue;
            return false;
        }
        return super.m_7301_(effectIn);
    }

    public boolean m_6573_(Player player) {
        return false;
    }

    public void m_21463_(Entity p_21464_, boolean p_21465_) {
    }

    public boolean m_21523_() {
        return false;
    }

    @Nullable
    public Entity m_21524_() {
        return null;
    }

    public void m_20084_(UUID uniqueIdIn) {
        UUID oldUniqueId = this.m_20148_();
        if (uniqueIdIn.equals(oldUniqueId)) {
            return;
        }
        super.m_20084_(uniqueIdIn);
        if (!this.isAddedToWorld()) {
            return;
        }
        if (this.m_9236_() != null && !this.m_9236_().f_46443_) {
            DogLocationStorage.get(this.m_9236_()).remove(oldUniqueId);
            DogLocationStorage.get(this.m_9236_()).getOrCreateData(this).update(this);
        }
    }

    public void m_21828_(Player player) {
        super.m_21828_(player);
        this.setOwnersName(player.m_7755_());
    }

    public void m_7105_(boolean tamed) {
        super.m_7105_(tamed);
        if (tamed) {
            float maxHealth = this.getDogLevel().getMaxHealth();
            this.m_21051_(Attributes.f_22276_).m_22100_((double)maxHealth);
            this.maxHealth();
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_(8.0);
        }
        this.m_21051_(Attributes.f_22281_).m_22100_(4.0);
    }

    public void maxHealth() {
        this.m_21153_(this.m_21233_());
    }

    public void m_21816_(@Nullable UUID uuid) {
        boolean isChangingOwner;
        UUID currentUUID = this.m_21805_();
        boolean bl = isChangingOwner = currentUUID != null && ObjectUtils.notEqual((Object)currentUUID, (Object)uuid);
        if (isChangingOwner && !this.authorizedChangingOwner) {
            return;
        }
        super.m_21816_(uuid);
        if (uuid == null) {
            this.setOwnersName((Component)null);
        }
    }

    public void m_6593_(@Nullable Component name) {
        if (!this.authorizedChangingName) {
            return;
        }
        name = this.checkDogNameLength(name);
        name = this.checkDogValidName(name);
        super.m_6593_(name);
    }

    private Component checkDogNameLength(Component name) {
        if (name == null) {
            return null;
        }
        String str = name.getString();
        if (str.length() <= MAX_NAME_LEN) {
            return name;
        }
        String new_str = str.substring(0, MAX_NAME_LEN);
        MutableComponent new_name = Component.m_237113_((String)new_str).m_130948_(name.m_7383_());
        return new_name;
    }

    private Component checkDogValidName(Component name) {
        if (name == null) {
            return null;
        }
        String str = name.getString();
        String newStr = DogUtil.checkAndCorrectInvalidName(str);
        if (newStr == str) {
            return name;
        }
        return Component.m_237113_((String)newStr).m_130948_(name.m_7383_());
    }

    public void setDogCustomName(@Nullable Component name) {
        this.authorizedChangingName = true;
        this.m_6593_(name);
        this.authorizedChangingName = false;
    }

    public boolean m_7313_(Entity entityIn) {
        boolean allPlayerCannotAttackDog = (Boolean)ConfigHandler.ClientConfig.getConfig(ConfigHandler.SERVER.ALL_PLAYER_CANNOT_ATTACK_DOG);
        if (allPlayerCannotAttackDog && entityIn instanceof Player) {
            return true;
        }
        if (!this.canOwnerAttack() && this.checkIfAttackedFromOwnerOrTeam(this.m_269323_(), entityIn)) {
            return true;
        }
        for (IDogAlteration alter : this.alterations) {
            InteractionResult result = alter.shouldSkipAttackFrom(this, entityIn);
            if (result.m_19080_()) {
                return true;
            }
            if (result != InteractionResult.FAIL) continue;
            return false;
        }
        return false;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)DoggyItems.DOGGY_CHARM.get());
    }

    public boolean m_6898_(ItemStack stack) {
        return false;
    }

    public boolean m_7848_(Animal otherAnimal) {
        if (this.isDefeated()) {
            return false;
        }
        if (otherAnimal == this) {
            return false;
        }
        if (!this.m_21824_()) {
            return false;
        }
        if (!(otherAnimal instanceof Dog)) {
            return false;
        }
        Dog entitydog = (Dog)otherAnimal;
        if (!entitydog.m_21824_()) {
            return false;
        }
        if (entitydog.m_21825_()) {
            return false;
        }
        if (!((Boolean)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.DISABLE_GENDER)).booleanValue() && !this.getGender().canMateWith(entitydog.getGender())) {
            return false;
        }
        return !entitydog.isDefeated() && this.m_27593_() && entitydog.m_27593_();
    }

    public AgeableMob m_142606_(ServerLevel worldIn, AgeableMob partner) {
        Dog child = (Dog)((EntityType)DoggyEntityTypes.DOG.get()).m_20615_((Level)worldIn);
        UUID uuid = this.m_21805_();
        if (uuid != null) {
            child.m_21816_(uuid);
            child.m_7105_(true);
        }
        if (partner instanceof Dog && ((Boolean)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.PUPS_GET_PARENT_LEVELS)).booleanValue()) {
            child.setLevel(this.getDogLevel().combine(((Dog)partner).getDogLevel()));
        }
        return child;
    }

    public boolean m_6052_() {
        return this.m_8077_() || super.m_6052_();
    }

    public float m_6134_() {
        if (this.m_6162_()) {
            return 0.5f;
        }
        return this.getDogSize().getScale();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (this.alterations == null) {
            return super.getCapability(cap, side);
        }
        for (IDogAlteration alter : this.alterations) {
            LazyOptional<T> result = alter.getCapability(this, cap, side);
            if (result == null) continue;
            return result;
        }
        return super.getCapability(cap, side);
    }

    public void authorizeChangeDimension() {
        this.changeDimensionAuthorized = true;
    }

    public Entity changeDimension(ServerLevel worldIn, ITeleporter teleporter) {
        boolean flag;
        boolean bl = flag = !this.changeDimensionAuthorized && (Boolean)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.ALL_DOG_BLOCK_PORTAL) != false;
        if (flag) {
            return null;
        }
        this.changeDimensionAuthorized = false;
        this.DTN_dogChangingDim = true;
        Entity transportedEntity = super.changeDimension(worldIn, teleporter);
        this.DTN_dogChangingDim = false;
        if (transportedEntity instanceof Dog) {
            DogLocationStorage.get(this.m_9236_()).getOrCreateData(this).update((Dog)transportedEntity);
        }
        return transportedEntity;
    }

    public void onRemovedFromWorld() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            DogLocationData data;
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.m_6084_() && (data = DogLocationStorage.get((Level)serverLevel).getData(this)) != null) {
                data.update(this);
            }
        }
        super.onRemovedFromWorld();
    }

    public void onAddedToWorld() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.m_6084_()) {
                DogLocationStorage storage = DogLocationStorage.get((Level)serverLevel);
                DogLocationData data = storage.getOrCreateData(this);
                if (data != null) {
                    data.update(this);
                }
                storage.getOnlineDogsManager().onDogGoOnline(this);
            }
        }
        super.onAddedToWorld();
    }

    public void m_142687_(Entity.RemovalReason removalReason) {
        if (removalReason.m_146965_() && this.m_9236_() != null && !this.m_9236_().f_46443_) {
            this.cacheSessionUUID();
            DogLocationStorage.get(this.m_9236_()).remove(this);
            if (this.m_21805_() != null) {
                DogRespawnStorage.get(this.m_9236_()).putData(this);
            }
        }
        super.m_142687_(removalReason);
        for (IDogAlteration x : this.alterations) {
            x.remove(this);
        }
    }

    private void startShaking() {
        if (this.isShaking) {
            return;
        }
        this.isShaking = true;
        this.shakeFire = false;
        this.timeWolfIsShaking = 0.0f;
        this.prevTimeWolfIsShaking = 0.0f;
    }

    public void startShakingAndBroadcast(boolean shakeFire) {
        if (this.isShaking) {
            return;
        }
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (shakeFire) {
            this.startShakingLava();
            ParticlePackets.DogShakingPacket.sendDogShakingPacket(this, DogShakingData.State.SHAKE_LAVA);
            return;
        }
        this.startShaking();
        ParticlePackets.DogShakingPacket.sendDogShakingPacket(this, DogShakingData.State.SHAKE_WATER);
    }

    private void finishShaking() {
        this.isShaking = false;
        this.shakeFire = false;
        this.timeWolfIsShaking = 0.0f;
        this.prevTimeWolfIsShaking = 0.0f;
    }

    public void startShakingLava() {
        if (this.isShaking) {
            return;
        }
        this.isShaking = true;
        this.shakeFire = true;
        this.timeWolfIsShaking = 0.0f;
        this.prevTimeWolfIsShaking = 0.0f;
    }

    public boolean isShakingLava() {
        return this.isShaking && this.shakeFire;
    }

    public void resetBeggingRotation() {
        this.headRotationCourse = 0.0f;
        this.headRotationCourseOld = 0.0f;
    }

    public void m_6667_(DamageSource cause) {
        if (this.checkAndHandleIncapacitated(cause)) {
            return;
        }
        this.wetSource = WetSource.NONE;
        this.finishShaking();
        this.alterations.forEach(alter -> alter.onDeath(this, cause));
        if (((Boolean)ConfigHandler.SERVER.DOG_RESPAWN_INCAPACITATED_WHEN_KILLED.get()).booleanValue()) {
            this.dogDeathCause = Optional.ofNullable(cause);
            this.setDogIncapValue(this.getInitalDogIncapVal(cause));
        }
        this.dogProccessAndBroadcastDieVanilla(cause);
    }

    public Optional<DamageSource> getDogDeathCause() {
        return this.dogDeathCause;
    }

    private void dogProccessAndBroadcastDieVanilla(DamageSource cause) {
        if (this.m_213877_()) {
            return;
        }
        if (this.f_20890_) {
            return;
        }
        Component deathMessage = this.m_21231_().m_19293_();
        this.f_20890_ = true;
        this.m_21231_().m_19296_();
        Level level = this.m_9236_();
        Entity entity = cause.m_7639_();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            if (entity == null || entity.m_214076_(serverlevel, (LivingEntity)this)) {
                this.m_146850_(GameEvent.f_223707_);
                this.m_6668_(cause);
            }
            this.m_9236_().m_7605_((Entity)this, (byte)3);
        }
        LivingEntity owner = this.m_269323_();
        if (!this.m_9236_().f_46443_ && this.m_9236_().m_46469_().m_46207_(GameRules.f_46142_) && owner instanceof ServerPlayer) {
            owner.m_213846_(deathMessage);
        }
    }

    private boolean checkAndHandleIncapacitated(DamageSource cause) {
        if (this.m_9236_().f_46443_) {
            return false;
        }
        if (!((Boolean)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.IMMORTAL_DOGS)).booleanValue()) {
            return false;
        }
        if (cause.m_269533_(DamageTypeTags.f_268738_)) {
            return false;
        }
        if (this.m_21805_() == null) {
            return false;
        }
        this.handleIncapacitated(cause);
        return true;
    }

    private void handleIncapacitated(DamageSource source) {
        this.m_21153_(1.0f);
        this.setMode(EnumMode.INCAPACITATED);
        this.setDogHunger(0.0f);
        this.m_21219_();
        this.setDogIncapValue(this.getInitalDogIncapVal(source));
        this.m_21573_().m_26573_();
        this.m_19877_();
        this.createAndSetIncapSyncState(source);
        if (this.m_20069_() || this.m_20077_()) {
            this.triggerAnimationAction(new DogDrownAction(this));
        } else {
            this.setAnim(this.incapacitatedMananger.getAnim());
        }
        LivingEntity owner = this.m_269323_();
        if (owner != null) {
            this.sendIncapacitatedMsg(owner, source);
        }
        this.incapacitatedMananger.setIncapMsg(source.m_6157_((LivingEntity)this).getString());
        this.wetSource = WetSource.NONE;
        this.finishShaking();
    }

    public int getInitalDogIncapVal(DamageSource source) {
        Difficulty difficulty = this.m_9236_().m_46791_();
        if (difficulty == Difficulty.PEACEFUL) {
            return this.getDefaultInitIncapVal() / 2;
        }
        if (difficulty == Difficulty.EASY) {
            return this.getDefaultInitIncapVal();
        }
        if (source.m_269533_(DamageTypeTags.f_268738_)) {
            return this.getDefaultInitIncapVal();
        }
        float fatal_damage = this.f_20898_;
        if (fatal_damage <= 0.0f) {
            return this.getDefaultInitIncapVal();
        }
        fatal_damage = this.m_21161_(source, fatal_damage);
        if ((fatal_damage = this.m_6515_(source, fatal_damage)) <= 0.0f) {
            return this.getDefaultInitIncapVal();
        }
        int multipler = difficulty == Difficulty.HARD ? 2 : 1;
        int additional_incap = Mth.m_14143_((float)((float)multipler * fatal_damage));
        return this.getDefaultInitIncapVal() + additional_incap;
    }

    private void sendIncapacitatedMsg(LivingEntity owner, DamageSource source) {
        MutableComponent msg = source.m_6157_((LivingEntity)this).m_6881_();
        String genderStr = Component.m_237115_((String)this.getGender().getUnlocalisedSubject()).getString();
        String msg005 = ". " + genderStr.substring(0, 1).toUpperCase() + genderStr.substring(1) + " ";
        MutableComponent msg01 = Component.m_237110_((String)"dog.mode.incapacitated.msg.partition1", (Object[])new Object[]{Component.m_237113_((String)msg005), Component.m_237115_((String)EnumMode.INCAPACITATED.getUnlocalisedName()).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_178520_(14025732))});
        msg.m_7220_((Component)msg01);
        owner.m_213846_((Component)msg);
    }

    public DogIncapacitatedMananger.IncapacitatedSyncState createIncapSyncState(DamageSource source) {
        DogIncapacitatedMananger.DefeatedType type = source.m_269533_(DamageTypeTags.f_268745_) || this.m_6060_() && !this.m_5825_() ? DogIncapacitatedMananger.DefeatedType.BURN : (source.m_276093_(DamageTypes.f_268515_) ? DogIncapacitatedMananger.DefeatedType.POISON : (source.m_276093_(DamageTypes.f_268722_) ? DogIncapacitatedMananger.DefeatedType.DROWN : (source.m_276093_(DamageTypes.f_268441_) ? DogIncapacitatedMananger.DefeatedType.STARVE : DogIncapacitatedMananger.DefeatedType.BLOOD)));
        int poseId = this.m_217043_().m_188503_(2);
        return new DogIncapacitatedMananger.IncapacitatedSyncState(type, DogIncapacitatedMananger.BandaidState.NONE, poseId);
    }

    private void createAndSetIncapSyncState(DamageSource source) {
        DogIncapacitatedMananger.IncapacitatedSyncState state = this.createIncapSyncState(source);
        this.setIncapSyncState(state);
    }

    public double m_20204_() {
        float defeated_threshold = this.m_20077_() ? 0.9f : 1.0f;
        return this.isDefeated() ? (double)defeated_threshold : super.m_20204_();
    }

    public void m_5907_() {
        this.alterations.forEach(alter -> alter.dropInventory(this));
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.alterations.forEach(alter -> alter.invalidateCapabilities(this));
    }

    public void m_7380_(CompoundTag compound) {
        DimensionDependantArg bowlsData;
        super.m_7380_(compound);
        ListTag talentList = new ListTag();
        List<TalentInstance> talents = this.getTalentMap();
        for (int i = 0; i < talents.size(); ++i) {
            CompoundTag talentTag = new CompoundTag();
            talents.get(i).writeInstance(this, talentTag);
            talentList.add((Object)talentTag);
        }
        compound.m_128365_("talents", (Tag)talentList);
        ListTag accessoryList = new ListTag();
        List<AccessoryInstance> accessories = this.getAccessories();
        for (int i = 0; i < accessories.size(); ++i) {
            CompoundTag accessoryTag = new CompoundTag();
            accessories.get(i).writeInstance(accessoryTag);
            accessoryList.add((Object)accessoryTag);
        }
        compound.m_128365_("accessories", (Tag)accessoryList);
        ListTag artifactsListTag = new ListTag();
        List<DoggyArtifactItem> artifacts = this.getArtifactsList();
        for (DoggyArtifactItem x : artifacts) {
            CompoundTag artifactTag = DoggyArtifactItem.writeCompound(x);
            if (artifactTag == null) continue;
            artifactsListTag.add((Object)artifactTag);
        }
        compound.m_128365_("doggy_artifacts", (Tag)artifactsListTag);
        compound.m_128359_("mode", this.getMode().getSaveName());
        compound.m_128359_("dogGender", this.getGender().getSaveName());
        compound.m_128350_("dogHunger", this.getDogHunger());
        compound.m_128405_("dogIncapacitatedValue", this.getDogIncapValue());
        this.getOwnersName().ifPresent(comp -> NBTUtil.putTextComponent(compound, "lastKnownOwnerName", comp));
        this.getSkinData().save(compound);
        compound.m_128379_("willObey", this.willObeyOthers());
        compound.m_128379_("friendlyFire", this.canOwnerAttack());
        compound.m_128379_("regardTeamPlayers", this.regardTeamPlayers());
        compound.m_128379_("forceSit", this.forceSit());
        compound.m_128344_("lowHealthStrategy", this.getLowHealthStrategy().getId());
        compound.m_128344_("combatReturnStrategy", this.getCombatReturnStrategy().getId());
        compound.m_128379_("crossOriginTp", this.crossOriginTp());
        compound.m_128379_("patrolTargetLock", this.patrolTargetLock());
        compound.m_128379_("hideDogArmor", this.hideArmor());
        compound.m_128405_("dogSize", this.getDogSize().getId());
        compound.m_128405_("level_normal", this.getDogLevel().getLevel(DogLevel.Type.NORMAL));
        compound.m_128405_("level_kami", this.getDogLevel().getLevel(DogLevel.Type.KAMI));
        NBTUtil.writeItemStack(compound, "fetchItem", this.getBoneVariant());
        DimensionDependantArg bedsData = (DimensionDependantArg)this.f_19804_.m_135370_(DOG_BED_LOCATION.get());
        if (!bedsData.isEmpty()) {
            ListTag bedsList = new ListTag();
            for (Map.Entry entry : bedsData.entrySet()) {
                CompoundTag compoundTag = new CompoundTag();
                NBTUtil.putResourceLocation(compoundTag, "dim", ((ResourceKey)entry.getKey()).m_135782_());
                NBTUtil.putBlockPos(compoundTag, "pos", (Optional)entry.getValue());
                bedsList.add((Object)compoundTag);
            }
            compound.m_128365_("beds", (Tag)bedsList);
        }
        if (!(bowlsData = (DimensionDependantArg)this.f_19804_.m_135370_(DOG_BOWL_LOCATION.get())).isEmpty()) {
            ListTag bowlsList = new ListTag();
            for (Map.Entry entry : bowlsData.entrySet()) {
                CompoundTag bowlsNBT = new CompoundTag();
                NBTUtil.putResourceLocation(bowlsNBT, "dim", entry.getKey().m_135782_());
                NBTUtil.putBlockPos(bowlsNBT, "pos", (Optional)entry.getValue());
                bowlsList.add((Object)bowlsNBT);
            }
            compound.m_128365_("bowls", (Tag)bowlsList);
        }
        this.statsTracker.writeAdditional(compound);
        this.dogOwnerDistanceManager.save(compound);
        this.alterations.forEach(alter -> alter.onWrite(this, compound));
        this.dogGroupsManager.save(compound);
        if (this.isDefeated()) {
            this.incapacitatedMananger.save(compound);
        }
        if (this.getMode().canWander() && this.m_21536_()) {
            BlockPos restrict = this.m_21534_();
            int n = (int)this.m_21535_();
            if (restrict != null) {
                CompoundTag compoundTag = new CompoundTag();
                compoundTag.m_128405_("wanderX", restrict.m_123341_());
                compoundTag.m_128405_("wanderY", restrict.m_123342_());
                compoundTag.m_128405_("wanderZ", restrict.m_123343_());
                compoundTag.m_128405_("wanderR", n);
                compound.m_128365_("dogWanderCenter", (Tag)compoundTag);
            }
        }
        if (!this.m_9236_().f_46443_ && !this.DTN_dogChangingDim) {
            UUID uuid = this.m_20148_();
            UUID uUID = this.m_21805_();
            if (uuid != null && uUID != null) {
                CompoundTag compoundTag = new CompoundTag();
                compoundTag.m_128362_("dtn_uuid_owner", uUID);
                compoundTag.m_128362_("dtn_uuid_self", uuid);
                this.writeSessionUUIDToCompound(uuid, compoundTag);
                compound.m_128365_("DTN_DupeDetect_UUID", (Tag)compoundTag);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public void m_20258_(CompoundTag compound) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchStringRewriter$TooOptimisticMatchException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchStringRewriter.getString(SwitchStringRewriter.java:404)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchStringRewriter.access$600(SwitchStringRewriter.java:53)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchStringRewriter$SwitchStringMatchResultCollector.collectMatches(SwitchStringRewriter.java:368)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.matchutil.ResetAfterTest.match(ResetAfterTest.java:24)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.matchutil.KleeneN.match(KleeneN.java:24)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.matchutil.MatchSequence.match(MatchSequence.java:26)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.matchutil.ResetAfterTest.match(ResetAfterTest.java:23)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchStringRewriter.rewriteComplex(SwitchStringRewriter.java:201)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchStringRewriter.rewrite(SwitchStringRewriter.java:73)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:881)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        ArrayList<TalentInstance> newTlInstLs = new ArrayList<TalentInstance>();
        if (compound.m_128425_("talents", 9)) {
            ListTag talentList = compound.m_128437_("talents", 10);
            for (int i = 0; i < talentList.size(); ++i) {
                TalentInstance.readInstance(this, talentList.m_128728_(i)).ifPresent(newTlInstLs::add);
            }
        } else {
            BackwardsComp.readTalentMapping(compound, newTlInstLs);
        }
        this.dogSyncedDataManager.talents().clear();
        this.dogSyncedDataManager.talents().addAll(newTlInstLs);
        this.dogSyncedDataManager.setTalentsDirty();
        ArrayList<AccessoryInstance> newAccInstLs = new ArrayList<AccessoryInstance>();
        if (compound.m_128425_("accessories", 9)) {
            ListTag accessoryList = compound.m_128437_("accessories", 10);
            for (int i = 0; i < accessoryList.size(); ++i) {
                AccessoryInstance.readInstance(accessoryList.m_128728_(i)).ifPresent(newAccInstLs::add);
            }
        } else {
            BackwardsComp.readAccessories(compound, newAccInstLs);
        }
        this.dogSyncedDataManager.accessories().clear();
        this.dogSyncedDataManager.accessories().addAll(newAccInstLs);
        this.dogSyncedDataManager.setAccessoriesDirty();
        ArrayList<DoggyArtifactItem> artifactsList = new ArrayList<DoggyArtifactItem>(3);
        if (compound.m_128425_("doggy_artifacts", 9)) {
            ListTag artifactsListTag = compound.m_128437_("doggy_artifacts", 10);
            for (int i = 0; i < artifactsListTag.size(); ++i) {
                DoggyArtifactItem artifactItem = DoggyArtifactItem.readCompound(artifactsListTag.m_128728_(i));
                if (artifactItem == null) continue;
                artifactsList.add(artifactItem);
            }
        }
        this.f_19804_.m_135381_(ARTIFACTS.get(), artifactsList);
        try {
            this.spendablePoints.markForRefresh();
        }
        catch (Exception e) {
            DoggyTalentsNext.LOGGER.error("Failed to init alteration: " + e.getMessage());
            e.printStackTrace();
        }
        try {
            this.setGender(EnumGender.bySaveName(compound.m_128461_("dogGender")));
            if (compound.m_128425_("mode", 8)) {
                this.setMode(EnumMode.bySaveName(compound.m_128461_("mode")));
            } else {
                BackwardsComp.readMode(compound, this::setMode);
            }
            DogSkinData dogSkinData = DogSkinData.readFromTag(compound);
            this.setDogSkinData(dogSkinData);
            if (compound.m_128425_("fetchItem", 10)) {
                this.setBoneVariant(NBTUtil.readItemStack(compound, "fetchItem"));
            } else {
                BackwardsComp.readHasBone(compound, this::setBoneVariant);
            }
            this.setHungerDirectly(compound.m_128457_("dogHunger"));
            this.setDogIncapValue(compound.m_128451_("dogIncapacitatedValue"));
            this.setOwnersName(NBTUtil.getTextComponent(compound, "lastKnownOwnerName"));
            this.setWillObeyOthers(compound.m_128471_("willObey"));
            this.setCanPlayersAttack(compound.m_128471_("friendlyFire"));
            this.setRegardTeamPlayers(compound.m_128471_("regardTeamPlayers"));
            this.setForceSit(compound.m_128471_("forceSit"));
            this.setCrossOriginTp(compound.m_128471_("crossOriginTp"));
            this.setPatrolTargetLock(compound.m_128471_("patrolTargetLock"));
            this.setHideArmor(compound.m_128471_("hideDogArmor"));
            byte low_health_strategy_id = compound.m_128445_("lowHealthStrategy");
            this.setLowHealthStrategy(LowHealthStrategy.fromId(low_health_strategy_id));
            byte combat_return_strategy_id = compound.m_128445_("combatReturnStrategy");
            this.setCombatReturnStrategy(CombatReturnStrategy.fromId(combat_return_strategy_id));
            if (compound.m_128425_("dogSize", 99)) {
                this.setDogSize(DogSize.fromId(compound.m_128451_("dogSize")));
            }
        }
        catch (Exception e) {
            DoggyTalentsNext.LOGGER.error("Failed to load levels: " + e.getMessage());
            e.printStackTrace();
        }
        try {
            int level_normal = 0;
            int level_kami = 0;
            if (compound.m_128425_("level_normal", 99)) {
                level_normal = compound.m_128451_("level_normal");
            }
            if (compound.m_128425_("level_kami", 99)) {
                level_kami = compound.m_128451_("level_kami");
            } else if (compound.m_128425_("level_dire", 99)) {
                level_kami = compound.m_128451_("level_dire");
            }
            this.f_19804_.m_135381_(DOG_LEVEL.get(), (Object)new DogLevel(level_normal, level_kami));
        }
        catch (Exception e) {
            DoggyTalentsNext.LOGGER.error("Failed to load levels: " + e.getMessage());
            e.printStackTrace();
        }
        DimensionDependantArg<Optional<BlockPos>> bedsData = ((DimensionDependantArg)this.f_19804_.m_135370_(DOG_BED_LOCATION.get())).copyEmpty();
        try {
            if (compound.m_128425_("beds", 9)) {
                ListTag bedsList = compound.m_128437_("beds", 10);
                for (int i = 0; i < bedsList.size(); ++i) {
                    CompoundTag bedNBT = bedsList.m_128728_(i);
                    ResourceLocation loc = NBTUtil.getResourceLocation(bedNBT, "dim");
                    ResourceKey type = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)loc);
                    Optional<BlockPos> pos = NBTUtil.getBlockPos(bedNBT, "pos");
                    bedsData.put((ResourceKey<Level>)type, pos);
                }
            } else {
                BackwardsComp.readBedLocations(compound, bedsData);
            }
        }
        catch (Exception e) {
            DoggyTalentsNext.LOGGER.error("Failed to load beds: " + e.getMessage());
            e.printStackTrace();
        }
        this.f_19804_.m_135381_(DOG_BED_LOCATION.get(), bedsData);
        DimensionDependantArg<Optional<BlockPos>> bowlsData = ((DimensionDependantArg)this.f_19804_.m_135370_(DOG_BOWL_LOCATION.get())).copyEmpty();
        try {
            if (compound.m_128425_("bowls", 9)) {
                ListTag bowlsList = compound.m_128437_("bowls", 10);
                for (int i = 0; i < bowlsList.size(); ++i) {
                    CompoundTag bowlsNBT = bowlsList.m_128728_(i);
                    ResourceLocation loc = NBTUtil.getResourceLocation(bowlsNBT, "dim");
                    ResourceKey type = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)loc);
                    Optional<BlockPos> pos = NBTUtil.getBlockPos(bowlsNBT, "pos");
                    bowlsData.put((ResourceKey<Level>)type, pos);
                }
            } else {
                BackwardsComp.readBowlLocations(compound, bowlsData);
            }
        }
        catch (Exception e) {
            DoggyTalentsNext.LOGGER.error("Failed to load bowls: " + e.getMessage());
            e.printStackTrace();
        }
        this.f_19804_.m_135381_(DOG_BOWL_LOCATION.get(), bowlsData);
        try {
            this.statsTracker.readAdditional(compound);
        }
        catch (Exception e) {
            DoggyTalentsNext.LOGGER.error("Failed to load stats tracker: " + e.getMessage());
            e.printStackTrace();
        }
        try {
            this.dogOwnerDistanceManager.load(compound);
        }
        catch (Exception e) {
            DoggyTalentsNext.LOGGER.error("Failed to load owner distance manager: " + e.getMessage());
            e.printStackTrace();
        }
        this.alterations.forEach(alter -> {
            try {
                alter.onRead(this, compound);
            }
            catch (Exception e) {
                DoggyTalentsNext.LOGGER.error("Failed to load alteration: " + e.getMessage());
                e.printStackTrace();
            }
        });
        try {
            this.dogGroupsManager.load(compound);
            if (this.isDefeated()) {
                this.incapacitatedMananger.load(compound);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.getMode().canWander() && compound.m_128425_("dogWanderCenter", 10)) {
                CompoundTag wanderTg = compound.m_128469_("dogWanderCenter");
                BlockPos restrictPos = new BlockPos(wanderTg.m_128451_("wanderX"), wanderTg.m_128451_("wanderY"), wanderTg.m_128451_("wanderZ"));
                int restrict_r = wanderTg.m_128451_("wanderR");
                restrict_r = Math.max(0, restrict_r);
                this.m_21446_(restrictPos, restrict_r);
            }
        }
        catch (Exception wanderTg) {
            // empty catch block
        }
        boolean duplicate_detected = false;
        if (!this.m_9236_().f_46443_) {
            try {
                duplicate_detected = this.detectDuplicate(compound);
            }
            catch (Exception restrictPos) {
                // empty catch block
            }
        }
        if (duplicate_detected) {
            int strategy = (Integer)ConfigHandler.SERVER.DUPLICATION_RESOLVE_STRATEGY.get();
            if (strategy == 0 || strategy == 1) {
                this.untame();
                if (!this.isAddedToWorld()) {
                    this.m_142467_(Entity.RemovalReason.DISCARDED);
                } else {
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                }
            }
            compound.m_128379_("DTN_DupeDetect_marked", true);
            if (strategy == 0) {
                throw new IllegalStateException("This dog has been restored from third-party storage which may leads to duplications.");
            }
            return;
        }
        this.detectedDuplicateVertified = true;
        if (!this.m_9236_().f_46443_) {
            try {
                this.checkAndRecorrectOwner(compound);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean detectDuplicate(CompoundTag tag) {
        if (this.detectedDuplicateVertified) {
            return false;
        }
        if (((Boolean)ConfigHandler.SERVER.DISABLE_PRESERVE_UUID.get()).booleanValue()) {
            return false;
        }
        if (!tag.m_128425_("DTN_DupeDetect_UUID", 10)) {
            return false;
        }
        if (tag.m_128441_("DTN_DupeDetect_marked")) {
            return tag.m_128471_("DTN_DupeDetect_marked");
        }
        CompoundTag backupUUIDTag = tag.m_128469_("DTN_DupeDetect_UUID");
        UUID uuid = backupUUIDTag.m_128342_("dtn_uuid_self");
        UUID ownerUUID = backupUUIDTag.m_128342_("dtn_uuid_owner");
        UUID sessionUUID = null;
        if (backupUUIDTag.m_128403_("session_uuid")) {
            sessionUUID = backupUUIDTag.m_128342_("session_uuid");
        }
        if (uuid == null || ownerUUID == null) {
            return false;
        }
        if (this.isAddedToWorld() && uuid.equals(this.m_20148_())) {
            return false;
        }
        boolean isDuplicate = false;
        if (!isDuplicate && this.checkRespawnStorageForDuplicate(uuid, ownerUUID)) {
            isDuplicate = true;
        }
        if (!isDuplicate && this.checkLocationStorageForDuplicate(uuid, ownerUUID, sessionUUID)) {
            isDuplicate = true;
        }
        if (!isDuplicate) {
            return false;
        }
        DoggyTalentsNext.LOGGER.warn("Duplicated Dog Detected! dog_uuid=[" + uuid.toString() + "] owner_uuid=[" + ownerUUID.toString() + "]");
        return true;
    }

    private boolean checkRespawnStorageForDuplicate(UUID uuid, UUID ownerUUID) {
        DogRespawnStorage storage = DogRespawnStorage.get(this.m_9236_());
        if (storage == null) {
            return false;
        }
        DogRespawnData data = storage.getData(uuid);
        if (data == null) {
            return false;
        }
        UUID ownerUUID0 = data.getOwnerId();
        if (ownerUUID0 == null) {
            return false;
        }
        return !ObjectUtils.notEqual((Object)ownerUUID0, (Object)ownerUUID);
    }

    private boolean checkLocationStorageForDuplicate(UUID uuid, UUID ownerUUID, UUID sessionUUID) {
        DogLocationStorage storage = DogLocationStorage.get(this.m_9236_());
        if (storage == null) {
            return false;
        }
        DogLocationData data = storage.getData(uuid);
        if (data == null) {
            return false;
        }
        UUID ownerUUID0 = data.getOwnerId();
        if (ownerUUID0 == null) {
            return false;
        }
        if (ObjectUtils.notEqual((Object)ownerUUID0, (Object)ownerUUID)) {
            return false;
        }
        UUID correctSessionUUID = data.getSessionUUID();
        if (correctSessionUUID == null) {
            return false;
        }
        return ObjectUtils.notEqual((Object)correctSessionUUID, (Object)sessionUUID);
    }

    private void writeSessionUUIDToCompound(UUID uuid, CompoundTag tag) {
        if (this.cachedSessionUUID != null) {
            tag.m_128362_("session_uuid", this.cachedSessionUUID);
            this.cachedSessionUUID = null;
            return;
        }
        Level level = this.m_9236_();
        if (level == null) {
            return;
        }
        DogLocationStorage storage = DogLocationStorage.get(level);
        if (storage == null) {
            return;
        }
        DogLocationData data = storage.getData(uuid);
        if (data == null) {
            return;
        }
        UUID sessionUUID = data.getSessionUUID();
        if (sessionUUID == null) {
            return;
        }
        tag.m_128362_("session_uuid", sessionUUID);
    }

    private void cacheSessionUUID() {
        UUID uuid = this.m_20148_();
        Level level = this.m_9236_();
        if (level == null) {
            return;
        }
        DogLocationStorage storage = DogLocationStorage.get(level);
        if (storage == null) {
            return;
        }
        DogLocationData data = storage.getData(uuid);
        if (data == null) {
            return;
        }
        UUID sessionUUID = data.getSessionUUID();
        if (sessionUUID == null) {
            return;
        }
        this.cachedSessionUUID = sessionUUID;
    }

    private void checkAndRecorrectOwner(CompoundTag tag) {
        if (!tag.m_128425_("DTN_DupeDetect_UUID", 10)) {
            return;
        }
        CompoundTag backupUUIDTag = tag.m_128469_("DTN_DupeDetect_UUID");
        UUID ownerUUID = backupUUIDTag.m_128342_("dtn_uuid_owner");
        if (!ObjectUtils.notEqual((Object)ownerUUID, (Object)this.m_21805_())) {
            return;
        }
        boolean prevAuthorized = this.authorizedChangingOwner;
        this.authorizedChangingOwner = true;
        this.m_21816_(ownerUUID);
        this.authorizedChangingOwner = prevAuthorized;
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (ARTIFACTS.get().equals(key)) {
            this.refreshAlterations();
        }
        if (DOG_LEVEL.get().equals(key)) {
            this.spendablePoints.markForRefresh();
            float h = this.getDogLevel().getMaxHealth();
            if (h != this.m_21233_()) {
                this.m_21051_(Attributes.f_22276_).m_22100_((double)h);
            }
            this.maxHealth();
        }
        if (DOG_SIZE.get().equals(key)) {
            this.m_6210_();
        }
        if (this.m_9236_().f_46443_ && CUSTOM_SKIN.get().equals(key)) {
            this.setClientSkin(DogTextureManager.INSTANCE.getDogSkin(this.getSkinData().getHash()));
        }
        if (ANIMATION.equals(key)) {
            this.animationManager.onAnimationChange(this.getAnim());
        }
        if (ANIM_SYNC_TIME.equals(key)) {
            this.animationManager.onSyncTimeUpdated();
        }
        if (!this.m_9236_().f_46443_ && MODE.get().equals(key)) {
            EnumMode mode = this.getMode();
            this.incapacitatedMananger.onModeUpdate(mode);
            if (mode == EnumMode.INCAPACITATED) {
                this.removeAttributeModifier(Attributes.f_22279_, HUNGER_MOVEMENT);
            }
            this.updateWanderState(mode);
        }
    }

    public void onTalentsUpdated() {
        this.refreshAlterations();
        this.spendablePoints.markForRefresh();
        if (this.m_9236_().f_46443_) {
            ClientEventHandler.onDogTalentUpdated(this);
        }
    }

    public void onAccessoriesUpdated() {
        this.refreshAlterations();
        this.spendablePoints.markForRefresh();
        if (this.m_9236_().f_46443_) {
            this.clientAccessories = new ArrayList<AccessoryInstance>(this.getAccessories());
            this.clientAccessories.sort(AccessoryInstance.RENDER_SORTER);
        }
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.dogSyncedDataManager.onStartBeingSeenBy(player);
    }

    private void updateWanderState(EnumMode mode) {
        BlockPos bowlPos;
        if (!mode.canWander()) {
            this.m_147271_();
            return;
        }
        BlockPos restrictPos = this.m_20183_();
        int restrictRadius = 12;
        Optional<BlockPos> bowlPosOptional = this.getBowlPos();
        if (bowlPosOptional.isPresent() && (bowlPos = bowlPosOptional.get()).m_123331_((Vec3i)this.m_20183_()) < 64.0) {
            restrictRadius = 5;
            restrictPos = bowlPos;
        }
        this.m_21446_(restrictPos, restrictRadius);
    }

    private boolean invalidateWanderCenter(int distanceSqr) {
        if (!this.m_21536_()) {
            return false;
        }
        BlockPos restrict_pos = this.m_21534_();
        if (restrict_pos == null) {
            return false;
        }
        if (restrict_pos.m_123331_((Vec3i)this.m_20183_()) >= (double)distanceSqr) {
            this.m_147271_();
            return true;
        }
        return false;
    }

    public void refreshAlterations() {
        for (IDogAlteration iDogAlteration : this.alterations) {
            iDogAlteration.remove(this);
        }
        this.alterations.clear();
        this.foodHandlers.clear();
        this.alterationProps = new DogAlterationProps();
        for (AccessoryInstance accessoryInstance : this.getAccessories()) {
            if (accessoryInstance instanceof IDogAlteration) {
                this.alterations.add((IDogAlteration)((Object)accessoryInstance));
            }
            if (!(accessoryInstance instanceof IDogFoodHandler)) continue;
            this.foodHandlers.add((IDogFoodHandler)((Object)accessoryInstance));
        }
        List<TalentInstance> talents = this.getTalentMap();
        this.alterations.addAll(talents);
        for (TalentInstance inst : talents) {
            if (!(inst instanceof IDogFoodHandler)) continue;
            this.foodHandlers.add((IDogFoodHandler)((Object)inst));
        }
        List<DoggyArtifactItem> list = this.getArtifactsList();
        for (DoggyArtifactItem artifactItem : list) {
            DoggyArtifact artifact = artifactItem.createArtifact();
            this.alterations.add(artifact);
        }
        for (IDogAlteration inst : this.alterations) {
            inst.props(this, this.alterationProps);
            inst.init(this);
        }
        this.onPropsUpdated();
    }

    private void onPropsUpdated() {
        this.dogArmors.onPropsUpdated(this.alterationProps);
        if (!this.alterationProps.canUseTools()) {
            this.mouthStack = ItemStack.f_41583_;
        }
    }

    @Override
    public boolean canInteract(LivingEntity livingEntity) {
        if (!this.isDoingFine()) {
            return false;
        }
        return this.willObeyOthers() || this.m_21830_(livingEntity);
    }

    @Override
    public List<AccessoryInstance> getAccessories() {
        return this.dogSyncedDataManager.accessories();
    }

    @Override
    public boolean addAccessory(@Nonnull AccessoryInstance accessoryInst) {
        List<AccessoryInstance> accessories = this.getAccessories();
        AccessoryType type = accessoryInst.getAccessory().getType();
        List filtered = accessories.stream().filter(inst -> type == inst.getAccessory().getType()).collect(Collectors.toList());
        if (filtered.size() >= type.numberToPutOn()) {
            return false;
        }
        this.dogSyncedDataManager.accessories().add(accessoryInst);
        this.dogSyncedDataManager.setAccessoriesDirty();
        return true;
    }

    @Override
    public List<AccessoryInstance> removeAccessories() {
        ArrayList<AccessoryInstance> removed = new ArrayList<AccessoryInstance>(this.getAccessories());
        this.dogSyncedDataManager.accessories().clear();
        this.dogSyncedDataManager.setAccessoriesDirty();
        return removed;
    }

    public Optional<AccessoryInstance> getAccessory(AccessoryType typeIn) {
        List<AccessoryInstance> accessories = this.getAccessories();
        for (AccessoryInstance inst : accessories) {
            if (inst.getAccessory().getType() != typeIn) continue;
            return Optional.of(inst);
        }
        return Optional.empty();
    }

    public Optional<AccessoryInstance> getAccessory(Accessory typeIn) {
        List<AccessoryInstance> accessories = this.getAccessories();
        for (AccessoryInstance inst : accessories) {
            if (inst.getAccessory() != typeIn) continue;
            return Optional.of(inst);
        }
        return Optional.empty();
    }

    public Optional<Component> getOwnersName() {
        return (Optional)this.f_19804_.m_135370_(LAST_KNOWN_NAME);
    }

    public void setOwnersName(@Nullable Component comp) {
        this.setOwnersName(Optional.ofNullable(comp));
    }

    public void setOwnersName(Optional<Component> collar) {
        this.f_19804_.m_135381_(LAST_KNOWN_NAME, collar);
    }

    public EnumGender getGender() {
        return (EnumGender)((Object)this.f_19804_.m_135370_(GENDER.get()));
    }

    public void setGender(EnumGender collar) {
        this.f_19804_.m_135381_(GENDER.get(), (Object)collar);
    }

    @Override
    public EnumMode getMode() {
        return (EnumMode)((Object)this.f_19804_.m_135370_(MODE.get()));
    }

    public boolean isMode(EnumMode ... modes) {
        EnumMode mode = this.getMode();
        for (EnumMode test : modes) {
            if (mode != test) continue;
            return true;
        }
        return false;
    }

    public void setMode(EnumMode collar) {
        this.f_19804_.m_135381_(MODE.get(), (Object)collar);
    }

    public Optional<BlockPos> getBedPos() {
        return this.getBedPos((ResourceKey<Level>)this.m_9236_().m_46472_());
    }

    public Optional<BlockPos> getBedPos(ResourceKey<Level> registryKey) {
        return ((DimensionDependantArg)this.f_19804_.m_135370_(DOG_BED_LOCATION.get())).getOrDefault(registryKey, Optional.empty());
    }

    public void setBedPos(@Nullable BlockPos pos) {
        this.setBedPos((ResourceKey<Level>)this.m_9236_().m_46472_(), pos);
    }

    public void setBedPos(ResourceKey<Level> registryKey, @Nullable BlockPos pos) {
        this.setBedPos(registryKey, WorldUtil.toImmutable(pos));
    }

    public void setBedPos(ResourceKey<Level> registryKey, Optional<BlockPos> pos) {
        this.f_19804_.m_135381_(DOG_BED_LOCATION.get(), ((DimensionDependantArg)this.f_19804_.m_135370_(DOG_BED_LOCATION.get())).copy().set(registryKey, pos));
    }

    public Optional<BlockPos> getBowlPos() {
        return this.getBowlPos((ResourceKey<Level>)this.m_9236_().m_46472_());
    }

    public Optional<BlockPos> getBowlPos(ResourceKey<Level> registryKey) {
        return ((DimensionDependantArg)this.f_19804_.m_135370_(DOG_BOWL_LOCATION.get())).getOrDefault(registryKey, Optional.empty());
    }

    public void setBowlPos(@Nullable BlockPos pos) {
        this.setBowlPos((ResourceKey<Level>)this.m_9236_().m_46472_(), pos);
    }

    public void setBowlPos(ResourceKey<Level> registryKey, @Nullable BlockPos pos) {
        this.setBowlPos(registryKey, WorldUtil.toImmutable(pos));
    }

    public void setBowlPos(ResourceKey<Level> registryKey, Optional<BlockPos> pos) {
        this.f_19804_.m_135381_(DOG_BOWL_LOCATION.get(), ((DimensionDependantArg)this.f_19804_.m_135370_(DOG_BOWL_LOCATION.get())).copy().set(registryKey, pos));
    }

    @Override
    public int getDefaultInitIncapVal() {
        return 64;
    }

    @Override
    public int getMaxDogIncapVal() {
        return 256;
    }

    @Override
    public int getDogIncapValue() {
        return (Integer)this.f_19804_.m_135370_(INCAP_VAL);
    }

    @Override
    public void setDogIncapValue(int val) {
        val = Mth.m_14045_((int)val, (int)0, (int)this.getMaxDogIncapVal());
        this.f_19804_.m_135381_(INCAP_VAL, (Object)val);
    }

    @Override
    public float getMaxHunger() {
        float maxHunger = 120.0f;
        for (IDogAlteration alter : this.alterations) {
            InteractionResultHolder<Float> result = alter.getMaxHunger(this, maxHunger);
            if (!result.m_19089_().m_19080_()) continue;
            maxHunger = ((Float)result.m_19095_()).floatValue();
        }
        return maxHunger;
    }

    @Override
    public float getDogHunger() {
        return ((Float)this.f_19804_.m_135370_(HUNGER_INT)).floatValue();
    }

    @Override
    public void addHunger(float add) {
        float h0 = this.getDogHunger();
        float h1 = h0 + add;
        int h2 = (int)(h1 - this.getMaxHunger());
        if (h2 > 0) {
            this.hungerSaturation = Math.max(this.hungerSaturation, h2);
        }
        this.setDogHunger(h0 + add);
    }

    @Override
    public void setDogHunger(float hunger) {
        float diff = hunger - this.getDogHunger();
        for (IDogAlteration alter : this.alterations) {
            InteractionResultHolder<Float> result = alter.setDogHunger(this, hunger, diff);
            if (!result.m_19089_().m_19080_()) continue;
            hunger = ((Float)result.m_19095_()).floatValue();
            diff = hunger - this.getDogHunger();
        }
        this.setHungerDirectly(Mth.m_14036_((float)hunger, (float)0.0f, (float)this.getMaxHunger()));
    }

    private void setHungerDirectly(float hunger) {
        this.f_19804_.m_135381_(HUNGER_INT, (Object)Float.valueOf(hunger));
        this.updateLowHunger();
    }

    public void m_5634_(float add) {
        if (add <= 0.0f) {
            return;
        }
        float add1 = ForgeEventFactory.onLivingHeal((LivingEntity)this, (float)add);
        add = Math.max(add1, add);
        float h = this.m_21223_();
        if (h > 0.0f) {
            this.m_21153_(h + add);
        }
    }

    public void m_6710_(@Nullable LivingEntity target) {
        LivingEntity oldTarget = this.m_5448_();
        super.m_6710_(target);
        LivingEntity newTarget = this.m_5448_();
        if (oldTarget != newTarget) {
            for (IDogAlteration alt : this.alterations) {
                alt.onDogSetTarget(this, newTarget, oldTarget);
            }
        }
    }

    public boolean hasCustomSkin() {
        return !Strings.isNullOrEmpty((String)this.getSkinData().getHash());
    }

    public DogSkinData getSkinData() {
        return (DogSkinData)this.f_19804_.m_135370_(CUSTOM_SKIN.get());
    }

    public void setDogSkinData(DogSkinData data) {
        if (data == null) {
            data = DogSkinData.NULL;
        }
        this.f_19804_.m_135381_(CUSTOM_SKIN.get(), (Object)data);
    }

    @Override
    public DogLevel getDogLevel() {
        return (DogLevel)this.f_19804_.m_135370_(DOG_LEVEL.get());
    }

    public void setLevel(DogLevel level) {
        this.f_19804_.m_135381_(DOG_LEVEL.get(), (Object)level);
    }

    public DogIncapacitatedMananger.IncapacitatedSyncState getIncapSyncState() {
        return (DogIncapacitatedMananger.IncapacitatedSyncState)this.f_19804_.m_135370_(DOG_INCAP_SYNC_STATE.get());
    }

    public void setIncapSyncState(DogIncapacitatedMananger.IncapacitatedSyncState state) {
        this.f_19804_.m_135381_(DOG_INCAP_SYNC_STATE.get(), (Object)state);
    }

    @Override
    public void increaseLevel(DogLevel.Type typeIn) {
        DogLevel copy = this.getDogLevel().copy();
        copy.incrementLevel(typeIn);
        this.setLevel(copy);
    }

    @Override
    public void setDogSize(DogSize size) {
        this.f_19804_.m_135381_(DOG_SIZE.get(), (Object)size);
    }

    @Override
    public DogSize getDogSize() {
        return (DogSize)((Object)this.f_19804_.m_135370_(DOG_SIZE.get()));
    }

    public boolean m_6162_() {
        if (this.getDogSize() == DogSize.PPP) {
            return true;
        }
        return super.m_6162_();
    }

    public void setBoneVariant(ItemStack stack) {
        this.f_19804_.m_135381_(BONE_VARIANT, (Object)stack);
    }

    public ItemStack getBoneVariant() {
        return (ItemStack)this.f_19804_.m_135370_(BONE_VARIANT);
    }

    @Nullable
    public IThrowableItem getThrowableItem() {
        Item item = ((ItemStack)this.f_19804_.m_135370_(BONE_VARIANT)).m_41720_();
        return item instanceof IThrowableItem ? (IThrowableItem)item : null;
    }

    public boolean hasBone() {
        return !this.getBoneVariant().m_41619_();
    }

    private boolean getDogFlag(int bit) {
        return ((Integer)this.f_19804_.m_135370_(DOG_FLAGS) & bit) != 0;
    }

    private void setDogFlag(int bits, boolean flag) {
        int c = (Integer)this.f_19804_.m_135370_(DOG_FLAGS);
        this.f_19804_.m_135381_(DOG_FLAGS, (Object)(flag ? c | bits : c & ~bits));
    }

    public void setBegging(boolean begging) {
        this.setDogFlag(1, begging);
    }

    public boolean isBegging() {
        return this.getDogFlag(1);
    }

    public void setWillObeyOthers(boolean obeyOthers) {
        this.setDogFlag(2, obeyOthers);
    }

    public boolean willObeyOthers() {
        return this.getDogFlag(2);
    }

    public void setCanPlayersAttack(boolean flag) {
        this.setDogFlag(4, flag);
    }

    public boolean canOwnerAttack() {
        return this.getDogFlag(4);
    }

    public void setForceSit(boolean val) {
        this.setDogFlag(8, val);
    }

    public boolean forceSit() {
        return this.getDogFlag(8);
    }

    public LowHealthStrategy getLowHealthStrategy() {
        int msb = this.getDogFlag(32) ? 1 : 0;
        int lsb = this.getDogFlag(16) ? 1 : 0;
        return LowHealthStrategy.fromId(msb * 2 + lsb);
    }

    public void setLowHealthStrategy(LowHealthStrategy strategy) {
        byte id = strategy.getId();
        boolean lsb = (id & 1) == 1;
        boolean msb = (id >> 1 & 1) == 1;
        this.setDogFlag(32, msb);
        this.setDogFlag(16, lsb);
    }

    public CombatReturnStrategy getCombatReturnStrategy() {
        int msb = this.getDogFlag(8192) ? 1 : 0;
        int lsb = this.getDogFlag(4096) ? 1 : 0;
        return CombatReturnStrategy.fromId(msb * 2 + lsb);
    }

    public void setCombatReturnStrategy(CombatReturnStrategy strategy) {
        byte id = strategy.getId();
        boolean lsb = (id & 1) == 1;
        boolean msb = (id >> 1 & 1) == 1;
        this.setDogFlag(8192, msb);
        this.setDogFlag(4096, lsb);
    }

    public void setRegardTeamPlayers(boolean val) {
        this.setDogFlag(128, val);
    }

    public boolean regardTeamPlayers() {
        return this.getDogFlag(128);
    }

    public boolean crossOriginTp() {
        return this.getDogFlag(64);
    }

    public void setCrossOriginTp(boolean val) {
        this.setDogFlag(64, val);
    }

    public RestingState getDogRestingState() {
        boolean isResting = this.getDogFlag(32768);
        if (!isResting) {
            return RestingState.NONE;
        }
        boolean bellyUp = this.getDogFlag(65536);
        return bellyUp ? RestingState.BELLY : RestingState.LYING;
    }

    public void setDogRestingState(RestingState val) {
        if (val == null) {
            val = RestingState.NONE;
        }
        switch (val) {
            default: {
                this.setDogFlag(32768, false);
                this.setDogFlag(65536, false);
                break;
            }
            case LYING: {
                this.setDogFlag(32768, true);
                this.setDogFlag(65536, false);
                break;
            }
            case BELLY: {
                this.setDogFlag(32768, true);
                this.setDogFlag(65536, true);
            }
        }
    }

    public boolean isDogResting() {
        return this.getDogRestingState() != RestingState.NONE;
    }

    public boolean patrolTargetLock() {
        return this.getDogFlag(512);
    }

    public boolean isInDrunkPose() {
        return this.getDogFlag(131072);
    }

    public void setInDrunkPose(boolean val) {
        this.setDogFlag(131072, val);
    }

    public void setDrunkTicks(int ticks) {
        this.drunkTickLeft = ticks;
    }

    public boolean isDogDrunk() {
        return this.drunkTickLeft > 0;
    }

    public void setPatrolTargetLock(boolean val) {
        this.setDogFlag(512, val);
    }

    public boolean hideArmor() {
        return this.getDogFlag(2048);
    }

    public void setHideArmor(boolean val) {
        this.setDogFlag(2048, val);
    }

    public boolean dogAutoMount() {
        return this.getDogFlag(16384);
    }

    public void setDogAutoMount(boolean val) {
        this.setDogFlag(16384, val);
    }

    public boolean wantsToRest() {
        return this.tickUntilRest <= 0 && this.m_217043_().m_188501_() < 0.02f;
    }

    public void resetTickTillRest() {
        this.tickUntilRest = 600 + this.m_217043_().m_188503_(271) * 20;
    }

    public List<TalentInstance> getTalentMap() {
        return this.dogSyncedDataManager.talents();
    }

    public InteractionResult setTalentLevel(Talent talent, int level) {
        if (0 > level || level > talent.getMaxLevel()) {
            return InteractionResult.FAIL;
        }
        List<TalentInstance> activeTalents = this.getTalentMap();
        TalentInstance inst = null;
        int selected_id = -1;
        for (int i = 0; i < activeTalents.size(); ++i) {
            TalentInstance activeInst = activeTalents.get(i);
            if (!activeInst.of(talent)) continue;
            inst = activeInst;
            selected_id = i;
            break;
        }
        if (inst == null) {
            if (level == 0) {
                return InteractionResult.PASS;
            }
            TalentInstance newTalent = talent.getDefault(level);
            this.dogSyncedDataManager.talents().add(newTalent);
        } else {
            int remove_id;
            int previousLevel = inst.level();
            if (previousLevel == level) {
                return InteractionResult.PASS;
            }
            inst.setLevel(level);
            inst.set(this, previousLevel);
            if (level <= 0 && (remove_id = selected_id) >= 0) {
                this.dogSyncedDataManager.talents().remove(remove_id);
            }
        }
        this.dogSyncedDataManager.setTalentsDirty();
        return InteractionResult.SUCCESS;
    }

    public List<DoggyArtifactItem> getArtifactsList() {
        List array = (List)this.f_19804_.m_135370_(ARTIFACTS.get());
        return array;
    }

    public boolean addArtifact(DoggyArtifactItem artifact) {
        if (artifact == null) {
            return false;
        }
        List<DoggyArtifactItem> array = this.getArtifactsList();
        if (array.size() >= 3) {
            return false;
        }
        if (array.contains((Object)artifact)) {
            return false;
        }
        this.modifyArtifact(artifacts -> artifacts.add(artifact));
        return true;
    }

    public ItemStack removeArtifact(int indx) {
        List<DoggyArtifactItem> array = this.getArtifactsList();
        if (indx < 0 || indx >= array.size()) {
            return null;
        }
        DoggyArtifactItem removedArtifact = array.get(indx);
        this.modifyArtifact(artifacts -> artifacts.remove(indx));
        return new ItemStack((ItemLike)removedArtifact);
    }

    public void modifyArtifact(Consumer<List<DoggyArtifactItem>> modify) {
        this.modifyListSyncedData(ARTIFACTS.get(), modify);
    }

    public <T> void modifyListSyncedData(EntityDataAccessor<List<T>> key, Consumer<List<T>> modify) {
        this.modifySyncedData(key, modify, x -> new ArrayList(x));
    }

    public <T> void modifySyncedData(EntityDataAccessor<T> key, Consumer<T> modify, Function<T, T> copyFunc) {
        Object result = copyFunc.apply(this.f_19804_.m_135370_(key));
        modify.accept(result);
        this.f_19804_.m_135381_(key, result);
    }

    @Override
    public Optional<TalentInstance> getTalent(Talent talentIn) {
        List<TalentInstance> activeTalents = this.getTalentMap();
        for (TalentInstance activeInst : activeTalents) {
            if (!activeInst.of(talentIn)) continue;
            return Optional.of(activeInst);
        }
        return Optional.empty();
    }

    @Override
    public int getDogLevel(Talent talentIn) {
        return this.getTalent(talentIn).map(TalentInstance::level).orElse(0);
    }

    @Override
    public <T> void setData(DataKey<T> key, T value) {
        if (key.isFinal() && this.hasData(key)) {
            throw new RuntimeException("Key is final but was tried to be set again.");
        }
        this.objects.put(key.getIndex(), value);
    }

    @Override
    public <T> void setDataIfEmpty(DataKey<T> key, T value) {
        if (!this.hasData(key)) {
            this.objects.put(key.getIndex(), value);
        }
    }

    @Override
    public <T> T getData(DataKey<T> key) {
        return (T)this.objects.get(key.getIndex());
    }

    @Override
    public <T> T getDataOrGet(DataKey<T> key, Supplier<T> other) {
        if (this.hasData(key)) {
            return this.getData(key);
        }
        return other.get();
    }

    @Override
    public <T> T getDataOrDefault(DataKey<T> key, T other) {
        if (this.hasData(key)) {
            return this.getData(key);
        }
        return other;
    }

    @Override
    public <T> boolean hasData(DataKey<T> key) {
        return this.objects.containsKey(key.getIndex());
    }

    public void untame() {
        this.f_21344_.m_26573_();
        this.clearTriggerableAction();
        this.f_21345_.m_25386_().map(goal -> {
            goal.m_8041_();
            return goal;
        });
        this.m_21839_(false);
        this.m_21153_(8.0f);
        this.setDogCustomName(null);
        this.dogSyncedDataManager.talents().clear();
        this.dogSyncedDataManager.setTalentsDirty();
        this.m_7105_(false);
        this.m_21816_(null);
        this.setWillObeyOthers(false);
        this.setCanPlayersAttack(true);
        this.setMode(EnumMode.DOCILE);
    }

    public void migrateOwner(UUID newOwnerUUID) {
        this.f_21344_.m_26573_();
        this.clearTriggerableAction();
        this.f_21345_.m_25386_().forEach(goal -> goal.m_8041_());
        this.setMode(EnumMode.DOCILE);
        this.authorizedChangingOwner = true;
        this.m_21816_(newOwnerUUID);
        this.authorizedChangingOwner = false;
    }

    public boolean canSpendPoints(int amount) {
        return this.getSpendablePoints() >= amount || this.getAccessory((Accessory)DoggyAccessories.GOLDEN_COLLAR.get()).isPresent();
    }

    private final int getSpendablePointsInternal() {
        int totalPoints = 15 + this.getDogLevel().getLevel(DogLevel.Type.NORMAL) + this.getDogLevel().getLevel(DogLevel.Type.KAMI);
        for (TalentInstance entry : this.getTalentMap()) {
            totalPoints -= entry.getTalent().getCummulativeCost(entry.level());
        }
        return totalPoints;
    }

    public int getSpendablePoints() {
        return this.spendablePoints.get();
    }

    public boolean canRiderInteract() {
        return true;
    }

    public LivingEntity m_6688_() {
        List passengers = this.m_20197_();
        if (passengers.isEmpty()) {
            return null;
        }
        Entity first_passenger = (Entity)passengers.get(0);
        if (!(first_passenger instanceof Player)) {
            return null;
        }
        Player player = (Player)first_passenger;
        return this.canInteract((LivingEntity)player) ? player : null;
    }

    public Vec3 m_7688_(LivingEntity passenger) {
        float a1 = this.m_146908_();
        float dx1 = -Mth.m_14031_((float)(a1 * ((float)Math.PI / 180)));
        float dz1 = Mth.m_14089_((float)(a1 * ((float)Math.PI / 180)));
        double newX = this.m_20185_() + (double)dx1;
        double newZ = this.m_20189_() + (double)dz1;
        Vec3 newPos = new Vec3(newX, this.m_20186_() + 0.5, newZ);
        BlockPos b0 = BlockPos.m_274446_((Position)newPos);
        BlockPathTypes type = WalkNodeEvaluator.m_77604_((BlockGetter)this.m_9236_(), (BlockPos.MutableBlockPos)b0.m_122032_());
        if (type == BlockPathTypes.WALKABLE) {
            return newPos;
        }
        return super.m_7688_(passenger);
    }

    public boolean m_6087_() {
        if (this.m_9236_().f_46443_ && ClientEventHandler.shouldClientBlockPick(this)) {
            return false;
        }
        return super.m_6087_();
    }

    public boolean m_6094_() {
        return (!this.m_20160_() || !this.m_217005_()) && super.m_6094_();
    }

    public boolean isDogJumping() {
        return this.dogJumping;
    }

    public void setDogJumping(boolean jumping) {
        this.dogJumping = jumping;
    }

    public void setJumpPower(int jumpPowerIn) {
        this.jumpPower = 1.0f;
    }

    public boolean canJump() {
        return true;
    }

    public void m_7023_(Vec3 positionIn) {
        super.m_7023_(positionIn);
        if (this.isDogFlying()) {
            Vec3 moveVec = this.m_20184_();
            double down = moveVec.f_82480_;
            double gravity = -0.112102;
            AttributeInstance attrib = this.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
            if (attrib != null) {
                gravity = -attrib.m_22135_();
            }
            down = down < 0.0 ? Math.min(down * 0.7, gravity) : (down *= 0.7);
            this.m_20334_(moveVec.f_82479_ * 0.67, down, moveVec.f_82481_ * 0.67);
        }
        this.addMovementStat(this.m_20185_() - this.f_19854_, this.m_20186_() - this.f_19855_, this.m_20189_() - this.f_19856_);
    }

    protected float m_274460_() {
        return this.isDogFlying() ? 0.49f : super.m_274460_();
    }

    public boolean canDogFly() {
        return this.alterationProps.canFly();
    }

    protected void m_274498_(Player rider, Vec3 rideVec) {
        if (this.isDefeated()) {
            return;
        }
        this.m_146922_(rider.m_146908_());
        this.f_19859_ = this.m_146908_();
        this.m_146926_(rider.m_146909_() * 0.5f);
        this.m_19915_(this.m_146908_(), this.m_146909_());
        this.f_20885_ = this.f_20883_ = this.m_146908_();
        this.checkAndJumpWhenBeingRidden((LivingEntity)rider);
        if (this.m_6147_()) {
            this.f_19789_ = 0.0f;
        }
        this.addMovementStat(this.m_20185_() - this.f_19854_, this.m_20186_() - this.f_19855_, this.m_20189_() - this.f_19856_);
    }

    protected BodyRotationControl m_7560_() {
        return new DogBodyRotationControl(this);
    }

    private void checkAndJumpWhenBeingRidden(LivingEntity rider) {
        float forward = rider.f_20902_;
        if (this.jumpPower > 0.0f) {
            if (this.m_20069_() && this.canSwimUnderwater()) {
                this.doDogRideFloat();
            } else if (!this.isDogJumping() && this.m_20096_()) {
                this.doDogRideJump(forward);
            }
        }
        if (this.m_20096_()) {
            this.jumpPower = 0.0f;
            this.setDogJumping(false);
        } else {
            this.jumpPower = 0.0f;
        }
    }

    protected Vec3 m_274312_(Player rider, Vec3 rideVec) {
        float straf = rider.f_20900_ * 0.7f;
        float forward = rider.f_20902_;
        double downward = rideVec.f_82480_;
        if (forward > 0.0f && !this.isDogRidingConstraintToGround()) {
            float l = forward;
            downward = -l * Mth.m_14031_((float)(rider.m_146909_() * ((float)Math.PI / 180)));
            forward = l * Mth.m_14089_((float)(rider.m_146909_() * ((float)Math.PI / 180)));
        }
        if (forward <= 0.0f) {
            forward *= 0.5f;
        }
        return new Vec3((double)straf, downward, (double)forward);
    }

    protected boolean isDogRidingConstraintToGround() {
        if (this.m_20069_() && this.canSwimUnderwater()) {
            return false;
        }
        return !this.canDogFly();
    }

    protected float m_245547_(Player rider) {
        return (float)this.m_21051_(Attributes.f_22279_).m_22135_() * 0.5f;
    }

    private void doDogRideFloat() {
        Vec3 vec3d = this.m_20184_();
        this.m_20334_(vec3d.f_82479_, 0.1, vec3d.f_82481_);
        this.jumpPower = 0.0f;
    }

    private void doDogRideJump(double forward) {
        double jumpValue = this.m_21051_((Attribute)DoggyAttributes.JUMP_POWER.get()).m_22135_() * (double)this.m_20098_() * (double)this.jumpPower;
        if (this.m_21023_(MobEffects.f_19603_)) {
            jumpValue += (double)((float)(this.m_21124_(MobEffects.f_19603_).m_19564_() + 1) * 0.1f);
        }
        Vec3 vec3d = this.m_20184_();
        this.m_20334_(vec3d.f_82479_, jumpValue, vec3d.f_82481_);
        this.setDogJumping(true);
        this.f_19812_ = true;
        if (forward > 0.0) {
            float amount = 0.4f;
            float compX = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            float compZ = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            this.m_20256_(this.m_20184_().m_82520_((double)(-0.4f * compX * this.jumpPower), 0.0, (double)(0.4f * compZ * this.jumpPower)));
        }
        this.jumpPower = 0.0f;
    }

    public void addMovementStat(double xD, double yD, double zD) {
        int j;
        if (this.m_20160_()) {
            j = Math.round(Mth.m_14116_((float)((float)(xD * xD + zD * zD))) * 100.0f);
            this.statsTracker.increaseDistanceRidden(j);
        }
        if (!this.m_20159_()) {
            if (this.m_204029_(FluidTags.f_13131_)) {
                j = Math.round(Mth.m_14116_((float)((float)(xD * xD + yD * yD + zD * zD))) * 100.0f);
                if (j > 0) {
                    this.statsTracker.increaseDistanceOnWater(j);
                }
            } else if (this.m_20069_()) {
                int k = Math.round(Mth.m_14116_((float)((float)(xD * xD + zD * zD))) * 100.0f);
                if (k > 0) {
                    this.statsTracker.increaseDistanceInWater(k);
                }
            } else if (this.m_20096_()) {
                int l = Math.round(Mth.m_14116_((float)((float)(xD * xD + zD * zD))) * 100.0f);
                if (l > 0) {
                    if (this.m_20142_()) {
                        this.statsTracker.increaseDistanceSprint(l);
                    } else if (this.m_6047_()) {
                        this.statsTracker.increaseDistanceSneaking(l);
                    } else {
                        this.statsTracker.increaseDistanceWalk(l);
                    }
                }
            } else {
                int n = Math.round(Mth.m_14116_((float)((float)(xD * xD + zD * zD))) * 100.0f);
            }
        }
    }

    public boolean isPushedByFluid(FluidType type) {
        for (IDogAlteration alter : this.alterations) {
            InteractionResult result = alter.canResistPushFromFluidType(type);
            if (!result.m_19080_()) continue;
            return false;
        }
        return super.isPushedByFluid(type);
    }

    public MutableComponent getTranslationKey(Function<EnumGender, String> function) {
        return Component.m_237115_((String)((String)function.apply((Object)((Boolean)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.DISABLE_GENDER) == false ? this.getGender() : EnumGender.UNISEX))));
    }

    @Override
    public boolean isLying() {
        boolean ownerSleeping;
        LivingEntity owner = this.m_269323_();
        boolean bl = ownerSleeping = owner != null && owner.m_5803_();
        if (ownerSleeping) {
            return true;
        }
        if (this.isDefeated()) {
            boolean onBed;
            BlockState blockBelow = this.m_9236_().m_8055_(this.m_20183_());
            boolean bl2 = onBed = blockBelow.m_60713_((Block)DoggyBlocks.DOG_BED.get()) || blockBelow.m_204336_(BlockTags.f_13038_);
            if (onBed) {
                return true;
            }
        }
        return false;
    }

    public void m_21837_(boolean sit) {
        if (!(this.m_9236_().f_46443_ || this.animAction != null && this.animAction.blockSitStandAnim())) {
            boolean sit0 = this.m_21825_();
            if (sit0 != sit) {
                DogAnimation anim;
                DogAnimation dogAnimation = anim = sit ? this.getSitAnim() : this.getStandAnim();
                if (!sit0 && this.isLying()) {
                    anim = DogAnimation.NONE;
                }
                if (anim != DogAnimation.NONE) {
                    this.setAnim(anim);
                }
            }
            this.sitAnim = DogAnimation.SIT_DOWN;
            this.standAnim = DogAnimation.STAND_QUICK;
        }
        super.m_21837_(sit);
    }

    public void setSitAnim(DogAnimation anim) {
        if (anim == null) {
            this.sitAnim = DogAnimation.SIT_DOWN;
            return;
        }
        this.sitAnim = anim;
    }

    public DogAnimation getStandAnim() {
        return this.standAnim;
    }

    public void setStandAnim(DogAnimation anim) {
        if (anim == null) {
            this.standAnim = DogAnimation.STAND_QUICK;
            return;
        }
        this.standAnim = anim;
    }

    public DogAnimation getSitAnim() {
        return this.sitAnim;
    }

    public void setChopinTailFor(int ticks) {
        this.tickChopinTail = ticks;
    }

    public boolean isChopinTail() {
        return this.tickChopinTail > 0;
    }

    @Override
    public List<IDogFoodHandler> getFoodHandlers() {
        return this.foodHandlers;
    }

    @Override
    public void resetNavigation() {
        this.setNavigation(this.defaultNavigation);
    }

    @Override
    public void resetMoveControl() {
        this.setMoveControl(this.defaultMoveControl);
    }

    @Override
    public void setNavigation(PathNavigation p) {
        super.setNavigation(p);
        this.switchNavCooldown = 5;
        this.currentNavigation = p;
        if (p instanceof IDogNavLock) {
            IDogNavLock lock;
            this.navigationLock = lock = (IDogNavLock)p;
        }
    }

    @Override
    public PathNavigation getDefaultNavigation() {
        return this.defaultNavigation;
    }

    @Override
    public MoveControl getDefaultMoveControl() {
        return this.defaultMoveControl;
    }

    protected PathNavigation m_6037_(Level p_21480_) {
        DogPathNavigation dogPathNav = new DogPathNavigation(this, p_21480_);
        this.currentNavigation = dogPathNav;
        this.navigationLock = dogPathNav;
        this.navigationLock.lockDogNavigation();
        return dogPathNav;
    }

    public float m_21439_(BlockPathTypes type) {
        switch (type) {
            default: {
                break;
            }
            case WATER: 
            case WATER_BORDER: {
                if (!this.shouldDogOmitWaterPathWeight()) break;
                return 0.0f;
            }
            case LAVA: 
            case DAMAGE_FIRE: 
            case DANGER_FIRE: {
                if (!this.m_5825_()) break;
                return 0.0f;
            }
            case DOOR_WOOD_CLOSED: {
                if (!this.canDogPassGate()) break;
                return 8.0f;
            }
        }
        return super.m_21439_(type);
    }

    private boolean shouldDogOmitWaterPathWeight() {
        if (this.isDogFollowingSomeone()) {
            return true;
        }
        if (!this.m_20069_()) {
            return false;
        }
        if (this.m_6040_()) {
            return true;
        }
        return this.canSwimUnderwater() && !this.isLowAirSupply();
    }

    public boolean shouldDogBlockFloat() {
        return this.m_5825_() && this.m_20077_();
    }

    public boolean isDogFollowingSomeone() {
        return this.isDogFollowingSomeone;
    }

    public void setDogFollowingSomeone(boolean val) {
        this.isDogFollowingSomeone = val;
    }

    public List<IDogAlteration> getAlterations() {
        return this.alterations;
    }

    @Override
    public boolean canSwimUnderwater() {
        return this.alterationProps.canSwimUnderwater();
    }

    @Override
    public boolean canDogWearArmor() {
        return this.alterationProps.canWearArmor();
    }

    @Override
    public boolean canDogUseTools() {
        return this.alterationProps.canUseTools();
    }

    @Override
    public DogArmorItemHandler dogArmors() {
        return this.dogArmors;
    }

    public Iterable<ItemStack> m_6167_() {
        if (!this.canDogUseTools() || this.mouthStack == null) {
            return List.of();
        }
        return List.of(this.mouthStack);
    }

    public Iterable<ItemStack> m_6168_() {
        if (!this.canDogWearArmor()) {
            return List.of();
        }
        return this.dogArmors.armors();
    }

    public ItemStack m_6844_(EquipmentSlot slot) {
        boolean getMouth;
        boolean getArmor;
        EquipmentSlot.Type type = slot.m_20743_();
        boolean bl = getArmor = type == EquipmentSlot.Type.ARMOR && (this.alterationProps.canWearArmor() || this.m_9236_().f_46443_);
        if (getArmor) {
            return this.dogArmors.getArmorFromSlot(slot);
        }
        boolean bl2 = getMouth = slot == EquipmentSlot.MAINHAND && (this.alterationProps.canUseTools() || this.m_9236_().f_46443_) && this.mouthStack != null;
        if (getMouth) {
            return this.mouthStack;
        }
        return ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot slot, ItemStack stack) {
        this.m_181122_(stack);
        if (this.trySetDogArmorSlot(slot, stack)) {
            return;
        }
        if (this.trySetDogToolSlot(slot, stack)) {
            return;
        }
    }

    private boolean trySetDogArmorSlot(EquipmentSlot slot, ItemStack stack) {
        if (slot.m_20743_() != EquipmentSlot.Type.ARMOR) {
            return false;
        }
        if (!this.m_9236_().f_46443_ && !this.canDogWearArmor()) {
            return false;
        }
        ItemStack oldStack = this.dogArmors.getArmorFromSlot(slot);
        this.dogArmors.setArmorInSlot(stack, slot);
        this.m_238392_(slot, oldStack, stack);
        return true;
    }

    private boolean trySetDogToolSlot(EquipmentSlot slot, ItemStack stack) {
        if (slot != EquipmentSlot.MAINHAND) {
            return false;
        }
        if (!this.m_9236_().f_46443_ && !this.canDogUseTools()) {
            return false;
        }
        ItemStack oldStack = this.mouthStack == null ? ItemStack.f_41583_ : this.mouthStack;
        this.mouthStack = stack;
        this.m_238392_(slot, oldStack, stack);
        return true;
    }

    public void m_238392_(EquipmentSlot slot, ItemStack oldStack, ItemStack newStack) {
        if (slot.m_20743_() != EquipmentSlot.Type.ARMOR) {
            return;
        }
        super.m_238392_(slot, oldStack, newStack);
    }

    public boolean m_7066_(ItemStack stack) {
        return this.canDogWearArmor() && stack.m_41720_() instanceof ArmorItem;
    }

    protected void m_6668_(DamageSource source) {
        this.m_5907_();
    }

    public boolean isLowAirSupply() {
        return (double)this.m_20146_() < (double)this.m_6062_() * 0.3;
    }

    @Override
    public boolean isDogLowHealth() {
        return this.m_21223_() < 6.0f;
    }

    @Override
    public void setDogSwimming(boolean s) {
        this.isDogSwimming = s;
    }

    public boolean isDogSwimming() {
        return this.isDogSwimming;
    }

    public boolean isDogCurious() {
        return this.isDogCurious;
    }

    public void setDogCurious(boolean val) {
        this.isDogCurious = val;
    }

    @Override
    public void setDogFlying(boolean s) {
        this.setDogFlag(1024, s);
    }

    @Override
    public boolean isDogFlying() {
        return this.getDogFlag(1024);
    }

    private void hungerHighToLow() {
        if (!this.isDefeated()) {
            this.setAttributeModifier(Attributes.f_22279_, HUNGER_MOVEMENT, (d, u) -> new AttributeModifier(u, "Hunger Slowness", (double)-0.35f, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
    }

    private void hungerLowToHigh() {
        this.removeAttributeModifier(Attributes.f_22279_, HUNGER_MOVEMENT);
    }

    public boolean isLowHunger() {
        return this.isLowHunger;
    }

    public void updateLowHunger() {
        if (this.isLowHunger) {
            if (this.getDogHunger() > 10.0f) {
                this.isLowHunger = false;
                this.hungerLowToHigh();
            }
        } else if (this.getDogHunger() <= 10.0f) {
            this.isLowHunger = true;
            this.hungerHighToLow();
        }
        this.isZeroHunger = this.getDogHunger() == 0.0f;
    }

    protected void handleZeroHunger() {
        ++this.hungerDamageTick;
        int hurt_interval = -1;
        boolean hurt_last_health = false;
        switch (this.m_9236_().m_46791_()) {
            case EASY: {
                hurt_interval = 125;
                break;
            }
            case NORMAL: {
                hurt_interval = 100;
                break;
            }
            case HARD: {
                hurt_interval = 75;
                hurt_last_health = true;
                break;
            }
            default: {
                hurt_interval = -1;
            }
        }
        if (hurt_interval >= 0 && ++this.hungerDamageTick >= hurt_interval && (hurt_last_health || this.m_21223_() > 1.0f)) {
            this.m_6469_(this.m_269291_().m_269064_(), 0.5f);
            this.hungerDamageTick = 0;
        }
    }

    protected void m_8022_() {
        boolean incapBlockedMove = this.isDefeated() && !this.incapacitatedMananger.canMove();
        boolean animBlockedMove = this.animAction != null && this.animAction.blockMove();
        boolean animBlockedLook = this.animAction != null && this.animAction.blockLook();
        boolean notControlledByPlayer = !(this.m_6688_() instanceof ServerPlayer);
        boolean notRidingBoat = !(this.m_20202_() instanceof Boat);
        this.f_21345_.m_25360_(Goal.Flag.MOVE, notControlledByPlayer && !incapBlockedMove && !animBlockedMove);
        this.f_21345_.m_25360_(Goal.Flag.JUMP, notControlledByPlayer && notRidingBoat);
        this.f_21345_.m_25360_(Goal.Flag.LOOK, notControlledByPlayer && !animBlockedLook);
    }

    protected void m_7324_(Entity pushTarget) {
        if (this.shouldBlockPush(pushTarget)) {
            return;
        }
        if (pushTarget.m_20202_() == this || this.m_20202_() == pushTarget) {
            return;
        }
        if (this.m_20160_() && !this.m_217005_()) {
            this.Entity_push(pushTarget);
        } else {
            super.m_7324_(pushTarget);
        }
    }

    protected boolean shouldBlockPush(Entity target) {
        boolean avoidPush = (Boolean)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.PREVENT_DOGS_PUSHING_EACH_OTHER);
        if (!avoidPush) {
            return false;
        }
        if (!(target instanceof Dog)) {
            return false;
        }
        Dog otherDog = (Dog)target;
        if (otherDog.isDogFlying() && this.isDogFlying()) {
            return false;
        }
        boolean oneDogStillNotOnGround = !this.m_20096_() || !otherDog.m_20096_();
        return oneDogStillNotOnGround;
    }

    public void m_7334_(Entity source) {
        if (source.m_20202_() == this || this.m_20202_() == source) {
            return;
        }
        if (this.m_20160_() && !this.m_217005_()) {
            this.Entity_push(source);
        } else {
            if (this.isDogCurious()) {
                this.setDogCurious(false);
            }
            super.m_7334_(source);
        }
    }

    private void Entity_push(Entity source) {
        double dz_vec;
        if (this.m_20365_(source)) {
            return;
        }
        if (source.f_19794_ || this.f_19794_) {
            return;
        }
        double dx_vec = source.m_20185_() - this.m_20185_();
        double max_magnitude = Mth.m_14005_((double)dx_vec, (double)(dz_vec = source.m_20189_() - this.m_20189_()));
        if (max_magnitude < 0.01) {
            return;
        }
        max_magnitude = Math.sqrt(max_magnitude);
        dx_vec /= max_magnitude;
        dz_vec /= max_magnitude;
        double max_magnitude_inv = 1.0 / max_magnitude;
        if (max_magnitude_inv > 1.0) {
            max_magnitude_inv = 1.0;
        }
        dx_vec *= max_magnitude_inv;
        dz_vec *= max_magnitude_inv;
        dx_vec *= 0.05;
        dz_vec *= 0.05;
        if (this.m_6094_()) {
            this.m_5997_(-dx_vec, 0.0, -dz_vec);
        }
        if (source.m_6094_()) {
            source.m_5997_(dx_vec, 0.0, dz_vec);
        }
    }

    public boolean m_7337_(Entity otherEntity) {
        if (this.shouldBlockPush(otherEntity)) {
            return false;
        }
        if (otherEntity.m_20202_() == this || this.m_20202_() == otherEntity) {
            return false;
        }
        return super.m_7337_(otherEntity);
    }

    public BlockPathTypes getBlockPathTypeViaAlterations(BlockPos pos) {
        BlockPathTypes blockType = WalkNodeEvaluator.m_77604_((BlockGetter)this.m_9236_(), (BlockPos.MutableBlockPos)pos.m_122032_());
        for (IDogAlteration alt : this.alterations) {
            InteractionResultHolder<BlockPathTypes> result = alt.inferType(this, blockType);
            if (!result.m_19089_().m_19080_()) continue;
            blockType = (BlockPathTypes)result.m_19095_();
            break;
        }
        return blockType;
    }

    public boolean canDogPassGate() {
        for (IDogAlteration alt : this.alterations) {
            if (!alt.canDogPassGate(this).m_19080_()) continue;
            return true;
        }
        return false;
    }

    public float getTimeDogIsShaking() {
        return this.timeWolfIsShaking;
    }

    public float getUrgentSpeedModifier() {
        if (this.m_21133_(Attributes.f_22279_) <= 0.3) {
            return 1.5f;
        }
        return 1.0f;
    }

    public StatsTracker getStatTracker() {
        return this.statsTracker;
    }

    public DogGroupsManager getGroups() {
        return this.dogGroupsManager;
    }

    public boolean isMiningCautious() {
        return this.dogMiningCautiousManager.isMiningCautious();
    }

    public void setAnim(DogAnimation animation) {
        this.f_19804_.m_135381_(ANIMATION, (Object)animation.getId());
    }

    public DogAnimation getAnim() {
        return DogAnimation.byId((Integer)this.f_19804_.m_135370_(ANIMATION));
    }

    public void setAnimSyncTime(int val) {
        this.f_19804_.m_135381_(ANIM_SYNC_TIME, (Object)val);
    }

    public int getAnimSyncTime() {
        return (Integer)this.f_19804_.m_135370_(ANIM_SYNC_TIME);
    }

    public void triggerAnimationAction(AnimationAction action) {
        if (this.animAction != null) {
            this.animAction.stop();
        }
        this.animAction = action;
        if (this.animAction != null) {
            this.m_21573_().m_26573_();
            this.m_8022_();
            if (this.animAction.blockMove()) {
                this.forceStopAllGoalWithFlag(Goal.Flag.MOVE);
            }
            if (this.animAction.blockLook()) {
                this.forceStopAllGoalWithFlag(Goal.Flag.LOOK);
            }
            this.animAction.start();
        }
    }

    private void forceStopAllGoalWithFlag(Goal.Flag flag) {
        this.f_21345_.m_25386_().filter(goal -> goal.m_7684_().contains(flag)).map(goal -> {
            goal.m_8041_();
            return goal;
        });
    }

    protected void tickAnimAction() {
        if (this.animAction == null) {
            return;
        }
        switch (this.animAction.getState()) {
            case FINISHED: {
                this.triggerAnimationAction(null);
                break;
            }
            default: {
                this.animAction.tick();
            }
        }
    }

    public DogPose getDogPose() {
        return this.activePose;
    }

    private void setDogPose(DogPose pose) {
        this.activePose = pose;
    }

    public void updateDogPose() {
        if (this.isDefeated() && !this.incapacitatedMananger.canMove()) {
            this.setDogPose(this.incapacitatedMananger.getPose());
            return;
        }
        if (this.isInDrunkPose()) {
            this.setDogPose(DogPose.REST_BELLY);
            return;
        }
        if (this.m_21825_()) {
            RestingState restState = this.getDogRestingState();
            if (restState == RestingState.LYING) {
                this.setDogPose(DogPose.REST);
                return;
            }
            if (restState == RestingState.BELLY) {
                this.setDogPose(DogPose.REST_BELLY);
                return;
            }
            this.setDogPose(this.isLying() ? DogPose.LYING_2 : DogPose.SIT);
            return;
        }
        if (this.isDogFlying()) {
            this.setDogPose(DogPose.FLYING);
            return;
        }
        this.setDogPose(DogPose.STAND);
    }

    @Override
    public float getClientAnimatedYBodyRotInRadians() {
        if (!this.m_9236_().f_46443_) {
            return this.f_20883_ * ((float)Math.PI / 180);
        }
        return this.f_20883_ * ((float)Math.PI / 180) + ClientEventHandler.getAnimatedYRot(this);
    }

    public DogSkin getClientSkin() {
        return this.clientSkin;
    }

    public void setClientSkin(DogSkin skin) {
        this.clientSkin = skin == null ? DogSkin.CLASSICAL : skin;
    }

    public List<AccessoryInstance> getClientSortedAccessories() {
        return this.clientAccessories;
    }

    public Optional<ItemStack> getMouthItemForRender() {
        if (this.hasBone()) {
            ItemStack customStack;
            ItemStack renderStack = this.getBoneVariant();
            IThrowableItem throwableItem = this.getThrowableItem();
            if (throwableItem != null && (customStack = throwableItem.getCustomRenderStack(renderStack)) != null) {
                renderStack = customStack;
            }
            return Optional.of(renderStack);
        }
        ItemStack stack = this.m_21205_();
        if (stack != null && !stack.m_41619_()) {
            return Optional.of(stack);
        }
        return Optional.empty();
    }

    public static enum LowHealthStrategy {
        NONE(0),
        RUN_AWAY(1),
        STICK_TO_OWNER(2);

        public static final LowHealthStrategy[] VALUES;
        private final byte id;

        private LowHealthStrategy(int id) {
            this.id = (byte)id;
        }

        public byte getId() {
            return this.id;
        }

        public String getUnlocalisedTitle() {
            return "dog.low_health_strategy." + this.getId();
        }

        public String getUnlocalisedInfo() {
            return "dog.low_health_strategy." + this.getId() + ".help";
        }

        public static LowHealthStrategy fromId(int id) {
            if (0 > id || id > 2) {
                return NONE;
            }
            return VALUES[id];
        }

        public LowHealthStrategy prev() {
            int i = this.getId() - 1;
            if (i < 0) {
                i = VALUES.length - 1;
            }
            return VALUES[i];
        }

        public LowHealthStrategy next() {
            int i = this.getId() + 1;
            if (i >= VALUES.length) {
                i = 0;
            }
            return VALUES[i];
        }

        static {
            VALUES = (LowHealthStrategy[])Arrays.stream(LowHealthStrategy.values()).sorted(Comparator.comparingInt(LowHealthStrategy::getId)).toArray(LowHealthStrategy[]::new);
        }
    }

    public static enum CombatReturnStrategy {
        STANDARD(0),
        FAR(1),
        NONE(2);

        public static final CombatReturnStrategy[] VALUES;
        private final byte id;

        private CombatReturnStrategy(int id) {
            this.id = (byte)id;
        }

        public byte getId() {
            return this.id;
        }

        public String getUnlocalisedTitle() {
            return "dog.combat_return_strategy." + this.getId();
        }

        public String getUnlocalisedInfo() {
            return "dog.combat_return_strategy." + this.getId() + ".help";
        }

        public static CombatReturnStrategy fromId(int id) {
            if (0 > id || id > 2) {
                return NONE;
            }
            return VALUES[id];
        }

        public CombatReturnStrategy prev() {
            int i = this.getId() - 1;
            if (i < 0) {
                i = VALUES.length - 1;
            }
            return VALUES[i];
        }

        public CombatReturnStrategy next() {
            int i = this.getId() + 1;
            if (i >= VALUES.length) {
                i = 0;
            }
            return VALUES[i];
        }

        static {
            VALUES = (CombatReturnStrategy[])Arrays.stream(CombatReturnStrategy.values()).sorted(Comparator.comparingInt(CombatReturnStrategy::getId)).toArray(CombatReturnStrategy[]::new);
        }
    }

    public static enum RestingState {
        NONE,
        LYING,
        BELLY;

    }
}

