/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.item;

import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Accessory;
import doggytalents.api.registry.AccessoryInstance;
import doggytalents.common.item.AccessoryItem;
import doggytalents.common.item.IDyeableArmorItem;
import doggytalents.common.util.Util;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class DyableBirthdayHatItem
extends AccessoryItem
implements IDyeableArmorItem {
    private Supplier<? extends Accessory> type;

    public DyableBirthdayHatItem(Supplier<? extends Accessory> type, Item.Properties properties) {
        super(type, properties);
        this.type = type;
    }

    @Override
    public AccessoryInstance createInstance(AbstractDog dogIn, ItemStack stack, Player playerIn) {
        return this.type.get().createFromStack(stack);
    }

    public int getForegroundColor(ItemStack stack) {
        int color = this.getDefaultColor(stack);
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return color;
        }
        if (!tag.m_128425_("dtn_bdhat_foreground", 99)) {
            return color;
        }
        return tag.m_128451_("dtn_bdhat_foreground");
    }

    public void setForegroundColor(ItemStack stack, int color) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("dtn_bdhat_foreground", color);
    }

    public void m_41123_(ItemStack stack) {
        IDyeableArmorItem.super.m_41123_(stack);
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return;
        }
        if (tag.m_128425_("dtn_bdhat_foreground", 99)) {
            tag.m_128473_("dtn_bdhat_foreground");
        }
    }

    public static ItemStack dyeForegroundColorStack(ItemStack stack, List<DyeColor> dye) {
        ItemStack newStack = stack.m_255036_(1);
        Item item = stack.m_41720_();
        if (!(item instanceof DyableBirthdayHatItem)) {
            return ItemStack.f_41583_;
        }
        DyableBirthdayHatItem birthdayHat = (DyableBirthdayHatItem)item;
        int color = Util.colorDye(-1, dye);
        birthdayHat.setForegroundColor(newStack, color);
        return newStack;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag flags) {
        String desc_id = this.m_5671_(stack) + ".description";
        components.add((Component)Component.m_237115_((String)desc_id).m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(true))));
    }
}

