/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.DoggyTalents;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.entity.Dog;
import doggytalents.common.network.packet.DogPacket;
import doggytalents.common.network.packet.data.RescueDogRenderData;
import doggytalents.common.talent.RescueDogTalent;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class RescueDogRenderPacket
extends DogPacket<RescueDogRenderData> {
    @Override
    public void encode(RescueDogRenderData data, FriendlyByteBuf buf) {
        super.encode(data, buf);
        buf.writeBoolean(data.val);
    }

    @Override
    public RescueDogRenderData decode(FriendlyByteBuf buf) {
        int entityId = buf.readInt();
        boolean val = buf.readBoolean();
        return new RescueDogRenderData(entityId, val);
    }

    @Override
    public void handleDog(Dog dogIn, RescueDogRenderData data, Supplier<NetworkEvent.Context> ctx) {
        Optional talentInstOptional = dogIn.getTalent((Supplier)DoggyTalents.RESCUE_DOG);
        if (!talentInstOptional.isPresent()) {
            return;
        }
        TalentInstance talentInst = (TalentInstance)talentInstOptional.get();
        if (!(talentInst instanceof RescueDogTalent)) {
            return;
        }
        RescueDogTalent rescue = (RescueDogTalent)talentInst;
        rescue.updateFromPacket(data);
        dogIn.dogSyncedDataManager.markTalentNeedRefresh(rescue);
    }
}

