/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import java.util.List;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import net.xalcon.torchmaster.TorchmasterConfig;
import net.xalcon.torchmaster.common.EntityFilterRegistry;
import net.xalcon.torchmaster.common.ModBlocks;
import net.xalcon.torchmaster.common.ModItems;
import net.xalcon.torchmaster.common.commands.CommandTorchmaster;
import net.xalcon.torchmaster.common.items.TMItemBlock;
import net.xalcon.torchmaster.compat.VanillaCompat;
import org.slf4j.Logger;

@Mod(value="torchmaster")
public class Torchmaster {
    public static final String MODID = "torchmaster";
    public static final Logger Log = LogUtils.getLogger();
    public static MinecraftServer server;
    public static final EntityFilterRegistry MegaTorchFilterRegistry;
    public static final EntityFilterRegistry DreadLampFilterRegistry;
    private static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS;
    public static final RegistryObject<CreativeModeTab> CreativeTab;

    public Torchmaster() {
        ModBlocks.init();
        ModItems.init();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::doClientStuff);
        modEventBus.addListener(EventPriority.LOWEST, this::postInit);
        CREATIVE_MODE_TABS.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)TorchmasterConfig.spec, "torchmaster.toml");
    }

    private void postInit(FMLLoadCompleteEvent event) {
        VanillaCompat.registerTorchEntities(MegaTorchFilterRegistry);
        VanillaCompat.registerDreadLampEntities(DreadLampFilterRegistry);
        Log.info("Applying mega torch entity block list overrides...");
        MegaTorchFilterRegistry.applyListOverrides(((List)TorchmasterConfig.GENERAL.megaTorchEntityBlockListOverrides.get()).toArray(new String[0]));
        Log.info("Applying dread lamp entity block list overrides...");
        DreadLampFilterRegistry.applyListOverrides(((List)TorchmasterConfig.GENERAL.dreadLampEntityBlockListOverrides.get()).toArray(new String[0]));
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.blockDreadLamp.get()), (RenderType)RenderType.m_110463_());
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        CommandTorchmaster.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onServerStarted(ServerStartedEvent event) {
        server = event.getServer();
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppedEvent event) {
        server = null;
    }

    static {
        MegaTorchFilterRegistry = new EntityFilterRegistry();
        DreadLampFilterRegistry = new EntityFilterRegistry();
        CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)MODID);
        CreativeTab = CREATIVE_MODE_TABS.register("creative_tab", () -> CreativeModeTab.builder().m_257737_(() -> ((TMItemBlock)((Object)((Object)((Object)ModBlocks.itemMegaTorch.get())))).m_7968_()).m_257501_((parameters, output) -> {
            output.m_246342_(new ItemStack((ItemLike)ModBlocks.itemMegaTorch.get()));
            output.m_246342_(new ItemStack((ItemLike)ModBlocks.itemDreadLamp.get()));
            output.m_246342_(new ItemStack((ItemLike)ModBlocks.itemFeralFlareLantern.get()));
            output.m_246342_(new ItemStack((ItemLike)ModItems.itemFrozenPearl.get()));
        }).m_257941_((Component)Component.m_237113_((String)"Torchmaster")).m_257652_());
    }
}

