/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.customizableelytra;

import com.hidoni.customizableelytra.Constants;
import com.hidoni.customizableelytra.ElytraUtils;
import com.hidoni.customizableelytra.customization.CustomizationUtils;
import com.hidoni.customizableelytra.customization.ElytraCustomization;
import com.hidoni.customizableelytra.item.CustomizableElytraItem;
import com.hidoni.customizableelytra.mixin.ItemPropertiesInvoker;
import com.hidoni.customizableelytra.platform.Services;
import com.hidoni.customizableelytra.registry.ModItems;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.core.Holder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.level.ItemLike;

public class CustomizableElytraClient {
    public static void init() {
        ItemPropertiesInvoker.invokeRegisterGeneric(Constants.ELYTRA_LEFT_WING_TRIM_TYPE_PREDICATE, CustomizableElytraClient.getWingTrimPropertyFunction(false));
        ItemPropertiesInvoker.invokeRegisterGeneric(Constants.ELYTRA_RIGHT_WING_TRIM_TYPE_PREDICATE, CustomizableElytraClient.getWingTrimPropertyFunction(true));
        Services.EVENT.registerItemColorEventHandler(itemColors -> {
            itemColors.register((stack, index) -> index == 0 ? ((CustomizableElytraItem)stack.m_41720_()).m_41121_(stack) : -1, (ItemLike)ModItems.ELYTRA_WING.get());
            itemColors.register((stack, index) -> {
                ElytraCustomization customization = CustomizationUtils.getElytraCustomization(stack);
                ItemStack leftWing = customization.leftWing();
                if (index == 0) {
                    return ((CustomizableElytraItem)leftWing.m_41720_()).m_41121_(leftWing);
                }
                if (index == 1) {
                    ItemStack rightWing = customization.rightWing();
                    return ((CustomizableElytraItem)rightWing.m_41720_()).m_41121_(rightWing);
                }
                return -1;
            }, new ItemLike[]{Items.f_42741_});
        });
    }

    public static ClampedItemPropertyFunction getWingTrimPropertyFunction(boolean rightWing) {
        return (itemStack, clientLevel, livingEntity, i) -> {
            if (!ElytraUtils.isElytra(itemStack)) {
                return Float.NEGATIVE_INFINITY;
            }
            if (clientLevel == null) {
                return 0.0f;
            }
            ElytraCustomization customization = CustomizationUtils.getElytraCustomization(itemStack);
            ItemStack wingStack = rightWing ? customization.rightWing() : customization.leftWing();
            return ((CustomizableElytraItem)wingStack.m_41720_()).getArmorTrim(wingStack, clientLevel.m_9598_()).map(ArmorTrim::m_266210_).map(Holder::m_203334_).map(TrimMaterial::f_265933_).orElse(Float.valueOf(0.0f)).floatValue();
        };
    }
}

