/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline.newshader;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import net.coderbot.iris.block_rendering.BlockMaterialMapping;
import net.coderbot.iris.block_rendering.BlockRenderingSettings;
import net.coderbot.iris.colorspace.ColorSpace;
import net.coderbot.iris.colorspace.ColorSpaceConverter;
import net.coderbot.iris.colorspace.ColorSpaceFragmentConverter;
import net.coderbot.iris.features.FeatureFlags;
import net.coderbot.iris.gbuffer_overrides.matching.InputAvailability;
import net.coderbot.iris.gbuffer_overrides.matching.SpecialCondition;
import net.coderbot.iris.gbuffer_overrides.state.RenderTargetStateListener;
import net.coderbot.iris.gl.GlResource;
import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.gl.blending.AlphaTest;
import net.coderbot.iris.gl.blending.BlendModeOverride;
import net.coderbot.iris.gl.buffer.ShaderStorageBufferHolder;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.gl.image.GlImage;
import net.coderbot.iris.gl.image.ImageHolder;
import net.coderbot.iris.gl.program.ComputeProgram;
import net.coderbot.iris.gl.program.ProgramBuilder;
import net.coderbot.iris.gl.program.ProgramImages;
import net.coderbot.iris.gl.program.ProgramSamplers;
import net.coderbot.iris.gl.sampler.SamplerHolder;
import net.coderbot.iris.gl.sampler.SamplerLimits;
import net.coderbot.iris.gl.shader.ShaderCompileException;
import net.coderbot.iris.gl.texture.DepthBufferFormat;
import net.coderbot.iris.gl.texture.TextureAccess;
import net.coderbot.iris.gl.texture.TextureType;
import net.coderbot.iris.gui.option.IrisVideoSettings;
import net.coderbot.iris.helpers.Tri;
import net.coderbot.iris.mixin.GlStateManagerAccessor;
import net.coderbot.iris.mixin.LevelRendererAccessor;
import net.coderbot.iris.pipeline.ClearPass;
import net.coderbot.iris.pipeline.ClearPassCreator;
import net.coderbot.iris.pipeline.CustomTextureManager;
import net.coderbot.iris.pipeline.HorizonRenderer;
import net.coderbot.iris.pipeline.ShaderPrinter;
import net.coderbot.iris.pipeline.ShadowRenderer;
import net.coderbot.iris.pipeline.SodiumTerrainPipeline;
import net.coderbot.iris.pipeline.WorldRenderingPhase;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.pipeline.newshader.CoreWorldRenderingPipeline;
import net.coderbot.iris.pipeline.newshader.ExtendedShader;
import net.coderbot.iris.pipeline.newshader.FakeChainedJsonException;
import net.coderbot.iris.pipeline.newshader.FogMode;
import net.coderbot.iris.pipeline.newshader.NewShaderTests;
import net.coderbot.iris.pipeline.newshader.ShaderAttributeInputs;
import net.coderbot.iris.pipeline.newshader.ShaderKey;
import net.coderbot.iris.pipeline.newshader.ShaderMap;
import net.coderbot.iris.pipeline.newshader.fallback.FallbackShader;
import net.coderbot.iris.pipeline.transform.PatchShaderType;
import net.coderbot.iris.pipeline.transform.TransformPatcher;
import net.coderbot.iris.postprocess.BufferFlipper;
import net.coderbot.iris.postprocess.CenterDepthSampler;
import net.coderbot.iris.postprocess.CompositeRenderer;
import net.coderbot.iris.postprocess.FinalPassRenderer;
import net.coderbot.iris.rendertarget.Blaze3dRenderTargetExt;
import net.coderbot.iris.rendertarget.NativeImageBackedSingleColorTexture;
import net.coderbot.iris.rendertarget.RenderTargets;
import net.coderbot.iris.samplers.IrisImages;
import net.coderbot.iris.samplers.IrisSamplers;
import net.coderbot.iris.shaderpack.CloudSetting;
import net.coderbot.iris.shaderpack.ComputeSource;
import net.coderbot.iris.shaderpack.ImageInformation;
import net.coderbot.iris.shaderpack.OptionalBoolean;
import net.coderbot.iris.shaderpack.PackDirectives;
import net.coderbot.iris.shaderpack.PackShadowDirectives;
import net.coderbot.iris.shaderpack.ParticleRenderingSettings;
import net.coderbot.iris.shaderpack.ProgramFallbackResolver;
import net.coderbot.iris.shaderpack.ProgramSet;
import net.coderbot.iris.shaderpack.ProgramSource;
import net.coderbot.iris.shaderpack.ShaderPack;
import net.coderbot.iris.shaderpack.loading.ProgramId;
import net.coderbot.iris.shaderpack.texture.TextureStage;
import net.coderbot.iris.shadows.ShadowCompositeRenderer;
import net.coderbot.iris.shadows.ShadowRenderTargets;
import net.coderbot.iris.texture.TextureInfoCache;
import net.coderbot.iris.texture.format.TextureFormat;
import net.coderbot.iris.texture.format.TextureFormatLoader;
import net.coderbot.iris.texture.pbr.PBRTextureHolder;
import net.coderbot.iris.texture.pbr.PBRTextureManager;
import net.coderbot.iris.texture.pbr.PBRType;
import net.coderbot.iris.uniforms.CapturedRenderingState;
import net.coderbot.iris.uniforms.CommonUniforms;
import net.coderbot.iris.uniforms.FrameUpdateNotifier;
import net.coderbot.iris.uniforms.custom.CustomUniforms;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_276;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_5294;
import net.minecraft.class_5944;
import net.minecraft.class_757;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector4f;
import org.lwjgl.opengl.ARBClearTexture;

public class NewWorldRenderingPipeline
implements WorldRenderingPipeline,
CoreWorldRenderingPipeline,
RenderTargetStateListener {
    private final RenderTargets renderTargets;
    private final ShaderMap shaderMap;
    private final CustomUniforms customUniforms;
    private final ShadowCompositeRenderer shadowCompositeRenderer;
    private final Object2ObjectMap<Tri<String, TextureType, TextureStage>, String> customTextureMap;
    private final ComputeProgram[] setup;
    private final boolean separateHardwareSamplers;
    private ShaderStorageBufferHolder shaderStorageBufferHolder;
    private final ProgramFallbackResolver resolver;
    private ShadowRenderTargets shadowRenderTargets;
    private final Supplier<ShadowRenderTargets> shadowTargetsSupplier;
    private WorldRenderingPhase overridePhase = null;
    private WorldRenderingPhase phase = WorldRenderingPhase.NONE;
    private final Set<class_5944> loadedShaders;
    private ImmutableList<ClearPass> clearPassesFull;
    private ImmutableList<ClearPass> clearPasses;
    private ImmutableList<ClearPass> shadowClearPasses;
    private ImmutableList<ClearPass> shadowClearPassesFull;
    private final GlFramebuffer baseline;
    private final CompositeRenderer beginRenderer;
    private final CompositeRenderer prepareRenderer;
    private final CompositeRenderer deferredRenderer;
    private final CompositeRenderer compositeRenderer;
    private final FinalPassRenderer finalPassRenderer;
    private final CustomTextureManager customTextureManager;
    private final class_1043 whitePixel;
    private final FrameUpdateNotifier updateNotifier;
    private final CenterDepthSampler centerDepthSampler;
    private final SodiumTerrainPipeline sodiumTerrainPipeline;
    private final ColorSpaceConverter colorSpaceConverter;
    private final ImmutableSet<Integer> flippedBeforeShadow;
    private final ImmutableSet<Integer> flippedAfterPrepare;
    private final ImmutableSet<Integer> flippedAfterTranslucent;
    public boolean isBeforeTranslucent;
    private final HorizonRenderer horizonRenderer = new HorizonRenderer();
    @Nullable
    private ComputeProgram[] shadowComputes;
    private final float sunPathRotation;
    private final boolean shouldRenderUnderwaterOverlay;
    private final boolean shouldRenderVignette;
    private final boolean shouldWriteRainAndSnowToDepthBuffer;
    private final boolean oldLighting;
    private final OptionalInt forcedShadowRenderDistanceChunks;
    private boolean destroyed = false;
    private boolean isRenderingWorld;
    private boolean isMainBound;
    private boolean frustumCulling;
    private final CloudSetting cloudSetting;
    private final boolean shouldRenderSun;
    private final boolean shouldRenderMoon;
    private final boolean allowConcurrentCompute;
    @Nullable
    private final ShadowRenderer shadowRenderer;
    private final int shadowMapResolution;
    private boolean shouldBindPBR;
    private int currentNormalTexture;
    private int currentSpecularTexture;
    private ParticleRenderingSettings particleRenderingSettings;
    private PackDirectives packDirectives;
    private Set<GlImage> customImages;
    private GlImage[] clearImages;
    private final ShaderPack pack;
    private PackShadowDirectives shadowDirectives;
    private ColorSpace currentColorSpace;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NewWorldRenderingPipeline(ProgramSet programSet) throws IOException {
        ShaderPrinter.resetPrintState();
        this.shouldRenderUnderwaterOverlay = programSet.getPackDirectives().underwaterOverlay();
        this.shouldRenderVignette = programSet.getPackDirectives().vignette();
        this.shouldWriteRainAndSnowToDepthBuffer = programSet.getPackDirectives().rainDepth();
        this.oldLighting = programSet.getPackDirectives().isOldLighting();
        this.updateNotifier = new FrameUpdateNotifier();
        this.packDirectives = programSet.getPackDirectives();
        this.customTextureMap = programSet.getPackDirectives().getTextureMap();
        this.separateHardwareSamplers = programSet.getPack().hasFeature(FeatureFlags.SEPARATE_HARDWARE_SAMPLERS);
        this.shadowDirectives = this.packDirectives.getShadowDirectives();
        this.cloudSetting = programSet.getPackDirectives().getCloudSetting();
        this.shouldRenderSun = programSet.getPackDirectives().shouldRenderSun();
        this.shouldRenderMoon = programSet.getPackDirectives().shouldRenderMoon();
        this.allowConcurrentCompute = programSet.getPackDirectives().getConcurrentCompute();
        this.frustumCulling = programSet.getPackDirectives().shouldUseFrustumCulling();
        this.resolver = new ProgramFallbackResolver(programSet);
        this.pack = programSet.getPack();
        class_276 class_2762 = class_310.method_1551().method_1522();
        int n2 = class_2762.method_30278();
        int n3 = TextureInfoCache.INSTANCE.getInfo(n2).getInternalFormat();
        DepthBufferFormat depthBufferFormat = DepthBufferFormat.fromGlEnumOrDefault(n3);
        this.customImages = new HashSet<GlImage>();
        for (ImageInformation imageInformation : programSet.getPack().getIrisCustomImages()) {
            if (imageInformation.isRelative()) {
                this.customImages.add(new GlImage.Relative(imageInformation.name(), imageInformation.samplerName(), imageInformation.format(), imageInformation.internalTextureFormat(), imageInformation.type(), imageInformation.clear(), imageInformation.relativeWidth(), imageInformation.relativeHeight(), class_2762.field_1482, class_2762.field_1481));
                continue;
            }
            this.customImages.add(new GlImage(imageInformation.name(), imageInformation.samplerName(), imageInformation.target(), imageInformation.format(), imageInformation.internalTextureFormat(), imageInformation.type(), imageInformation.clear(), imageInformation.width(), imageInformation.height(), imageInformation.depth()));
        }
        this.clearImages = (GlImage[])this.customImages.stream().filter(GlImage::shouldClear).toArray(GlImage[]::new);
        this.particleRenderingSettings = programSet.getPackDirectives().getParticleRenderingSettings().orElseGet(() -> {
            if (programSet.getDeferred().length > 0 && !programSet.getPackDirectives().shouldUseSeparateEntityDraws()) {
                return ParticleRenderingSettings.AFTER;
            }
            return ParticleRenderingSettings.MIXED;
        });
        this.renderTargets = new RenderTargets(class_2762.field_1482, class_2762.field_1481, n2, ((Blaze3dRenderTargetExt)class_2762).iris$getDepthBufferVersion(), depthBufferFormat, programSet.getPackDirectives().getRenderTargetDirectives().getRenderTargetSettings(), programSet.getPackDirectives());
        this.sunPathRotation = programSet.getPackDirectives().getSunPathRotation();
        PackShadowDirectives packShadowDirectives = programSet.getPackDirectives().getShadowDirectives();
        this.forcedShadowRenderDistanceChunks = packShadowDirectives.isDistanceRenderMulExplicit() ? ((double)packShadowDirectives.getDistanceRenderMul() >= 0.0 ? OptionalInt.of(((int)(packShadowDirectives.getDistance() * packShadowDirectives.getDistanceRenderMul()) + 15) / 16) : OptionalInt.of(-1)) : OptionalInt.empty();
        this.customUniforms = programSet.getPack().customUniforms.build(uniformHolder -> CommonUniforms.addNonDynamicUniforms(uniformHolder, programSet.getPack().getIdMap(), programSet.getPackDirectives(), this.updateNotifier));
        GlStateManager._activeTexture((int)33986);
        this.customTextureManager = new CustomTextureManager(programSet.getPackDirectives(), programSet.getPack().getCustomTextureDataMap(), programSet.getPack().getIrisCustomTextureDataMap(), programSet.getPack().getCustomNoiseTexture());
        this.whitePixel = new NativeImageBackedSingleColorTexture(255, 255, 255, 255);
        GlStateManager._activeTexture((int)33984);
        BufferFlipper bufferFlipper = new BufferFlipper();
        this.centerDepthSampler = new CenterDepthSampler(() -> this.renderTargets.getDepthTexture(), programSet.getPackDirectives().getCenterDepthHalfLife());
        this.shadowMapResolution = programSet.getPackDirectives().getShadowDirectives().getResolution();
        this.shadowTargetsSupplier = () -> {
            if (this.shadowRenderTargets == null) {
                this.shadowRenderTargets = new ShadowRenderTargets(this, this.shadowMapResolution, packShadowDirectives);
            }
            return this.shadowRenderTargets;
        };
        if (!programSet.getPackDirectives().getBufferObjects().isEmpty()) {
            if (!IrisRenderSystem.supportsSSBO()) throw new IllegalStateException("Shader storage buffers/immutable buffer storage is not supported on this graphics card, however the shaderpack requested them? This shouldn't be possible.");
            this.shaderStorageBufferHolder = new ShaderStorageBufferHolder(programSet.getPackDirectives().getBufferObjects(), class_2762.field_1482, class_2762.field_1481);
            this.shaderStorageBufferHolder.setupBuffers();
        } else {
            for (int i = 0; i < Math.min(16, SamplerLimits.get().getMaxShaderStorageUnits()); ++i) {
                IrisRenderSystem.bindBufferBase(37074, i, 0);
            }
        }
        this.shadowComputes = this.createShadowComputes(programSet.getShadowCompute(), programSet);
        this.beginRenderer = new CompositeRenderer(this, programSet.getPackDirectives(), programSet.getBegin(), programSet.getBeginCompute(), this.renderTargets, this.customTextureManager.getNoiseTexture(), this.updateNotifier, this.centerDepthSampler, bufferFlipper, this.shadowTargetsSupplier, TextureStage.BEGIN, this.customTextureManager.getCustomTextureIdMap().getOrDefault((Object)TextureStage.BEGIN, (Object2ObjectMap<String, TextureAccess>)Object2ObjectMaps.emptyMap()), this.customTextureManager.getIrisCustomTextures(), this.customImages, programSet.getPackDirectives().getExplicitFlips("begin_pre"), this.customUniforms);
        this.flippedBeforeShadow = bufferFlipper.snapshot();
        this.prepareRenderer = new CompositeRenderer(this, programSet.getPackDirectives(), programSet.getPrepare(), programSet.getPrepareCompute(), this.renderTargets, this.customTextureManager.getNoiseTexture(), this.updateNotifier, this.centerDepthSampler, bufferFlipper, this.shadowTargetsSupplier, TextureStage.PREPARE, this.customTextureManager.getCustomTextureIdMap().getOrDefault((Object)TextureStage.PREPARE, (Object2ObjectMap<String, TextureAccess>)Object2ObjectMaps.emptyMap()), this.customTextureManager.getIrisCustomTextures(), this.customImages, programSet.getPackDirectives().getExplicitFlips("prepare_pre"), this.customUniforms);
        this.flippedAfterPrepare = bufferFlipper.snapshot();
        this.deferredRenderer = new CompositeRenderer(this, programSet.getPackDirectives(), programSet.getDeferred(), programSet.getDeferredCompute(), this.renderTargets, this.customTextureManager.getNoiseTexture(), this.updateNotifier, this.centerDepthSampler, bufferFlipper, this.shadowTargetsSupplier, TextureStage.DEFERRED, this.customTextureManager.getCustomTextureIdMap().getOrDefault((Object)TextureStage.DEFERRED, (Object2ObjectMap<String, TextureAccess>)Object2ObjectMaps.emptyMap()), this.customTextureManager.getIrisCustomTextures(), this.customImages, programSet.getPackDirectives().getExplicitFlips("deferred_pre"), this.customUniforms);
        this.flippedAfterTranslucent = bufferFlipper.snapshot();
        this.compositeRenderer = new CompositeRenderer(this, programSet.getPackDirectives(), programSet.getComposite(), programSet.getCompositeCompute(), this.renderTargets, this.customTextureManager.getNoiseTexture(), this.updateNotifier, this.centerDepthSampler, bufferFlipper, this.shadowTargetsSupplier, TextureStage.COMPOSITE_AND_FINAL, this.customTextureManager.getCustomTextureIdMap().getOrDefault((Object)TextureStage.COMPOSITE_AND_FINAL, (Object2ObjectMap<String, TextureAccess>)Object2ObjectMaps.emptyMap()), this.customTextureManager.getIrisCustomTextures(), this.customImages, programSet.getPackDirectives().getExplicitFlips("composite_pre"), this.customUniforms);
        this.finalPassRenderer = new FinalPassRenderer(this, programSet, this.renderTargets, this.customTextureManager.getNoiseTexture(), this.updateNotifier, bufferFlipper.snapshot(), this.centerDepthSampler, this.shadowTargetsSupplier, this.customTextureManager.getCustomTextureIdMap().getOrDefault((Object)TextureStage.COMPOSITE_AND_FINAL, (Object2ObjectMap<String, TextureAccess>)Object2ObjectMaps.emptyMap()), this.customTextureManager.getIrisCustomTextures(), this.customImages, this.compositeRenderer.getFlippedAtLeastOnceFinal(), this.customUniforms);
        Supplier<ImmutableSet> supplier = () -> this.isBeforeTranslucent ? this.flippedAfterPrepare : this.flippedAfterTranslucent;
        IntFunction<ProgramSamplers> intFunction = n -> {
            ProgramSamplers.Builder builder = ProgramSamplers.builder(n, IrisSamplers.WORLD_RESERVED_TEXTURE_UNITS);
            ProgramSamplers.CustomTextureSamplerInterceptor customTextureSamplerInterceptor = ProgramSamplers.customTextureSamplerInterceptor(builder, this.customTextureManager.getCustomTextureIdMap().getOrDefault((Object)TextureStage.GBUFFERS_AND_SHADOW, (Object2ObjectMap<String, TextureAccess>)Object2ObjectMaps.emptyMap()));
            IrisSamplers.addRenderTargetSamplers(customTextureSamplerInterceptor, supplier, this.renderTargets, false);
            IrisSamplers.addCustomTextures(builder, this.customTextureManager.getIrisCustomTextures());
            if (!this.shouldBindPBR) {
                this.shouldBindPBR = IrisSamplers.hasPBRSamplers(customTextureSamplerInterceptor);
            }
            IrisSamplers.addLevelSamplers(customTextureSamplerInterceptor, this, (class_1044)this.whitePixel, new InputAvailability(true, true, false));
            IrisSamplers.addWorldDepthSamplers(customTextureSamplerInterceptor, this.renderTargets);
            IrisSamplers.addNoiseSampler(customTextureSamplerInterceptor, this.customTextureManager.getNoiseTexture());
            IrisSamplers.addCustomImages(customTextureSamplerInterceptor, this.customImages);
            if (IrisSamplers.hasShadowSamplers(customTextureSamplerInterceptor)) {
                IrisSamplers.addShadowSamplers(customTextureSamplerInterceptor, Objects.requireNonNull(this.shadowRenderTargets), null, this.separateHardwareSamplers);
            }
            return builder.build();
        };
        IntFunction<ProgramImages> intFunction2 = n -> {
            ProgramImages.Builder builder = ProgramImages.builder(n);
            IrisImages.addRenderTargetImages(builder, supplier, this.renderTargets);
            IrisImages.addCustomImages(builder, this.customImages);
            if (IrisImages.hasShadowImages(builder)) {
                IrisImages.addShadowColorImages(builder, Objects.requireNonNull(this.shadowRenderTargets), null);
            }
            return builder.build();
        };
        IntFunction<ProgramSamplers> intFunction3 = n -> {
            ProgramSamplers.Builder builder = ProgramSamplers.builder(n, IrisSamplers.WORLD_RESERVED_TEXTURE_UNITS);
            ProgramSamplers.CustomTextureSamplerInterceptor customTextureSamplerInterceptor = ProgramSamplers.customTextureSamplerInterceptor(builder, this.customTextureManager.getCustomTextureIdMap().getOrDefault((Object)TextureStage.GBUFFERS_AND_SHADOW, (Object2ObjectMap<String, TextureAccess>)Object2ObjectMaps.emptyMap()));
            IrisSamplers.addRenderTargetSamplers(customTextureSamplerInterceptor, () -> this.flippedBeforeShadow, this.renderTargets, false);
            IrisSamplers.addCustomTextures(builder, this.customTextureManager.getIrisCustomTextures());
            if (!this.shouldBindPBR) {
                this.shouldBindPBR = IrisSamplers.hasPBRSamplers(customTextureSamplerInterceptor);
            }
            IrisSamplers.addLevelSamplers(customTextureSamplerInterceptor, this, (class_1044)this.whitePixel, new InputAvailability(true, true, false));
            IrisSamplers.addNoiseSampler(customTextureSamplerInterceptor, this.customTextureManager.getNoiseTexture());
            IrisSamplers.addCustomImages(customTextureSamplerInterceptor, this.customImages);
            if (IrisSamplers.hasShadowSamplers(customTextureSamplerInterceptor)) {
                IrisSamplers.addShadowSamplers(customTextureSamplerInterceptor, Objects.requireNonNull(this.shadowRenderTargets), null, this.separateHardwareSamplers);
            }
            return builder.build();
        };
        IntFunction<ProgramImages> intFunction4 = n -> {
            ProgramImages.Builder builder = ProgramImages.builder(n);
            IrisImages.addRenderTargetImages(builder, () -> this.flippedBeforeShadow, this.renderTargets);
            IrisImages.addCustomImages(builder, this.customImages);
            if (IrisImages.hasShadowImages(builder)) {
                IrisImages.addShadowColorImages(builder, Objects.requireNonNull(this.shadowRenderTargets), null);
            }
            return builder.build();
        };
        this.baseline = this.renderTargets.createFramebufferWritingToMain(new int[]{0});
        this.loadedShaders = new HashSet<class_5944>();
        this.shaderMap = new ShaderMap(shaderKey -> {
            try {
                if (shaderKey.isShadow()) {
                    if (this.shadowRenderTargets != null) {
                        return this.createShadowShader(shaderKey.getName(), this.resolver.resolve(shaderKey.getProgram()), (ShaderKey)((Object)shaderKey));
                    }
                    return null;
                }
                return this.createShader(shaderKey.getName(), this.resolver.resolve(shaderKey.getProgram()), (ShaderKey)((Object)shaderKey));
            }
            catch (FakeChainedJsonException fakeChainedJsonException) {
                this.destroyShaders();
                throw fakeChainedJsonException.getTrueException();
            }
            catch (IOException iOException) {
                this.destroyShaders();
                throw new RuntimeException(iOException);
            }
            catch (RuntimeException runtimeException) {
                this.destroyShaders();
                throw runtimeException;
            }
        });
        BlockRenderingSettings.INSTANCE.setBlockStateIds(BlockMaterialMapping.createBlockStateIdMap(programSet.getPack().getIdMap().getBlockProperties()));
        BlockRenderingSettings.INSTANCE.setBlockTypeIds(BlockMaterialMapping.createBlockTypeMap(programSet.getPack().getIdMap().getBlockRenderTypeMap()));
        BlockRenderingSettings.INSTANCE.setEntityIds(programSet.getPack().getIdMap().getEntityIdMap());
        BlockRenderingSettings.INSTANCE.setItemIds(programSet.getPack().getIdMap().getItemIdMap());
        BlockRenderingSettings.INSTANCE.setAmbientOcclusionLevel(programSet.getPackDirectives().getAmbientOcclusionLevel());
        BlockRenderingSettings.INSTANCE.setDisableDirectionalShading(this.shouldDisableDirectionalShading());
        BlockRenderingSettings.INSTANCE.setUseSeparateAo(programSet.getPackDirectives().shouldUseSeparateAo());
        BlockRenderingSettings.INSTANCE.setVoxelizeLightBlocks(programSet.getPackDirectives().shouldVoxelizeLightBlocks());
        BlockRenderingSettings.INSTANCE.setSeparateEntityDraws(programSet.getPackDirectives().shouldUseSeparateEntityDraws());
        BlockRenderingSettings.INSTANCE.setUseExtendedVertexFormat(true);
        if (this.shadowRenderTargets == null && packShadowDirectives.isShadowEnabled() == OptionalBoolean.TRUE) {
            this.shadowRenderTargets = new ShadowRenderTargets(this, this.shadowMapResolution, packShadowDirectives);
        }
        if (this.shadowRenderTargets != null) {
            class_5944 class_59442 = this.shaderMap.getShader(ShaderKey.SHADOW_TERRAIN_CUTOUT);
            boolean bl = false;
            if (class_59442 instanceof ExtendedShader) {
                ExtendedShader extendedShader = (ExtendedShader)class_59442;
                bl = extendedShader.hasActiveImages();
            }
            this.shadowClearPasses = ClearPassCreator.createShadowClearPasses(this.shadowRenderTargets, false, packShadowDirectives);
            this.shadowClearPassesFull = ClearPassCreator.createShadowClearPasses(this.shadowRenderTargets, true, packShadowDirectives);
            this.shadowCompositeRenderer = new ShadowCompositeRenderer(this, programSet.getPackDirectives(), programSet.getShadowComposite(), programSet.getShadowCompCompute(), this.shadowRenderTargets, this.customTextureManager.getNoiseTexture(), this.updateNotifier, this.customTextureManager.getCustomTextureIdMap(TextureStage.SHADOWCOMP), this.customImages, programSet.getPackDirectives().getExplicitFlips("shadowcomp_pre"), this.customTextureManager.getIrisCustomTextures(), this.customUniforms);
            this.shadowRenderer = programSet.getPackDirectives().getShadowDirectives().isShadowEnabled().orElse(true) ? new ShadowRenderer(programSet.getShadow().orElse(null), programSet.getPackDirectives(), this.shadowRenderTargets, this.shadowCompositeRenderer, this.customUniforms, programSet.getPack().hasFeature(FeatureFlags.SEPARATE_HARDWARE_SAMPLERS)) : null;
        } else {
            this.shadowClearPasses = ImmutableList.of();
            this.shadowClearPassesFull = ImmutableList.of();
            this.shadowCompositeRenderer = null;
            this.shadowRenderer = null;
        }
        this.sodiumTerrainPipeline = new SodiumTerrainPipeline(this, programSet, intFunction, this.shadowRenderTargets == null ? null : intFunction3, intFunction2, intFunction4, this.renderTargets, this.flippedAfterPrepare, this.flippedAfterTranslucent, this.shadowRenderTargets != null ? this.shadowRenderTargets.createShadowFramebuffer((ImmutableSet<Integer>)ImmutableSet.of(), programSet.getShadow().filter(programSource -> !programSource.getDirectives().hasUnknownDrawBuffers()).map(programSource -> programSource.getDirectives().getDrawBuffers()).orElse(new int[]{0, 1})) : null, this.customUniforms);
        this.setup = this.createSetupComputes(programSet.getSetup(), programSet, TextureStage.SETUP);
        this.customUniforms.optimise();
        boolean bl = false;
        this.clearPassesFull = ClearPassCreator.createClearPasses(this.renderTargets, true, programSet.getPackDirectives().getRenderTargetDirectives());
        this.clearPasses = ClearPassCreator.createClearPasses(this.renderTargets, false, programSet.getPackDirectives().getRenderTargetDirectives());
        for (ComputeProgram computeProgram : this.setup) {
            if (computeProgram == null) continue;
            if (!bl) {
                bl = true;
                this.renderTargets.onFullClear();
                Vector3d vector3d = CapturedRenderingState.INSTANCE.getFogColor();
                Vector4f vector4f = new Vector4f((float)vector3d.x, (float)vector3d.y, (float)vector3d.z, 1.0f);
                this.clearPassesFull.forEach(clearPass -> clearPass.execute(vector4f));
            }
            computeProgram.use();
            computeProgram.dispatch(1.0f, 1.0f);
        }
        if (bl) {
            ComputeProgram.unbind();
        }
        class Net_coderbot_iris_pipeline_newshader_NewWorldRenderingPipeline$1
        implements ColorSpaceConverter {
            Net_coderbot_iris_pipeline_newshader_NewWorldRenderingPipeline$1() {
            }

            @Override
            public void rebuildProgram(int n, int n2, ColorSpace colorSpace) {
            }

            @Override
            public void process(int n) {
            }
        }
        this.colorSpaceConverter = programSet.getPackDirectives().supportsColorCorrection() ? new Net_coderbot_iris_pipeline_newshader_NewWorldRenderingPipeline$1() : new ColorSpaceFragmentConverter(class_2762.field_1482, class_2762.field_1481, IrisVideoSettings.colorSpace);
        this.currentColorSpace = IrisVideoSettings.colorSpace;
    }

    private ComputeProgram[] createShadowComputes(ComputeSource[] computeSourceArray, ProgramSet programSet) {
        ComputeProgram[] computeProgramArray = new ComputeProgram[computeSourceArray.length];
        for (int i = 0; i < computeProgramArray.length; ++i) {
            ProgramBuilder programBuilder;
            Object object;
            ComputeSource computeSource = computeSourceArray[i];
            if (computeSource == null || !computeSource.getSource().isPresent()) continue;
            try {
                object = TransformPatcher.patchCompute(computeSource.getName(), computeSource.getSource().orElse(null), TextureStage.GBUFFERS_AND_SHADOW, this.customTextureMap);
                ShaderPrinter.printProgram(computeSource.getName()).addSource(PatchShaderType.COMPUTE, (String)object).print();
                programBuilder = ProgramBuilder.beginCompute(computeSource.getName(), (String)object, IrisSamplers.WORLD_RESERVED_TEXTURE_UNITS);
            }
            catch (ShaderCompileException shaderCompileException) {
                throw shaderCompileException;
            }
            catch (RuntimeException runtimeException) {
                throw new RuntimeException("Shader compilation failed for compute " + computeSource.getName() + "!", runtimeException);
            }
            CommonUniforms.addDynamicUniforms(programBuilder, FogMode.OFF);
            this.customUniforms.assignTo(programBuilder);
            object = () -> this.flippedBeforeShadow;
            TextureStage textureStage = TextureStage.GBUFFERS_AND_SHADOW;
            ProgramSamplers.CustomTextureSamplerInterceptor customTextureSamplerInterceptor = ProgramSamplers.customTextureSamplerInterceptor(programBuilder, this.customTextureManager.getCustomTextureIdMap(textureStage));
            IrisSamplers.addRenderTargetSamplers(customTextureSamplerInterceptor, (Supplier<ImmutableSet<Integer>>)object, this.renderTargets, false);
            IrisSamplers.addCustomTextures(programBuilder, this.customTextureManager.getIrisCustomTextures());
            IrisSamplers.addCustomImages(customTextureSamplerInterceptor, this.customImages);
            IrisImages.addRenderTargetImages(programBuilder, (Supplier<ImmutableSet<Integer>>)object, this.renderTargets);
            IrisImages.addCustomImages(programBuilder, this.customImages);
            IrisSamplers.addLevelSamplers(customTextureSamplerInterceptor, this, (class_1044)this.whitePixel, new InputAvailability(true, true, false));
            IrisSamplers.addNoiseSampler(customTextureSamplerInterceptor, this.customTextureManager.getNoiseTexture());
            if (IrisSamplers.hasShadowSamplers(customTextureSamplerInterceptor) && this.shadowRenderTargets != null) {
                IrisSamplers.addShadowSamplers(customTextureSamplerInterceptor, this.shadowRenderTargets, null, this.separateHardwareSamplers);
                IrisImages.addShadowColorImages(programBuilder, this.shadowRenderTargets, null);
            }
            computeProgramArray[i] = programBuilder.buildCompute();
            this.customUniforms.mapholderToPass(programBuilder, computeProgramArray[i]);
            computeProgramArray[i].setWorkGroupInfo(computeSource.getWorkGroupRelative(), computeSource.getWorkGroups());
        }
        return computeProgramArray;
    }

    private ComputeProgram[] createSetupComputes(ComputeSource[] computeSourceArray, ProgramSet programSet, TextureStage textureStage) {
        ComputeProgram[] computeProgramArray = new ComputeProgram[computeSourceArray.length];
        for (int i = 0; i < computeProgramArray.length; ++i) {
            ProgramBuilder programBuilder;
            String string;
            ComputeSource computeSource = computeSourceArray[i];
            if (computeSource == null || !computeSource.getSource().isPresent()) continue;
            try {
                string = TransformPatcher.patchCompute(computeSource.getName(), computeSource.getSource().orElse(null), textureStage, this.customTextureMap);
                ShaderPrinter.printProgram(computeSource.getName()).addSource(PatchShaderType.COMPUTE, string).print();
                programBuilder = ProgramBuilder.beginCompute(computeSource.getName(), string, IrisSamplers.COMPOSITE_RESERVED_TEXTURE_UNITS);
            }
            catch (RuntimeException runtimeException) {
                throw new RuntimeException("Shader compilation failed for setup compute " + computeSource.getName() + "!", runtimeException);
            }
            CommonUniforms.addDynamicUniforms(programBuilder, FogMode.OFF);
            this.customUniforms.assignTo(programBuilder);
            string = ImmutableSet.of();
            Supplier<ImmutableSet<Integer>> supplier = () -> NewWorldRenderingPipeline.lambda$createSetupComputes$17((ImmutableSet)string);
            TextureStage textureStage2 = TextureStage.SETUP;
            ProgramSamplers.CustomTextureSamplerInterceptor customTextureSamplerInterceptor = ProgramSamplers.customTextureSamplerInterceptor(programBuilder, this.customTextureManager.getCustomTextureIdMap(textureStage2));
            IrisSamplers.addRenderTargetSamplers(customTextureSamplerInterceptor, supplier, this.renderTargets, true);
            IrisSamplers.addCustomTextures(programBuilder, this.customTextureManager.getIrisCustomTextures());
            IrisSamplers.addCompositeSamplers(programBuilder, this.renderTargets);
            IrisSamplers.addCustomImages(customTextureSamplerInterceptor, this.customImages);
            IrisImages.addRenderTargetImages(programBuilder, supplier, this.renderTargets);
            IrisImages.addCustomImages(programBuilder, this.customImages);
            IrisSamplers.addNoiseSampler(customTextureSamplerInterceptor, this.customTextureManager.getNoiseTexture());
            if (IrisSamplers.hasShadowSamplers(customTextureSamplerInterceptor) && this.shadowRenderTargets != null) {
                IrisSamplers.addShadowSamplers(customTextureSamplerInterceptor, this.shadowRenderTargets, null, this.separateHardwareSamplers);
                IrisImages.addShadowColorImages(programBuilder, this.shadowRenderTargets, null);
            }
            computeProgramArray[i] = programBuilder.buildCompute();
            this.customUniforms.mapholderToPass(programBuilder, computeProgramArray[i]);
            computeProgramArray[i].setWorkGroupInfo(computeSource.getWorkGroupRelative(), computeSource.getWorkGroups());
        }
        return computeProgramArray;
    }

    private class_5944 createShader(String string, Optional<ProgramSource> optional, ShaderKey shaderKey) throws IOException {
        if (!optional.isPresent()) {
            return this.createFallbackShader(string, shaderKey);
        }
        return this.createShader(string, optional.get(), shaderKey.getProgram(), shaderKey.getAlphaTest(), shaderKey.getVertexFormat(), shaderKey.getFogMode(), shaderKey.isIntensity(), shaderKey.shouldIgnoreLightmap(), shaderKey.isGlint(), shaderKey.isText());
    }

    @Override
    public Object2ObjectMap<Tri<String, TextureType, TextureStage>, String> getTextureMap() {
        return this.customTextureMap;
    }

    private class_5944 createShader(String string, ProgramSource programSource, ProgramId programId, AlphaTest alphaTest, class_293 class_2932, FogMode fogMode, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws IOException {
        GlFramebuffer glFramebuffer = this.renderTargets.createGbufferFramebuffer(this.flippedAfterPrepare, programSource.getDirectives().getDrawBuffers());
        GlFramebuffer glFramebuffer2 = this.renderTargets.createGbufferFramebuffer(this.flippedAfterTranslucent, programSource.getDirectives().getDrawBuffers());
        boolean bl5 = programId == ProgramId.Line && this.resolver.has(ProgramId.Line);
        ShaderAttributeInputs shaderAttributeInputs = new ShaderAttributeInputs(class_2932, bl2, bl5, bl3, bl4);
        Supplier<ImmutableSet<Integer>> supplier = () -> this.isBeforeTranslucent ? this.flippedAfterPrepare : this.flippedAfterTranslucent;
        ExtendedShader extendedShader = NewShaderTests.create(this, string, programSource, programId, glFramebuffer, glFramebuffer2, this.baseline, alphaTest, class_2932, shaderAttributeInputs, this.updateNotifier, this, supplier, fogMode, bl, bl2, false, bl5, this.customUniforms);
        this.loadedShaders.add(extendedShader);
        return extendedShader;
    }

    private class_5944 createFallbackShader(String string, ShaderKey shaderKey) throws IOException {
        GlFramebuffer glFramebuffer = this.renderTargets.createGbufferFramebuffer(this.flippedAfterPrepare, new int[]{0});
        GlFramebuffer glFramebuffer2 = this.renderTargets.createGbufferFramebuffer(this.flippedAfterTranslucent, new int[]{0});
        FallbackShader fallbackShader = NewShaderTests.createFallback(string, glFramebuffer, glFramebuffer2, shaderKey.getAlphaTest(), shaderKey.getVertexFormat(), null, this, shaderKey.getFogMode(), shaderKey == ShaderKey.GLINT, shaderKey.isText(), shaderKey.hasDiffuseLighting(), shaderKey.isIntensity(), shaderKey.shouldIgnoreLightmap());
        this.loadedShaders.add(fallbackShader);
        return fallbackShader;
    }

    private class_5944 createShadowShader(String string, Optional<ProgramSource> optional, ShaderKey shaderKey) throws IOException {
        if (!optional.isPresent()) {
            return this.createFallbackShadowShader(string, shaderKey);
        }
        return this.createShadowShader(string, optional.get(), shaderKey.getProgram(), shaderKey.getAlphaTest(), shaderKey.getVertexFormat(), shaderKey.isIntensity(), shaderKey.shouldIgnoreLightmap(), shaderKey.isText());
    }

    private class_5944 createFallbackShadowShader(String string, ShaderKey shaderKey) throws IOException {
        GlFramebuffer glFramebuffer = this.shadowRenderTargets.createShadowFramebuffer((ImmutableSet<Integer>)ImmutableSet.of(), new int[]{0});
        FallbackShader fallbackShader = NewShaderTests.createFallback(string, glFramebuffer, glFramebuffer, shaderKey.getAlphaTest(), shaderKey.getVertexFormat(), BlendModeOverride.OFF, this, shaderKey.getFogMode(), shaderKey == ShaderKey.GLINT, shaderKey.isText(), shaderKey.hasDiffuseLighting(), shaderKey.isIntensity(), shaderKey.shouldIgnoreLightmap());
        this.loadedShaders.add(fallbackShader);
        return fallbackShader;
    }

    private class_5944 createShadowShader(String string, ProgramSource programSource, ProgramId programId, AlphaTest alphaTest, class_293 class_2932, boolean bl, boolean bl2, boolean bl3) throws IOException {
        int[] nArray;
        ImmutableSet immutableSet = ImmutableSet.of();
        if (programSource.getDirectives().hasUnknownDrawBuffers()) {
            int[] nArray2 = new int[2];
            nArray2[0] = 0;
            nArray = nArray2;
            nArray2[1] = 1;
        } else {
            nArray = programSource.getDirectives().getDrawBuffers();
        }
        GlFramebuffer glFramebuffer = this.shadowRenderTargets.createShadowFramebuffer((ImmutableSet<Integer>)immutableSet, nArray);
        boolean bl4 = programId == ProgramId.Line && this.resolver.has(ProgramId.Line);
        ShaderAttributeInputs shaderAttributeInputs = new ShaderAttributeInputs(class_2932, bl2, bl4, false, bl3);
        Supplier<ImmutableSet<Integer>> supplier = () -> this.flippedBeforeShadow;
        ExtendedShader extendedShader = NewShaderTests.create(this, string, programSource, programId, glFramebuffer, glFramebuffer, this.baseline, alphaTest, class_2932, shaderAttributeInputs, this.updateNotifier, this, supplier, FogMode.PER_VERTEX, bl, bl2, true, bl4, this.customUniforms);
        this.loadedShaders.add(extendedShader);
        return extendedShader;
    }

    public void addGbufferOrShadowSamplers(SamplerHolder samplerHolder, ImageHolder imageHolder, Supplier<ImmutableSet<Integer>> supplier, boolean bl, InputAvailability inputAvailability) {
        TextureStage textureStage = TextureStage.GBUFFERS_AND_SHADOW;
        ProgramSamplers.CustomTextureSamplerInterceptor customTextureSamplerInterceptor = ProgramSamplers.customTextureSamplerInterceptor(samplerHolder, this.customTextureManager.getCustomTextureIdMap().getOrDefault((Object)textureStage, (Object2ObjectMap<String, TextureAccess>)Object2ObjectMaps.emptyMap()));
        IrisSamplers.addRenderTargetSamplers(customTextureSamplerInterceptor, supplier, this.renderTargets, false);
        IrisSamplers.addCustomTextures(customTextureSamplerInterceptor, this.customTextureManager.getIrisCustomTextures());
        IrisImages.addRenderTargetImages(imageHolder, supplier, this.renderTargets);
        IrisImages.addCustomImages(imageHolder, this.customImages);
        if (!this.shouldBindPBR) {
            this.shouldBindPBR = IrisSamplers.hasPBRSamplers(customTextureSamplerInterceptor);
        }
        IrisSamplers.addLevelSamplers(samplerHolder, this, (class_1044)this.whitePixel, inputAvailability);
        IrisSamplers.addWorldDepthSamplers(customTextureSamplerInterceptor, this.renderTargets);
        IrisSamplers.addNoiseSampler(customTextureSamplerInterceptor, this.customTextureManager.getNoiseTexture());
        IrisSamplers.addCustomImages(customTextureSamplerInterceptor, this.customImages);
        if (bl || IrisSamplers.hasShadowSamplers(customTextureSamplerInterceptor)) {
            if (!bl) {
                this.shadowTargetsSupplier.get();
            }
            IrisSamplers.addShadowSamplers(customTextureSamplerInterceptor, Objects.requireNonNull(this.shadowRenderTargets), null, this.separateHardwareSamplers);
        }
        if (bl || IrisImages.hasShadowImages(imageHolder)) {
            IrisImages.addShadowColorImages(imageHolder, Objects.requireNonNull(this.shadowRenderTargets), null);
        }
    }

    @Override
    public WorldRenderingPhase getPhase() {
        if (this.overridePhase != null) {
            return this.overridePhase;
        }
        return this.phase;
    }

    @Override
    public void beginSodiumTerrainRendering() {
    }

    @Override
    public void endSodiumTerrainRendering() {
    }

    @Override
    public void setOverridePhase(WorldRenderingPhase worldRenderingPhase) {
        this.overridePhase = worldRenderingPhase;
    }

    @Override
    public void setPhase(WorldRenderingPhase worldRenderingPhase) {
        this.phase = worldRenderingPhase;
    }

    @Override
    public void setSpecialCondition(SpecialCondition specialCondition) {
    }

    @Override
    public RenderTargetStateListener getRenderTargetStateListener() {
        return this;
    }

    @Override
    public int getCurrentNormalTexture() {
        return this.currentNormalTexture;
    }

    @Override
    public int getCurrentSpecularTexture() {
        return this.currentSpecularTexture;
    }

    @Override
    public void onSetShaderTexture(int n) {
        if (this.shouldBindPBR && this.isRenderingWorld) {
            PBRTextureHolder pBRTextureHolder = PBRTextureManager.INSTANCE.getOrLoadHolder(n);
            this.currentNormalTexture = pBRTextureHolder.getNormalTexture().method_4624();
            this.currentSpecularTexture = pBRTextureHolder.getSpecularTexture().method_4624();
            TextureFormat textureFormat = TextureFormatLoader.getFormat();
            if (textureFormat != null) {
                int n2 = GlStateManagerAccessor.getTEXTURES()[GlStateManagerAccessor.getActiveTexture()].field_5167;
                textureFormat.setupTextureParameters(PBRType.NORMAL, pBRTextureHolder.getNormalTexture());
                textureFormat.setupTextureParameters(PBRType.SPECULAR, pBRTextureHolder.getSpecularTexture());
                GlStateManager._bindTexture((int)n2);
            }
            PBRTextureManager.notifyPBRTexturesChanged();
        }
    }

    @Override
    public void onShadowBufferChange() {
        this.shadowClearPasses = ClearPassCreator.createShadowClearPasses(this.shadowRenderTargets, false, this.shadowDirectives);
        this.shadowClearPassesFull = ClearPassCreator.createShadowClearPasses(this.shadowRenderTargets, true, this.shadowDirectives);
    }

    @Override
    public void beginLevelRendering() {
        ImmutableList<ClearPass> immutableList;
        ImmutableList<ClearPass> immutableList2;
        this.isRenderingWorld = true;
        RenderSystem.activeTexture((int)33984);
        Vector4f vector4f = new Vector4f(1.0f);
        for (GlImage glImage2 : this.clearImages) {
            ARBClearTexture.glClearTexImage((int)glImage2.getId(), (int)0, (int)glImage2.getFormat().getGlFormat(), (int)glImage2.getPixelType().getGlFormat(), (int[])null);
        }
        if (this.shadowRenderTargets != null) {
            if (this.packDirectives.getShadowDirectives().isShadowEnabled() == OptionalBoolean.FALSE) {
                if (this.shadowRenderTargets.isFullClearRequired()) {
                    this.shadowRenderTargets.onFullClear();
                    for (ClearPass clearPass2 : this.shadowClearPassesFull) {
                        clearPass2.execute(vector4f);
                    }
                }
            } else {
                this.shadowRenderTargets.getDepthSourceFb().bind();
                RenderSystem.clear((int)256, (boolean)class_310.field_1703);
                for (ComputeProgram computeProgram : this.shadowComputes) {
                    if (computeProgram == null) continue;
                    computeProgram.use();
                    this.customUniforms.push(computeProgram);
                    computeProgram.dispatch(this.shadowMapResolution, this.shadowMapResolution);
                }
                if (this.shadowRenderTargets.isFullClearRequired()) {
                    immutableList2 = this.shadowClearPassesFull;
                    this.shadowRenderTargets.onFullClear();
                } else {
                    immutableList2 = this.shadowClearPasses;
                }
                for (ClearPass clearPass3 : immutableList2) {
                    clearPass3.execute(vector4f);
                }
            }
        }
        this.updateNotifier.onNewFrame();
        this.customUniforms.update();
        immutableList2 = class_310.method_1551().method_1522();
        int n = immutableList2.method_30278();
        int n2 = TextureInfoCache.INSTANCE.getInfo(n).getInternalFormat();
        DepthBufferFormat depthBufferFormat = DepthBufferFormat.fromGlEnumOrDefault(n2);
        boolean bl = this.renderTargets.resizeIfNeeded(((Blaze3dRenderTargetExt)immutableList2).iris$getDepthBufferVersion(), n, immutableList2.field_1482, immutableList2.field_1481, depthBufferFormat, this.packDirectives);
        if (bl) {
            this.beginRenderer.recalculateSizes();
            this.prepareRenderer.recalculateSizes();
            this.deferredRenderer.recalculateSizes();
            this.compositeRenderer.recalculateSizes();
            this.finalPassRenderer.recalculateSwapPassSize();
            if (this.shaderStorageBufferHolder != null) {
                this.shaderStorageBufferHolder.hasResizedScreen(immutableList2.field_1482, immutableList2.field_1481);
            }
            this.customImages.forEach(glImage -> glImage.updateNewSize(class_2762.field_1482, class_2762.field_1481));
            this.clearPassesFull.forEach(clearPass -> this.renderTargets.destroyFramebuffer(clearPass.getFramebuffer()));
            this.clearPasses.forEach(clearPass -> this.renderTargets.destroyFramebuffer(clearPass.getFramebuffer()));
            this.clearPassesFull = ClearPassCreator.createClearPasses(this.renderTargets, true, this.packDirectives.getRenderTargetDirectives());
            this.clearPasses = ClearPassCreator.createClearPasses(this.renderTargets, false, this.packDirectives.getRenderTargetDirectives());
        }
        if (bl || IrisVideoSettings.colorSpace != this.currentColorSpace) {
            this.currentColorSpace = IrisVideoSettings.colorSpace;
            this.colorSpaceConverter.rebuildProgram(immutableList2.field_1482, immutableList2.field_1481, this.currentColorSpace);
        }
        if (this.renderTargets.isFullClearRequired()) {
            this.renderTargets.onFullClear();
            immutableList = this.clearPassesFull;
        } else {
            immutableList = this.clearPasses;
        }
        Vector3d vector3d = CapturedRenderingState.INSTANCE.getFogColor();
        Vector4f vector4f2 = new Vector4f((float)vector3d.x, (float)vector3d.y, (float)vector3d.z, 1.0f);
        for (ComputeProgram[] computeProgramArray : immutableList) {
            computeProgramArray.execute(vector4f2);
        }
        immutableList2.method_1235(true);
        this.isMainBound = true;
        if (bl) {
            boolean bl2 = false;
            for (ComputeProgram computeProgram : this.setup) {
                if (computeProgram == null) continue;
                bl2 = true;
                computeProgram.use();
                computeProgram.dispatch(1.0f, 1.0f);
            }
            if (bl2) {
                ComputeProgram.unbind();
            }
        }
        this.isBeforeTranslucent = true;
        this.beginRenderer.renderAll();
        this.setPhase(WorldRenderingPhase.SKY);
        UnmodifiableIterator unmodifiableIterator = class_310.method_1551().field_1687.method_28103().method_29992();
        if (unmodifiableIterator == class_5294.class_5401.field_25640) {
            RenderSystem.depthMask((boolean)false);
            RenderSystem.setShaderColor((float)vector4f2.x, (float)vector4f2.y, (float)vector4f2.z, (float)vector4f2.w);
            this.horizonRenderer.renderHorizon(CapturedRenderingState.INSTANCE.getGbufferModelView(), CapturedRenderingState.INSTANCE.getGbufferProjection(), class_757.method_34539());
            RenderSystem.depthMask((boolean)true);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @Override
    public void renderShadows(LevelRendererAccessor levelRendererAccessor, class_4184 class_41842) {
        if (this.shadowRenderer != null) {
            this.shadowRenderer.renderShadows(levelRendererAccessor, class_41842);
        }
        this.prepareRenderer.renderAll();
    }

    @Override
    public void addDebugText(List<String> list) {
        if (this.shadowRenderer != null) {
            list.add("");
            this.shadowRenderer.addDebugText(list);
        } else {
            list.add("");
            list.add("[Iris] Shadow Maps: not used by shader pack");
        }
    }

    @Override
    public OptionalInt getForcedShadowRenderDistanceChunksForDisplay() {
        return this.forcedShadowRenderDistanceChunks;
    }

    @Override
    public void beginHand() {
        this.centerDepthSampler.sampleCenterDepth();
        this.renderTargets.copyPreHandDepth();
    }

    @Override
    public void beginTranslucents() {
        if (this.destroyed) {
            throw new IllegalStateException("Tried to use a destroyed world rendering pipeline");
        }
        this.isBeforeTranslucent = false;
        this.renderTargets.copyPreTranslucentDepth();
        this.deferredRenderer.renderAll();
        RenderSystem.enableBlend();
        RenderSystem.setShader(class_757::method_34539);
    }

    @Override
    public void finalizeLevelRendering() {
        this.isRenderingWorld = false;
        this.compositeRenderer.renderAll();
        this.finalPassRenderer.renderFinalPass();
        this.colorSpaceConverter.process(class_310.method_1551().method_1522().method_30277());
    }

    @Override
    public boolean shouldDisableVanillaEntityShadows() {
        return this.shadowRenderer != null;
    }

    @Override
    public boolean shouldRenderUnderwaterOverlay() {
        return this.shouldRenderUnderwaterOverlay;
    }

    @Override
    public boolean shouldRenderVignette() {
        return this.shouldRenderVignette;
    }

    @Override
    public boolean shouldRenderSun() {
        return this.shouldRenderSun;
    }

    @Override
    public boolean shouldRenderMoon() {
        return this.shouldRenderMoon;
    }

    @Override
    public boolean shouldWriteRainAndSnowToDepthBuffer() {
        return this.shouldWriteRainAndSnowToDepthBuffer;
    }

    @Override
    public ParticleRenderingSettings getParticleRenderingSettings() {
        return this.particleRenderingSettings;
    }

    @Override
    public boolean allowConcurrentCompute() {
        return this.allowConcurrentCompute;
    }

    @Override
    public boolean hasFeature(FeatureFlags featureFlags) {
        return this.pack.hasFeature(featureFlags);
    }

    @Override
    public boolean shouldDisableDirectionalShading() {
        return !this.oldLighting;
    }

    @Override
    public boolean shouldDisableFrustumCulling() {
        return !this.frustumCulling;
    }

    @Override
    public CloudSetting getCloudSetting() {
        return this.cloudSetting;
    }

    @Override
    public ShaderMap getShaderMap() {
        return this.shaderMap;
    }

    private void destroyShaders() {
        this.loadedShaders.forEach(class_59442 -> {
            class_59442.method_34585();
            class_59442.close();
        });
    }

    @Override
    public void destroy() {
        int n;
        this.destroyed = true;
        this.destroyShaders();
        for (n = 0; n < 16; ++n) {
            GlStateManager.glActiveTexture((int)(33984 + n));
            IrisRenderSystem.unbindAllSamplers();
            GlStateManager._bindTexture((int)0);
        }
        GlStateManager.glActiveTexture((int)33984);
        for (n = 0; n < 12; ++n) {
            RenderSystem.setShaderTexture((int)n, (int)0);
        }
        if (this.shadowCompositeRenderer != null) {
            this.shadowCompositeRenderer.destroy();
        }
        this.prepareRenderer.destroy();
        this.compositeRenderer.destroy();
        this.deferredRenderer.destroy();
        this.finalPassRenderer.destroy();
        this.centerDepthSampler.destroy();
        this.customTextureManager.destroy();
        this.whitePixel.close();
        this.horizonRenderer.destroy();
        GlStateManager._glBindFramebuffer((int)36008, (int)0);
        GlStateManager._glBindFramebuffer((int)36009, (int)0);
        GlStateManager._glBindFramebuffer((int)36160, (int)0);
        class_310.method_1551().method_1522().method_1235(false);
        this.renderTargets.destroy();
        this.customImages.forEach(GlResource::destroy);
        if (this.shadowRenderer != null) {
            this.shadowRenderer.destroy();
        }
        if (this.shaderStorageBufferHolder != null) {
            this.shaderStorageBufferHolder.destroyBuffers();
        }
    }

    @Override
    public boolean shouldOverrideShaders() {
        return this.isRenderingWorld && this.isMainBound;
    }

    @Override
    public SodiumTerrainPipeline getSodiumTerrainPipeline() {
        return this.sodiumTerrainPipeline;
    }

    @Override
    public FrameUpdateNotifier getFrameUpdateNotifier() {
        return this.updateNotifier;
    }

    @Override
    public float getSunPathRotation() {
        return this.sunPathRotation;
    }

    protected class_1044 getWhitePixel() {
        return this.whitePixel;
    }

    @Override
    public void beginPostChain() {
    }

    @Override
    public void endPostChain() {
    }

    @Override
    public void setIsMainBound(boolean bl) {
        this.isMainBound = bl;
    }

    private static /* synthetic */ ImmutableSet lambda$createSetupComputes$17(ImmutableSet immutableSet) {
        return immutableSet;
    }
}

