/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.inventory;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;

public final class ItemStackKey {
    private static final Field CAP_NBT = ObfuscationReflectionHelper.findField(ItemStack.class, (String)"capNBT");
    private final ItemStack stack;
    private static final Map<ItemStack, ItemStackKey> CACHE = new ConcurrentHashMap<ItemStack, ItemStackKey>();
    private boolean hashInitialized = false;
    private int hash;

    public static ItemStackKey of(ItemStack stack) {
        return CACHE.computeIfAbsent(stack, ItemStackKey::new);
    }

    private ItemStackKey(ItemStack stack) {
        this.stack = stack.m_41777_();
        this.stack.m_41764_(1);
    }

    public static void clearCacheOnTickEnd(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        CACHE.clear();
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemStackKey that = (ItemStackKey)o;
        return ItemStackKey.canItemStacksStack(this.stack, that.stack);
    }

    public static boolean canItemStacksStack(ItemStack a, ItemStack b) {
        if (a.m_41619_() || a.m_41720_() != b.m_41720_() || a.m_41782_() != b.m_41782_()) {
            return false;
        }
        return (!a.m_41782_() || a.m_41783_().equals((Object)b.m_41783_())) && Objects.equals(ItemStackKey.getCapNbt(a), ItemStackKey.getCapNbt(b));
    }

    public boolean hashCodeNotEquals(ItemStack otherStack) {
        return this.hashCode() != ItemStackKey.getHashCode(otherStack);
    }

    public int hashCode() {
        if (!this.hashInitialized) {
            this.hashInitialized = true;
            this.hash = ItemStackKey.getHashCode(this.stack);
        }
        return this.hash;
    }

    public static int getHashCode(ItemStack stack) {
        CompoundTag capNbt;
        int hash = stack.m_41720_().hashCode();
        if (stack.m_41782_()) {
            hash = hash * 31 + stack.m_41783_().hashCode();
        }
        if ((capNbt = ItemStackKey.getCapNbt(stack)) != null && !capNbt.m_128456_()) {
            hash = hash * 31 + capNbt.hashCode();
        }
        return hash;
    }

    @Nullable
    private static CompoundTag getCapNbt(ItemStack stack) {
        try {
            return (CompoundTag)CAP_NBT.get(stack);
        }
        catch (IllegalAccessException e) {
            SophisticatedCore.LOGGER.error("Error getting capNBT of stack ", (Throwable)e);
            return null;
        }
    }

    public boolean matches(ItemStack stack) {
        return this.hashCode() == ItemStackKey.getHashCode(stack);
    }

    public ItemStack stack() {
        return this.stack;
    }

    public String toString() {
        return "ItemStackKey[stack=" + this.stack + "]";
    }
}

