/*
 * Decompiled with CFR 0.152.
 */
package com.anar4732.opf;

import com.anar4732.opf.OPFBlock;
import com.anar4732.opf.OPFMod;
import com.anar4732.opf.Utils;
import com.anar4732.opf.client.DownloadingTextureExtended;
import com.google.common.hash.Hashing;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.util.math.box.AlignedBox;

public class OPFEntity
extends BlockEntity {
    public static final String DEFAULT_URL = "https://techcrunch.com/wp-content/uploads/2015/08/safe_image.gif";
    public static final int MAX_SIZE = 32;
    public String url = "https://techcrunch.com/wp-content/uploads/2015/08/safe_image.gif";
    public int sizeX = 1;
    public int sizeY = 1;
    public boolean flippedX;
    public boolean flippedY;
    public boolean onFloor;
    public String oldUrl = "";
    public float speed = 0.8f;
    @OnlyIn(value=Dist.CLIENT)
    public DownloadingTextureExtended textureWorker;
    @OnlyIn(value=Dist.CLIENT)
    public static File cacheDir;
    @OnlyIn(value=Dist.CLIENT)
    public static TextureManager textureManager;
    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation textureLocation;

    public OPFEntity(BlockPos blockPos, BlockState state) {
        super((BlockEntityType)OPFMod.TE_OPF.get(), blockPos, state);
        if (Platform.getEnvironment() == Env.CLIENT) {
            textureManager = Minecraft.m_91087_().m_91097_();
            cacheDir = new File(Minecraft.m_91087_().f_91069_, "opf_cache");
        }
    }

    public void removeBlocks() {
        this.removeBlocks(this.sizeX, this.sizeY);
    }

    public void removeBlocks(int oldSizeX, int oldSizeY) {
        Direction direction = ((Direction)this.f_58857_.m_8055_(this.f_58858_).m_61143_((Property)OPFBlock.FACING)).m_122427_();
        if (!this.onFloor) {
            for (int x = 0; x < oldSizeX; ++x) {
                BlockPos pos2 = this.f_58858_.m_5484_(direction, x);
                if (!pos2.equals((Object)this.f_58858_) && this.f_58857_.m_8055_(pos2).m_60734_() == OPFMod.BLOCK_OPF_DUMMY.get()) {
                    this.f_58857_.m_7731_(pos2, Blocks.f_50016_.m_49966_(), 3);
                }
                for (int y = 1; y < oldSizeY; ++y) {
                    BlockPos pos3 = pos2.m_5484_(Direction.UP, y);
                    if (this.f_58857_.m_8055_(pos3).m_60734_() != OPFMod.BLOCK_OPF_DUMMY.get()) continue;
                    this.f_58857_.m_7731_(pos3, Blocks.f_50016_.m_49966_(), 3);
                }
            }
        } else {
            for (int x = 0; x < oldSizeX; ++x) {
                BlockPos pos2 = this.f_58858_.m_5484_(direction.m_122427_().m_122427_().m_122427_(), x);
                if (!pos2.equals((Object)this.f_58858_) && this.f_58857_.m_8055_(pos2).m_60734_() == OPFMod.BLOCK_OPF_DUMMY_FLOOR.get()) {
                    this.f_58857_.m_7731_(pos2, Blocks.f_50016_.m_49966_(), 3);
                }
                for (int y = 1; y < oldSizeY; ++y) {
                    BlockPos pos3 = pos2.m_5484_(direction, y);
                    if (this.f_58857_.m_8055_(pos3).m_60734_() != OPFMod.BLOCK_OPF_DUMMY_FLOOR.get()) continue;
                    this.f_58857_.m_7731_(pos3, Blocks.f_50016_.m_49966_(), 3);
                }
            }
        }
    }

    public void updateBlocks() {
        this.updateBlocks(this.sizeX, this.sizeY);
    }

    public void updateBlocks(int oldSizeX, int oldSizeY) {
        this.removeBlocks(oldSizeX, oldSizeY);
        Direction direction = ((Direction)this.f_58857_.m_8055_(this.f_58858_).m_61143_((Property)OPFBlock.FACING)).m_122427_();
        if (this.onFloor) {
            for (int x = 0; x < this.sizeX; ++x) {
                BlockPos pos2 = this.f_58858_.m_5484_(direction.m_122427_().m_122427_().m_122427_(), x);
                if (!pos2.equals((Object)this.f_58858_)) {
                    if (this.f_58857_.m_8055_(pos2).m_60795_()) {
                        this.f_58857_.m_7731_(pos2, (BlockState)((BlockState)((BlockState)((OPFBlock)((Object)OPFMod.BLOCK_OPF_DUMMY_FLOOR.get())).m_49966_().m_61124_((Property)OPFBlock.FACING, (Comparable)((Direction)this.m_58900_().m_61143_((Property)OPFBlock.FACING)))).m_61124_((Property)OPFBlock.ATTACHED, (Comparable)((Boolean)this.m_58900_().m_61143_((Property)OPFBlock.ATTACHED)))).m_61124_((Property)OPFBlock.VISIBLE, (Comparable)((Boolean)this.m_58900_().m_61143_((Property)OPFBlock.VISIBLE))), 3);
                    } else {
                        this.sizeX = x++;
                    }
                }
                for (int y = 1; y < this.sizeY; ++y) {
                    BlockPos pos3 = pos2.m_5484_(direction, y);
                    if (this.f_58857_.m_8055_(pos3).m_60795_()) {
                        this.f_58857_.m_7731_(pos3, (BlockState)((BlockState)((BlockState)((OPFBlock)((Object)OPFMod.BLOCK_OPF_DUMMY_FLOOR.get())).m_49966_().m_61124_((Property)OPFBlock.FACING, (Comparable)((Direction)this.m_58900_().m_61143_((Property)OPFBlock.FACING)))).m_61124_((Property)OPFBlock.ATTACHED, (Comparable)((Boolean)this.m_58900_().m_61143_((Property)OPFBlock.ATTACHED)))).m_61124_((Property)OPFBlock.VISIBLE, (Comparable)((Boolean)this.m_58900_().m_61143_((Property)OPFBlock.VISIBLE))), 3);
                        continue;
                    }
                    this.sizeY = y;
                }
            }
        } else {
            for (int x = 0; x < this.sizeX; ++x) {
                BlockPos pos2 = this.f_58858_.m_5484_(direction, x);
                if (!pos2.equals((Object)this.f_58858_)) {
                    if (this.f_58857_.m_8055_(pos2).m_60795_()) {
                        this.f_58857_.m_7731_(pos2, (BlockState)((BlockState)((BlockState)((OPFBlock)((Object)OPFMod.BLOCK_OPF_DUMMY.get())).m_49966_().m_61124_((Property)OPFBlock.FACING, (Comparable)((Direction)this.m_58900_().m_61143_((Property)OPFBlock.FACING)))).m_61124_((Property)OPFBlock.ATTACHED, (Comparable)((Boolean)this.m_58900_().m_61143_((Property)OPFBlock.ATTACHED)))).m_61124_((Property)OPFBlock.VISIBLE, (Comparable)((Boolean)this.m_58900_().m_61143_((Property)OPFBlock.VISIBLE))), 3);
                    } else {
                        this.sizeX = x++;
                    }
                }
                for (int y = 1; y < this.sizeY; ++y) {
                    BlockPos pos3 = pos2.m_5484_(Direction.UP, y);
                    if (this.f_58857_.m_8055_(pos3).m_60795_()) {
                        this.f_58857_.m_7731_(pos3, (BlockState)((BlockState)((BlockState)((OPFBlock)((Object)OPFMod.BLOCK_OPF_DUMMY.get())).m_49966_().m_61124_((Property)OPFBlock.FACING, (Comparable)((Direction)this.m_58900_().m_61143_((Property)OPFBlock.FACING)))).m_61124_((Property)OPFBlock.ATTACHED, (Comparable)((Boolean)this.m_58900_().m_61143_((Property)OPFBlock.ATTACHED)))).m_61124_((Property)OPFBlock.VISIBLE, (Comparable)((Boolean)this.m_58900_().m_61143_((Property)OPFBlock.VISIBLE))), 3);
                        continue;
                    }
                    this.sizeY = y;
                }
            }
        }
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128359_("url", this.url);
        compound.m_128405_("sizeX", this.sizeX);
        compound.m_128405_("sizeY", this.sizeY);
        compound.m_128379_("floor", this.onFloor);
        compound.m_128379_("flippedX", this.flippedX);
        compound.m_128379_("flippedY", this.flippedY);
        compound.m_128350_("speed", this.speed);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.url = compound.m_128461_("url");
        this.sizeX = compound.m_128451_("sizeX");
        this.sizeY = compound.m_128451_("sizeY");
        this.onFloor = compound.m_128471_("floor");
        this.flippedX = compound.m_128471_("flippedX");
        this.flippedY = compound.m_128471_("flippedY");
        this.speed = compound.m_128457_("speed");
        if (Platform.getEnvironment() == Env.CLIENT && !this.oldUrl.isEmpty() && !this.url.isEmpty() && this.textureLocation != null) {
            this.updateTextureIfNeeded();
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.f_58857_ != null && this.f_58857_.f_46443_ && this.textureLocation != null) {
            textureManager.m_118506_(this.textureLocation).m_117964_();
            this.textureWorker = null;
        }
    }

    public void sendToClients() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ClientboundBlockEntityDataPacket pkt = this.getUpdatePacket();
            serverLevel.m_7726_().f_8325_.m_183262_(new ChunkPos(this.m_58899_()), false).forEach(arg_0 -> OPFEntity.lambda$sendToClients$0((Packet)pkt, arg_0));
        } else {
            OPFMod.LOGGER.warn("Tried to send OPF packet to clients on client side!");
        }
    }

    public static AABB getBoundingBox(OPFEntity frame) {
        AlignedBox cube = new AlignedBox(0.0f, 0.0f, 0.0f, 0.05f, 1.0f, 1.0f);
        float sizeX = frame.sizeX;
        float sizeY = frame.sizeY;
        if (sizeX == 0.0f) {
            sizeX = 1.0f;
        }
        if (sizeY == 0.0f) {
            sizeY = 1.0f;
        }
        Direction direction = (Direction)frame.f_58857_.m_8055_(frame.f_58858_).m_61143_((Property)OPFBlock.FACING);
        cube.maxZ += sizeX - 1.0f;
        cube.maxY += sizeY - 1.0f;
        cube = new AlignedBox(Math.min(cube.minX, cube.maxX), Math.min(cube.minY, cube.maxY), Math.min(cube.minZ, cube.maxZ), Math.max(cube.minX, cube.maxX), Math.max(cube.minY, cube.maxY), Math.max(cube.minZ, cube.maxZ));
        if (frame.onFloor) {
            cube.set(-cube.maxY + 1.0f, 0.0f, -cube.maxZ + 1.0f, 1.0f, 0.05f, 1.0f);
            return Utils.rotateCube(cube, direction.m_122424_()).getBB();
        }
        if (((Boolean)frame.f_58857_.m_8055_(frame.f_58858_).m_61143_((Property)OPFBlock.ATTACHED)).booleanValue()) {
            cube.set(0.0f, cube.maxY, -cube.maxZ + 1.0f, 0.05f, 0.0f, 1.0f);
            return Utils.rotateCube(cube, direction.m_122424_()).getBB();
        }
        return Utils.rotateCube(cube, direction).getBB();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateTextureIfNeeded() {
        if (!this.oldUrl.equals(this.url)) {
            this.loadTexture();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldLoadTexture() {
        return !this.isTextureLoaded();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isTextureLoaded() {
        return this.textureWorker != null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void loadTexture() {
        this.oldUrl = this.url;
        String s = Hashing.sha1().hashUnencodedChars((CharSequence)this.url).toString().replaceAll("==", "");
        this.textureLocation = new ResourceLocation("opf", "assets/opf/frames/" + s + this.m_58899_().m_121878_());
        File f = new File(cacheDir.toString(), s);
        this.textureWorker = new DownloadingTextureExtended(f, this.url, this.textureLocation, null, this);
        textureManager.m_118495_(this.textureLocation, (AbstractTexture)this.textureWorker);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tickTexture() {
        if (this.textureWorker != null && this.textureWorker.isGif()) {
            this.textureWorker.tick();
        }
    }

    private static /* synthetic */ void lambda$sendToClients$0(Packet pkt, ServerPlayer p) {
        p.f_8906_.m_9829_(pkt);
    }
}

