/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.element;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import org.lwjgl.opengl.GL11;
import xaero.map.WorldMap;
import xaero.map.element.HoveredMapElementHolder;
import xaero.map.element.MapElementReader;
import xaero.map.element.MapElementRenderProvider;
import xaero.map.element.MapElementRenderer;
import xaero.map.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.map.gui.GuiMap;
import xaero.map.mods.SupportMods;

public class MapElementRenderHandler {
    private final List<MapElementRenderer<?, ?, ?>> renderers;
    protected final int location;

    private MapElementRenderHandler(List<MapElementRenderer<?, ?, ?>> renderers, int location) {
        this.renderers = renderers;
        this.location = location;
    }

    public void add(MapElementRenderer<?, ?, ?> renderer) {
        this.renderers.add(renderer);
    }

    public static <E, C> HoveredMapElementHolder<E, C> createResult(E hovered, MapElementRenderer<?, ?, ?> hoveredRenderer) {
        MapElementRenderer<?, ?, ?> rendererCast = hoveredRenderer;
        return new HoveredMapElementHolder(hovered, rendererCast);
    }

    private <E> MapElementRenderer<E, ?, ?> getRenderer(HoveredMapElementHolder<E, ?> holder) {
        return holder.getRenderer();
    }

    public HoveredMapElementHolder<?, ?> render(GuiMap mapScreen, GuiGraphics guiGraphics, MultiBufferSource.BufferSource renderTypeBuffers, MultiTextureRenderTypeRendererProvider rendererProvider, double cameraX, double cameraZ, int width, int height, double screenSizeBasedScale, double scale, double playerDimDiv, double mouseX, double mouseZ, float brightness, boolean cave, HoveredMapElementHolder<?, ?> oldHovered, Minecraft mc, float partialTicks) {
        HoveredMapElementHolder<?, ?> hoveredToReturn;
        PoseStack matrixStack = guiGraphics.m_280168_();
        Object hovered = null;
        MapElementRenderer<?, ?, ?> hoveredRenderer = null;
        TextureManager textureManager = mc.m_91097_();
        Font fontRenderer = mc.f_91062_;
        textureManager.m_174784_(WorldMap.guiTextures);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)WorldMap.guiTextures);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        double baseScale = 1.0 / scale;
        Collections.sort(this.renderers);
        for (int i = this.renderers.size() - 1; i >= 0; --i) {
            MapElementRenderer<?, ?, ?> renderer = this.renderers.get(i);
            Object obj = this.getRendererHovered(renderer, mapScreen, mouseX, mouseZ, scale, screenSizeBasedScale, playerDimDiv, partialTicks);
            if (obj == null) continue;
            hovered = obj;
            hoveredRenderer = renderer;
            break;
        }
        HoveredMapElementHolder<Object, Object> hoveredMapElementHolder = oldHovered != null && oldHovered.is(hovered) ? oldHovered : (hoveredToReturn = hovered == null ? null : MapElementRenderHandler.createResult(hovered, hoveredRenderer));
        if (hovered == null && oldHovered != null) {
            hovered = oldHovered.getElement();
            hoveredRenderer = this.getRenderer(oldHovered);
        }
        matrixStack.m_85836_();
        matrixStack.m_252880_(0.0f, 0.0f, -980.0f);
        matrixStack.m_85841_((float)baseScale, (float)baseScale, 1.0f);
        for (MapElementRenderer mapElementRenderer : this.renderers) {
            this.renderWithRenderer(mapElementRenderer, hovered, mapScreen, guiGraphics, renderTypeBuffers, rendererProvider, textureManager, fontRenderer, cameraX, cameraZ, width, height, screenSizeBasedScale, baseScale, scale, playerDimDiv, mouseX, mouseZ, brightness, cave, oldHovered, mc, true, partialTicks, 0, 0);
        }
        if (hovered != null) {
            this.renderHoveredWithRenderer(hoveredRenderer, hovered, mapScreen, guiGraphics, renderTypeBuffers, rendererProvider, textureManager, fontRenderer, cameraX, cameraZ, width, height, screenSizeBasedScale, baseScale, scale, playerDimDiv, mouseX, mouseZ, brightness, cave, mc, true, partialTicks, 0, 0);
        }
        int indexLimit = 19490;
        for (MapElementRenderer<?, ?, ?> renderer : this.renderers) {
            int elementIndex = 0;
            elementIndex = this.renderWithRenderer(renderer, hovered, mapScreen, guiGraphics, renderTypeBuffers, rendererProvider, textureManager, fontRenderer, cameraX, cameraZ, width, height, screenSizeBasedScale, baseScale, scale, playerDimDiv, mouseX, mouseZ, brightness, cave, oldHovered, mc, false, partialTicks, elementIndex, indexLimit);
            matrixStack.m_85837_(0.0, 0.0, this.getElementIndexDepth(elementIndex, indexLimit));
            if ((indexLimit -= elementIndex) >= 0) continue;
            indexLimit = 0;
        }
        if (hovered != null) {
            this.renderHoveredWithRenderer(hoveredRenderer, hovered, mapScreen, guiGraphics, renderTypeBuffers, rendererProvider, textureManager, fontRenderer, cameraX, cameraZ, width, height, screenSizeBasedScale, baseScale, scale, playerDimDiv, mouseX, mouseZ, brightness, cave, mc, false, partialTicks, 0, indexLimit);
        }
        matrixStack.m_85849_();
        textureManager.m_174784_(WorldMap.guiTextures);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)WorldMap.guiTextures);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        return hoveredToReturn;
    }

    private <E, C, R extends MapElementRenderer<E, C, R>> E getRendererHovered(MapElementRenderer<E, C, R> renderer, GuiMap mapScreen, double mouseX, double mouseZ, double scale, double screenSizeBasedScale, double playerDimDiv, float partialTicks) {
        if (!renderer.shouldRender(this.location, false) && !renderer.shouldRender(this.location, true)) {
            return null;
        }
        MapElementReader reader = renderer.reader;
        MapElementRenderProvider provider = renderer.provider;
        Object context = renderer.context;
        int location = this.location;
        E result = null;
        double rendererDimDiv = renderer.shouldBeDimScaled() ? playerDimDiv : 1.0;
        provider.begin(location, context);
        while (provider.hasNext(location, context)) {
            Object e = provider.getNext(location, context);
            if (e == null || reader.isHidden(e, context) || !reader.isInteractable(location, e) || !reader.isHoveredOnMap(location, e, mouseX, mouseZ, scale, screenSizeBasedScale, rendererDimDiv, context, partialTicks)) continue;
            result = e;
        }
        provider.end(location, context);
        return result;
    }

    private <E, C, R extends MapElementRenderer<E, C, R>> int renderHoveredWithRenderer(MapElementRenderer<E, C, R> renderer, Object hovered, GuiMap mapScreen, GuiGraphics guiGraphics, MultiBufferSource.BufferSource renderTypeBuffers, MultiTextureRenderTypeRendererProvider rendererProvider, TextureManager textureManager, Font font, double cameraX, double cameraZ, int width, int height, double screenSizeBasedScale, double baseScale, double scale, double playerDimDiv, double mouseX, double mouseZ, float brightness, boolean cave, Minecraft mc, boolean pre, float partialTicks, int elementIndex, int indexLimit) {
        double rendererDimDiv;
        if (!renderer.shouldRenderHovered(pre)) {
            return elementIndex;
        }
        PoseStack matrixStack = guiGraphics.m_280168_();
        MapElementReader reader = renderer.reader;
        Object hoveredCast = hovered;
        renderer.beforeRender(this.location, mc, guiGraphics, cameraX, cameraZ, mouseX, mouseZ, brightness, scale, screenSizeBasedScale, textureManager, font, renderTypeBuffers, rendererProvider, pre);
        matrixStack.m_85836_();
        if (!pre) {
            matrixStack.m_252880_(0.0f, 0.0f, 1.0f);
        }
        double d = rendererDimDiv = renderer.shouldBeDimScaled() ? playerDimDiv : 1.0;
        if (!reader.isHidden(hoveredCast, renderer.getContext()) && this.transformAndRenderElement(renderer, hoveredCast, hovered, mapScreen, guiGraphics, renderTypeBuffers, rendererProvider, textureManager, font, cameraX, cameraZ, width, height, screenSizeBasedScale, baseScale, scale, rendererDimDiv, mouseX, mouseZ, brightness, cave, mc, pre, partialTicks, elementIndex, indexLimit) && !pre) {
            ++elementIndex;
        }
        matrixStack.m_85849_();
        renderer.afterRender(this.location, mc, guiGraphics, cameraX, cameraZ, mouseX, mouseZ, brightness, scale, screenSizeBasedScale, textureManager, font, renderTypeBuffers, rendererProvider, pre);
        return elementIndex;
    }

    private <E, C, R extends MapElementRenderer<E, C, R>> int renderWithRenderer(MapElementRenderer<E, C, R> renderer, Object hovered, GuiMap mapScreen, GuiGraphics guiGraphics, MultiBufferSource.BufferSource renderTypeBuffers, MultiTextureRenderTypeRendererProvider rendererProvider, TextureManager textureManager, Font font, double cameraX, double cameraZ, int width, int height, double screenSizeBasedScale, double baseScale, double scale, double playerDimDiv, double mouseX, double mouseZ, float brightness, boolean cave, HoveredMapElementHolder<?, ?> oldHovered, Minecraft mc, boolean pre, float partialTicks, int elementIndex, int indexLimit) {
        int location = this.location;
        if (!renderer.shouldRender(location, pre)) {
            return elementIndex;
        }
        MapElementReader reader = renderer.reader;
        MapElementRenderProvider provider = renderer.provider;
        Object context = renderer.context;
        double rendererDimDiv = renderer.shouldBeDimScaled() ? playerDimDiv : 1.0;
        renderer.beforeRender(location, mc, guiGraphics, cameraX, cameraZ, mouseX, mouseZ, brightness, scale, screenSizeBasedScale, textureManager, font, renderTypeBuffers, rendererProvider, pre);
        provider.begin(location, context);
        while (provider.hasNext(location, context)) {
            Object e = provider.setupContextAndGetNext(location, context);
            if (e == null || reader.isHidden(e, context) || e == hovered || !reader.isOnScreen(e, cameraX, cameraZ, width, height, scale, screenSizeBasedScale, rendererDimDiv, context, partialTicks) || !this.transformAndRenderElement(renderer, e, hovered, mapScreen, guiGraphics, renderTypeBuffers, rendererProvider, textureManager, font, cameraX, cameraZ, width, height, screenSizeBasedScale, baseScale, scale, rendererDimDiv, mouseX, mouseZ, brightness, cave, mc, pre, partialTicks, elementIndex, indexLimit) || pre) continue;
            ++elementIndex;
        }
        provider.end(location, context);
        renderer.afterRender(location, mc, guiGraphics, cameraX, cameraZ, mouseX, mouseZ, brightness, scale, screenSizeBasedScale, textureManager, font, renderTypeBuffers, rendererProvider, pre);
        return elementIndex;
    }

    private <E, C, R extends MapElementRenderer<E, C, R>> boolean transformAndRenderElement(MapElementRenderer<E, C, R> renderer, E e, Object hovered, GuiMap mapScreen, GuiGraphics guiGraphics, MultiBufferSource.BufferSource renderTypeBuffers, MultiTextureRenderTypeRendererProvider rendererProvider, TextureManager textureManager, Font font, double cameraX, double cameraZ, int width, int height, double screenSizeBasedScale, double baseScale, double scale, double rendererDimDiv, double mouseX, double mouseZ, float brightness, boolean cave, Minecraft mc, boolean pre, float partialTicks, int elementIndex, int indexLimit) {
        PoseStack matrixStack = guiGraphics.m_280168_();
        MapElementReader reader = renderer.reader;
        Object context = renderer.context;
        matrixStack.m_85836_();
        double offX = (reader.getRenderX(e, context, partialTicks) / rendererDimDiv - cameraX) / baseScale;
        double offZ = (reader.getRenderZ(e, context, partialTicks) / rendererDimDiv - cameraZ) / baseScale;
        long roundedOffX = Math.round(offX);
        long roundedOffZ = Math.round(offZ);
        double partialX = offX - (double)roundedOffX;
        double partialY = offZ - (double)roundedOffZ;
        matrixStack.m_252880_((float)roundedOffX, (float)roundedOffZ, 0.0f);
        boolean result = false;
        if (pre) {
            renderer.renderElementPre(this.location, e, e == hovered, mc, guiGraphics, cameraX, cameraZ, mouseX, mouseZ, brightness, scale, screenSizeBasedScale, textureManager, font, renderTypeBuffers, rendererProvider, (float)screenSizeBasedScale, partialX, partialY, cave, partialTicks);
        } else {
            double optionalDepth = this.getElementIndexDepth(elementIndex, indexLimit);
            result = renderer.renderElement(this.location, e, e == hovered, mc, guiGraphics, cameraX, cameraZ, mouseX, mouseZ, brightness, scale, screenSizeBasedScale, textureManager, font, renderTypeBuffers, rendererProvider, elementIndex, optionalDepth, (float)screenSizeBasedScale, partialX, partialY, cave, partialTicks);
        }
        matrixStack.m_85849_();
        return result;
    }

    private double getElementIndexDepth(int elementIndex, int indexLimit) {
        return (double)(elementIndex >= indexLimit ? indexLimit : elementIndex) * 0.1;
    }

    public static final class Builder {
        private Builder() {
        }

        public MapElementRenderHandler build() {
            ArrayList renderers = new ArrayList();
            if (SupportMods.minimap()) {
                renderers.add(SupportMods.xaeroMinimap.getWaypointRenderer());
            }
            renderers.add(WorldMap.trackedPlayerRenderer);
            if (SupportMods.pac()) {
                renderers.add(SupportMods.xaeroPac.getCaimResultElementRenderer());
            }
            return new MapElementRenderHandler(renderers, 3);
        }

        public static Builder begin() {
            return new Builder();
        }
    }
}

