/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.network;

import ht.treechop.client.SafeClient;
import ht.treechop.common.network.ClientRequestSettingsPacket;
import ht.treechop.common.network.CustomPacket;
import ht.treechop.common.network.MessageFromClientHandler;
import ht.treechop.common.network.MessageFromServerHandler;
import ht.treechop.common.network.ServerConfirmSettingsPacket;
import ht.treechop.common.network.ServerPermissionsPacket;
import ht.treechop.common.network.ServerUpdateChopsPacket;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public abstract class ForgePacketHandler {
    private static final String PROTOCOL = "7";
    public static final SimpleChannel HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("treechop-channel"), () -> "7", "7"::equals, "7"::equals);

    public static void registerPackets() {
        ForgePacketHandler.registerClientToServerPacket(ClientRequestSettingsPacket.ID, ClientRequestSettingsPacket.class, ClientRequestSettingsPacket::encode, ClientRequestSettingsPacket::decode, ClientRequestSettingsPacket::handle);
        ForgePacketHandler.registerServerToClientPacket(ServerConfirmSettingsPacket.ID, ServerConfirmSettingsPacket.class, ServerConfirmSettingsPacket::encode, ServerConfirmSettingsPacket::decode, ServerConfirmSettingsPacket::handle);
        ForgePacketHandler.registerServerToClientPacket(ServerPermissionsPacket.ID, ServerPermissionsPacket.class, ServerPermissionsPacket::encode, ServerPermissionsPacket::decode, ServerPermissionsPacket::handle);
        ForgePacketHandler.registerServerToClientPacket(ServerUpdateChopsPacket.ID, ServerUpdateChopsPacket.class, ServerUpdateChopsPacket::encode, ServerUpdateChopsPacket::decode, SafeClient::handleUpdateChopsPacket);
    }

    private static <T> void registerClientToServerPacket(ResourceLocation id, Class<T> packetClass, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, MessageFromClientHandler<T> handler) {
        HANDLER.registerMessage(id.hashCode(), packetClass, encoder, decoder, ClientPacketProcessor.replyChannel(handler));
    }

    private static <T> void registerServerToClientPacket(ResourceLocation id, Class<T> packetClass, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, MessageFromServerHandler<T> handler) {
        HANDLER.registerMessage(id.hashCode(), packetClass, encoder, decoder, ServerPacketProcessor.replyChannel(handler));
    }

    private record ClientPacketProcessor<T>(MessageFromClientHandler<T> handler) implements BiConsumer<T, Supplier<NetworkEvent.Context>>
    {
        public static <T> ClientPacketProcessor<T> replyChannel(MessageFromClientHandler<T> handler) {
            return new ClientPacketProcessor<T>(handler);
        }

        @Override
        public void accept(T message, Supplier<NetworkEvent.Context> context) {
            if (context.get().getDirection().getReceptionSide() == LogicalSide.SERVER) {
                context.get().enqueueWork(() -> this.handler.accept(message, ((NetworkEvent.Context)context.get()).getSender(), arg_0 -> ClientPacketProcessor.lambda$accept$0((Supplier)context, arg_0)));
            }
            context.get().setPacketHandled(true);
        }

        private static /* synthetic */ void lambda$accept$0(Supplier context, CustomPacket reply) {
            HANDLER.sendTo((Object)reply, ((NetworkEvent.Context)context.get()).getNetworkManager(), NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    private record ServerPacketProcessor<T>(MessageFromServerHandler<T> handler) implements BiConsumer<T, Supplier<NetworkEvent.Context>>
    {
        public static <T> ServerPacketProcessor<T> replyChannel(MessageFromServerHandler<T> handler) {
            return new ServerPacketProcessor<T>(handler);
        }

        @Override
        public void accept(T message, Supplier<NetworkEvent.Context> context) {
            if (context.get().getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                context.get().enqueueWork(() -> this.handler.accept(message));
            }
            context.get().setPacketHandled(true);
        }
    }
}

