/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.registry;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.recipe.ZetaDyeRecipe;
import org.violetmoon.zeta.util.BooleanSuppliers;

public class DyeablesRegistry {
    public final Map<Item, BooleanSupplier> dyeableConditions = new HashMap<Item, BooleanSupplier>();
    public final DyeableLeatherItem SURROGATE = new DyeableLeatherItem(){};

    @LoadEvent
    public void register(ZRegister event) {
        ResourceLocation id = event.getRegistry().newResourceLocation("dye_item");
        ZetaDyeRecipe recipe = new ZetaDyeRecipe(id, CraftingBookCategory.EQUIPMENT, this);
        event.getRegistry().register(recipe.m_7707_(), id, Registries.f_256764_);
    }

    @LoadEvent
    public void registerPost(ZRegister.Post event) {
        WashingInteraction wosh = new WashingInteraction();
        for (Item item : this.dyeableConditions.keySet()) {
            CauldronInteraction.f_175607_.put(item, wosh);
        }
    }

    public void register(Item item) {
        this.register(item, BooleanSuppliers.TRUE);
    }

    public void register(Item item, ZetaModule module) {
        this.register(item, () -> module.enabled);
    }

    public void register(Item item, BooleanSupplier cond) {
        this.dyeableConditions.put(item, cond);
    }

    public boolean isDyeable(ItemStack stack) {
        Item item = stack.m_41720_();
        return this.dyeableConditions.containsKey(item) && this.dyeableConditions.get(item).getAsBoolean();
    }

    public boolean isDyed(ItemStack stack) {
        return this.isDyeable(stack) && this.SURROGATE.m_41113_(stack);
    }

    public int getDye(ItemStack stack) {
        return this.SURROGATE.m_41121_(stack);
    }

    public void applyDye(ItemStack stack, int color) {
        if (this.isDyeable(stack)) {
            this.SURROGATE.m_41115_(stack, color);
        }
    }

    public int getColor(ItemStack stack) {
        return this.isDyed(stack) ? this.SURROGATE.m_41121_(stack) : 0xFFFFFF;
    }

    public ItemStack dyeItem(ItemStack stack, List<DyeItem> dyes) {
        int[] aint = new int[3];
        int i = 0;
        int j = 0;
        if (this.isDyeable(stack)) {
            ItemStack itemstack = stack.m_41777_();
            itemstack.m_41764_(1);
            if (this.SURROGATE.m_41113_(stack)) {
                int k = this.SURROGATE.m_41121_(itemstack);
                float f = (float)(k >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(k >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(k & 0xFF) / 255.0f;
                i += (int)(Math.max(f, Math.max(f1, f2)) * 255.0f);
                aint[0] = aint[0] + (int)(f * 255.0f);
                aint[1] = aint[1] + (int)(f1 * 255.0f);
                aint[2] = aint[2] + (int)(f2 * 255.0f);
                ++j;
            }
            for (DyeItem dyeitem : dyes) {
                float[] afloat = dyeitem.m_41089_().m_41068_();
                int i2 = (int)(afloat[0] * 255.0f);
                int l = (int)(afloat[1] * 255.0f);
                int i1 = (int)(afloat[2] * 255.0f);
                i += Math.max(i2, Math.max(l, i1));
                aint[0] = aint[0] + i2;
                aint[1] = aint[1] + l;
                aint[2] = aint[2] + i1;
                ++j;
            }
            int j1 = aint[0] / j;
            int k1 = aint[1] / j;
            int l1 = aint[2] / j;
            float f3 = (float)i / (float)j;
            float f4 = Math.max(j1, Math.max(k1, l1));
            j1 = (int)((float)j1 * f3 / f4);
            k1 = (int)((float)k1 * f3 / f4);
            l1 = (int)((float)l1 * f3 / f4);
            int j2 = (j1 << 8) + k1;
            j2 = (j2 << 8) + l1;
            this.SURROGATE.m_41115_(itemstack, j2);
            return itemstack;
        }
        return ItemStack.f_41583_;
    }

    class WashingInteraction
    implements CauldronInteraction {
        WashingInteraction() {
        }

        public InteractionResult m_175710_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack stack) {
            if (!DyeablesRegistry.this.isDyed(stack)) {
                return InteractionResult.PASS;
            }
            if (!level.f_46443_) {
                DyeablesRegistry.this.SURROGATE.m_41123_(stack);
                LayeredCauldronBlock.m_153559_((BlockState)state, (Level)level, (BlockPos)pos);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
    }
}

