/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.block;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.furniture.block.FurnitureHorizontalBlock;
import com.mrcrayfish.furniture.client.MailBoxEntry;
import com.mrcrayfish.furniture.common.mail.MailBox;
import com.mrcrayfish.furniture.common.mail.PostOffice;
import com.mrcrayfish.furniture.inventory.container.PostBoxMenu;
import com.mrcrayfish.furniture.util.VoxelShapeHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;

public class PostBoxBlock
extends FurnitureHorizontalBlock {
    private static final Component TITLE = Component.m_237115_((String)"container.cfm.post_box");
    public final VoxelShape SHAPE;

    public PostBoxBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)DIRECTION, (Comparable)Direction.NORTH));
        this.SHAPE = this.generateShape();
    }

    private VoxelShape generateShape() {
        ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
        shapes.add(Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)6.0, (double)3.0));
        shapes.add(Block.m_49796_((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)6.0, (double)3.0));
        shapes.add(Block.m_49796_((double)13.0, (double)0.0, (double)13.0, (double)15.0, (double)6.0, (double)15.0));
        shapes.add(Block.m_49796_((double)1.0, (double)0.0, (double)13.0, (double)3.0, (double)6.0, (double)15.0));
        shapes.add(Block.m_49796_((double)1.0, (double)6.0, (double)1.0, (double)15.0, (double)23.0, (double)15.0));
        return VoxelShapeHelper.combineAll(shapes);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return this.SHAPE;
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter reader, BlockPos pos) {
        return this.SHAPE;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)this.m_7246_(state, level, pos), buffer -> {
                List<MailBox> mailBoxes = PostOffice.getMailBoxes(serverPlayer);
                CompoundTag compound = new CompoundTag();
                ListTag mailBoxList = new ListTag();
                mailBoxes.forEach(mailBox -> mailBoxList.add((Object)mailBox.serializeDetails()));
                compound.m_128365_("MailBoxes", (Tag)mailBoxList);
                buffer.m_130079_(compound);
            });
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public MenuProvider m_7246_(BlockState state, Level level, BlockPos pos) {
        return new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new PostBoxMenu(windowId, playerInventory, ContainerLevelAccess.m_39289_((Level)level, (BlockPos)pos), (List<MailBoxEntry>)ImmutableList.of()), TITLE);
    }
}

