/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.gui.group.JoinGroupList;
import de.maxhenkel.voicechat.intercompatibility.ClientCompatibilityManager;
import de.maxhenkel.voicechat.intercompatibility.CommonCompatibilityManager;
import de.maxhenkel.voicechat.voice.common.ClientGroup;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

public class ClientGroupManager {
    private Map<UUID, ClientGroup> groups = new ConcurrentHashMap<UUID, ClientGroup>();

    public ClientGroupManager() {
        CommonCompatibilityManager.INSTANCE.getNetManager().addGroupChannel.setClientListener((client, handler, packet) -> {
            this.groups.put(packet.getGroup().getId(), packet.getGroup());
            Voicechat.LOGGER.debug("Added group '{}' ({})", packet.getGroup().getName(), packet.getGroup().getId());
            JoinGroupList.update();
        });
        CommonCompatibilityManager.INSTANCE.getNetManager().removeGroupChannel.setClientListener((client, handler, packet) -> {
            this.groups.remove(packet.getGroupId());
            Voicechat.LOGGER.debug("Removed group {}", packet.getGroupId());
            JoinGroupList.update();
        });
        ClientCompatibilityManager.INSTANCE.onDisconnect(() -> this.groups.clear());
    }

    @Nullable
    public ClientGroup getGroup(UUID id) {
        return this.groups.get(id);
    }

    public Collection<ClientGroup> getGroups() {
        return this.groups.values();
    }
}

