/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.comforts.common;

import com.illusivesoulworks.comforts.ComfortsConstants;
import com.illusivesoulworks.comforts.common.ComfortsConfig;
import com.illusivesoulworks.comforts.common.block.HammockBlock;
import com.illusivesoulworks.comforts.common.block.SleepingBagBlock;
import com.illusivesoulworks.comforts.platform.Services;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ComfortsEvents {
    private static final List<MobEffectInstance> SLEEPING_BAG_EFFECTS = new ArrayList<MobEffectInstance>();
    static boolean effectsInitialized = false;

    public static boolean canSetSpawn(Player player, BlockPos pos) {
        Level level = player.m_9236_();
        if (pos != null && !player.m_9236_().m_5776_()) {
            Block block = level.m_8055_(pos).m_60734_();
            return !(block instanceof SleepingBagBlock) && !(block instanceof HammockBlock);
        }
        return true;
    }

    public static Result checkTime(Level level, BlockPos pos) {
        long time = level.m_46468_() % 24000L;
        ComfortsConfig.ComfortsTimeUse timeUse = ComfortsConfig.ComfortsTimeUse.NIGHT;
        Block block = level.m_8055_(pos).m_60734_();
        if (block instanceof HammockBlock) {
            timeUse = (ComfortsConfig.ComfortsTimeUse)((Object)ComfortsConfig.SERVER.hammockUse.get());
        } else if (block instanceof SleepingBagBlock) {
            timeUse = (ComfortsConfig.ComfortsTimeUse)((Object)ComfortsConfig.SERVER.sleepingBagUse.get());
        }
        if (time > 500L && time < 11500L && (timeUse == ComfortsConfig.ComfortsTimeUse.DAY || timeUse == ComfortsConfig.ComfortsTimeUse.DAY_OR_NIGHT)) {
            return Result.ALLOW;
        }
        if (timeUse == ComfortsConfig.ComfortsTimeUse.DAY_OR_NIGHT || timeUse == ComfortsConfig.ComfortsTimeUse.NIGHT) {
            return Result.DEFAULT;
        }
        return Result.DENY;
    }

    public static long getWakeTime(ServerLevel level, long currentTime, long newTime) {
        boolean[] daySleeping = new boolean[]{false};
        List players = level.m_6907_();
        for (Player player : players) {
            player.m_21257_().ifPresent(bedPos -> {
                if (player.m_36317_()) {
                    ComfortsConfig.ComfortsTimeUse timeUse = ComfortsConfig.ComfortsTimeUse.NIGHT;
                    Block block = level.m_8055_(bedPos).m_60734_();
                    if (block instanceof HammockBlock) {
                        timeUse = (ComfortsConfig.ComfortsTimeUse)((Object)((Object)ComfortsConfig.SERVER.hammockUse.get()));
                    } else if (block instanceof SleepingBagBlock) {
                        timeUse = (ComfortsConfig.ComfortsTimeUse)((Object)((Object)ComfortsConfig.SERVER.sleepingBagUse.get()));
                    }
                    if (timeUse == ComfortsConfig.ComfortsTimeUse.DAY || timeUse == ComfortsConfig.ComfortsTimeUse.DAY_OR_NIGHT) {
                        daySleeping[0] = true;
                    }
                }
            });
            if (!daySleeping[0]) continue;
            break;
        }
        if (daySleeping[0] && level.m_6018_().m_46461_()) {
            long i = currentTime + 24000L;
            return i - i % 24000L - 12001L;
        }
        return newTime;
    }

    public static void onWakeUp(Player player) {
        Level level = player.m_9236_();
        if (!level.f_46443_) {
            Services.SLEEP_EVENTS.getSleepData(player).ifPresent(data -> player.m_21257_().ifPresent(bedPos -> {
                long wakeTime = level.m_46468_();
                long timeSlept = wakeTime - data.getSleepTime();
                BlockState state = level.m_8055_(bedPos);
                if (state.m_60734_() instanceof SleepingBagBlock) {
                    boolean broke = false;
                    if (timeSlept > 500L) {
                        AttributeInstance attributeInstance;
                        List<MobEffectInstance> effectInstances;
                        if (!effectsInitialized) {
                            ComfortsEvents.initializeEffects();
                            effectsInitialized = true;
                        }
                        if (!(effectInstances = SLEEPING_BAG_EFFECTS).isEmpty()) {
                            for (MobEffectInstance effect : effectInstances) {
                                player.m_7292_(new MobEffectInstance(effect.m_19544_(), effect.m_19557_(), effect.m_19564_()));
                            }
                        }
                        double breakChance = (double)((Integer)ComfortsConfig.SERVER.sleepingBagBreakChance.get()).intValue() / 100.0;
                        double luckMultiplier = (Double)ComfortsConfig.SERVER.sleepingBagBreakChanceLuckMultiplier.get();
                        if (luckMultiplier > 0.0 && (attributeInstance = player.m_21051_(Attributes.f_22286_)) != null) {
                            breakChance -= luckMultiplier * attributeInstance.m_22135_();
                        }
                        if (level.f_46441_.m_188500_() < breakChance) {
                            broke = true;
                            BlockPos blockpos = bedPos.m_121945_(((Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122424_());
                            level.m_7471_(bedPos, false);
                            level.m_7471_(blockpos, false);
                            player.m_5661_((Component)Component.m_237115_((String)"block.comforts.sleeping_bag.broke"), true);
                            level.m_5594_(null, bedPos, SoundEvents.f_12639_, SoundSource.BLOCKS, 1.0f, 1.0f);
                            player.m_21258_();
                        }
                    }
                    if (!broke && data.getAutoSleepPos() != null) {
                        BlockPos blockpos = bedPos.m_121945_(((Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122424_());
                        if (!player.m_7500_()) {
                            level.m_7471_(blockpos, false);
                            level.m_7471_(bedPos, false);
                        } else {
                            level.m_7471_(bedPos, false);
                            level.m_7471_(blockpos, false);
                        }
                        player.m_21258_();
                    }
                }
                data.setWakeTime(wakeTime);
                data.setTiredTime(wakeTime + (long)((double)timeSlept / (Double)ComfortsConfig.SERVER.restMultiplier.get()));
                data.setAutoSleepPos(null);
            }));
        }
    }

    private static void initializeEffects() {
        SLEEPING_BAG_EFFECTS.clear();
        ((List)ComfortsConfig.SERVER.sleepingBagEffects.get()).forEach(effect -> {
            String[] elements = effect.split(";");
            MobEffect mobEffect = Services.REGISTRY_UTIL.getMobEffect(new ResourceLocation(elements[0]));
            if (mobEffect == null) {
                return;
            }
            int duration = 0;
            int amp = 0;
            try {
                duration = Math.max(1, Math.min(Integer.parseInt(elements[1]), 1600));
                amp = Math.max(1, Math.min(Integer.parseInt(elements[2]), 4));
            }
            catch (Exception e) {
                ComfortsConstants.LOG.error("Problem parsing sleeping bag effects in config!", (Throwable)e);
            }
            SLEEPING_BAG_EFFECTS.add(new MobEffectInstance(mobEffect, duration * 20, amp - 1));
        });
    }

    public static Player.BedSleepingProblem onSleep(Player player) {
        if (!player.m_9236_().m_5776_()) {
            return Services.SLEEP_EVENTS.getSleepData(player).map(data -> {
                long dayTime = player.m_20193_().m_46468_();
                data.setSleepTime(dayTime);
                if (((Boolean)ComfortsConfig.SERVER.restrictSleeping.get()).booleanValue()) {
                    if (data.getWakeTime() > dayTime) {
                        data.setWakeTime(0L);
                        data.setTiredTime(0L);
                    }
                    if (data.getTiredTime() > dayTime) {
                        player.m_5661_((Component)Component.m_237115_((String)"capability.comforts.not_sleepy"), true);
                        return Player.BedSleepingProblem.OTHER_PROBLEM;
                    }
                }
                return null;
            }).orElse(null);
        }
        return null;
    }

    public static enum Result {
        ALLOW,
        DEFAULT,
        DENY;

    }
}

