/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.forge.mixin.perf.forge_registry_alloc;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistry;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ForgeRegistry.class}, remap=false)
public abstract class ForgeRegistryMixin<V> {
    @Shadow
    @Final
    private Map<ResourceLocation, Holder.Reference<V>> delegatesByName = new Object2ObjectOpenHashMap();
    @Shadow
    @Final
    private Map<V, Holder.Reference<V>> delegatesByValue = new Object2ObjectOpenHashMap(16, 0.5f);

    @Overwrite
    public Holder.Reference<V> getDelegateOrThrow(ResourceLocation location) {
        Holder.Reference<V> holder = this.delegatesByName.get(location);
        if (holder == null) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "No delegate exists for location %s", location));
        }
        return holder;
    }

    @Overwrite
    public Holder.Reference<V> getDelegateOrThrow(ResourceKey<V> rkey) {
        Holder.Reference<V> holder = this.delegatesByName.get(rkey.m_135782_());
        if (holder == null) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "No delegate exists for key %s", rkey));
        }
        return holder;
    }

    @Overwrite
    public Holder.Reference<V> getDelegateOrThrow(V value) {
        Holder.Reference<V> holder = this.delegatesByValue.get(value);
        if (holder == null) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "No delegate exists for value %s", value));
        }
        return holder;
    }
}

