/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import org.joml.Matrix4f;

public class SpriteRenderer {
    private final Matrix4f transform;
    private final VertexConsumer builder;
    private final int light;
    private final int z;
    private final int r;
    private final int g;
    private final int b;

    public SpriteRenderer(Matrix4f transform, VertexConsumer builder, int z, int light, int r, int g, int b) {
        this.transform = transform;
        this.builder = builder;
        this.z = z;
        this.light = light;
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public static SpriteRenderer createForGui(GuiGraphics graphics, RenderType renderType) {
        return new SpriteRenderer(graphics.m_280168_().m_85850_().m_252922_(), graphics.m_280091_().m_6299_(renderType), 0, 0xF000F0, 255, 255, 255);
    }

    public void blit(TextureAtlasSprite sprite, int x, int y, int width, int height) {
        this.blit(x, y, width, height, sprite.m_118409_(), sprite.m_118411_(), sprite.m_118410_(), sprite.m_118412_());
    }

    public void blitHorizontalSliced(TextureAtlasSprite sprite, int x, int y, int width, int height, int leftBorder, int rightBorder, int textureWidth) {
        if (width < leftBorder + rightBorder) {
            throw new IllegalArgumentException("width is less than two borders");
        }
        float centerStart = SpriteRenderer.u(sprite, leftBorder, textureWidth);
        float centerEnd = SpriteRenderer.u(sprite, textureWidth - rightBorder, textureWidth);
        this.blit(x, y, leftBorder, height, sprite.m_118409_(), sprite.m_118411_(), centerStart, sprite.m_118412_());
        this.blit(x + leftBorder, y, width - leftBorder - rightBorder, height, centerStart, sprite.m_118411_(), centerEnd, sprite.m_118412_());
        this.blit(x + width - rightBorder, y, rightBorder, height, centerEnd, sprite.m_118411_(), sprite.m_118410_(), sprite.m_118412_());
    }

    public void blitVerticalSliced(TextureAtlasSprite sprite, int x, int y, int width, int height, int topBorder, int bottomBorder, int textureHeight) {
        if (width < topBorder + bottomBorder) {
            throw new IllegalArgumentException("height is less than two borders");
        }
        float centerStart = SpriteRenderer.v(sprite, topBorder, textureHeight);
        float centerEnd = SpriteRenderer.v(sprite, textureHeight - bottomBorder, textureHeight);
        this.blit(x, y, width, topBorder, sprite.m_118409_(), sprite.m_118411_(), sprite.m_118410_(), centerStart);
        this.blit(x, y + topBorder, width, height - topBorder - bottomBorder, sprite.m_118409_(), centerStart, sprite.m_118410_(), centerEnd);
        this.blit(x, y + height - bottomBorder, width, bottomBorder, sprite.m_118409_(), centerEnd, sprite.m_118410_(), sprite.m_118412_());
    }

    public void blit(int x, int y, int width, int height, float u0, float v0, float u1, float v1) {
        this.builder.m_252986_(this.transform, (float)x, (float)(y + height), (float)this.z).m_6122_(this.r, this.g, this.b, 255).m_7421_(u0, v1).m_85969_(this.light).m_5752_();
        this.builder.m_252986_(this.transform, (float)(x + width), (float)(y + height), (float)this.z).m_6122_(this.r, this.g, this.b, 255).m_7421_(u1, v1).m_85969_(this.light).m_5752_();
        this.builder.m_252986_(this.transform, (float)(x + width), (float)y, (float)this.z).m_6122_(this.r, this.g, this.b, 255).m_7421_(u1, v0).m_85969_(this.light).m_5752_();
        this.builder.m_252986_(this.transform, (float)x, (float)y, (float)this.z).m_6122_(this.r, this.g, this.b, 255).m_7421_(u0, v0).m_85969_(this.light).m_5752_();
    }

    public static float u(TextureAtlasSprite sprite, int x, int width) {
        return sprite.m_118367_((double)x / (double)width * 16.0);
    }

    public static float v(TextureAtlasSprite sprite, int y, int height) {
        return sprite.m_118393_((double)y / (double)height * 16.0);
    }
}

