/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.filesystem;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import dan200.computercraft.core.apis.handles.ArrayByteChannel;
import dan200.computercraft.core.filesystem.AbstractInMemoryMount;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.util.concurrent.TimeUnit;

public abstract class ArchiveMount<T extends FileEntry<T>>
extends AbstractInMemoryMount<T> {
    private static final int MAX_CACHE_SIZE = 0x4000000;
    private static final Cache<FileEntry<?>, byte[]> CONTENTS_CACHE = CacheBuilder.newBuilder().concurrencyLevel(4).expireAfterAccess(60L, TimeUnit.SECONDS).maximumWeight(0x4000000L).weakKeys().weigher((k, v) -> ((byte[])v).length).build();

    @Override
    protected final long getSize(String path, T file) throws IOException {
        if (((FileEntry)file).size != -1L) {
            return ((FileEntry)file).size;
        }
        if (((AbstractInMemoryMount.FileEntry)file).isDirectory()) {
            ((FileEntry)file).size = 0L;
            return 0L;
        }
        byte[] contents = (byte[])CONTENTS_CACHE.getIfPresent(file);
        ((FileEntry)file).size = contents != null ? (long)contents.length : this.getFileSize(path, file);
        return ((FileEntry)file).size;
    }

    protected long getFileSize(String path, T file) throws IOException {
        return this.getContents(path, file).length;
    }

    @Override
    protected final SeekableByteChannel openForRead(String path, T file) throws IOException {
        return new ArrayByteChannel(this.getContents(path, file));
    }

    private byte[] getContents(String path, T file) throws IOException {
        byte[] cachedContents = (byte[])CONTENTS_CACHE.getIfPresent(file);
        if (cachedContents != null) {
            return cachedContents;
        }
        byte[] contents = this.getFileContents(path, file);
        CONTENTS_CACHE.put(file, (Object)contents);
        return contents;
    }

    protected abstract byte[] getFileContents(String var1, T var2) throws IOException;

    protected static class FileEntry<T extends FileEntry<T>>
    extends AbstractInMemoryMount.FileEntry<T> {
        long size = -1L;

        protected FileEntry() {
        }
    }
}

