/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.core;

import com.google.common.annotations.VisibleForTesting;
import dan200.computercraft.api.filesystem.FileOperationException;
import dan200.computercraft.core.filesystem.AbstractInMemoryMount;
import dan200.computercraft.core.filesystem.ArchiveMount;
import dan200.computercraft.core.filesystem.FileSystem;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourceMount
extends ArchiveMount<FileEntry> {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceMount.class);
    private static final Map<ResourceLocation, ResourceMount> MOUNT_CACHE = new HashMap<ResourceLocation, ResourceMount>(2);
    private final String namespace;
    private final String subPath;
    private ResourceManager manager;
    public static final SimplePreparableReloadListener<Void> RELOAD_LISTENER = new SimplePreparableReloadListener<Void>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Void prepare(ResourceManager manager, ProfilerFiller profiler) {
            profiler.m_6180_("Reloading ComputerCraft mounts");
            try {
                for (ResourceMount mount : MOUNT_CACHE.values()) {
                    mount.load(manager);
                }
            }
            finally {
                profiler.m_7238_();
            }
            return null;
        }

        protected void apply(Void result, ResourceManager manager, ProfilerFiller profiler) {
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceMount get(String namespace, String subPath, ResourceManager manager) {
        ResourceLocation path = new ResourceLocation(namespace, subPath);
        Map<ResourceLocation, ResourceMount> map = MOUNT_CACHE;
        synchronized (map) {
            ResourceMount mount = MOUNT_CACHE.get(path);
            if (mount == null) {
                mount = new ResourceMount(namespace, subPath, manager);
                MOUNT_CACHE.put(path, mount);
            }
            return mount;
        }
    }

    @VisibleForTesting
    ResourceMount(String namespace, String subPath, ResourceManager manager) {
        this.namespace = namespace;
        this.subPath = subPath;
        this.load(manager);
    }

    private void load(ResourceManager manager) {
        boolean hasAny = false;
        String existingNamespace = null;
        FileEntry newRoot = new FileEntry(new ResourceLocation(this.namespace, this.subPath));
        for (ResourceLocation file : manager.m_214159_(this.subPath, s -> true).keySet()) {
            existingNamespace = file.m_135827_();
            if (!file.m_135827_().equals(this.namespace) || !FileSystem.contains(this.subPath, file.m_135815_())) continue;
            String localPath = FileSystem.toLocal(file.m_135815_(), this.subPath);
            try {
                this.getOrCreateChild(newRoot, localPath, this::createEntry);
            }
            catch (ResourceLocationException e) {
                LOG.warn("Cannot create resource location for {} ({})", (Object)localPath, (Object)e.getMessage());
            }
            hasAny = true;
        }
        this.manager = manager;
        AbstractInMemoryMount.FileEntry fileEntry = this.root = hasAny ? newRoot : null;
        if (!hasAny) {
            LOG.warn("Cannot find any files under /data/{}/{} for resource mount.", (Object)this.namespace, (Object)this.subPath);
            if (existingNamespace != null) {
                LOG.warn("There are files under /data/{}/{} though. Did you get the wrong namespace?", (Object)existingNamespace, (Object)this.subPath);
            }
        }
    }

    private FileEntry createEntry(String path) {
        return new FileEntry(new ResourceLocation(this.namespace, this.subPath + "/" + path));
    }

    @Override
    protected byte[] getFileContents(String path, FileEntry file) throws IOException {
        Resource resource = this.manager.m_213713_(file.identifier).orElse(null);
        if (resource == null) {
            throw new FileOperationException(path, "No such file");
        }
        try (InputStream stream = resource.m_215507_();){
            byte[] byArray = stream.readAllBytes();
            return byArray;
        }
    }

    protected static final class FileEntry
    extends ArchiveMount.FileEntry<FileEntry> {
        final ResourceLocation identifier;

        FileEntry(ResourceLocation identifier) {
            this.identifier = identifier;
        }
    }
}

