/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.client;

import dan200.computercraft.shared.network.MessageType;
import dan200.computercraft.shared.network.NetworkMessage;
import dan200.computercraft.shared.network.NetworkMessages;
import dan200.computercraft.shared.network.client.ClientNetworkContext;
import dan200.computercraft.shared.peripheral.speaker.SpeakerPosition;
import java.nio.ByteBuffer;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;

public class SpeakerAudioClientMessage
implements NetworkMessage<ClientNetworkContext> {
    private final UUID source;
    private final SpeakerPosition.Message pos;
    private final ByteBuffer content;
    private final float volume;

    public SpeakerAudioClientMessage(UUID source, SpeakerPosition pos, float volume, ByteBuffer content) {
        this.source = source;
        this.pos = pos.asMessage();
        this.content = content;
        this.volume = volume;
    }

    public SpeakerAudioClientMessage(FriendlyByteBuf buf) {
        this.source = buf.m_130259_();
        this.pos = SpeakerPosition.Message.read(buf);
        this.volume = buf.readFloat();
        byte[] bytes = new byte[buf.readableBytes()];
        buf.readBytes(bytes);
        this.content = ByteBuffer.wrap(bytes);
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130077_(this.source);
        this.pos.write(buf);
        buf.writeFloat(this.volume);
        buf.writeBytes(this.content.duplicate());
    }

    @Override
    public void handle(ClientNetworkContext context) {
        context.handleSpeakerAudio(this.source, this.pos, this.volume, this.content);
    }

    @Override
    public MessageType<SpeakerAudioClientMessage> type() {
        return NetworkMessages.SPEAKER_AUDIO;
    }
}

