/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.monitor;

import dan200.computercraft.shared.computer.terminal.TerminalState;
import dan200.computercraft.shared.config.Config;
import dan200.computercraft.shared.network.client.MonitorClientMessage;
import dan200.computercraft.shared.network.server.ServerNetworking;
import dan200.computercraft.shared.peripheral.monitor.MonitorBlockEntity;
import dan200.computercraft.shared.peripheral.monitor.ServerMonitor;
import java.util.ArrayDeque;
import java.util.Queue;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;

public final class MonitorWatcher {
    private static final Queue<MonitorBlockEntity> watching = new ArrayDeque<MonitorBlockEntity>();

    private MonitorWatcher() {
    }

    static void enqueue(MonitorBlockEntity monitor) {
        if (monitor.enqueued) {
            return;
        }
        monitor.enqueued = true;
        monitor.cached = null;
        watching.add(monitor);
    }

    public static void onWatch(LevelChunk chunk, ServerPlayer player) {
        for (BlockEntity te : chunk.m_62954_().values()) {
            MonitorBlockEntity monitor;
            ServerMonitor serverMonitor;
            if (!(te instanceof MonitorBlockEntity) || (serverMonitor = MonitorWatcher.getMonitor(monitor = (MonitorBlockEntity)te)) == null || monitor.enqueued) continue;
            TerminalState state = MonitorWatcher.getState(monitor, serverMonitor);
            ServerNetworking.sendToPlayer(new MonitorClientMessage(monitor.m_58899_(), state), player);
        }
    }

    public static void onTick() {
        MonitorBlockEntity tile;
        boolean obeyLimit;
        long limit = Config.monitorBandwidth;
        boolean bl = obeyLimit = limit > 0L;
        while (!(obeyLimit && limit <= 0L || (tile = watching.poll()) == null)) {
            LevelChunk chunk;
            tile.enqueued = false;
            ServerMonitor monitor = MonitorWatcher.getMonitor(tile);
            if (monitor == null) continue;
            BlockPos pos = tile.m_58899_();
            Level world = tile.m_58904_();
            if (!(world instanceof ServerLevel) || ((ServerLevel)world).m_7726_().f_8325_.m_183262_((chunk = world.m_46745_(pos)).m_7697_(), false).isEmpty()) continue;
            TerminalState state = MonitorWatcher.getState(tile, monitor);
            ServerNetworking.sendToAllTracking(new MonitorClientMessage(pos, state), chunk);
            limit -= (long)state.size();
        }
    }

    @Nullable
    private static ServerMonitor getMonitor(MonitorBlockEntity monitor) {
        return !monitor.m_58901_() && monitor.getXIndex() == 0 && monitor.getYIndex() == 0 ? monitor.getCachedServerMonitor() : null;
    }

    private static TerminalState getState(MonitorBlockEntity tile, ServerMonitor monitor) {
        TerminalState state = tile.cached;
        if (state == null) {
            state = tile.cached = new TerminalState(monitor.getTerminal());
        }
        return state;
    }
}

