/*
 * Decompiled with CFR 0.152.
 */
package doggytalents;

import doggytalents.common.entity.Dog;
import doggytalents.common.inventory.container.DogArmorContainer;
import doggytalents.common.inventory.container.DogInventoriesContainer;
import doggytalents.common.inventory.container.DoggyToolsMenu;
import doggytalents.common.inventory.container.FoodBowlContainer;
import doggytalents.common.inventory.container.PackPuppyContainer;
import doggytalents.common.inventory.container.RiceMillMenu;
import doggytalents.common.inventory.container.TreatBagContainer;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.network.IContainerFactory;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class DoggyContainerTypes {
    public static final DeferredRegister<MenuType<?>> CONTAINERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.MENU_TYPES, (String)"doggytalents");
    public static final RegistryObject<MenuType<FoodBowlContainer>> FOOD_BOWL = DoggyContainerTypes.register("food_bowl", (windowId, inv, data) -> {
        BlockPos pos = data.m_130135_();
        return new FoodBowlContainer(windowId, inv.f_35978_.m_9236_(), pos, inv, inv.f_35978_);
    });
    public static final RegistryObject<MenuType<PackPuppyContainer>> PACK_PUPPY = DoggyContainerTypes.register("pack_puppy", (windowId, inv, data) -> {
        Entity entity = inv.f_35978_.m_9236_().m_6815_(data.readInt());
        return entity instanceof Dog ? new PackPuppyContainer(windowId, inv, (Dog)entity) : null;
    });
    public static final RegistryObject<MenuType<TreatBagContainer>> TREAT_BAG = DoggyContainerTypes.register("treat_bag", (windowId, inv, data) -> {
        byte slotId = data.readByte();
        return new TreatBagContainer(windowId, inv, slotId, data.m_130267_());
    });
    public static final RegistryObject<MenuType<DogInventoriesContainer>> DOG_INVENTORIES = DoggyContainerTypes.register("dog_inventories", (windowId, inv, data) -> {
        int noDogs = data.readInt();
        ArrayList<Dog> dogs = new ArrayList<Dog>(noDogs);
        SimpleContainerData array = new SimpleContainerData(noDogs);
        for (int i = 0; i < noDogs; ++i) {
            Entity entity = inv.f_35978_.m_9236_().m_6815_(data.readInt());
            if (!(entity instanceof Dog)) continue;
            dogs.add((Dog)entity);
            array.m_8050_(i, entity.m_19879_());
        }
        return !dogs.isEmpty() ? new DogInventoriesContainer(windowId, inv, array) : null;
    });
    public static final RegistryObject<MenuType<DogArmorContainer>> DOG_ARMOR = DoggyContainerTypes.register("dog_armor", (windowId, inv, data) -> {
        int dogId = data.readInt();
        Entity e = inv.f_35978_.m_9236_().m_6815_(dogId);
        if (!(e instanceof Dog)) {
            return null;
        }
        return new DogArmorContainer(windowId, inv, (Dog)e);
    });
    public static final RegistryObject<MenuType<DoggyToolsMenu>> DOG_TOOLS = DoggyContainerTypes.register("dog_tools", (windowId, inv, data) -> {
        int dogId = data.readInt();
        Entity e = inv.f_35978_.m_9236_().m_6815_(dogId);
        if (!(e instanceof Dog)) {
            return null;
        }
        return new DoggyToolsMenu(windowId, inv, (Dog)e);
    });
    public static final RegistryObject<MenuType<RiceMillMenu>> RICE_MILL = DoggyContainerTypes.register("rice_mill", (windowId, inv, data) -> {
        BlockPos pos = data.m_130135_();
        return new RiceMillMenu(windowId, inv, pos);
    });

    private static <X extends AbstractContainerMenu, T extends MenuType<X>> RegistryObject<MenuType<X>> register(String name, IContainerFactory<X> factory) {
        return DoggyContainerTypes.register(name, () -> IForgeMenuType.create((IContainerFactory)factory));
    }

    private static <T extends MenuType<?>> RegistryObject<T> register(String name, Supplier<T> sup) {
        return CONTAINERS.register(name, sup);
    }
}

