/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client;

import com.google.common.collect.Maps;
import com.google.common.hash.Hashing;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import doggytalents.client.ClientSetup;
import doggytalents.client.entity.model.DogModelRegistry;
import doggytalents.client.entity.skin.DogSkin;
import doggytalents.common.entity.Dog;
import doggytalents.common.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DogTextureManager
extends SimplePreparableReloadListener<Preparations> {
    public static final Logger LOGGER = LogManager.getLogger((String)"doggytalents/dogSkin");
    public static final DogTextureManager INSTANCE = new DogTextureManager();
    private static final Gson GSON = new Gson();
    protected final Map<String, DogSkin> skinHashToLoc = Maps.newHashMap();
    protected final Map<DogSkin, String> locToSkinHash = Maps.newHashMap();
    protected final List<DogSkin> customSkinLoc = new ArrayList<DogSkin>(20);

    public List<DogSkin> getAll() {
        return Collections.unmodifiableList(this.customSkinLoc);
    }

    public DogSkin getDogSkin(String hash) {
        return this.skinHashToLoc.getOrDefault(hash, DogSkin.MISSING);
    }

    public String getHash(DogSkin loc) {
        return this.locToSkinHash.getOrDefault(loc, "");
    }

    public ResourceLocation getTexture(Dog dog) {
        DogSkin skin = dog.getClientSkin();
        return skin.getPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized RegisterState registerDogSkin(Preparations prep, Resource resource, DogSkin dogSkin) {
        RegisterState state = RegisterState.FAIL;
        InputStream inputstream = null;
        try {
            inputstream = resource.m_215507_();
            String hash = this.computeHash(IOUtils.toByteArray((InputStream)inputstream));
            if (prep.skinHashToLoc.containsKey(hash)) {
                state = RegisterState.DUPLICATE;
            } else {
                prep.skinHashToLoc.put(hash, dogSkin);
                prep.locToSkinHash.put(dogSkin, hash);
                prep.customSkinLoc.add(dogSkin);
                state = RegisterState.SUCCESS;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputstream);
        }
        return state;
    }

    public String computeHash(byte[] targetArray) {
        return Hashing.sha1().hashBytes(targetArray).toString();
    }

    protected Preparations prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        Preparations prep = new Preparations();
        profiler.m_7242_();
        this.getSkinFromSkinJsonAllPack(resourceManager, prep);
        profiler.m_7238_();
        profiler.m_7241_();
        return prep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean getSkinFromSkinJsonAllPack(ResourceManager resMan, Preparations prep) {
        ResourceLocation SKIN_JSON_RES = Util.getResource("textures/entity/dog/skin.json");
        List jsonSkinPacks = resMan.m_7536_().collect(Collectors.toList());
        for (PackResources jsonSkinPack : jsonSkinPacks) {
            InputStream istream = null;
            try {
                IoSupplier packRes = jsonSkinPack.m_214146_(PackType.CLIENT_RESOURCES, SKIN_JSON_RES);
                if (packRes == null) continue;
                istream = (InputStream)packRes.m_247737_();
                JsonElement jsonElement = (JsonElement)GSON.fromJson((Reader)new InputStreamReader(istream, StandardCharsets.UTF_8), JsonElement.class);
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                RegsiterResult result = this.getSkinFromSkinJson(resMan, prep, jsonObject);
                if (result.success > 0) {
                    LOGGER.info("Successfully registered " + result.success + " entries from pack [" + jsonSkinPack.m_5542_() + "]");
                }
                if (result.duplicates > 0) {
                    LOGGER.warn("Pack [" + jsonSkinPack.m_5542_() + "] contains " + result.duplicates + " duplicated entries. Those will be omitted.");
                }
                IOUtils.closeQuietly((InputStream)istream);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                IOUtils.closeQuietly(istream);
            }
        }
        this.getSkinJsonFromOtherMods(resMan, prep);
        prep.customSkinLoc.add(0, DogSkin.CLASSICAL);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSkinJsonFromOtherMods(ResourceManager resMan, Preparations prep) {
        List<ResourceLocation> paths = ClientSetup.OTHER_MOD_SKIN_JSONS;
        if (paths.isEmpty()) {
            return;
        }
        for (ResourceLocation path : paths) {
            InputStream istream = null;
            try {
                Optional res = resMan.m_213713_(path);
                if (res.isEmpty()) continue;
                istream = ((Resource)res.get()).m_215507_();
                JsonElement jsonElement = (JsonElement)GSON.fromJson((Reader)new InputStreamReader(istream, StandardCharsets.UTF_8), JsonElement.class);
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                RegsiterResult result = this.getSkinFromSkinJson(resMan, prep, jsonObject);
                if (result.success > 0) {
                    LOGGER.info("Successfully registered " + result.success + " entries from path [" + path + "]");
                }
                if (result.duplicates > 0) {
                    LOGGER.warn("Path [" + path + "] contains " + result.duplicates + " duplicated entries. Those will be omitted.");
                }
                IOUtils.closeQuietly((InputStream)istream);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                IOUtils.closeQuietly(istream);
            }
        }
    }

    public RegsiterResult getSkinFromSkinJson(ResourceManager resMan, Preparations prep, JsonObject jsonObject) {
        int success_cnt = 0;
        int duplicate_cnt = 0;
        int failed_cnt = 0;
        JsonArray skinEntries = jsonObject.get("dog_skins").getAsJsonArray();
        block4: for (JsonElement skinEntry : skinEntries) {
            DogSkin skin;
            JsonObject skinObject = skinEntry.getAsJsonObject();
            String name = skinObject.get("skin_name").getAsString();
            String id = skinObject.get("skin_id").getAsString();
            String use_model = skinObject.get("use_model").getAsString();
            ResourceLocation text_rl = id.indexOf(58) >= 0 ? new ResourceLocation(id + ".png") : Util.getResource("textures/entity/dog/custom/" + id + ".png");
            if (use_model == null || use_model.equals("default") || use_model.equals("")) {
                skin = new DogSkin(text_rl).setName(name);
            } else if (use_model.equals("variant")) {
                JsonElement earOptional;
                dogModel = DogModelRegistry.getDogModelHolder(use_model);
                skin = dogModel == null ? new DogSkin(text_rl).setName(name) : new DogSkin(text_rl, dogModel).setName(name);
                JsonElement tailOptional = skinObject.get("tail_id");
                if (tailOptional != null) {
                    skin.setTail(tailOptional.getAsByte());
                }
                if ((earOptional = skinObject.get("ear_id")) != null) {
                    skin.setEar(earOptional.getAsByte());
                }
            } else {
                dogModel = DogModelRegistry.getDogModelHolder(use_model);
                skin = dogModel == null ? new DogSkin(text_rl).setName(name) : new DogSkin(text_rl, dogModel).setName(name);
            }
            this.readSkinExtraInfo(skin, skinObject);
            RegisterState state = RegisterState.FAIL;
            Optional res = resMan.m_213713_(text_rl);
            if (res.isPresent()) {
                state = this.registerDogSkin(prep, (Resource)res.get(), skin);
            }
            switch (state) {
                case SUCCESS: {
                    ++success_cnt;
                    continue block4;
                }
                case DUPLICATE: {
                    ++duplicate_cnt;
                    continue block4;
                }
            }
            ++failed_cnt;
        }
        return new RegsiterResult(success_cnt, duplicate_cnt, failed_cnt);
    }

    private void readSkinExtraInfo(DogSkin skin, JsonObject skinJsonObject) {
        JsonElement mystery;
        JsonElement tags;
        JsonElement desc;
        JsonElement based_on;
        JsonElement author = skinJsonObject.get("author");
        if (author != null) {
            skin.setAuthor(author.getAsString());
        }
        if ((based_on = skinJsonObject.get("based_on")) != null) {
            skin.setBasedOn(based_on.getAsString());
        }
        if ((desc = skinJsonObject.get("description")) != null) {
            skin.setDesc(desc.getAsString());
        }
        if ((tags = skinJsonObject.get("tags")) != null) {
            skin.setTags(tags.getAsString());
        }
        if ((mystery = skinJsonObject.get("mystery")) != null) {
            skin.setMystery(mystery.getAsBoolean());
        }
    }

    protected void apply(Preparations prep, ResourceManager resourceManager, ProfilerFiller profiler) {
        prep.apply(this);
    }

    public String m_7812_() {
        return "DogTextureManager";
    }

    private static enum RegisterState {
        SUCCESS,
        DUPLICATE,
        FAIL;

    }

    protected static class Preparations {
        private final Map<String, DogSkin> skinHashToLoc = new HashMap<String, DogSkin>();
        private final Map<DogSkin, String> locToSkinHash = new HashMap<DogSkin, String>();
        private final List<DogSkin> customSkinLoc = new ArrayList<DogSkin>();

        protected Preparations() {
        }

        public void apply(DogTextureManager dogTextureManager) {
            dogTextureManager.skinHashToLoc.clear();
            dogTextureManager.customSkinLoc.clear();
            dogTextureManager.skinHashToLoc.putAll(this.skinHashToLoc);
            dogTextureManager.locToSkinHash.putAll(this.locToSkinHash);
            dogTextureManager.customSkinLoc.addAll(this.customSkinLoc);
        }
    }

    private record RegsiterResult(int success, int duplicates, int fail) {
    }
}

