/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.render.world;

import com.mojang.blaze3d.vertex.PoseStack;
import doggytalents.client.entity.render.RenderUtil;
import doggytalents.common.entity.Dog;
import doggytalents.common.item.CanineTrackerItem;
import doggytalents.common.lib.Resources;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.CanineTrackerData;
import doggytalents.common.util.Util;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.network.PacketDistributor;

public class CanineTrackerLocateRenderer {
    private static ResourceLocation DEFAULT_0 = new ResourceLocation("default/0");
    private static boolean locating;
    private static UUID locatingUUID;
    private static String locatingName;
    private static BlockPos locatingPos;
    private static int locateColor;
    private static WeakReference<Dog> cachedDog;

    public static void onWorldRenderLast(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        if (!locating) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && player.m_5833_()) {
            return;
        }
        Vec3 dog_pos = null;
        if (cachedDog.get() != null) {
            double d0 = Mth.m_14139_((double)event.getPartialTick(), (double)((Dog)CanineTrackerLocateRenderer.cachedDog.get()).f_19790_, (double)((Dog)cachedDog.get()).m_20185_());
            double d1 = Mth.m_14139_((double)event.getPartialTick(), (double)((Dog)CanineTrackerLocateRenderer.cachedDog.get()).f_19791_, (double)((Dog)cachedDog.get()).m_20186_());
            double d2 = Mth.m_14139_((double)event.getPartialTick(), (double)((Dog)CanineTrackerLocateRenderer.cachedDog.get()).f_19792_, (double)((Dog)cachedDog.get()).m_20189_());
            dog_pos = new Vec3(d0, d1 + 1.0, d2);
        } else {
            dog_pos = new Vec3((double)locatingPos.m_123341_(), (double)(locatingPos.m_123342_() + 1), (double)locatingPos.m_123343_());
        }
        Camera camera = event.getCamera();
        Vec3 camera_pos = camera.m_90583_().m_82520_(0.0, -0.2, 0.0);
        Vec3 off_dog_camera = dog_pos.m_82546_(camera_pos);
        double d_dog_camera = off_dog_camera.m_82553_();
        Vec3 off_txt = off_dog_camera;
        if (d_dog_camera > 5.0) {
            off_txt = off_txt.m_82541_().m_82490_(5.0);
        }
        CanineTrackerLocateRenderer.drawFloatingDistanceText(locatingName, event.getPoseStack(), d_dog_camera, off_txt, camera);
    }

    public static void drawFloatingDistanceText(String name, PoseStack stack, double distance, Vec3 off_from_player, Camera camera) {
        stack.m_85836_();
        stack.m_85837_(off_from_player.m_7096_(), off_from_player.m_7098_(), off_from_player.m_7094_());
        stack.m_252781_(camera.m_253121_());
        stack.m_85841_(-0.02f, -0.02f, 0.02f);
        Font font = Minecraft.m_91087_().f_91062_;
        Object dog_name = name;
        if (((String)dog_name).length() > 14) {
            dog_name = ((String)dog_name).substring(0, 14) + "..";
        }
        int hl_color = CanineTrackerLocateRenderer.getHighlightColor(distance);
        MutableComponent line1 = Component.m_237110_((String)"item.doggytalents.radar.locate.line1", (Object[])new Object[]{Component.m_237113_((String)dog_name).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)))});
        MutableComponent line2 = null;
        line2 = distance < 5.0 ? Component.m_237115_((String)"item.doggytalents.radar.locate.line2.close").m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_178520_(hl_color)) : Component.m_237110_((String)"item.doggytalents.radar.locate.line2.far", (Object[])new Object[]{Component.m_237113_((String)("" + Mth.m_14165_((double)distance))).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_178520_(hl_color))});
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        bufferSource.m_6299_(RenderType.m_110497_((ResourceLocation)Resources.SMALL_WIDGETS));
        float tX = -font.m_92852_((FormattedText)line1) / 2;
        float tY = 0.0f;
        font.m_272077_((Component)line1, tX, tY, -1, false, stack.m_85850_().m_252922_(), (MultiBufferSource)bufferSource, Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
        tX = -font.m_92852_((FormattedText)line2) / 2;
        Objects.requireNonNull(font);
        font.m_272077_((Component)line2, tX, tY += (float)(9 + 3), -1, false, stack.m_85850_().m_252922_(), (MultiBufferSource)bufferSource, Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
        bufferSource.m_173043_();
        stack.m_85849_();
    }

    public static int getHighlightColor(double distance) {
        int main_color = locateColor == 0 ? -5586 : locateColor;
        int[] main_color3 = Util.rgbIntToIntArray(main_color);
        if (distance >= 160.0) {
            return -1;
        }
        if ((distance -= 32.0) <= 0.0) {
            return main_color;
        }
        double progress = Mth.m_14008_((double)((128.0 - distance) / 128.0), (double)0.0, (double)1.0);
        int[] color = new int[]{255, 255, 255};
        color[0] = (int)((double)color[0] + (double)(main_color3[0] - 255) * progress);
        color[1] = (int)((double)color[1] + (double)(main_color3[1] - 255) * progress);
        color[2] = (int)((double)color[2] + (double)(main_color3[2] - 255) * progress);
        return 0xFF000000 | RenderUtil.rgbToInt(color);
    }

    public static void tickUpdate(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || mc.f_91073_ == null) {
            return;
        }
        if (player.f_19797_ % 4 != 0) {
            return;
        }
        Optional<CompoundTag> tagOptional = CanineTrackerLocateRenderer.getRadarTagIfHoldingAndExist((Player)player);
        if (locating) {
            if (tagOptional.isEmpty()) {
                CanineTrackerLocateRenderer.stopLocating();
                return;
            }
            CompoundTag tag = tagOptional.get();
            if (!tag.m_128342_("uuid").equals(locatingUUID)) {
                CanineTrackerLocateRenderer.setLocating(tag);
            }
            CanineTrackerLocateRenderer.updateCache((Player)player);
            if (player.f_19797_ % 256 == 0) {
                CanineTrackerLocateRenderer.requestServerForPosUpdate();
            }
        } else {
            if (tagOptional.isEmpty()) {
                return;
            }
            CompoundTag tag = tagOptional.get();
            CanineTrackerLocateRenderer.setLocating(tag);
        }
    }

    private static void updateCache(Player player) {
        if (cachedDog.get() != null && (((Dog)cachedDog.get()).m_213877_() || !((Dog)cachedDog.get()).m_20148_().equals(locatingUUID))) {
            cachedDog = new WeakReference<Object>(null);
        }
        if (locatingUUID == null || player.f_19797_ % 8 != 0) {
            return;
        }
        List dogs = player.m_9236_().m_6443_(Dog.class, player.m_20191_().m_82377_(24.0, 8.0, 24.0), dog -> dog.m_20148_().equals(locatingUUID));
        if (!dogs.isEmpty()) {
            cachedDog = new WeakReference<Dog>((Dog)dogs.get(0));
        }
    }

    private static Optional<CompoundTag> getRadarTagIfHoldingAndExist(Player player) {
        ItemStack item_main = player.m_21120_(InteractionHand.MAIN_HAND);
        ItemStack item_off = player.m_21120_(InteractionHand.OFF_HAND);
        ItemStack radar = null;
        if (item_main.m_41720_() instanceof CanineTrackerItem) {
            radar = item_main;
        } else if (item_off.m_41720_() instanceof CanineTrackerItem) {
            radar = item_off;
        }
        if (radar == null) {
            return Optional.empty();
        }
        if (!radar.m_41782_()) {
            return Optional.empty();
        }
        CompoundTag tag = radar.m_41783_();
        if (tag == null || !tag.m_128403_("uuid")) {
            return Optional.empty();
        }
        return Optional.of(tag);
    }

    private static void requestServerForPosUpdate() {
        if (locatingUUID == null) {
            return;
        }
        if (locatingPos == null) {
            return;
        }
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new CanineTrackerData.RequestPosUpdateData(locatingUUID, locatingPos));
    }

    public static void correctPos(UUID uuid, BlockPos pos) {
        if (!locating) {
            return;
        }
        if (uuid == null) {
            return;
        }
        if (!uuid.equals(locatingUUID)) {
            return;
        }
        locatingPos = pos;
    }

    public static void setLocating(CompoundTag tag) {
        UUID uuid = tag.m_128342_("uuid");
        String name = tag.m_128461_("name");
        int posX = tag.m_128451_("posX");
        int posY = tag.m_128451_("posY");
        int posZ = tag.m_128451_("posZ");
        int color = tag.m_128451_("locateColor");
        CanineTrackerLocateRenderer.setLocating(uuid, name, new BlockPos(posX, posY, posZ), color);
    }

    public static void setLocating(UUID id, String name, BlockPos pos, int color) {
        if (id == null || name == null || pos == null) {
            return;
        }
        locating = true;
        locatingUUID = id;
        locatingName = name;
        locatingPos = pos;
        locateColor = color;
        if (cachedDog.get() != null && (((Dog)cachedDog.get()).m_213877_() || !((Dog)cachedDog.get()).m_20148_().equals(locatingUUID))) {
            cachedDog = new WeakReference<Object>(null);
        }
    }

    public static void stopLocating() {
        locating = false;
        locatingUUID = null;
        locatingName = null;
        locatingPos = null;
        locateColor = 0;
    }

    static {
        cachedDog = new WeakReference<Object>(null);
    }
}

