/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen.AmnesiaBoneScreen.element.view.GeneralView;

import doggytalents.api.feature.DogSize;
import doggytalents.client.entity.render.DogScreenOverlays;
import doggytalents.client.screen.framework.element.AbstractElement;
import doggytalents.common.entity.Dog;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;

public class DogStatusViewBoxElement
extends AbstractElement {
    private Dog dog;
    private Font font;

    public DogStatusViewBoxElement(AbstractElement parent, Screen screen, Dog dog) {
        super(parent, screen);
        this.dog = dog;
        Minecraft mc = this.getScreen().getMinecraft();
        this.font = mc.f_91062_;
    }

    @Override
    public void renderElement(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int e_mX = this.getRealX() + this.getSizeX() / 2;
        int e_mY = this.getRealY() + this.getSizeY() / 2;
        DogStatusViewBoxElement.renderDogInside(graphics, this.dog, e_mX, e_mY + 32, 50, e_mX - mouseX, e_mY - mouseY);
        this.renderHealthBar(graphics, this.dog, e_mX - 41, this.getRealY() + this.getSizeY() - 10);
        int points = this.dog.getSpendablePoints();
        graphics.m_280488_(this.font, "Pts: " + points, this.getRealX(), this.getRealY(), -1);
    }

    public static void renderDogInside(GuiGraphics graphics, Dog dog, int dog_mX, int dog_mY, int size, int lookX, int lookY) {
        boolean dogTooBig;
        DogSize currentDogSize = dog.getDogSize();
        boolean bl = dogTooBig = currentDogSize.getId() > DogSize.MODERATO.getId();
        if (dogTooBig) {
            dog.setDogSize(DogSize.MODERATO);
        }
        Component currentDogName = dog.m_7770_();
        String currentDogNameStr = "";
        boolean nameTooLong = false;
        if (currentDogName != null) {
            currentDogNameStr = currentDogName.getString();
            boolean bl2 = nameTooLong = currentDogNameStr.length() > 14;
        }
        if (nameTooLong) {
            String tempName = currentDogNameStr.substring(0, 13) + " ..";
            dog.setDogCustomName((Component)Component.m_237113_((String)tempName));
        }
        InventoryScreen.m_274545_((GuiGraphics)graphics, (int)dog_mX, (int)dog_mY, (int)size, (float)lookX, (float)lookY, (LivingEntity)dog);
        if (nameTooLong) {
            dog.setDogCustomName(currentDogName);
        }
        if (dogTooBig) {
            dog.setDogSize(currentDogSize);
        }
    }

    public void renderHealthBar(GuiGraphics graphics, Dog dog, int x, int y) {
        Random random = new Random();
        random.setSeed(dog.f_19797_ * 312871);
        int dogHealth = Mth.m_14167_((float)dog.m_21223_());
        int aX = x;
        int aY = y;
        float dogMaxHealth = dog.m_21233_();
        int dogAbsorbAmount = Mth.m_14167_((float)dog.m_6103_());
        float totalHealth = dogMaxHealth + (float)dogAbsorbAmount;
        if (totalHealth > 40.0f) {
            int pX = aX;
            int pY = aY;
            String healthStr = " x " + dog.m_21223_() + "/" + dogMaxHealth;
            graphics.m_280218_(DogScreenOverlays.GUI_ICONS_LOCATION, pX += (80 - (8 + this.font.m_92895_(healthStr))) / 2, pY, 52, 0, 9, 9);
            graphics.m_280488_(this.font, healthStr, pX += 9, ++pY, -1);
            return;
        }
        if (totalHealth > 20.0f) {
            aY += 9;
        }
        int fullHealthLines = Mth.m_14167_((float)(totalHealth / 20.0f));
        int j2 = Math.max(10 - (fullHealthLines - 2), 3);
        int pDogAbsorbAmount = dogAbsorbAmount;
        int k3 = -1;
        if (dog.m_21023_(MobEffects.f_19605_)) {
            k3 = dog.f_19797_ % Mth.m_14167_((float)(dogMaxHealth + 5.0f));
        }
        for (int pHeart = Mth.m_14167_((float)(totalHealth / 2.0f)) - 1; pHeart >= 0; --pHeart) {
            int guiIconIndexX = 16;
            int guiIconIndexY = 0;
            if (dog.m_21023_(MobEffects.f_19614_)) {
                guiIconIndexX += 36;
            } else if (dog.m_21023_(MobEffects.f_19615_)) {
                guiIconIndexX += 72;
            }
            int k4 = Mth.m_14167_((float)((float)(pHeart + 1) / 10.0f)) - 1;
            int heartX = aX + pHeart % 10 * 8;
            int heartY = aY - k4 * j2;
            if (dogHealth <= 4) {
                heartY += random.nextInt(2);
            }
            if (pDogAbsorbAmount <= 0 && pHeart == k3) {
                heartY -= 2;
            }
            graphics.m_280218_(DogScreenOverlays.GUI_ICONS_LOCATION, heartX, heartY, 16, 0, 9, 9);
            if (pDogAbsorbAmount > 0) {
                if (pDogAbsorbAmount == dogAbsorbAmount && dogAbsorbAmount % 2 == 1) {
                    graphics.m_280218_(DogScreenOverlays.GUI_ICONS_LOCATION, heartX, heartY, guiIconIndexX + 153, 9 * guiIconIndexY, 9, 9);
                    --pDogAbsorbAmount;
                    continue;
                }
                graphics.m_280218_(DogScreenOverlays.GUI_ICONS_LOCATION, heartX, heartY, guiIconIndexX + 144, 9 * guiIconIndexY, 9, 9);
                pDogAbsorbAmount -= 2;
                continue;
            }
            if (pHeart * 2 + 1 < dogHealth) {
                graphics.m_280218_(DogScreenOverlays.GUI_ICONS_LOCATION, heartX, heartY, guiIconIndexX + 36, 9 * guiIconIndexY, 9, 9);
            }
            if (pHeart * 2 + 1 != dogHealth) continue;
            graphics.m_280218_(DogScreenOverlays.GUI_ICONS_LOCATION, heartX, heartY, guiIconIndexX + 45, 9 * guiIconIndexY, 9, 9);
        }
    }
}

