/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.item;

import doggytalents.api.feature.FoodHandler;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.inferface.IDogFoodHandler;
import doggytalents.common.Screens;
import doggytalents.common.entity.DogFoodProjectile;
import doggytalents.common.inventory.TreatBagItemHandler;
import doggytalents.common.util.Cache;
import doggytalents.common.util.InventoryUtil;
import doggytalents.common.util.ItemUtil;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class TreatBagItem
extends Item
implements IDogFoodHandler {
    private Cache<String> contentsTranslationKey = Cache.make(() -> this.m_5524_() + ".contents");

    public TreatBagItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        if (worldIn.f_46443_) {
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        if (!playerIn.m_6144_()) {
            if (playerIn instanceof ServerPlayer) {
                ServerPlayer sP = (ServerPlayer)playerIn;
                this.findFoodAndShootOut(sP, stack);
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        if (playerIn instanceof ServerPlayer && !(playerIn instanceof FakePlayer)) {
            ServerPlayer serverPlayer = (ServerPlayer)playerIn;
            Screens.openTreatBagScreen(serverPlayer, stack, playerIn.m_150109_().f_35977_);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    private void findFoodAndShootOut(ServerPlayer player, ItemStack stack) {
        IItemHandlerModifiable itemHandler = (IItemHandlerModifiable)stack.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse((Object)EmptyHandler.INSTANCE);
        int foodStackId = this.findFoodInItemHandler((IItemHandler)itemHandler);
        if (foodStackId < 0) {
            return;
        }
        ItemStack foodStack = itemHandler.getStackInSlot(foodStackId);
        if (foodStack.m_41619_()) {
            return;
        }
        DogFoodProjectile dogFoodProj = new DogFoodProjectile(player.m_9236_(), (LivingEntity)player);
        dogFoodProj.setDogFoodStack(new ItemStack((ItemLike)foodStack.m_41720_()));
        dogFoodProj.m_5602_((Entity)player);
        dogFoodProj.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 0.8f, 1.0f);
        player.m_9236_().m_7967_((Entity)dogFoodProj);
        foodStack = foodStack.m_41777_();
        foodStack.m_41774_(1);
        itemHandler.setStackInSlot(foodStackId, foodStack);
    }

    private int findFoodInItemHandler(IItemHandler itemHandler) {
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack stack = itemHandler.getStackInSlot(i);
            if (stack.m_41619_() || !FoodHandler.isFood(stack).isPresent()) continue;
            return i;
        }
        return -1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        tooltip.add((Component)Component.m_237115_((String)"item.doggytalents.treat_bag.help").m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(true))));
        this.displayContents(stack, worldIn, tooltip, flagIn);
    }

    private void displayContents(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        IItemHandler inv = (IItemHandler)stack.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse((Object)EmptyHandler.INSTANCE);
        ItemUtil.ContentOverview contentsOverview = ItemUtil.getContentOverview(inv);
        Map<Item, Integer> contentsMap = contentsOverview.contents();
        if (contentsMap.isEmpty()) {
            return;
        }
        tooltip.add((Component)Component.m_237115_((String)"item.doggytalents.treat_bag.contents"));
        for (Map.Entry<Item, Integer> entry : contentsMap.entrySet()) {
            MutableComponent c1 = Component.m_237110_((String)"item.doggytalents.starter_bundle.contains", (Object[])new Object[]{entry.getValue(), entry.getKey().m_41466_()}).m_130948_(Style.f_131099_.m_178520_(-6052957));
            tooltip.add((Component)c1);
        }
        if (contentsOverview.isMore() > 0) {
            tooltip.add((Component)Component.m_237110_((String)"item.doggytalents.treat_bag.contents.more", (Object[])new Object[]{contentsOverview.isMore()}).m_130948_(Style.f_131099_.m_178520_(-6052957)));
        }
    }

    public ICapabilityProvider initCapabilities(final ItemStack stack, CompoundTag nbt) {
        if (ForgeCapabilities.ITEM_HANDLER == null) {
            return null;
        }
        return new ICapabilityProvider(){
            final LazyOptional<IItemHandler> itemHandlerInstance = LazyOptional.of(() -> new TreatBagItemHandler(stack));

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                if (cap == ForgeCapabilities.ITEM_HANDLER) {
                    return this.itemHandlerInstance;
                }
                return LazyOptional.empty();
            }
        };
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !ItemStack.m_41728_((ItemStack)oldStack, (ItemStack)newStack);
    }

    @Override
    public boolean isFood(ItemStack stackIn) {
        return false;
    }

    @Override
    public boolean canConsume(AbstractDog dogIn, ItemStack stackIn, Entity entityIn) {
        if (dogIn.isDefeated()) {
            return false;
        }
        return entityIn instanceof LivingEntity ? dogIn.canInteract((LivingEntity)entityIn) : false;
    }

    @Override
    public InteractionResult consume(AbstractDog dogIn, ItemStack stackIn, Entity entityIn) {
        if (dogIn.m_9236_().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        IItemHandlerModifiable treatBag = (IItemHandlerModifiable)stackIn.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse((Object)EmptyHandler.INSTANCE);
        return InventoryUtil.feedDogFrom(dogIn, entityIn, treatBag);
    }
}

