/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.api.DoggyTalentsAPI;
import doggytalents.api.registry.Accessory;
import doggytalents.api.registry.AccessoryInstance;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.client.event.ClientEventHandler;
import doggytalents.common.network.IPacket;
import doggytalents.common.network.packet.data.DogSyncData;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class DogSyncDataPacket
implements IPacket<DogSyncData> {
    @Override
    public void encode(DogSyncData data, FriendlyByteBuf buf) {
        Optional<ArrayList<TalentInstance>> refreshOptionOptional;
        Optional<ArrayList<AccessoryInstance>> accessoriesOptional;
        buf.writeInt(data.dogId);
        Optional<ArrayList<TalentInstance>> talentsOptional = data.talents();
        if (talentsOptional.isPresent()) {
            buf.writeInt(ReadState.TALENTS.getId());
            this.writeTalents(talentsOptional.get(), buf);
        }
        if ((accessoriesOptional = data.accessories()).isPresent()) {
            buf.writeInt(ReadState.ACCESSORIES.getId());
            this.writeAccessories(accessoriesOptional.get(), buf);
        }
        if ((refreshOptionOptional = data.refreshOptions()).isPresent()) {
            buf.writeInt(ReadState.TALENTS_REFRESH_OPTIONS.getId());
            this.writeTalents(refreshOptionOptional.get(), buf);
        }
        buf.writeInt(ReadState.FINISH.getId());
    }

    private void writeTalents(ArrayList<TalentInstance> talents, FriendlyByteBuf buf) {
        buf.writeInt(talents.size());
        for (TalentInstance inst : talents) {
            buf.writeRegistryIdUnsafe(DoggyTalentsAPI.TALENTS.get(), (Object)inst.getTalent());
            inst.writeToBuf(buf);
        }
    }

    private void writeAccessories(ArrayList<AccessoryInstance> value, FriendlyByteBuf buf) {
        buf.writeInt(value.size());
        for (AccessoryInstance inst : value) {
            buf.writeRegistryIdUnsafe(DoggyTalentsAPI.ACCESSORIES.get(), (Object)inst.getAccessory());
            inst.getAccessory().write(inst, buf);
        }
    }

    @Override
    public DogSyncData decode(FriendlyByteBuf buf) {
        int dogId = buf.readInt();
        ReadState readState = ReadState.fromId(buf.readInt());
        ArrayList<TalentInstance> talents = null;
        ArrayList<AccessoryInstance> accessories = null;
        ArrayList<TalentInstance> refreshOptions = null;
        while (readState != ReadState.FINISH) {
            if (readState == ReadState.TALENTS) {
                talents = this.readTalents(buf);
            } else if (readState == ReadState.ACCESSORIES) {
                accessories = this.readAccessories(buf);
            } else if (readState == ReadState.TALENTS_REFRESH_OPTIONS) {
                refreshOptions = this.readTalents(buf);
            }
            readState = ReadState.fromId(buf.readInt());
        }
        return new DogSyncData(dogId, talents, accessories, refreshOptions);
    }

    private ArrayList<TalentInstance> readTalents(FriendlyByteBuf buf) {
        int size = buf.readInt();
        ArrayList<TalentInstance> newInst = new ArrayList<TalentInstance>(size);
        for (int i = 0; i < size; ++i) {
            TalentInstance inst = ((Talent)buf.readRegistryIdUnsafe(DoggyTalentsAPI.TALENTS.get())).getDefault();
            inst.readFromBuf(buf);
            newInst.add(inst);
        }
        return newInst;
    }

    private ArrayList<AccessoryInstance> readAccessories(FriendlyByteBuf buf) {
        int size = buf.readInt();
        ArrayList<AccessoryInstance> newInst = new ArrayList<AccessoryInstance>(size);
        for (int i = 0; i < size; ++i) {
            Accessory type = (Accessory)buf.readRegistryIdUnsafe(DoggyTalentsAPI.ACCESSORIES.get());
            newInst.add(type.createInstance(buf));
        }
        return newInst;
    }

    @Override
    public void handle(DogSyncData data, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (!((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient()) {
                return;
            }
            ClientEventHandler.onDogSyncedDataUpdated(data);
        });
        ctx.get().setPacketHandled(true);
    }

    public static enum ReadState {
        FINISH(0),
        TALENTS(1),
        ACCESSORIES(2),
        TALENTS_REFRESH_OPTIONS(3);

        private int id;

        private ReadState(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static ReadState fromId(int id) {
            ReadState[] values = ReadState.values();
            return values[id];
        }
    }
}

