/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.DoggyItems;
import doggytalents.common.network.IPacket;
import doggytalents.common.network.packet.data.WhisltleEditHotKeyData;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class WhistleEditHotKeyPacket
implements IPacket<WhisltleEditHotKeyData> {
    @Override
    public void encode(WhisltleEditHotKeyData data, FriendlyByteBuf buf) {
        buf.writeInt(data.hotkey_id);
        buf.writeInt(data.new_mode_id);
    }

    @Override
    public WhisltleEditHotKeyData decode(FriendlyByteBuf buf) {
        int hotkey_id = buf.readInt();
        int new_mode_id = buf.readInt();
        return new WhisltleEditHotKeyData(hotkey_id, new_mode_id);
    }

    @Override
    public void handle(WhisltleEditHotKeyData data, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            int[] keyarr;
            LogicalSide side = ((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide();
            if (!side.isServer()) {
                return;
            }
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            ItemStack stack = player.m_21205_();
            if (stack.m_41720_() != DoggyItems.WHISTLE.get()) {
                return;
            }
            CompoundTag tag = stack.m_41784_();
            if (!tag.m_128425_("hotkey_modes", 11)) {
                tag.m_128385_("hotkey_modes", new int[]{-1, -1, -1, -1});
            }
            if ((keyarr = tag.m_128465_("hotkey_modes")) == null) {
                return;
            }
            if (keyarr.length != 4) {
                tag.m_128385_("hotkey_modes", new int[]{-1, -1, -1, -1});
                return;
            }
            if (data.hotkey_id >= keyarr.length) {
                return;
            }
            if (data.hotkey_id < 0) {
                return;
            }
            if (data.new_mode_id >= 0) {
                for (int i : keyarr) {
                    if (i != data.new_mode_id) continue;
                    return;
                }
            }
            keyarr[data.hotkey_id] = data.new_mode_id;
            tag.m_128385_("hotkey_modes", keyarr);
        });
        ctx.get().setPacketHandled(true);
    }
}

