/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util;

import doggytalents.DoggyBlocks;
import doggytalents.api.registry.IBeddingMaterial;
import doggytalents.api.registry.ICasingMaterial;
import doggytalents.common.block.DogBedMaterialManager;
import doggytalents.common.block.tileentity.DogBedTileEntity;
import doggytalents.common.util.NBTUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.tuple.Pair;

public class DogBedUtil {
    private static final Random RANDOM = new Random(System.currentTimeMillis());

    public static void setBedVariant(DogBedTileEntity dogBedTileEntity, ItemStack stack) {
        Pair<ICasingMaterial, IBeddingMaterial> materials = DogBedUtil.getMaterials(stack);
        dogBedTileEntity.setCasing((ICasingMaterial)materials.getLeft());
        dogBedTileEntity.setBedding((IBeddingMaterial)materials.getRight());
    }

    public static ItemStack createRandomBed() {
        ICasingMaterial casing = DogBedMaterialManager.randomCasing();
        IBeddingMaterial bedding = DogBedMaterialManager.randomBedding();
        return DogBedUtil.createItemStack(casing, bedding);
    }

    public static Pair<ICasingMaterial, IBeddingMaterial> getMaterials(ItemStack stack) {
        CompoundTag tag = stack.m_41737_("doggytalents");
        if (tag != null) {
            ICasingMaterial casingId = DogBedMaterialManager.getCasing(tag, "casingId");
            IBeddingMaterial beddingId = DogBedMaterialManager.getBedding(tag, "beddingId");
            return Pair.of((Object)casingId, (Object)beddingId);
        }
        return Pair.of((Object)DogBedMaterialManager.NaniCasing.NULL, (Object)DogBedMaterialManager.NaniBedding.NULL);
    }

    public static ItemStack createItemStack(ICasingMaterial casingId, IBeddingMaterial beddingId) {
        ItemStack stack = new ItemStack((ItemLike)DoggyBlocks.DOG_BED.get(), 1);
        CompoundTag tag = stack.m_41698_("doggytalents");
        NBTUtil.putRegistryValue(tag, "casingId", DogBedMaterialManager.getKey(casingId));
        NBTUtil.putRegistryValue(tag, "beddingId", DogBedMaterialManager.getKey(beddingId));
        return stack;
    }

    public static ICasingMaterial getCasingFromStack(ItemStack stack) {
        for (Map.Entry<ResourceLocation, ICasingMaterial> e : DogBedMaterialManager.getCasings().entrySet()) {
            ICasingMaterial m = e.getValue();
            if (m.getIngredient() == Ingredient.f_43901_ || !m.getIngredient().test(stack)) continue;
            return m;
        }
        return null;
    }

    public static IBeddingMaterial getBeddingFromStack(ItemStack stack) {
        for (Map.Entry<ResourceLocation, IBeddingMaterial> e : DogBedMaterialManager.getBeddings().entrySet()) {
            IBeddingMaterial m = e.getValue();
            if (m.getIngredient() == Ingredient.f_43901_ || !m.getIngredient().test(stack)) continue;
            return m;
        }
        return null;
    }

    public static <T> T pickRandom(IForgeRegistry<T> registry) {
        Collection values = registry.getValues();
        List list = values instanceof List ? (List)values : new ArrayList(values);
        return (T)list.get(RANDOM.nextInt(list.size()));
    }
}

