/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ding.loader.forge;

import me.ichun.mods.ding.common.core.Config;
import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigForge
extends Config {
    public ConfigForge(ForgeConfigSpec.Builder builder) {
        builder.comment("Configs related to how ding works").push("ding");
        builder.comment("Configs for ding to trigger when the game loads").push("load");
        ForgeConfigSpec.BooleanValue cPlayOnLoad = builder.comment("Play sound when the game loads.").translation("config.ding.prop.playOnLoad.desc").define("playOnLoad", true);
        this.playOnLoad = new Config.ConfigWrapper<Boolean>(() -> ((ForgeConfigSpec.BooleanValue)cPlayOnLoad).get(), arg_0 -> ((ForgeConfigSpec.BooleanValue)cPlayOnLoad).set(arg_0), () -> ((ForgeConfigSpec.BooleanValue)cPlayOnLoad).save());
        ForgeConfigSpec.ConfigValue cName = builder.comment("Resource Location based name of the sound file to play when Minecraft finishes loading.\nEG: \"ui.button.click\" or \"entity.experience_orb.pickup\"\n\nThis can also be a mod sound if the mod is installed.\nEG: \"modname:modsound.boing\"\n\nIf you want to use external sounds, consider looking into the mod Additional Resources").translation("config.ding.prop.name.desc").define("name", (Object)"entity.experience_orb.pickup");
        this.name = new Config.ConfigWrapper<String>(() -> ((ForgeConfigSpec.ConfigValue)cName).get(), arg_0 -> ((ForgeConfigSpec.ConfigValue)cName).set(arg_0), () -> ((ForgeConfigSpec.ConfigValue)cName).save());
        ForgeConfigSpec.DoubleValue cVolume = builder.comment("Volume of the sound (when Minecraft loads)").translation("config.ding.prop.volume.desc").defineInRange("volume", 0.25, 0.0, 10.0);
        this.volume = new Config.ConfigWrapper<Double>(() -> ((ForgeConfigSpec.DoubleValue)cVolume).get(), arg_0 -> ((ForgeConfigSpec.DoubleValue)cVolume).set(arg_0), () -> ((ForgeConfigSpec.DoubleValue)cVolume).save());
        ForgeConfigSpec.DoubleValue cPitch = builder.comment("Pitch of the sound (when Minecraft loads)").translation("config.ding.prop.pitch.desc").defineInRange("pitch", 1.0, 0.0, 10.0);
        this.pitch = new Config.ConfigWrapper<Double>(() -> ((ForgeConfigSpec.DoubleValue)cPitch).get(), arg_0 -> ((ForgeConfigSpec.DoubleValue)cPitch).set(arg_0), () -> ((ForgeConfigSpec.DoubleValue)cPitch).save());
        ForgeConfigSpec.ConfigValue cCategory = builder.comment("Sound category for the sound played when Minecraft finishes loading. EG: \"ambient\" or \"music\". Defaults to \"master\" if Ding cannot find your category.").translation("config.ding.prop.category.desc").define("category", (Object)"master");
        this.category = new Config.ConfigWrapper<String>(() -> ((ForgeConfigSpec.ConfigValue)cCategory).get(), arg_0 -> ((ForgeConfigSpec.ConfigValue)cCategory).set(arg_0), () -> ((ForgeConfigSpec.ConfigValue)cCategory).save());
        builder.pop();
        builder.comment("Configs for ding to trigger when the world loads after connecting to a server").push("world");
        ForgeConfigSpec.BooleanValue cPlayOnWorld = builder.comment("Play sound when the world loads after connecting to a server.").translation("config.ding.prop.playOnWorld.desc").worldRestart().define("playOnWorld", false);
        this.playOnWorld = new Config.ConfigWrapper<Boolean>(() -> ((ForgeConfigSpec.BooleanValue)cPlayOnWorld).get(), arg_0 -> ((ForgeConfigSpec.BooleanValue)cPlayOnWorld).set(arg_0), () -> ((ForgeConfigSpec.BooleanValue)cPlayOnWorld).save());
        ForgeConfigSpec.ConfigValue cNameWorld = builder.comment("Resource Location based name of the sound file to play when the world finishes loading (after connecting to a server).\n\nLook at the \"name\" config for more details.").translation("config.ding.prop.nameWorld.desc").define("nameWorld", (Object)"entity.experience_orb.pickup");
        this.nameWorld = new Config.ConfigWrapper<String>(() -> ((ForgeConfigSpec.ConfigValue)cNameWorld).get(), arg_0 -> ((ForgeConfigSpec.ConfigValue)cNameWorld).set(arg_0), () -> ((ForgeConfigSpec.ConfigValue)cNameWorld).save());
        ForgeConfigSpec.DoubleValue cVolumeWorld = builder.comment("Volume of the sound (when the world loads after connecting to a server)").translation("config.ding.prop.volumeWorld.desc").defineInRange("volumeWorld", 0.25, 0.0, 10.0);
        this.volumeWorld = new Config.ConfigWrapper<Double>(() -> ((ForgeConfigSpec.DoubleValue)cVolumeWorld).get(), arg_0 -> ((ForgeConfigSpec.DoubleValue)cVolumeWorld).set(arg_0), () -> ((ForgeConfigSpec.DoubleValue)cVolumeWorld).save());
        ForgeConfigSpec.DoubleValue cPitchWorld = builder.comment("Pitch of the sound (when the world loads after connecting to a server)").translation("config.ding.prop.pitchWorld.desc").defineInRange("pitchWorld", 1.0, 0.0, 10.0);
        this.pitchWorld = new Config.ConfigWrapper<Double>(() -> ((ForgeConfigSpec.DoubleValue)cPitchWorld).get(), arg_0 -> ((ForgeConfigSpec.DoubleValue)cPitchWorld).set(arg_0), () -> ((ForgeConfigSpec.DoubleValue)cPitchWorld).save());
        ForgeConfigSpec.ConfigValue cCategoryWorld = builder.comment("Sound category for the sound played when the world finishes loading (after connecting to a server). EG: \"ambient\" or \"music\". Defaults to \"master\" if Ding cannot find your category.").translation("config.ding.prop.categoryWorld.desc").define("categoryWorld", (Object)"master");
        this.categoryWorld = new Config.ConfigWrapper<String>(() -> ((ForgeConfigSpec.ConfigValue)cCategoryWorld).get(), arg_0 -> ((ForgeConfigSpec.ConfigValue)cCategoryWorld).set(arg_0), () -> ((ForgeConfigSpec.ConfigValue)cCategoryWorld).save());
        builder.pop();
        builder.comment("Configs for ding to trigger when resources are reloaded").push("resourcesReload");
        ForgeConfigSpec.BooleanValue cPlayOnResourcesReload = builder.comment("Play sound when resources complete reloading. Requires game to be restarted.").translation("config.ding.prop.playOnResourcesReload.desc").worldRestart().define("playOnResourcesReload", true);
        this.playOnResourcesReload = new Config.ConfigWrapper<Boolean>(() -> ((ForgeConfigSpec.BooleanValue)cPlayOnResourcesReload).get(), arg_0 -> ((ForgeConfigSpec.BooleanValue)cPlayOnResourcesReload).set(arg_0), () -> ((ForgeConfigSpec.BooleanValue)cPlayOnResourcesReload).save());
        ForgeConfigSpec.ConfigValue cNameResourcesReload = builder.comment("Resource Location based name of the sound file to play when resources complete reloading.\n\nLook at the \"name\" config for more details.").translation("config.ding.prop.nameResourcesReload.desc").define("nameResourcesReload", (Object)"entity.experience_orb.pickup");
        this.nameResourcesReload = new Config.ConfigWrapper<String>(() -> ((ForgeConfigSpec.ConfigValue)cNameResourcesReload).get(), arg_0 -> ((ForgeConfigSpec.ConfigValue)cNameResourcesReload).set(arg_0), () -> ((ForgeConfigSpec.ConfigValue)cNameResourcesReload).save());
        ForgeConfigSpec.DoubleValue cVolumeResourcesReload = builder.comment("Volume of the sound (when resources complete reloading)").translation("config.ding.prop.volumeResourcesReloadResourcesReload.desc").defineInRange("volumeResourcesReload", 0.25, 0.0, 10.0);
        this.volumeResourcesReload = new Config.ConfigWrapper<Double>(() -> ((ForgeConfigSpec.DoubleValue)cVolumeResourcesReload).get(), arg_0 -> ((ForgeConfigSpec.DoubleValue)cVolumeResourcesReload).set(arg_0), () -> ((ForgeConfigSpec.DoubleValue)cVolumeResourcesReload).save());
        ForgeConfigSpec.DoubleValue cPitchResourcesReload = builder.comment("Pitch of the sound (when resources complete reloading)").translation("config.ding.prop.pitchResourcesReloadResourcesReload.desc").defineInRange("pitchResourcesReload", 1.0, 0.0, 10.0);
        this.pitchResourcesReload = new Config.ConfigWrapper<Double>(() -> ((ForgeConfigSpec.DoubleValue)cPitchResourcesReload).get(), arg_0 -> ((ForgeConfigSpec.DoubleValue)cPitchResourcesReload).set(arg_0), () -> ((ForgeConfigSpec.DoubleValue)cPitchResourcesReload).save());
        ForgeConfigSpec.ConfigValue cCategoryResourcesReload = builder.comment("Sound category for the sound played when resources complete reloading. EG: \"ambient\" or \"music\". Defaults to \"master\" if Ding cannot find your category.").translation("config.ding.prop.categoryResourcesReload.desc").define("categoryResourcesReload", (Object)"master");
        this.categoryResourcesReload = new Config.ConfigWrapper<String>(() -> ((ForgeConfigSpec.ConfigValue)cCategoryResourcesReload).get(), arg_0 -> ((ForgeConfigSpec.ConfigValue)cCategoryResourcesReload).set(arg_0), () -> ((ForgeConfigSpec.ConfigValue)cCategoryResourcesReload).save());
        builder.pop();
        builder.pop();
    }
}

