/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.misc;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.mehvahdjukaar.moonlight.api.misc.CodecMapRegistry;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class MapRegistry<T>
implements Codec<T> {
    private final BiMap<ResourceLocation, T> map = HashBiMap.create();

    public static <B> CodecMapRegistry<B> ofCodec() {
        return new CodecMapRegistry();
    }

    public <E> Codec<E> dispatch(Function<? super E, ? extends T> type) {
        return super.dispatch(type, c -> (Codec)c);
    }

    public void register(ResourceLocation name, T value) {
        this.map.put((Object)name, value);
    }

    @Nullable
    public T getValue(ResourceLocation name) {
        return (T)this.map.get((Object)name);
    }

    @Nullable
    public ResourceLocation getKey(T value) {
        return (ResourceLocation)this.map.inverse().get(value);
    }

    public Set<ResourceLocation> keySet() {
        return this.map.keySet();
    }

    public Set<T> getValues() {
        return this.map.values();
    }

    public Set<Map.Entry<ResourceLocation, T>> getEntries() {
        return this.map.entrySet();
    }

    public boolean containsKey(ResourceLocation name) {
        return this.map.containsKey((Object)name);
    }

    public <U> DataResult<Pair<T, U>> decode(DynamicOps<U> ops, U json) {
        return ResourceLocation.f_135803_.decode(ops, json).flatMap(pair -> {
            ResourceLocation id = (ResourceLocation)pair.getFirst();
            T value = this.getValue(id);
            return value == null ? DataResult.error(() -> "Unknown registry key: " + id) : DataResult.success((Object)Pair.of(value, (Object)pair.getSecond()));
        });
    }

    public <U> DataResult<U> encode(T object, DynamicOps<U> ops, U prefix) {
        ResourceLocation id = this.getKey(object);
        return id == null ? DataResult.error(() -> "Unknown registry element: " + object) : ops.mergeToPrimitive(prefix, ops.createString(id.toString()));
    }
}

