/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.custom_bogeys.narrow_gauge;

import com.railwayteam.railways.content.custom_bogeys.CRBogeyBlock;
import com.railwayteam.railways.registry.CRBogeyStyles;
import com.railwayteam.railways.registry.CRTrackMaterials;
import com.simibubi.create.content.trains.bogey.BogeySizes;
import com.simibubi.create.content.trains.bogey.BogeyStyle;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import java.util.function.Supplier;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.phys.Vec3;

public class NarrowGaugeBogeyBlock
extends CRBogeyBlock {
    public final NarrowGaugeStandardStyle style;

    public static NonNullFunction<BlockBehaviour.Properties, NarrowGaugeBogeyBlock> create(NarrowGaugeStandardStyle style) {
        return props -> new NarrowGaugeBogeyBlock((BlockBehaviour.Properties)props, style);
    }

    public NarrowGaugeBogeyBlock(BlockBehaviour.Properties props, NarrowGaugeStandardStyle style) {
        super(props, style.style.get(), style.size.get());
        this.style = style;
    }

    @Override
    public TrackMaterial.TrackType getTrackType(BogeyStyle style) {
        return CRTrackMaterials.CRTrackType.NARROW_GAUGE;
    }

    @Override
    public Vec3 getConnectorAnchorOffset() {
        return switch (this.style) {
            default -> throw new IncompatibleClassChangeError();
            case NarrowGaugeStandardStyle.SMALL, NarrowGaugeStandardStyle.SCOTCH_YOKE -> new Vec3(0.0, 0.21875, 1.0);
            case NarrowGaugeStandardStyle.DOUBLE_SCOTCH_YOKE -> new Vec3(0.0, 0.21875, 1.1875);
        };
    }

    @Override
    public double getWheelRadius() {
        return (this.size == BogeySizes.LARGE ? 12.5 : 6.5) / 16.0;
    }

    public static enum NarrowGaugeStandardStyle {
        SMALL(() -> CRBogeyStyles.NARROW_DEFAULT, () -> BogeySizes.SMALL),
        SCOTCH_YOKE(() -> CRBogeyStyles.NARROW_DEFAULT, () -> BogeySizes.LARGE),
        DOUBLE_SCOTCH_YOKE(() -> CRBogeyStyles.NARROW_DOUBLE_SCOTCH, () -> BogeySizes.LARGE);

        public final Supplier<BogeyStyle> style;
        public final Supplier<BogeySizes.BogeySize> size;

        private NarrowGaugeStandardStyle(Supplier<BogeyStyle> style, Supplier<BogeySizes.BogeySize> size) {
            this.style = style;
            this.size = size;
        }
    }
}

